<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

include_once ( dirname(__FILE__) . '/class.DefinableColumn.php' );
include_once ( dirname(__FILE__) . '/class.ServiceColumn.php' );
include_once ( dirname(__FILE__) . '/class.ResellerLimitColumn.php' );
include_once ( dirname(__FILE__) . '/class.ResellerStorageColumn.php' );
include_once ( dirname(__FILE__) . '/class.ResellerMailSpaceColumn.php' );
include_once ( dirname(__FILE__) . '/class.ResellerTrafficColumn.php' );
include_once ( dirname(__FILE__) . '/class.ServiceColumn.php' );
include_once ( dirname(__FILE__) . '/limits/class.AllLimits.php' );
include_once ( dirname(__FILE__) . '/class.ShellColumn.php' );
include_once ( dirname(__FILE__) . '/module.Informer.php' );
include_once ( dirname(__FILE__) . '/class.RadioGroupColumn.php' );
include_once ( dirname(__FILE__) . '/class.CompoundColumn.php' );
include_once ( dirname(__FILE__) . '/idn_functions.php' );
include_once ( dirname(__FILE__) . '/class.InputDecode.php' );
include_once ( dirname(__FILE__) . '/module.DNSTemplate.php' );
include_once ( dirname(__FILE__) . '/class.Page.php' );
include_once ( dirname(__FILE__) . '/class.Actor.php' );
include_once ( dirname(__FILE__) . '/class.SQLFieldSet.php' );
include_once ( dirname(__FILE__)  . '/event_functions.php' );
include_once ( dirname(__FILE__) . '/module.url.inc.php' );


class User extends Actor {

    var $ma_Domains; // array of domains
    var $ma_NatDomains; // array of national domains
    var $ma_SharedDomains; // array of Shared domains (flags)
    var $ma_DNS; // array of DNS flags
    var $ma_DNR; // array of DNR flags
    var $ma_DBDNR; // array of DNR flags from DB
    var $mcServerID;
    var $ms_CurrentIP; // current ip
    var $ms_Exclusive; // use ip address exclusively
    var $ma_Statistics;  // array of user's statistics 
    var $ma_Settings; // array of user's settings
    var $ma_Required; // array of required fields

    /**
     * Constructor
     */
    function User( $ps_UserName='', $psServerID = null)
    {
      global $ServerID;
    	if( $ps_UserName ){
    		$this->ms_Name=$ps_UserName;
    		if( strpos( $ps_UserName,$GLOBALS['user_prefix'] ) === 0 ){
    			$this->ms_Number=substr( $ps_UserName, strlen( $GLOBALS['user_prefix'] ) );
    		}
    	}

    	$this->mcServerID = is_null( $psServerID ) ? $ServerID : $psServerID;
			$this->Actor();
    	$this->ma_Statistics = array();
    	$this->ma_Settings = array();
			$this->ma_Domains = array();
			$this->ma_Required = array();
			$this->ma_SharedDomains = array();
			$this->ma_NatDomains = array();
			$this->ma_DNS = array();
			$this->ma_DNR = array();
			$this->ma_DBDNR = array();
    }

    /* -------------------- personal information -------------------- */
    function InitializePersonal () {
			parent::InitializePersonal();

			$this->ma_Personal['kundennummer'] = new InputTextColumn ( 'kundennummer', ltext('pi_customerid'), '' );
			$this->ma_Personal['freifeldname1'] = new DefinableColumn ( 'freifeldname1', 'freifeldwert1', '', '' );
			$this->ma_Personal['freifeldname2'] = new DefinableColumn ( 'freifeldname2', 'freifeldwert2', '', '' );
			$this->ma_Personal['freifeldname3'] = new DefinableColumn ( 'freifeldname3', 'freifeldwert3', '', '' );
			$lo_Column = new CompoundColumn ( NULL, '', '' );
			$lo_Text = new InputTextColumn ( NULL, '', ltext('kune3_cell_text1') );
			$lo_Text->SetInput (FALSE);
			$lo_Column->AddColumn ( $lo_Text );
			
			$lo_Radio = new RadioGroupColumn ( array( 1=>ltext('g_yes'), 0=>ltext('g_no') ), 'kundendatenanzeigen', '', '1' );
			$lo_Radio->SetSeparator ( ' ' );
			$lo_Column->AddColumn ($lo_Radio);
			$lo_Column->SetSeparator ( '<br>' );
			
			$this->ma_Personal['kundendatenanzeigen'] = $lo_Column;
    }

    function ValidatePersonal ()
    {
			$ls_Result = TRUE;
			$ls_Definable = FALSE;
			foreach ( array_keys($this->ma_Personal) as $ls_Key )	{
				$lo_Column =& $this->ma_Personal[$ls_Key];
				if ( ! $lo_Column->IsValid() ) {
					if ( strtolower ( get_class($lo_Column) ) == 'definablecolumn' ||
							 is_subclass_of ( $lo_Column, 'definablecolumn' ) )	{
						if ( ! $ls_Definable ) {
							$this->AddMessage ( ERROR, ltext( 'kune4_error1' ) );
							$ls_Definable = TRUE;
						}
					}	else
						$this->AddMessage ( ERROR, ltext ( 'fp_incorrect_field', $lo_Column->GetLabel() ) );
					$ls_Result = FALSE;
				}
			}
			return $ls_Result;
    }
    
    function &ServerID( $pcServerId = null ){
      if( is_string( $pcServerId ) ){
      	$this->mcServerID = $pcServerId;
      }
      return $this->mcServerID;
    }
    
	function SetPersonalData( $pa_Data ){
		// set ID to the specified value (if it is new user)
		// then clean this variable
		$freifeldname3 = $pa_Data['freifeldname3'];
		$freifeldwert3 = $pa_Data['freifeldwert3'];
		
		if( ( $freifeldname3 == 'add-user') && ( (int)$freifeldwert3 > 0 ) 
		  && !isset( $this->ms_Number ) ){
//			$pa_Data['freifeldname3'] = '';
//			$pa_Data['freifeldwert3'] = '';

			global $user_prefix;
			if( !$this->if_user_exists( $user_prefix.$freifeldwert3 ) ){
				$this->ms_Number = $freifeldwert3;
			}
		}
    parent::SetPersonalData( $pa_Data );
  }


    /* -------------------- end personal information -------------------- */




    /* -------------------- services & limits -------------------- */
    function AddLimit ( $ps_Name, $ps_Value, $ps_Limit, $ps_Maximum, $ps_Hard, $ps_Reseller, $ps_Query=NULL )
    {
      global $ServerID;
	if ( $ps_Limit )
	{
	    $lo_Column = new ResellerLimitColumn ( $ps_Name, ltext("uc_$ps_Name"), $ps_Value );
	    $lo_Column->CallOnValidator ( 'SetLimit', $ps_Limit );
	    $lo_Column->CallOnValidator ( 'SetMaximum', $ps_Maximum );
	    $lo_Column->CallOnValidator ( 'SetHardLimit', $ps_Hard );
	    $lo_Column->CallOnValidator ( 'SetQuery', is_null($ps_Query) ?
		  "SELECT SUM($ps_Name) FROM kunden WHERE  server_id=".db_full_quote( $this->mcServerID )." AND anbieter = $ps_Reseller" : $ps_Query );
	    $this->ma_Services[$ps_Name] = $lo_Column;
	}
    }

    function AddService ( $ps_Name, $pa_ResellerData ){
			if ( $pa_ResellerData[$ps_Name] )
				$this->ma_Services[$ps_Name] = new ServiceColumn ( $ps_Name, ltext("uc_$ps_Name"), "1" );
    }

    function InitializeServices ( $pa_ResellerData ) {
      global $ServerID;
			$this->ma_Services = array();

			$ls_Reseller = db_full_quote($pa_ResellerData['anbieter']);

			$lo_Column = new ResellerStorageColumn ( "maxkb", ltext("uc_maxkb"), "" );
			$lo_Column->CallOnValidator( "SetLimit", $pa_ResellerData["maxkb"] );
			$lo_Column->CallOnValidator( "SetHardLimit", $pa_ResellerData["maxkblimit"] );
			$lo_Column->CallOnValidator( "SetQuery", "SELECT SUM(maxkb) FROM kunden WHERE  server_id=".db_full_quote( $this->mcServerID )." AND anbieter = $ls_Reseller" );
			$this->ma_Services["maxkb"] = $lo_Column;
      
      if( $pa_ResellerData['popmaxkb'] ){
        $lo_Column = new ResellerMailSpaceColumn ( "popmaxkb", ltext("uc_popmaxkb"), "" );
        $lo_Column->CallOnValidator( "SetLimit", $pa_ResellerData["popmaxkb"] );
        $lo_Column->CallOnValidator( "SetHardLimit", $pa_ResellerData["popmaxkblimit"] );
        $lo_Column->CallOnValidator( "SetQuery", 
                                      " SELECT SUM(popmaxkb) FROM kunden ".
                                      " WHERE  server_id=".db_full_quote( $this->mcServerID ).
                                      " AND anbieter = $ls_Reseller" );
        $this->ma_Services["popmaxkb"] = $lo_Column;
      }
			$this->AddLimit ( "maxpop", "-1", $pa_ResellerData["maxpop"], 
												0x7FFF, $pa_ResellerData["maxpoplimit"],
												$ls_Reseller );
			$this->AddLimit ( "maxemail", "-1", $pa_ResellerData["maxemail"], 
												0x7FFF, $pa_ResellerData["maxemaillimit"],
												$ls_Reseller );
			$this->AddLimit ( "maxautoresponder", "-1", $pa_ResellerData["maxautoresponder"], 
												0x7FFF,
												$pa_ResellerData["maxautoresponderlimit"], $ls_Reseller );
			$this->AddLimit ( "maxftp", "0", $pa_ResellerData["maxftp"], 
												0x7FFFFF, $pa_ResellerData["maxftplimit"],
												$ls_Reseller );

			$lo_Column = new ResellerTrafficColumn ( "maxtransfer", ltext("uc_maxtransfer"), "" );
			$lo_Column->CallOnValidator ( "SetLimit", $pa_ResellerData["maxtransfer"] );
			$this->ma_Services["maxtransfer"] = $lo_Column;

			$this->AddLimit ( "maxsubdomains", "0", $pa_ResellerData["maxsubdomains"], 
												0x7FFF,
												$pa_ResellerData["maxsubdomainslimit"], $ls_Reseller );
			$this->AddLimit ( "maxmysql", "1", $pa_ResellerData["maxmysql"], 
												0x7FFF, $pa_ResellerData["maxmysqllimit"],
												$ls_Reseller );
			$this->AddLimit ( "wildcard", "0", $pa_ResellerData["maxwildcards"], 
												0x7FFF, $pa_ResellerData["maxwildcardslimit"],
												$ls_Reseller );

			$this->AddLimit ( "maxatdomains", "0", $pa_ResellerData["maxatdomains"], 
												0x7FFF,
												$pa_ResellerData["maxatdomainslimit"], $ls_Reseller );
			$this->AddLimit ( "maxcronjobs", "0", $pa_ResellerData["maxcronjobs"], 
												0x7FFF, $pa_ResellerData["maxcronjobslimit"],
												$ls_Reseller );
			$this->AddLimit ( "maxmaillist", "0", $pa_ResellerData["maxmaillist"], 
												0x7FFFFFFF,
												$pa_ResellerData["maxmaillistlimit"], $ls_Reseller );
			$this->AddLimit ( 'maxwebapp',
												'0',
												$pa_ResellerData['maxwebapp'], 
												0x7FFF,
												$pa_ResellerData['maxwebapplimit'],
												$ls_Reseller );

			foreach ( array(  "ftp", "cssl", "php", "phpupload", "perl", "modpython", "ssi", 
											 "wap", "coldfusion", "frontpage" ) as $ls_Name ) {
				$this->AddService ( $ls_Name, $pa_ResellerData );
			}

			if ( $pa_ResellerData["shell"] && $pa_ResellerData["scponly"] )	{
				$this->ma_Services["shell"] = new SelectColumn
					( array( 0=>ltext("g_no"), 1=>ltext("uc_stdshell"), 2=>ltext("uc_scponly") ),
						"shell", ltext ("uc_shell"), "0" );
			}	elseif ( $pa_ResellerData["shell"] ) {
				$this->ma_Services["shell"] = new ShellColumn ( "shell", ltext ("uc_shell"), "0" );
			}	elseif ( $pa_ResellerData["scponly"] ) {
				$lo_Column = new ShellColumn ( "scponly", ltext ("uc_scponly"), "0" );
				$lo_Column->SetStandard (FALSE);
				$this->ma_Services["shell"] = $lo_Column;
			}

			foreach ( array( "dirlist", "statistik", "awstats", "pwschutz", "fehlerseiten", 
											 "webftp", "webmail", "stdcgi" ) as $ls_Name ) {
				$this->AddService ( $ls_Name, $pa_ResellerData );
			}

			if ( $pa_ResellerData["maxpop"] ){
				$this->AddService ( "spamfilter", $pa_ResellerData );
			}
			if ( $pa_ResellerData["backup"] ) {
				if( $pa_ResellerData["backup"] > 1 ){
					$this->ma_Services["backup"] = new SelectColumn	( array( 
																			0=>ltext("g_no"), 
																			1=>ltext("g_yes"), 
																			2=>ltext("uc_backup_upload") 
																		),
																		"backup", 
																		ltext ("uc_backup"), 
																		1 
																	);
				} else {
					$this->AddService ( "backup", $pa_ResellerData );
				}
			}

			$lo_Limits = new AllLimits ( "UserCanHave", $pa_ResellerData );
			for ( $lo_Limits->FirstService(); $lo_Service =& $lo_Limits->NextService(); ) {
				$this->ma_Services[$lo_Service->GetName()] = new ServiceColumn ( $lo_Service->GetName(),  $lo_Service->GetLabel(), "1" );
			}

    }


    function ValidateServices() {
			$ls_Result = TRUE;
			foreach ( array_keys($this->ma_Services) as $ls_Key )	{
				$lo_Column =& $this->ma_Services[$ls_Key];
				$lo_Validator =& $lo_Column->GetValidator();
				if ( method_exists ( $lo_Validator, "SetCurrentFromSQL" ) )
					$lo_Validator->SetCurrentFromSQL();
				if ( !$lo_Column->IsValid() )	{
					switch ( method_exists( $lo_Validator, "GetError" ) ?
									 $lo_Column->CallOnValidator( "GetError" ) : NULL )
						{
						case cc_LimitErrorLimit:
							if ($lo_Column->CallOnValidator("GetLimit")-$lo_Column->CallOnValidator("GetCurrent") < 0)
								$this->AddMessage ( ERROR, ltext( "kune3_error36", $lo_Column->GetLabel(), $lo_Column->CallOnValidator("GetCurrent"), 
																									$lo_Column->CallOnValidator("GetLimit") ) );
							else
								$this->AddMessage ( ERROR, ltext( "uc_limit", $lo_Column->GetLabel(),
																									$lo_Column->CallOnValidator("GetLimit")-$lo_Column->CallOnValidator("GetCurrent") ) );
							break;
						case cc_LimitErrorMaximum:
							$this->AddMessage ( ERROR, ltext( "uc_maximume", $lo_Column->GetLabel(),
																								$lo_Column->CallOnValidator( "GetMaximum" ) ) );
							break;
						case cc_LimitErrorInvalidChar:
						default:
							$this->AddMessage ( ERROR, ltext( "uc_invalidchar", $lo_Column->GetLabel() ) );
							break;
						}
					$ls_Result = FALSE;
	    }
	}
	if ( array_key_exists("maxemail",$this->ma_Services) && array_key_exists("maxautoresponder",$this->ma_Services) )
	{
	    $lo_EMail = $this->ma_Services["maxemail"];
	    $lo_Auto = $this->ma_Services["maxautoresponder"];
	    if ( $lo_EMail->GetValue() != -1 &&
		    ( $lo_Auto->GetValue() == -1 || $lo_Auto->GetValue()>$lo_EMail->GetValue() ) )
	    {
		$this->AddMessage ( ERROR, ltext("kune3_error7") );
		$ls_Result = FALSE;
	    }
	}
	if ( array_key_exists("ftp",$this->ma_Services) && array_key_exists("maxftp",$this->ma_Services) )
	{
	    $lo_FTP = $this->ma_Services["ftp"];
	    $lo_MaxFTP = $this->ma_Services["maxftp"];
	    if ( $lo_FTP->GetValue()==0 && $lo_MaxFTP->GetValue() != 0 )
     {
    $this->AddMessage ( ERROR, ltext("kune3_error9") );
    $ls_Result = FALSE;
	    }
	}
  
   
	if ( array_key_exists("shell",$this->ma_Services) && array_key_exists("ftp",$this->ma_Services) )
	{
	    $lo_Shell = $this->ma_Services["shell"];
	    $lo_FTP = $this->ma_Services["ftp"];
	    if ( $lo_Shell->GetValue()==1 && $lo_FTP->GetValue()==0 )
	    {
		$this->AddMessage ( ERROR, ltext("kune3_error14") );
		$ls_Result = FALSE;
	    }
	}
	if ( array_key_exists("php",$this->ma_Services) && array_key_exists("phpupload",$this->ma_Services) )
	{
	    $lo_PHP = $this->ma_Services["php"];
	    $lo_PHPUpload = $this->ma_Services["phpupload"];
	    if ( $lo_PHP->GetValue()==0 && $lo_PHPUpload->GetValue()==1 )
	    {
		$this->AddMessage ( ERROR, ltext("kund3_error26") );
		$ls_Result = FALSE;
	    }
	}
	if ( array_key_exists("maxsubdomains",$this->ma_Services) && array_key_exists("wildcard",$this->ma_Services) )
	{
	    $lo_Subdomains = $this->ma_Services["maxsubdomains"];
	    $lo_Wildcard = $this->ma_Services["wildcard"];
	    if ( $lo_Subdomains->GetValue()!=-1 && $lo_Subdomains->GetValue()<$lo_Wildcard->GetValue() )
	    {
		$this->AddMessage ( ERROR, ltext("kune3_error23") );
		$ls_Result = FALSE;
	    }
	}

       if ( array_key_exists("frontpage",$this->ma_Services) && array_key_exists("fehlerseiten",$this->ma_Services) )
        {
            $loErrorFiles = $this->ma_Services["fehlerseiten"];
            $loFrontPage = $this->ma_Services["frontpage"];
            if ($loFrontPage->GetValue()==1 && $loErrorFiles->GetValue() ==1 )
            {
                $this->AddMessage ( ERROR, ltext("anne2_error23") );
		                $ls_Result = FALSE;
	    }
	}
	
       if ( array_key_exists("frontpage",$this->ma_Services) && array_key_exists("pwschutz",$this->ma_Services) )
        {
	    $loFrontPage = $this->ma_Services["frontpage"];
	    $loPassProtect = $this->ma_Services["pwschutz"];
	    if ( $loFrontPage->GetValue()==1 && $loPassProtect->GetValue()==1 )
	    {
	        $this->AddMessage ( ERROR, ltext("anne2_error24") );
	        $ls_Result = FALSE;
	    }
	}
																			
	if ( array_key_exists("stdcgi",$this->ma_Services) && array_key_exists("perl",$this->ma_Services) )
	{
	    $lo_StdCGI = $this->ma_Services["stdcgi"];
	    $lo_Perl = $this->ma_Services["perl"];
	    if ( $lo_StdCGI->GetValue()==1 && $lo_Perl->GetValue()!=1 )
	    {
		$this->AddMessage ( ERROR, ltext("kune3_error25") );
		$ls_Result = FALSE;
	    }
	}
	return $ls_Result;
    }


    function SetServicesFromSQL ( $ps_Query )
    {
		$this->SetFromSQL ( $this->ma_Services, $ps_Query );
		$this->FixTraffic();
    }
    
    function SetServicesFromArray ( &$paServices )
    {
    	if ($paServices["scponly"]) {
    		$paServices["shell"] = 2;
    	}
		$this->SetFromArray ( $this->ma_Services, $paServices );
		$this->FixTraffic();
    }

    function FixTraffic()
    {
	if ( ( $ls_Value = $this->ma_Services["maxtransfer"]->GetValue() ) > 0 )
	    $this->ma_Services["maxtransfer"]->SetValue ( $ls_Value/1024 );
    }


    /**
     *  Cheks if service is enabled for user
     *
     *  @param string $pcService
     *  @return bool
     */
    function isServiceEnabled( $pcService ){

      $lbReturn = false;
      $liServiceState = 0;

      $laServices = array( 'quota'      => 'popmaxkb',
                           'cssl'       => 'cssl',
                           'frontpage'  => 'frontpage',
                           'shell'      => 'shell',
                           'scponly'    => 'scponly',
                           'statistik'  => 'statistik',
                           'awstats'    => 'awstats',
                           'webftp'     => 'webftp',
                           'webmail'    => 'webmail',
                           'stdcgi'     => 'stdcgi',
                           'phpupload'  => 'phpupload',
                           'wap'        => 'wap',
                           'coldfusion' => 'coldfusion',
                           'dirlist'    => 'dirlist',
                           'cgicheck' 	=> 'perl',
                           'pwschutz' 	=> 'pwschutz',
                           'password_protect' => 'pwschutz',
                           'errordocs'  => 'fehlerseiten',
                           'backup'     => 'backup'
                          );
      if( ! array_key_exists( $pcService, $laServices ) ){
        return $lbReturn;
      }
      
      $lrId = safe_query2( "SELECT {$laServices[$pcService]} FROM kunden WHERE kunde=? AND server_id=?",
                           new SQLString( $this->ms_Name ),
                           new SQLString( $this->mcServerID )
                           );
      list( $liServiceState ) = db_fetch_array( $lrId, 'N' );
      db_free_query( $lrId );

      if( $liServiceState ){
        $lbReturn = true;
      }

      return $lbReturn;
    }

    /* -------------------- end services & limits -------------------- */




    /* -------------------- domains -------------------- */
	function InitializeDomains ( $ps_Query ) {
		
    $this->ma_Domains = array();
    $this->ma_SharedDomains = array(); 
    $this->ma_NatDomains = array(); 
    $this->ma_DNS = array(); 
    $this->ma_DNR = array();
    $this->ma_DBDNR = array();

		$lo_DB =& get_db_connection();

		$lo_Query =& $lo_DB->Select ( $ps_Query );

		for ( $i=1; $la_Row =& $lo_Query->nextrow(); $i++ ) {
			$this->ma_Domains[$i] = trim( $la_Row["domain"] );
			$this->ma_SharedDomains[$i] = $this->ma_DNS[$i] = $this->ma_DNR[$i] = $this->ma_DBDNR[$i] = 0;
			if( array_key_exists( "dns", $la_Row ) )
				$this->ma_DNS[$i] = $la_Row["dns"];
		}

		$lo_Query->finish();
	}

	function InitializeDNS ( $ps_Query ){

		$this->ma_Domains = $this->ma_DNS = $this->ma_DNR = $this->ma_DBDNR = array();
	
		$lo_DB =& get_db_connection();
		
	
		$lo_Query =& $lo_DB->Select ( $ps_Query );
		for ( $i=1; $la_Row =& $lo_Query->nextrow(); $i++ ){
	    $ls_Domain = trim( $la_Row['domain'] );

	    $ls_IDN = get_html_idn_name( $ls_Domain );

	    $this->ma_Domains[$i] = $ls_Domain = $ls_IDN ? $ls_IDN : $ls_Domain;

	    if( $la_Row['neu'] == 2 ){
				$this->ma_DNS[$i] = $this->ma_DNR[$i] = 0;
				$this->ma_DBDNR[$ls_Domain] = $la_Row['dnr'];
	    }else{
				$this->ma_DNS[$i] = $la_Row['neu'] == 1 ? 1 : $la_Row['dns'];
				$this->ma_DBDNR[$ls_Domain] = $this->ma_DNR[$i] = $la_Row['dnr'];
	    }
		}
		$lo_Query->finish();
	}

	function InitializeDBDNR ( $ps_Query ){

		$this->ma_Domains = $this->ma_DNS = $this->ma_DNR = $this->ma_DBDNR = array();
	
		$lo_DB =& get_db_connection();
		
		$lo_Query =& $lo_DB->Select ( $ps_Query );

		while ( $la_Row =& $lo_Query->nextrow() ){
	    $ls_Domain = trim( $la_Row['domain'] );
	    $ls_IDN = get_html_idn_name($ls_Domain);
	    if ( $ls_IDN )
				$ls_Domain = $ls_IDN;
	    $this->ma_DBDNR[ $ls_Domain ] = $la_Row['dnr'];
		}
		$lo_Query->finish();
	}

	function GetDomains() {
		return $this->ma_Domains;
	}

	function GetNatDomains() {
		return $this->ma_NatDomains;
	}
    
	function &NatDomains( $paNatDomains = NULL ) {
		if( is_array( $paNatDomains ) ) {
			$this->ma_NatDomains = array();
			foreach ( array_keys($paNatDomains) as $liID ) {
				$this->ma_NatDomains[$liID] = $paNatDomains[$liID];
			}
			}
		return $this->ma_NatDomains;
	}
    
	function &Domains( $paDomains = NULL ) {
		if( is_array( $paDomains ) ) {
			$this->ma_Domains = array();
			foreach ( array_keys($paDomains) as $liID ) {
				$this->ma_Domains[$liID] = $paDomains[$liID];
				}
		}
		return $this->ma_Domains;
	}


	function GetDNS(){
		return $this->ma_DNS;
	}

	function &DNS( $paDNS = NULL ) {
		if( is_array( $paDNS ) ) {
			$this->ma_DNS = array();
			foreach ( array_keys($paDNS) as $liID ) {
				$this->ma_DNS[$liID] = $paDNS[$liID];
			}
		}
		return $this->ma_DNS;
	}


	function GetDNR(){
		return $this->ma_DNR;
	}

	function &DNR( $paDNR = NULL ) {
		if( is_array( $paDNR ) ) {
			$this->ma_DNR = array();
			foreach ( array_keys($paDNR) as $liID ) {
				$this->ma_DNR[$liID] = $paDNR[$liID];
			}
		}
		return $this->ma_DNR;
	}


	function GetDBDNR(){
		return $this->ma_DBDNR;
	}

	function SetDomains ( $pa_Domains ){
		$this->ma_Domains = $pa_Domains;
	}

	function SetSharedDomains ($paSharedDomains) {
		$this->ma_SharedDomains = $paSharedDomains;
  }
 	function GetSharedDomains(){
		return $this->ma_SharedDomains;
  }

  function SetNatDomains ($pa_NatDomains) {
		$this->ma_NatDomains = $pa_NatDomains;
	}
    
	function SetDNS ( $pa_DNS ){
		$this->ma_DNS = $pa_DNS;
	}

	function SetDNR ( $pa_DNR ){
		$this->ma_DNR = $pa_DNR;
  }

  function GetSharedDomainsCount(){
    $i = 0;
    foreach( $this->ma_SharedDomains as $key => $value){
      if( $value ){
        $i++;
      } 
    }
    return $i;
  }

	function SetDomainsData( $pa_POST ) {
		$this->SetDomains( $pa_POST['domain'] );
		$this->SetNatDomains( $pa_POST['natdomain'] );
		$this->SetDNS( $pa_POST['domdns'] );
		$this->SetSharedDomains( $pa_POST['domshared'] );
		$this->SetDNR( $pa_POST['domdnr'] );
  }

  /**
   * Validate domains	
   */
	function ValidateDomains ( $pa_Reseller ) {

		$la_Domains = $this->AdjustDomains();
		if( ! count( $la_Domains ) ){
			$this->AddMessage ( ERROR, ltext( 'kune5_error16' ) );
			return FALSE;
		}

    /**
     * todo: need to move this loop to set/get methods of dns and shared domains?
     */
    foreach( $this->ma_SharedDomains as $key => $value ){
      if( $value ){
        $this->ma_DNS[$key] = 0;
        $this->ma_DNR[$key] = 0;
      }
    }

		$loServerID = new SQLString( $this->mcServerID );		
		$loRes      = new SQLString( $pa_Reseller['anbieter'] );
    
			if( $pa_Reseller['maxdomains'] >= 0 && $pa_Reseller['maxdomainslimit'] ){
			$lrID = safe_query2( " SELECT COUNT(*) FROM domains WHERE server_id = ? ".
                           " AND anbieter = ? AND richtigedomain = 1", $loServerID, $loRes );
			list( $liCnt ) = db_fetch_array( $lrID );
			db_free_query( $lrID );

			if ( $liCnt +( count( $la_Domains ) - $this->GetSharedDomainsCount() ) > $pa_Reseller['maxdomains'] ){
				$this->AddMessage ( ERROR, ltext ( "kune5_error17", $pa_Reseller["maxdomains"], $la_Data[0] ) );
				return FALSE;
			}
      }

    if( $pa_Reseller['maxshareddomains'] >= 0 && $pa_Reseller['maxshareddomainslimit'] ){
			$lrID = safe_query2( " SELECT COUNT(*) FROM domains WHERE richtigedomain = 7 AND server_id = ? ".
                           " AND anbieter = ?", $loServerID, $loRes );
			list( $liCnt ) = db_fetch_array( $lrID );
			db_free_query( $lrID );

			if ( ( $liCnt + $this->GetSharedDomainsCount() ) > $pa_Reseller['maxshareddomains'] ){
				$this->AddMessage ( ERROR, ltext ( 'kune5_error26', $pa_Reseller['maxshareddomains'], $la_Data[0] ) );
				return FALSE;
			}
		}

		$lrID = safe_query2( "SELECT standarddomain, idn, userprefix FROM admin WHERE server_id=?",
												 $loServerID );
		list($lcStDomain,$llIDN, $lcUserPrefix) = db_fetch_array( $lrID, 'N' );
		db_free_query( $lrID );

		$ls_Expression = '/^'.$lcUserPrefix.'[0-9]+\.' . 
			str_replace( '.', '\.', $lcStDomain ) . '$/i';

    $la_WrongIDN = $la_Existing = $la_Badnames = $la_Reserved = array();

    /**
     * IDN
     */			
		foreach ( $la_Domains as $ls_Key => $ls_Domain ) {

			$ls_Translated = InputDecode::decode( $ls_Domain );

			if( $ls_Translated != $ls_Domain ){ //  there is a national character
				if( $llIDN  ){
					$lcIDN = translate_name_to_idn ( $ls_Translated );
					if( $lcIDN ){
						$ls_Domain = $lcIDN;
					}else{
						$la_WrongIDN[] = $ls_Domain;
					}
				}	else {
					$la_WrongIDN[] = $ls_Domain;
				}
			}
      
      if ( ! checkDomain( $ls_Domain ) 
           || preg_match ( "/^www\./i", $ls_Domain ) ){
				$la_Badnames[] = $ls_Domain;
				continue;
			}

			if( preg_match ( $ls_Expression, $ls_Domain ) ){
				$la_Reserved[] = $ls_Domain;
				continue;
			}
      if(! $this->ma_SharedDomains[$ls_Key] ){
        $lrID = safe_query2( "SELECT COUNT(domain) FROM domains WHERE domain = ? AND richtigedomain <> 7",
                             new SQLString( $ls_Domain ) );
        list( $liCnt ) = db_fetch_array( $lrID, 'N' );
        db_free_query( $lrID );
        if( $liCnt ){
          $la_Existing[] = $ls_Domain;
        }
      }else{
        /**
         * Check for black list
         */
        $lrID = safe_query2( "SELECT COUNT(domain) FROM domains WHERE domain = ? AND richtigedomain = 5",
                             new SQLString( $ls_Domain ) );
        list( $liCnt ) = db_fetch_array( $lrID, 'N' );
        db_free_query( $lrID );
        if( $liCnt ){
          $la_Existing[] = $ls_Domain;
        }
      }
		}
			
		$ls_Result = TRUE;
		if( count( $la_Badnames ) ){
			$this->AddMessage ( ERROR, ltext ( 'kune5_error19', implode ( ', ', $la_Badnames ) ) );
			$ls_Result = FALSE;
		}

		if( count( $la_WrongIDN ) ){
			$this->AddMessage ( ERROR, ltext ( 'error_bad_domains__no_idn_support', implode ( ", ", $la_WrongIDN ) ) );
			$ls_Result = FALSE;
		}

		if( count( $la_Existing ) ){
			$this->AddMessage ( ERROR, ltext ( 'kune5_error18', implode ( ', ', $la_Existing ) ) );
			$ls_Result = FALSE;
		}

		if( count( $la_Reserved ) ){
			$this->AddMessage ( ERROR, ltext ( 'kune5_error23', implode ( ', ', $la_Reserved ) ) );
			$ls_Result = FALSE;
		}
		return $ls_Result;
	}

	function AdjustDomains() {

		$la_Domains = $this->GetDomains();

		if( ! is_array( $la_Domains ) ){
			return array();
		}
			
		foreach ( array_keys($la_Domains) as $ls_Key ) {

			$ls_Domain = strtolower ( trim ($la_Domains[$ls_Key]) );

			if ( ! $ls_Domain ){
				unset ($la_Domains[$ls_Key]);
			}else{
				$la_Domains[$ls_Key] = $ls_Domain;
			}
		}

		return array_unique( $la_Domains );
	}

	function AdjustNatDomains() {

		$la_NatDomains = $this->GetNatDomains();

		if( ! is_array($la_NatDomains) ){
			return array();
		}
			
		foreach( array_keys($la_NatDomains) as $ls_Key ){
			$ls_NatDomain = strtolower ( trim ($la_NatDomains[$ls_Key]) );
			if( ! strlen($ls_NatDomain) ){
				unset ($la_NatDomains[$ls_Key]);
			}else{
				$la_NatDomains[$ls_Key] = $ls_NatDomain;
			}
		}
		return array_unique ($la_NatDomains);
	}

    /* -------------------- end domains -------------------- */





    /* -------------------- ips -------------------- */
	function InitializeIP (){
		$this->ms_CurrentIP = 'standard';
		$this->ms_Exclusive = FALSE;
	}

	function SetIPExclusive ( $pa_Data ){
		$this->ms_CurrentIP = $pa_Data['ip'];
		$this->ms_Exclusive = array_key_exists ( 'exclusiv', $pa_Data ) && 
			$pa_Data['exclusiv'];
	}

	function SetIP ( $ps_UserName ){

		if( $ps_UserName ){
		  $lo_DB =& get_db_connection();
		
	    $lo_Query =& $lo_DB->Select ( "SELECT ip FROM kunden WHERE server_id=".db_full_quote( $this->mcServerID )." AND kunde = " . db_full_quote($ps_UserName) );
	    if( $la_Row =& $lo_Query->nextrow() ){
				$this->ms_CurrentIP = $la_Row['ip'];
			} else {
				$this->ms_CurrentIP = '';
			}
			$lo_Query->finish();

	    if( ! strlen($this->ms_CurrentIP ) ){
				$lo_DB->Execute ( "UPDATE ipadressen SET kunde = '' WHERE server_id=".db_full_quote( $this->mcServerID )." AND kunde = " . db_full_quote($ps_UserName) );
			}

		}else{
			$this->ms_CurrentIP = 'standard';
    }
	}

    function SetExclusive ( $ps_UserName ){

		  $lo_DB =& get_db_connection();
		
			$lo_Query =& $lo_DB->Select ( "SELECT kunde FROM ipadressen WHERE server_id=".db_full_quote( $this->mcServerID )." AND ip = " . db_full_quote($this->ms_CurrentIP) .
																		" AND kunde = " . db_full_quote($ps_UserName) );
			$this->ms_Exclusive = $lo_Query->nextrow() ? TRUE : FALSE;
			$lo_Query->finish();
    }

    function GetIP(){
			return $this->ms_CurrentIP;
    }

    function GetExclusive(){
			return $this->ms_Exclusive;
    }

    function ValidateIP ( $pa_Reseller ){
      
			if ( $this->ms_CurrentIP != 'standard' ){
	    
				$lo_DB =& get_db_connection();
		
				$lo_Query =& $lo_DB->Select ( "SELECT ip FROM ipadressen WHERE server_id=".db_full_quote( $this->mcServerID )." AND anbieter = " .
		    db_full_quote($pa_Reseller['anbieter']) . " AND kunde = '' AND ip = " .
																			db_full_quote($this->ms_CurrentIP) );
				if( ! ( $la_Row =& $lo_Query->nextrow() ) ) {
					$this->AddMessage ( ERROR, ltext("kune5_error21") );
					return FALSE;
				}
				$lo_Query->finish();

				if( $this->ms_Exclusive ){
					$lo_Query =& $lo_DB->Select ( "SELECT ip FROM kunden WHERE server_id=".db_full_quote( $this->mcServerID )." AND ip = " . db_full_quote($this->ms_CurrentIP) );
					if ( $lo_Query->nextrow() ){
						$this->AddMessage ( ERROR, ltext("kune5_error22") );
						return FALSE;
					}
					$lo_Query->finish();
				}
			}
			return TRUE;
    }
    /* -------------------- end ips -------------------- */





    /* -------------------- user registration -------------------- */
    function ValidateRegistration ( $pa_Reseller ){

			if ( $pa_Reseller['maxkunden'] < 0 || !$pa_Reseller['maxkundenlimit'] ){
				return TRUE;
			}
		  $lo_DB =& get_db_connection();
		
			$lo_Query =& $lo_DB->Select ( "SELECT COUNT(*)+1 FROM kunden WHERE server_id=".db_full_quote( $this->mcServerID )." AND anbieter = " .
																		db_full_quote($pa_Reseller['anbieter']) );
			$la_Data =& $lo_Query->nextrow();
			$lo_Query->finish();

			return $pa_Reseller['maxkunden'] >= $la_Data[0];
    }

		function DefineUserNumber(){

		  $lo_DB =& get_db_connection();
			$lo_Query =& $lo_DB->Select( "SELECT userprefix FROM admin WHERE server_id=".db_full_quote( $this->mcServerID ) );

			list( $lcUserPrefix ) = $lo_Query->nextrow();
			$lo_Query->finish();

			if( ! isset( $this->ms_Number ) ){
				$this->ms_Number = $this->find_new_user_id();	// call to static function
			}
			$this->ms_Name = $lcUserPrefix.$this->ms_Number;
		}

		function SaveIP ( $pa_Reseller ){
			if( $this->ms_CurrentIP != 'standard' ){
				if( $this->ms_Exclusive ){
					$lo_DB =& get_db_connection();
		    

					$loFldsUpdate = new SQLFieldSet( new SQLField( 'kunde', $this->ms_Name, 'C'),
																					 new SQLField( 'lastchange', $this->ms_Timestamp)										 
																					 );

					$loFldsWhere = new SQLFieldSet( new SQLField( 'ip', $this->ms_CurrentIP, 'C'),
																					new SQLField( 'anbieter', $pa_Reseller["anbieter"], 'C'),
																					new SQLField( 'kunde', '', 'C'),
																					new SQLField( 'server_id', $this->mcServerID, 'C')
																					);
					$lcSQL = "UPDATE ipadressen SET ".$loFldsUpdate->getSQLUpdate().
						" WHERE ".$loFldsWhere->getSQLWhere();
					
					$lo_DB->Execute ( $lcSQL );

				}
			} else {
				$this->ms_CurrentIP = $pa_Reseller["standardip"];
			}
		}
	
		function AddSharedDomain( $ps_Domain, $pa_Reseller ){
		
		$loKunde = new SQLField( 'kunde', $this->ms_Name, 'C' );

		$loFlds = new SQLFieldSet( new SQLField( 'domain', $ps_Domain, 'C' ),
															 $loKunde,
															 new SQLField( 'anbieter', $pa_Reseller['anbieter'], 'C' ),
															 new SQLField( 'server_id', $this->mcServerID, 'C')
															 );

		list( $lcFlds, $lcVls ) = $loFlds->getSQLInsert();
		$lcSQL = "INSERT INTO domains ( $lcFlds, richtigedomain, httpd ) VALUES ( $lcVls, 7,0 )";
    db_query( $lcSQL );
		$ls_ID = db_insert_id( 'domains', 'id' );
		return $ls_ID;
  }

	function AddDomain ( $ps_Domain, $pa_Reseller, $ps_Type, 
												 $ps_DNS=0, $ps_DNR=0 ) {
		
		$loKunde = new SQLField( 'kunde', $this->ms_Name, 'C' );

		$loFlds = new SQLFieldSet( new SQLField( 'domain', $ps_Domain, 'C' ),
															 $loKunde,
															 new SQLField( 'anbieter', $pa_Reseller['anbieter'], 'C' ),
															 new SQLField( 'richtigedomain',$ps_Type),
															 new SQLField( 'pfad', '/', 'C' ),
															 new SQLField( 'lastchange', $this->ms_Timestamp ),
															 new SQLField( 'zusatz', $pa_Reseller['httpdspezial'], 'C'),
															 new SQLField( 'dns', $ps_DNS ),
															 new SQLField( 'dnr', $ps_DNR ),
															 new SQLField( 'server_id', $this->mcServerID, 'C')
															 );

		list( $lcFlds, $lcVls ) = $loFlds->getSQLInsert();
		$lcSQL = "INSERT INTO domains ( $lcFlds ) VALUES ( $lcVls )";
		db_query( $lcSQL );
		$ls_ID = db_insert_id( 'domains', 'id' );

		safe_query2( "UPDATE domains SET grp = id WHERE server_id=? AND".
								 " kunde=". $loKunde->getSQLValue().
								 " AND grp != id AND richtigedomain IN (1,2)",
								 new SQLString( $this->mcServerID ) );
    
		domain_aendern ( $ps_Domain, 'anlegen', $this->ms_Name, $this->mcServerID );

		fpalias_aendern ( $ps_Domain, 'anlegen', $this->ms_Name, $this->mcServerID );

		return $ls_ID;

	}

	function SaveDomains ( $pa_Reseller, $pa_Admin ) {
		global $DEBUG;

		$la_Domains = $this->AdjustDomains();
		$la_NatDomains = $this->AdjustNatDomains();

		if($DEBUG){
			echo "User::SaveDomains : NatDomains <br><pre>\n";
			print_r( $this->ma_NatDomains );
			echo "</pre><hr>\n";
		}
		
		$ls_Template = $ls_Primary = $ls_Secondary = NULL;
		$ls_IDN = $pa_Admin['idn'];
		$ls_SaveIDN = FALSE;

		$lcDnrPhp = dirname(__FILE__) . "/../dnr.php";
		if( file_exists( $lcDnrPhp )	) {
			include_once ( $lcDnrPhp );
		} else {
			$lcDnrPhp = '';
		}

		foreach( $la_Domains as $ls_ID => $ls_Domain ) {
			if ( $ls_IDN ) {
				$ls_Translated = InputDecode::decode ($ls_Domain);
				if ( $ls_Translated != $ls_Domain ) {
					$ls_Domain = translate_name_to_idn( $ls_Translated );
					$ls_SaveIDN = TRUE;
				}	else { 
					$ls_SaveIDN = FALSE;
				}
			}
			$ls_DNS = $pa_Reseller['dns'] && $this->ma_DNS[$ls_ID] ? 1 : 0;
			$ls_DNR = $pa_Reseller['dnr'] && $this->ma_DNR[$ls_ID] ? 1 : 0;
      $ls_Shared = $pa_Reseller['maxshareddomains'] && $this->ma_SharedDomains[$ls_ID] ? 1 : 0;

      if( $ls_Shared ){
        $ls_ID1 = $this->AddSharedDomain( $ls_Domain, $pa_Reseller );

        if( $ls_SaveIDN 
            && array_key_exists( $ls_ID, $this->ma_NatDomains ) 
            && $this->ma_NatDomains[$ls_ID] ){

	    			save_idn_alias ( $ls_ID1, 
  						  						 $this->ma_NatDomains[$ls_ID],
								    				 FALSE,
										    		 $this->ServerID() );
            }
        continue;
      }

			$ls_ID1 = $this->AddDomain ( $ls_Domain, $pa_Reseller, 1, $ls_DNS, $ls_DNR );
			$ls_ID2 = $this->AddDomain ( "www.".$ls_Domain, $pa_Reseller, 2, 0, 0 );

			if( $ls_SaveIDN &&
					 array_key_exists( $ls_ID, $this->ma_NatDomains ) &&
					 $this->ma_NatDomains[$ls_ID] ){

				save_idn_alias ( $ls_ID1, 
												 $this->ma_NatDomains[$ls_ID],
												 FALSE,
												 $this->ServerID() );

				save_idn_alias ( $ls_ID2, 
												 "www.".$this->ma_NatDomains[$ls_ID],
												 FALSE,
												 $this->ServerID() );

			}

			if ( $ls_DNS || $ls_DNR ) {
				list($ls_Zonefile, $ls_Serial) = ff_ProcessTemplate( array( $pa_Reseller['anbieter'], $this->mcServerID ), 
																														 $ls_Domain,
																														 $this->ms_CurrentIP,
																														 NULL,
																														 $ls_Template,
																														 $ls_Primary,
																														 $ls_Secondary
																															
																														 );
				
				$loFlds = new SQLFieldSet( new SQLField( 'domain', $ls_Domain, 'C' ),
																	 new SQLField( 'zonefile', $ls_Zonefile, 'C' ),
																	 new SQLField( 'lastchange', $this->ms_Timestamp),
																	 new SQLField( 'neu', 1 ),
																	 new SQLField( 'anbieter', $pa_Reseller['anbieter'], 'C' ),
																	 new SQLField( 'kunde', $this->ms_Name, 'C'),
																	 new SQLField( 'server_id', $this->mcServerID, 'C')
																	 );

				list($lcFields,$lcVals) = $loFlds->getSQLInsert();

				$lcSQL = "INSERT INTO dns ( $lcFields ) VALUES ( $lcVals )";
				db_query( $lcSQL ); 

				$lcSQL = "UPDATE allgemein SET dns = 1 WHERE server_id=".db_full_quote( $this->mcServerID )."";
				db_query ( $lcSQL );

				if ( $ls_DNR && $lcDnrPhp ) {
					
					global $dnr_c_firstname,$dnr_c_gender,$dnr_c_plz,$dnr_c_land,$dnr_c_name,$dnr_c_firma,
						$dnr_c_anschrift,$dnr_c_ort,$dnr_c_telefon,$dnr_c_telefax,$dnr_c_emailadresse,
						$dnr_d_domain,$dnr_d_pns,$dnr_d_sns;
						
					global $dnr_a_firstname,$dnr_a_gender,$dnr_a_plz,$dnr_a_land,$dnr_a_name,$dnr_a_firma,
						$dnr_a_anschrift,$dnr_a_ort,$dnr_a_telefon,$dnr_a_telefax,$dnr_a_emailadresse;

					$dnr_c_firstname = $this->ma_Personal['firstname']->GetValue();
					$dnr_c_gender = $this->ma_Personal['gender']->GetValue();
					$dnr_c_plz = $this->ma_Personal['plz']->GetValue();
					$dnr_c_land = $this->ma_Personal['land']->GetValue();
					$dnr_c_name = $this->ma_Personal['name']->GetValue();
					$dnr_c_firma = $this->ma_Personal['firma']->GetValue();
					$dnr_c_anschrift = $this->ma_Personal['anschrift']->GetValue();
					$dnr_c_ort = $this->ma_Personal['plzort']->GetValue();
					$dnr_c_telefon = $this->ma_Personal['telefon']->GetValue();
					$dnr_c_telefax = $this->ma_Personal['fax']->GetValue();
					$dnr_c_emailadresse = $this->ma_Personal['emailadresse']->GetValue();
					$dnr_d_domain = $ls_Domain;
					$dnr_d_pns = $ls_Primary;
					$dnr_d_sns = $ls_Secondary;
					$dnr_a_firstname = $pa_Reseller['firstname'];
					$dnr_a_gender = $pa_Reseller['gender'];
					$dnr_a_plz = $pa_Reseller['plz'];
					$dnr_a_land = $pa_Reseller['land'];
					$dnr_a_name = $pa_Reseller['name'];
					$dnr_a_firma = $pa_Reseller['firma'];
					$dnr_a_anschrift = $pa_Reseller['anschrift'];
					$dnr_a_ort = $pa_Reseller['plzort'];
					$dnr_a_telefon = $pa_Reseller['telefon'];
					$dnr_a_telefax = $pa_Reseller['fax'];
					$dnr_a_emailadresse = $pa_Reseller['emailadresse'];

					sendDnr();

				}
			}
   }	
			$ls_Domain = $this->ms_Name . '.' . $pa_Admin['standarddomain'];
      
			safe_query2( "DELETE FROM domains WHERE domain=?",
									 new SQLString( $ls_Domain )
									 );
			$this->AddDomain ( $ls_Domain, $pa_Reseller, 3, 0, 0 );

			set_countdomains ( $this->ms_Name, $this->ServerID() );
		
	}

	function SaveServices ( $pa_Reseller, $pa_Admin ){
    global $OBJECT_STAT;
    global $EVENT_CHANGE; 

		$lo_DB =& get_db_connection();
		
		$loKunde = new SQLField( 'kunde', $this->ms_Name, 'C' );
		$loRes = new SQLField( 'anbieter', $pa_Reseller['anbieter'], 'C' );
		
		$loAllgemein = new SQLFieldSet();
		
		if( array_key_exists( 'statistik', $this->ma_Services ) && 
				$this->ma_Services['statistik']->GetValue() ){

			$loFields = new SQLFieldSet( $loKunde, 
																	 new SQLField('loeschen',0), 
																	 new SQLField('neu',1), 
																	 new SQLField('server_id',$this->mcServerID,'C'), 
																	 $loRes
																	 );

			list( $lcFlds, $lcVals ) = $loFields->getSQLInsert();
			$lcSQL = "INSERT INTO webalizer ( $lcFlds ) VALUES ( $lcVals )";
			$lo_DB->Execute ( $lcSQL );
			
			$loAllgemein->addField( 'webalizer', 1 );
		}

		/**
		* Add event to AWstats
	  */
		if( array_key_exists( 'awstats', $this->ma_Services ) && 
				$this->ma_Services['awstats']->GetValue() ) {

    	eventAdd( $OBJECT_STAT,
								$EVENT_CHANGE,
								$this->ms_Name,
								$this->mcServerID );
		}
		
		if( array_key_exists( 'perl', $this->ma_Services ) && 
				 $this->ma_Services['perl']->GetValue() )	{

			$loFields = new SQLFieldSet( $loKunde, 
																	 new SQLField('loeschen',0), 
																	 new SQLField('neu',1), 
																	 new SQLField('server_id',$this->mcServerID,'C'), 
																	 $loRes
																	 );
			list($lcFlds,$lcVals) = $loFields->getSQLInsert();
			$lcSQL = "INSERT INTO perl ( $lcFlds ) VALUES ( $lcVals )";
			$lo_DB->Execute ( $lcSQL );
			

			$loAllgemein->addField( 'perl', 1 );

		}

		if( array_key_exists( 'stdcgi', $this->ma_Services ) && 
				 $this->ma_Services['stdcgi']->GetValue() ) {

			$loAllgemein->addField( 'stdcgi', 1 );

		}

		$lo_DB->Execute( "UPDATE kunden SET httpd = 1 WHERE server_id=".db_full_quote( $this->mcServerID )." AND kunde=".$loKunde->getSQLValue() );


		$loAllgemein->addField( 'adduser', 1 );
		$loAllgemein->addField( 'httpd', 1 );
		$loAllgemein->addField( 'quota', 1 );


		if( $pa_Admin['neukundenreload'] == 1 ){
			$loAllgemein->addField( 'httpdupdate', 0 );
		}

		if( $pa_Admin['spamfilter'] ) {
			$loAllgemein->addField( 'spamupdate', 1 );
		}

		$lcSQL = "UPDATE allgemein SET ".$loAllgemein->getSQLUpdate()." WHERE server_id=".db_full_quote( $this->mcServerID )."";
		
		$lo_DB->Execute( $lcSQL );
		
	}

	function SaveUser ( $pa_Reseller, $ps_UID, $pa_Admin ){
		global $DEBUG;
		global $lang_short, $kbtyp, $popkbtyp;

		if( ! $this->ms_Password ){
			$this->ms_Password = mkpasswd(8);
		}

		$ls_Password = crypt_pw ( $this->ms_Password );

		$loFlds = new SQLFieldSet( new SQLField('kunde',$this->ms_Name,'C'),
															 new SQLField('number',$this->ms_Number),
															 new SQLField('uid',$ps_UID),
															 new SQLField('longpw',$ls_Password,'C'),
															 new SQLField('statistiklongpw',$ls_Password,'C'),
															 new SQLField('anbieter',$pa_Reseller["anbieter"],'C'),
															 new SQLField('anmeldedatum',$this->ms_Timestamp),
															 new SQLField('ip',$this->ms_CurrentIP,'C'),
															 new SQLField('server_id',$this->mcServerID,'C'),
															 new SQLField('quota',1),
															 new SQLField('language',$lang_short,'C'),
															 new SQLField('lastchange',$this->ms_Timestamp),
															 new SQLField('httpdspezial',$pa_Reseller["httpdspezial"],'C'),
															 new SQLField('maxidn',-1)
														 );

		foreach ( $this->ma_Personal as $ls_Key => $lo_Column ){
  		$lcName = $lo_Column->GetName();
      if( $lcName ){
        if( ! ( is_a( $lo_Column, 'definablecolumn' ) 
                && $lo_Column->GetLabelText() == 'add-user' ) ){
				$loFlds->addField( $lcName, $lo_Column->GetValue(), 'C' );

				if( is_a( $lo_Column, 'definablecolumn' ) ) {
					$lcName = $lo_Column->GetLabelName();
					if( $lcName ){
						$loFlds->addField( $lcName, $lo_Column->GetLabelText(), 'C' );
					}
				}					
		  }
			}elseif( $ls_Key == 'kundendatenanzeigen' ){
				$loClmn =& $lo_Column->getColumn( 1 );
				if( $loClmn ){
					$loFlds->addField( $loClmn->GetName(), $loClmn->GetValue() );
				}
			}
		}

		foreach ( $this->ma_Services as $ls_Key => $lo_Column ){

			if( $DEBUG ){
				echo "User::SaveUser $ls_Key => ".$lo_Column->GetValue()."<br>\n";
			}

			switch( $ls_Key ){
			case 'maxtransfer':

				$liVal = $lo_Column->GetValue();

				$loFlds->addField( 'maxtransfer', ($liVal>0)? $liVal*1024: $liVal );
				break;

			case 'maxkb':
				$ls_Value = $lo_Column->GetValue();
				if ( $ls_Value >= 0 )
					switch ( $kbtyp ) {
					case "MB":
						$ls_Value *= 1024;
						break;
					case "GB":
						$ls_Value *= 1024 * 1024;
						break;
					}
				$loFlds->addField( 'maxkb', $ls_Value );
				break;
      case 'popmaxkb':
        $ls_Value = $lo_Column->GetValue();
        if ( $ls_Value >= 0 )
          switch ( $popkbtyp ) {
          case "MB":
            $ls_Value *= 1024;
            break;
          case "GB":
            $ls_Value *= 1024 * 1024;
            break;
          }
        $loFlds->addField( 'popmaxkb', $ls_Value );
        break;

			case 'shell':
				switch ( $lo_Column->GetValue() ){
				case 1:
					$loFlds->addField( 'shell', 1 );
					break;
				case 2:
					$loFlds->addField( 'scponly', 2 );
				}
				break;
					
			default:
				if( $ls_Key ){
					$loFlds->addField( $ls_Key, $lo_Column->GetValue() );
				}
				break;
			}
		}
		
		if( !array_key_exists( 'backup', $this->ma_Services ) ){
			$loFlds->addField( 'backup', 0 );
		}
   
    if( $pa_Admin['quota'] ){
      $loFlds->addField( 'def_popmaxkb', $pa_Admin['popmaxkb'] );
      $loFlds->addField( 'def_popmaxkbhard', $pa_Admin['popmaxkbhard'] );
    }

    $lo_DB =& get_db_connection();
   
		list($lcFlds,$lcVals) = $loFlds->getSQLInsert();
		$lcSQL = "INSERT INTO kunden ( $lcFlds ) VALUES ( $lcVals )";

		return $lo_DB->Execute ( $lcSQL );
	}
		
	function RegisterUser ( $pa_Reseller, $pa_Admin ) {
		$this->ms_Timestamp = time();

		$ls_UID = getuid();

		$this->DefineUserNumber ();

		$this->SaveIP ( $pa_Reseller );

		$this->SaveUser ( $pa_Reseller, $ls_UID, $pa_Admin );

		freeuid();

		$this->SaveDomains ( $pa_Reseller, $pa_Admin );
		$this->SaveServices ( $pa_Reseller, $pa_Admin );
	}
	/* -------------------- end user registration -------------------- */

/*---------------------- delete user -------------------------*/
	function Delete($ps_Reseller){
		global $DEBUG;

		$lo_DB =& get_db_connection();
		
		$kunde = $this->ms_Name;

// check if user exists	
		$sql = "SELECT kunde,anbieter FROM kunden WHERE server_id=".db_full_quote( $this->mcServerID ).
			" AND kunde='$kunde' AND anbieter='$ps_Reseller'";
		$lo_Query =& $lo_DB->Select($sql);
		if( ! $lo_Query->getNumRows()){
			return FALSE;
		}
		$lo_Query->finish();

		$lo_Query =& $lo_DB->Select("SELECT account FROM delaccs WHERE server_id=".db_full_quote( $this->mcServerID )." AND account = '$kunde'");
		if( ! $lo_Query->getNumRows() ){
			db_query( "INSERT INTO delaccs (account, type, kunde, anbieter, server_id) ".
								" VALUES ('$kunde', 'kunde', '$kunde', '$ps_Reseller', ".db_full_quote( $this->mcServerID ).")");
		}
		$lo_Query->finish();
		
// pop3 account		
		$loRes =& $lo_DB->Select( "SELECT account FROM pop3 WHERE server_id=".db_full_quote( $this->mcServerID )." AND kunde='$kunde' and anbieter='$ps_Reseller'");
		while( $la_Row = $loRes->nextrow() ){
			$account = $la_Row[0];

			$lo_Query =& $lo_DB->Select( "SELECT account FROM delaccs WHERE server_id=".db_full_quote( $this->mcServerID )." AND account = '$account'");
			if( ! $lo_Query->getNumRows() ){
				db_query( "INSERT INTO delaccs (account, type, kunde, anbieter, server_id) VALUES ('$ccount', 'pop3', '$kunde', '$ps_Reseller', ".db_full_quote( $this->mcServerID ).")");
			}	

			$lo_DB->Execute( "DELETE FROM webmail_ab WHERE server_id=".db_full_quote( $this->mcServerID )." AND pop3='$account'");

			$lo_DB->Execute( "DELETE FROM webmail_session WHERE server_id=".db_full_quote( $this->mcServerID )." AND pop3='$account'");

			$lo_DB->Execute( "DELETE FROM webmail_sign WHERE server_id=".db_full_quote( $this->mcServerID )." AND pop3='$account'");
		
		}		
		$loRes->finish();

		$lo_DB->Execute( "DELETE FROM pop3 WHERE server_id=".db_full_quote( $this->mcServerID )." AND kunde='$kunde'");
// end pop3 account		

// email	account	
		$lo_DB->Execute( "DELETE FROM email WHERE server_id=".db_full_quote( $this->mcServerID )." AND kunde='$kunde' AND neu = 1");

		$lo_DB->Execute( "DELETE FROM webapp_user WHERE server_id=".db_full_quote( $this->mcServerID )." AND kunde='$kunde'");


		$loRes =& $lo_DB->Select("SELECT prefix,domain FROM email WHERE server_id=".db_full_quote( $this->mcServerID )." AND kunde = '$kunde'"); 

		while( $la_Row = $loRes->nextrow() ){
			$account = $la_Row[0];
      $pfad = $la_Row[1];
			$lo_Query =& $lo_DB->Select( "SLEECT account FROM delaccs WHERE server_id=".db_full_quote( $this->mcServerID )." AND account = '$account'");
			if( ! $lo_Query->getNumRows() ){
      	$lo_DB->Execute("INSERT INTO delaccs (account, type, kunde, pfad, server_id) ".
												" VALUES ('$account', 'alias', '$kunde', '$pfad', ".db_full_quote( $this->mcServerID ).")");
			}	
			$lo_Query->finish();
		}		
		$loRes->finish();

		$lo_DB->Execute( "DELEET FROM email WHERE server_id=".db_full_quote( $this->mcServerID )." AND kunde='$kunde'");
// end email account		

// domains
		$lo_Query =& $lo_DB->Select("SELECT domain, id FROM domains WHERE server_id=".db_full_quote( $this->mcServerID )." AND kunde='$kunde'");
		$la_IDs = array();
		while( $la_Row = $lo_Query->nextrow() ){
			$domain = $la_Row[0];
			$la_IDs[] = $la_Row[1];

			domain_aendern( $domain, 'loeschen', $kunde, $this->mcServerID );

			fpalias_aendern( $domain, 'loeschen', $kunde, $this->mcServerID );
		}
// end domains
// links to domains
		if( count($la_IDs ) ){
			$ls_idList=implode(',', $la_IDs);
			
			$lo_Query =& $lo_DB->Select("SELECT id FROM maillist WHERE  server_id=".db_full_quote( $this->mcServerID )." AND  domain_id IN ($ls_idList) AND neu<>3");
			$la_IDs = array();
			while( $la_Row = $lo_Query->nextrow() ){
				$la_IDs[] = $la_Row[0];
			}

			MailListPage::deleteLists ($la_IDs, $this->mcServerID );
			
			$lo_DB->Execute( "DELETE FROM atdomains WHERE server_id=".db_full_quote( $this->mcServerID )." AND id_from IN ($ls_idList)");
			
			$lo_DB->Execute( "DELETE FROM idn_aliases WHERE server_id=".db_full_quote( $this->mcServerID )." AND domain_id IN ($ls_idList)");
			
		}
// end links to domains		

		$lo_DB->Execute("delete from kunden where  server_id=".db_full_quote( $this->mcServerID )." AND  kunde='$kunde' and anbieter='$ps_Reseller'");
		$lo_DB->Execute("delete from alerts where server_id=".db_full_quote( $this->mcServerID )." AND kunde='$kunde' and anbieter='$ps_Reseller'");
		$lo_DB->Execute("delete from cronjobs where server_id=".db_full_quote( $this->mcServerID )." AND kunde='$kunde'");
		$lo_DB->Execute("delete from domains where server_id=".db_full_quote( $this->mcServerID )." AND kunde='$kunde'");
		$lo_DB->Execute("delete from autoresponder where server_id=".db_full_quote( $this->mcServerID )." AND kunde='$kunde'");
		$lo_DB->Execute("delete from ftp where server_id=".db_full_quote( $this->mcServerID )." AND kunde='$kunde'");
		$lo_DB->Execute("delete from pwschutz where server_id=".db_full_quote( $this->mcServerID )." AND kunde='$kunde'");
		$lo_DB->Execute("delete from htaccess where server_id=".db_full_quote( $this->mcServerID )." AND kunde='$kunde'");
		$lo_DB->Execute("delete from fehlermeldungen where server_id=".db_full_quote( $this->mcServerID )." AND kunde='$kunde'");
		$lo_DB->Execute("delete from perl where server_id=".db_full_quote( $this->mcServerID )." AND kunde='$kunde'");
		$lo_DB->Execute("delete from webalizer where server_id=".db_full_quote( $this->mcServerID )." AND kunde='$kunde'");

		$lo_DB->Execute("update ereignisse set geloescht=1 where server_id=".db_full_quote( $this->mcServerID )." AND kunde='$kunde'");
		$lo_DB->Execute("update cssl set loeschen = 1 where server_id=".db_full_quote( $this->mcServerID )." AND kunde='$kunde'");
		$lo_DB->Execute("update ipadressen set kunde='' where server_id=".db_full_quote( $this->mcServerID )." AND kunde='$kunde' and anbieter='$ps_Reseller'");
		$lo_DB->Execute("update transfer set geloescht=1 where server_id=".db_full_quote( $this->mcServerID )." AND kunde='$kunde'");
		$lo_DB->Execute("update frontpage set loeschen=1, neu=0 where server_id=".db_full_quote( $this->mcServerID )." AND kunde='$kunde'");

		$lo_DB->Execute("update allgemein set deluser=1, delpop=1, httpd=1, aliases=1, dns=1, frontpage=1, cssl=1, frontpagedel=1 WHERE server_id=".db_full_quote( $this->mcServerID )."");

		$lo_Query =& $lo_DB->Select("select dbname from mysql_datenbanken where server_id=".db_full_quote( $this->mcServerID )." AND kunde = '$kunde' and anbieter = '$ps_Reseller'");
		if ($lo_Query->getNumRows()){
			$la_dbnames=array();
			while($la_Row=$lo_Query->nextrow()){
				$la_dbnames[]=$la_Row[0];
			}			
			$lo_DB->Execute("delete from mysql_datenbanken where server_id=".db_full_quote( $this->mcServerID )." AND kunde = '$kunde' and anbieter = '$ps_Reseller'");
			
			/* -------------------- SOAP area -------------------- */
			$local_paswd = $_SESSION['_users'][$this->mcServerID][$PHP_AUTH_USER]['password'];
	    $chunks = array( '../cgi-bin/soap/delete_user.pl',
									 "-h=$local_host",
									 "-l=$PHP_AUTH_USER",
									 "-p=\"$local_paswd\"",
									 "-u=$kunde"
								 );
      	if( $DEBUG ){
      		$chunks[] = "-dbg";
      	}
      
      	$chunks[] =  '2>&1';
      								 
      	$cmd = join(' ',$chunks);
      
      	if( $DEBUG ){
      		echo "run: $cmd<br>\n"; 
      	}
      
      	$fh = popen( $cmd, 'r' );
      	$error = array();
      	$unlocked = '';
      	while( ! feof( $fh ) ){
      		$line = fgets( $fh );
      		
      		if( $DEBUG ){
      			echo "$line<br>\n";
      		}
      		list($key,$value) = split(':',$line,2);
      		$key = trim($key);
      		$value = trim($value);
      
      		if( $key == 'session_id' ){
      			$session_id = $value;
      		}elseif( $key == 'delete' ){
      			$unlocked = $value;
      		}elseif( strpos( $key, 'error-' ) === 0 ){
      			$error[$key] = $value;
      		}
      	}
      	pclose( $fh );

			/*
			@mysql_connect($mysql_user_host, $mysql_user_user, $mysql_user_pass);
			@mysql_select_db("mysql");
			@mysql_query("delete from db where User = '$kunde'");
			@mysql_query("delete from user where User = '$kunde'");

			foreach($la_dbnames as $db){
        @mysql_query("drop database $db");
			}
			
			@mysql_query("FLUSH PRIVILEGES");
			@mysql_close();*/
			/* -------------------- end of SOAP area -------------------- */
		}
		return TRUE;
	}
/*---------------------- end delete user -------------------------*/    

/* ---------------------------- Statistics ---------------------------------*/
	function SetStatistics($pm_Key, $pm_Value=''){
		global $DEBUG;
		if (is_array($pm_Key)){
			foreach($pm_Key as $ls_Key => $lm_Value){
				$this->ma_Statistics[$ls_Key]=$lm_Value;
			}
		}else{
			$this->ma_Statistics[$pm_Key]=$pm_Value;
		}
	}	

	function GetStatistics($ps_Key,$pm_Default=NULL){
		global $DEBUG;
		if(	array_key_exists($ps_Key,$this->ma_Statistics)){
			return $this->ma_Statistics[$ps_Key];
		}else{
			return $pm_Default;	
		}
	}
/* -------------------------- end Statistics -------------------------------*/
	
/* ------------------------ Settings ----------------------*/
	function FillSettings(){
		if( $this->ms_Name ){

			$lo_DB =& get_db_connection();
		  
			$lo_Query =& $lo_DB->Select ( "SELECT * FROM kunden WHERE server_id=".db_full_quote( $this->mcServerID )." AND kunde='".db_quote($this->ms_Name)."'");
	  	$la_Row =& $lo_Query->nextrow();
	  	foreach ($la_Row as $ls_Key => $lm_Value){
	  		$this->ma_Settings[$ls_Key]=$lm_Value;
	  	}
			$lo_Query->finish();
		}
	}

	function GetSettings($ps_Key){
		if( is_array( $ps_Key ) ){
			$lo_Ret = array();
			foreach( $ps_Key as $ls_Key ){
				if( array_key_exists( $ls_Key, $this->ma_Settings ) ){
					$lo_Ret[$ls_Key] = $this->ma_Settings[$ls_Key];
				}
			}
			return $lo_Ret;

		}else{
			if( array_key_exists( $ps_Key, $this->ma_Settings ) ){
				return $this->ma_Settings[$ps_Key];
			}else{
				return false;
			}
		}
	}

	function CheckLimits( $pm_KeySettings, $pm_KeyStatistics=NULL ){
		global $DEBUG;
		$ll_Ret = true;
		if( is_array( $pm_KeySettings ) ){
			foreach( $pm_KeySettings as $ls_SetKey => $ls_StatKey ){
				if( array_key_exists( $ls_SetKey, $this->ma_Settings ) &&
						array_key_exists( $ls_StatKey, $this->ma_Statistics ) ){
					if( ( $this->ma_Settings[$ls_SetKey] > -1 ) && 
							($this->ma_Settings[$ls_StatKey] < $this->ma_Statistics[$ls_StatKey])){
						$ll_Ret = false;	
						break;
					}
				}
			}	
		} else {
			if( array_key_exists( $pm_KeySettings, $this->ma_Settings ) &&
					array_key_exists( $pm_KeyStatistics, $this->ma_Statistics ) ){
				if( ( $this->ma_Settings[$pm_KeySettings] > -1) && 
					( $this->ma_Settings[$pm_KeySettings] < $this->ma_Statistics[$pm_KeyStatistics])){
					$ll_Ret = false;	
				}
			}	
		}
		return $ll_Ret;
	}
/* ------------------------ end Settings ----------------------*/



	/* -------------------- e-mail -------------------- */
	function ProcessEMail ( $pa_EMail ) {
		$la_Domains = $this->AdjustDomains();
		return preg_replace (
				array (
					"/##kunde##/",
					"/##passwort##/",
					"/##firma##/",
					"/##user##/",
					"/##domain##/",
					"/##domains##/",
					"/##name##/",
					"/##company##/",
					"/##email##/",
					"/##password##/" ),
				array (
					$this->GetName(),
					$this->GetPassword(),
					$this->GetPersonal("firma"),
					$this->GetName(),
					$la_Domains[key($la_Domains)],
					implode( ", ", $la_Domains ),
					$this->GetPersonal("name"),
					$this->GetPersonal("firma"),
					$this->GetPersonal("emailadresse"),
					$this->GetPassword() ),
				array ( $pa_EMail["emailbetreff"], $pa_EMail["emailtext"] ) );
	}
	/* -------------------- end e-mail -------------------- */

	/* static functions (not object methods) */
	
	/* return: minimal free id of end-user
	 */

	function find_new_user_id(){ // static
	
		global $DEBUG;

    $used = array();

		$lcSQL = "SELECT k.kunde, a.userprefix FROM kunden k, admin a ".
  		                    " WHERE a.server_id=k.server_id";
  	
  	$id = db_query( $lcSQL );	 
  	
		while( $row = db_fetch_array( $id, 'A' ) ){	 
			$index = (int)substr( $row['kunde'], strlen( $row['userprefix'] ) );
			
			$used[$index] = 1; 
		}	 
		db_free_query( $id );

  
		// select which accounts are going to be deleted, but are not deleted yet
		
		$lcSQL = "SELECT d.account, a.userprefix FROM delaccs d, admin a ".
		                 " WHERE a.server_id=d.server_id AND d.type='kunde'";
  	
  	$id = db_query( $lcSQL );
		
		while( $werte = db_fetch_array( $id, 'A' ) ){
			$index = (int)substr( $werte['account'], strlen( $werte['userprefix'] ) );
			$used[$index] = 1;
		}
		db_free_query( $id );
		
			
		$used_accounts = array_keys( $used );

    sort( $used_accounts, SORT_NUMERIC );	// required (!) for search routine below

		if( $DEBUG ){
			echo "find_new_user_id: <br><pre>\n";
			print_r( $used_accounts );
			echo "</pre><hr>\n";
		}
  
		$num_accounts = count( $used_accounts );
		$max_used_id  = end( $used_accounts );

		// I used '<=', because array may include '0' value	
		if( $num_accounts <= $max_used_id ){  
			// look for a missing IDs [ O(n) perfomance ]
			for( $i = 0; $i < $num_accounts; $i++ ){
				if( $used_accounts[$i] > $i ){	
					// no value for this index
					$new_id = $i;
					return $new_id;
				} 
			}
			// this should never happen, but who knows ...
			// todo: write to stderr 
			return $max_used_id + 1;
		} 
		// no skipped IDs in array, use next value
		return $max_used_id + 1;
	}

	/* return: true, if the specified end-user exists 
	   arg $account string, login name to check
	 */
	function if_user_exists($account, $server_id = null) 
	{
	  global $ServerID;
	  $lcServerID = $server_id ? $server_id : $this->mcServerID;
	   
		// NOTE: for mysql would be better to add "LIMIT 1" 
		// (could seriously increase perfomance)
		$id1 = db_query("select kunde from kunden where server_id='$lcServerID' AND kunde = '$account'");	
		// make sure that there are no not-completely deleted users with this name
		$id2 = db_query("select account from delaccs where server_id='$lcServerID' AND account = '$account'");

		return (db_num_rows($id1) != 0 || db_num_rows($id2) != 0);
	}
	

	function &Required( $paRequired = NULL ) {
		if( is_array( $paRequired ) ) {
				$this->ma_Required = array();
				foreach ($paRequired as $value)
					$this->ma_Required[] = $value;
			}
		return $this->ma_Required;
	}

	function &AddRequired( $paRequired = NULL ) {
		if( is_string( $paRequired ) ) {
					$this->ma_Required[] = $paRequired;
			}
		return $this->ma_Required;
	}
	
	
}
