<?
########## Confixx(R) 3.0 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####

include_once("class.Crontab.php");

function lmsg($v, $a = false)
{
	return ltext($v, $a);
}

function read_cron( $user=NULL, $server_id=NULL ){
	global $PHP_AUTH_USER, $ServerID;
	if( ! $user ){
		$user = $PHP_AUTH_USER;
	}
	if( ! $server_id ){
		$server_id = $ServerID;
	}
	$loUser = new SQlString($user);
	$loServerID = new SQlString( $server_id );
 
	$id = safe_query2( "SELECT count(*) AS c FROM cronjobs WHERE kunde=? AND server_id=?",
										 $loUser, $loServerID );
	list($cnt) = db_fetch_array($id,'N');
	db_free_query( $id );
	if( $cnt ) {
		safe_query2( "UPDATE cronjobs SET neu = 2 WHERE kunde=? AND server_id=?",
								 $loUser, $loServerID );
	} else 	{
		safe_query2( "INSERT INTO cronjobs (kunde, neu, server_id) ".
								 " VALUES ( ?, 2, ?)",
								 $loUser, $loServerID );
	}
	safe_query2( "UPDATE allgemein SET cronupdate=1 WHERE server_id=?", $loServerID );
}

function load_cron( $user = false, $server_id = NULL ){
	global $PHP_AUTH_USER, $bindir, $ServerID;
	if( ! $user ){
		$user = $PHP_AUTH_USER;
	}
	if( ! $server_id ){
		$server_id = $ServerID;
	}
	$loUser = new SQlString($user);
	$loServerID = new SQlString( $server_id );
	$ret = "";
	$id = safe_query2( "SELECT cronfile, neu, lastchange FROM cronjobs ".
										 " WHERE kunde=? AND server_id=?",
										 $loUser, $loServerID
										 );
	if( db_num_rows( $id ) ) {
		$ret = db_fetch_array($id);
//		$ret = explode("\n", $werte["cronfile"]);
	} else {
		$ret = false;	// no crontab detected
	}
	db_free_query( $id );
	//echo $comm."<br>";
	//print_r($ret);
	//echo "<br>";
	//print_r($err);
	return $ret;
}

function save_cron($f,$user=NULL,$server_id=NULL){
	global $PHP_AUTH_USER,$ServerID;
	if( ! $user ){
		$user = $PHP_AUTH_USER;
	}
	if( ! $server_id ){
		$server_id = $ServerID;
	}
	$loUser = new SQlString($user);
	$loServerID = new SQlString( $server_id );
	//	$f = str_replace( "'", "\\'", $f );
	$id = safe_query2( "SELECT count(*) AS c FROM cronjobs ".
										 " WHERE kunde=? AND server_id=?",
										 $loUser, $loServerID
										 );
	list($cnt) = db_fetch_array($id, 'N' );
	db_free_query( $id );
	if( $cnt ){
		safe_query2( "UPDATE cronjobs SET cronfile=?, neu = 1 ".
								 " WHERE kunde=? AND server_id=?",
								 new SQlString($f), $loUser, $loServerID );
	}	else{
		safe_query2( "INSERT INTO cronjobs (cronfile, kunde, neu,server_id) ".
								 " VALUES (?, ?, 1, ?)",
								 new SQlString($f), $loUser, $loServerID);
	}
	safe_query2( "UPDATE allgemein SET cronupdate=1 WHERE server_id=?", $loServerID);

}

function count_cron_jobs_user( $user=NULL,$server_id=NULL ){

	$cron_rec = load_cron( $user, $server_id );
	$cron_content = ($cron_rec == false) ? array('') : explode("\n", $cron_rec['cronfile']);
	$crn = new Crontab( $cron_content );
	return $crn->count_jobs();
}

function count_cron_jobs_reseller( $res, $server_id=NULL ){
	global $ServerID;
	if( ! $server_id ){
		$server_id = $ServerID;
	}
	$loServerID = new SQlString( $server_id );

	$c = 0;
	$id = safe_query2( "SELECT kunde FROM kunden WHERE anbieter=? AND server_id=?",
										 new SQLString($res), $loServerID );
	if( $id ){
		while( list($user) = db_fetch_array( $id,'N' )){
			$c += count_cron_jobs_user( $user, $server_id );
		}
	}
	db_free_query( $id );
	return $c;
}

function count_cron_jobs_server( $server_id = NULL ){
	global $ServerID;
	if( ! $server_id ){
		$server_id = $ServerID;
	}
	$loServerID = new SQlString( $server_id );

	$c = 0;
	$id = safe_query2( "SELECT kunde FROM kunden WHERE server_id=?",
										 $loServerID );
	if( $id ){
		while( list($user) = db_fetch_array( $id,'N' )){
			$c += count_cron_jobs_user( $user, $server_id );
		}
	}
	db_free_query( $id );
	return $c;
}


?>
