<?php
########## Confixx(R) 3.1 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####

/*  -------------------- Name conventions --------------------
  Function names (except methods):	ff_DescriptionOfFunction
  
  Constant names:	cc_DescriptionOfConstant

  Variable names:	$ST_DescriptionOfVariable

  Where S is a scope, T is a type.
  
  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed
  -------------------- end Name conventions --------------------*/

include_once( dirname(__FILE__) . "/class.OneValueDataField.php" );
include_once( dirname(__FILE__) . "/../html/class.TextAreaElement.php" );
include_once( dirname(__FILE__) ."/class.LongTextDataField.php" );
include_once( dirname(__FILE__) ."/class.ListDataField.php" );
include_once( dirname(__FILE__) . "/../html/class.TextElement.php" );
include_once( dirname(__FILE__) . "/../html/class.InputHiddenElement.php" );

class ConfListDataField extends ListDataField {

	var $miCols;
	var $mcComment;
  var $mcTopCommentLine;	
	/* -------------------- Constructor -------------------- */
	function ConfListDataField( $pmValue = array(), $paAttributes = array(),
													$pcSeparator = " ", $pcLineSeparator = "\n", $piCols = 2, $pcComment = "#" ) {
		global $DEBUG;
		
		$this->miCols = $piCols;
		$this->mcComment = $pcComment;
		$this->mcTopCommentLine = '';
		$this->mcLineSeparator = $pcLineSeparator;
		$this->mcSeparator = $pcSeparator;
		$this->mcOutputType = "T";
		
		if (is_array($pmValue)) {
			
			$this->maValue = $pmValue;
			
		} elseif (is_string($pmValue)) {
			
			$laStrMass = preg_split("/[".preg_quote($this->mcLineSeparator)."]/", str_replace("\r", "", trim($pmValue)));
			$liMaxLen = 0;
			
				foreach ($laStrMass as $key => $value) {
					
					if (!empty($this->mcComment)) {
						$value = preg_replace("/".preg_quote($this->mcComment).".+/","", $value);
					}
						
					if (preg_match("/^\s+$/",$value)||empty($value)) {
						continue;
					}
					
					$laList = preg_split("/[".preg_quote($this->mcSeparator)."]+/", $value);
					$liMaxLen = count($laList);
					$lcTmp = "";
					
					for ($i=1; $i<$liMaxLen; $i++) {
						$lcTmp.= ($this->mcSeparator).(isset($laList[$i]) ? trim($laList[$i]) : "");
					}
					
					$this->maValue[0][] = isset($laList[0]) ? trim($laList[0]) : "";
					$this->maValue[1][] = isset($lcTmp) ? trim($lcTmp) : "";
				}
		}
		$this->DataField($paAttributes, $paParentAttributes);
		if ($DEBUG) {
			echo '<pre>';
			var_dump($this->maValue);
			echo '</pre>';
		}
	}
	/* -------------------- end Constructor -------------------- */
	
	/* -------------------- Add Methods  -------------------- */
	function AppendRow($pmValue) {

		$liCountMain = count($this->maValue);
		
		if (is_array($pmValue)) {
			
					for ($j =0; $j<$liCountMain; $j++) {
								$this->maValue[$j][] = $pmValue[$j];
					}
					
		} elseif (is_string($pmValue)) {
			
			$laStrMass = preg_split("/[".preg_quote($this->mcLineSeparator)."]/", str_replace("\r", "", trim($pmValue)));
			$liMaxLen = 1;
				foreach ($laStrMass as $key => $value) {
					
					if (!empty($this->mcComment)) 
						$value = preg_replace("/".preg_quote($this->mcComment).".+/","", $value);
						
					if (preg_match("/^\s+$/",$value)||empty($value)) 
						continue;
						
					$laList = preg_split("/[".preg_quote($this->mcSeparator)."]+/", $value);
					$liMaxLen = count($laList);
					$lcTmp = "";
					
					for ($i=1; $i<$liMaxLen; $i++) {
						$lcTmp.= ($this->mcSeparator).(isset($laList[$i]) ? trim($laList[$i]) : "");
					}
					
					$this->maValue[0][] = isset($laList[0]) ? trim($laList[0]) : "";
					$this->maValue[1][] = isset($lcTmp) ? trim($lcTmp) : "";
				}
		}
	}
	
	function topComment($pcLine = null) {
  	if (is_string($pcLine) && preg_match("/^".preg_quote($this->mcComment)."/", $pcLine = trim($pcLine))) {
   			$this->mcTopCommentLine = $pcLine;
  	   }  
	}
/* -------------------- End AddMethods  -------------------- */

/* -------------------- Set/Get Methods  -------------------- */
	function &OutputType( $pcOutputType = NULL ) {
		if( is_string( $pcOutputType ) ) {
			$this->mcOutputType = $pcOutputType;
		}
		return $this->mcOutputType;
	}
	
	function &LineSeparator( $pcLineSeparator = NULL ) {
		if( is_string( $pcLineSeparator ) ) {
			$this->mcLineSeparator = $pcLineSeparator;
		}
		return $this->mcLineSeparator;
	}
	
	function &Separator( $pcSeparator = NULL ) {
		if( is_string( $pcSeparator ) ) {
			$this->mcLineSeparator = $pcLineSeparator;
		}
		return $this->mcSeparator;
	}
	
	function &Cols( $piCols = NULL ) {
		if( is_integer( $piCols ) ) {
			$this->miCols = $piCols;
		}
		return $this->miCols;
	}
	
	function &Comment( $pcComment = NULL ) {
		if( is_string( $pcComment ) ) {
			$this->mcComment = $pcComment;
		}
		return $this->mcComment;
	}
	
	function &GetValueAsArray() {
		return $this->maValue;
	}
	
/* -------------------- end  Set/Get Methods -------------------- */

	/* -------------------- definitions of "abstract" methods -------------------- */
	function GetValue() {
		
		$lcReturnText = "";
		$liCountMain = count($this->maValue);
		$liCount = count(current($this->maValue));
		if (!empty($this->mcTopCommentLine)) {
  		$lcReturnText.= $this->mcTopCommentLine.$this->mcLineSeparator;
		}
		
		for ($i=0; $i<$liCount; $i++) {
			
			for ($j =0; $j<$liCountMain; $j++) {
						$lcReturnText.=$this->maValue[$j][$i].(($j == $liCountMain||$liCountMain == 1) ? "" : $this->mcSeparator);
			}
			
								$lcReturnText.= $this->mcLineSeparator;
		}
		
			return $lcReturnText;
	}
	
	/* -------------------- end definitions "abstract" methods -------------------- */

}
?>