<?php 

########## Confixx(R) 3.1 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####

/*  -------------------- Name conventions --------------------
  Function names (except methods):	ff_DescriptionOfFunction
  
  Constant names:	cc_DescriptionOfConstant

  Variable names:	$ST_DescriptionOfVariable

  Where S is a scope, T is a type.
  
  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed
  -------------------- end Name conventions --------------------*/

include_once( dirname(__FILE__) . "/class.OneValueDataField.php" );
include_once( dirname(__FILE__) . "/../html/class.TextAreaElement.php" );
include_once( dirname(__FILE__) ."/class.LongTextDataField.php" );
include_once( dirname(__FILE__) . "/../html/class.TextElement.php" );
include_once( dirname(__FILE__) . "/../html/class.InputHiddenElement.php" );

class ListDataField extends DataField {

	var $mcSeparator;
	var $mcLineSeparator;
	var $maValue = array();
	var $mcOutputType;
	
	/* -------------------- Constructor -------------------- */
	function ListDataField( $pmValue = array(), $paAttributes = array(),
													$pcSeparator = " ", $pcLineSeparator = "\n", $pcOutputType = "T" ) {
		$this->mcLineSeparator = $pcLineSeparator;
		$this->mcSeparator = $pcSeparator;
		if (is_array($pmValue)) {
			$this->maValue = $pmValue;
		} elseif (is_string($pmValue)) {
			$pmValue = trim($pmValue);
			$lcSrt = str_replace("\r", "", $pmValue);
			$laStrMass = preg_split("/[".preg_quote($this->mcLineSeparator)."]+/",$lcSrt);
			$liMaxLen = 1;
			
			foreach ($laStrMass as $key => $value) {
				$laStrMass[$key]=$value = trim($value);
				$laList = preg_split("/[".preg_quote($this->mcSeparator)."]+/", $value);
				$lcMaxTmp = count($laList);
			if ($lcMaxTmp>$liMaxLen) $liMaxLen = $lcMaxTmp;
			}
			
			foreach ($laStrMass as $key => $value) {
				$laList = preg_split("/[".preg_quote($this->mcSeparator)."]+/", $value);
				for ($i=0; $i<$liMaxLen; $i++) {
					$this->maValue[$i][] = isset($laList[$i]) ? $laList[$i] : "";
				}
			}
		}
		
		$this->mcOutputType = $pcOutputType;
		$this->DataField($paAttributes, $paParentAttributes);
	}
	/* -------------------- end Constructor -------------------- */
	
	/* -------------------- Methods  -------------------- */
	function AppendRow($pmValue) {
		$liCountMain = count($this->maValue);
		if (is_array($pmValue)) {
					for ($j =0; $j<$liCountMain; $j++) {
								$this->maValue[$j][] = $pmValue[$j];
				}
		} elseif (is_string($pmValue)) {
			$pmValue = trim($pmValue);
				$lcSrt = str_replace("\r","",$pmValue);
				$laStrMass = preg_split("/[".preg_quote($this->mcLineSeparator)."]+/",$lcSrt);
				foreach ($laStrMass as $key => $value) {
					$laList = preg_split("/[".preg_quote($this->mcSeparator)."]+/", $value);
					for ($i=0; $i<$liCountMain; $i++) {
						$this->maValue[$i][] = isset($laList[$i]) ? $laList[$i] : "";
					}
			 }
		}
	}
	
	function &OutputType( $pcOutputType = NULL ) {
		if( is_string( $pcOutputType ) ) {
			$this->mcOutputType = $pcOutputType;
		}
		return $this->mcOutputType;
	}
	
	function &LineSeparator( $pcLineSeparator = NULL ) {
		if( is_string( $pcLineSeparator ) ) {
			$this->mcLineSeparator = $pcLineSeparator;
		}
		return $this->mcLineSeparator;
	}
	
	function &Separator( $pcSeparator = NULL ) {
		if( is_string( $pcSeparator ) ) {
			$this->mcLineSeparator = $pcLineSeparator;
		}
		return $this->mcSeparator;
	}
	
	function &GetValueAsArray() {
		return $this->maValue;
	}
	
/* -------------------- end  Methods -------------------- */

	/* -------------------- definitions of "abstract" methods -------------------- */
	function GetValue() {
		$lcReturnText = "";
			$liCountMain = count($this->maValue);
			$liCount = count(current($this->maValue));
			
			for ($i=0; $i < $liCount; $i++) {
				for ($j = 0; $j < $liCountMain; $j++) {
							$lcReturnText.=$this->maValue[$j][$i].(($j == $liCountMain||$liCountMain == 1) ? "" : $this->mcSeparator);
				}
								$lcReturnText.= $this->mcLineSeparator;
			}
			return $lcReturnText;
	}
	
	function GetInputPresentation( $psID=NULL ) {
		$laAttributes = $this->GetAttributes( $psID );
		// If String
		if ($this->mcOutputType == 'I') {
			$laAttributes = $this->GetAttributes( $psID );
			$laAttributes["value"] = $this->GetValue();
			return new InputTextElement( $laAttributes );
		} else {
		$laAttributes["cols"]=50;
		$laAttributes["rows"]=10;
		return new TextAreaElement( $laAttributes, $this->GetValue() );
		}
	}

	function GetOutputPresentation() {
		return new TextElement( $this->GetValue() );
	}

	function GetHiddenPresentation( $psID=NULL ) {
		return new InputHiddenElement( array( "name"=>$this->GetNameWithID( $psID ), "value"=>$this->GetValue() ) );
	}
	/* -------------------- end definitions "abstract" methods -------------------- */

}
?>
