<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once( dirname(__FILE__) . "/class.DataField.php" );





class NameDataField extends DataField {

	/* -------------------- Members -------------------- */
	var $ms_Name; // name of field
	/* -------------------- end Members -------------------- */





	/* -------------------- Constructor -------------------- */
	function NameDataField( $ps_Name=NULL, $paAttributes = array(), $paParentAttributes = array() ) {
		$this->DataField( $paAttributes, $paParentAttributes );
		$this->SetName( $ps_Name );
	}
	/* -------------------- end Constructor -------------------- */





	/* -------------------- Set.../Get... -------------------- */
	function SetName( $ps_Name ) {
		$this->ms_Name = $ps_Name;
	}

	function GetName() {
		return $this->ms_Name;
	}
	/* -------------------- end Set.../Get... -------------------- */





	/* -------------------- GetNameWithID -------------------- */
	function GetNameWithID( $ps_ID ) {
		return is_null($ps_ID) ? $this->GetName() : $this->GetName() . "[" . $ps_ID . "]";
	}
	/* -------------------- end GetNameWithID -------------------- */





	/* -------------------- GetAttributes -------------------- */
	function GetAttributes( $ps_ID ) {
		$la_Result = DataField::GetAttributes();
		$la_Result["name"] = $this->GetNameWithID( $ps_ID );
		return $la_Result;
	}
	/* -------------------- end GetAttributes -------------------- */

}
?>
