<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once( dirname(__FILE__) . "/class.Limit.php" );
include_once( dirname(__FILE__) . "/class.TextLimitDataField.php" );





class TextLimit extends Limit {

	/* -------------------- Constructor -------------------- */
	function TextLimit( $ps_Name, $ps_HardName, $ps_Value="-1" ) {
		$this->Limit( $ps_Name, $ps_HardName, $ps_Value );
	}
	/* -------------------- end Constructor -------------------- */





	/* -------------------- definitions of "abstract" methods -------------------- */
	function GetField() {
		$lo_Result = new TextLimitDataField( $this->GetValue(), $this->GetName() );
		if( $this->GetValue()<0 )
			$lo_Result->SetDisabled( TRUE );
		return $lo_Result;
	}

	function GetOff($pi_FromIndex=NULL, $pi_FieldIndex=NULL) {
		if (!is_numeric($pi_FromIndex)){
			$pi_FromIndex = $this->FormIndex();
		}
		if ( !is_numeric($pi_FieldIndex) ) {
			$pi_FieldIndex = 0;
		}

		$la_Result = array( "document.forms[$pi_FromIndex].".$this->GetName()."[$pi_FieldIndex]" );
		if( !is_null($this->GetHardName()) )
			$la_Result[] = "document.forms[$pi_FromIndex].".$this->GetHardName();
		return $la_Result;
	}
	/* -------------------- end definitions of "abstract" methods -------------------- */

}
?>
