<?
########## Confixx(R) 3.1 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####

/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once( dirname(__FILE__) . "/class.OneValueDataField.php" );
include_once( dirname(__FILE__) . "/../html/class.InputCheckboxElement.php" );
include_once( dirname(__FILE__) . "/../html/class.InputHiddenElement.php" );
include_once( dirname(__FILE__) . "/../html/class.TextElement.php" );
include_once( dirname(__FILE__) . "/../html/class.TagWithEndElement.php" );
include_once( dirname(__FILE__) . "/../html/class.BRElement.php" );
include_once( dirname(__FILE__) . "/../html/class.CompoundElement.php" );
include_once( dirname(__FILE__) . "/../html/class.InputRadioElement.php" );





class YesNoDataField extends OneValueDataField {

	/* -------------------- Members -------------------- */
	var $ma_Yes = array(); // yes value/text
	var $ma_No = array(); // no value/text
	var $ms_Presentation; // what presentation should be used
	var $mo_Separator; // what separator to use for radio group presentation
	var $ma_On = array(); // elements that should be enabled when this element is checked
	var $ma_Off = array(); // elements that should be disabled when this element is checked
	/* -------------------- end Members -------------------- */





	/* -------------------- Constructor -------------------- */
	function YesNoDataField( $pa_Yes, $pa_No, $ps_Value="", $ps_Name=NULL, 
													 $ps_Presentation=cc_CheckboxPresentation,
													 $paAttrinutes = array(), 
													 $paParentAttributes = array() ) {

		if( is_array( $ps_Presentation ) ) { ## shift list of arguments
			$paParentAttributes = $paAttrinutes;
			$paAttrinutes = $ps_Presentation;
			$ps_Presentation=cc_CheckboxPresentation;
		}

		$this->OneValueDataField( $ps_Value, $ps_Name, 
															$paAttrinutes, $paParentAttributes );
		$this->SetYes( $pa_Yes );
		$this->SetNo( $pa_No );
		$this->SetPresentation( $ps_Presentation );
		$this->SetSeparator( new BRElement( array() ) );
		$this->SetDependableFields( array(), array() );
	}
	/* -------------------- end Constructor -------------------- */





	/* -------------------- Set.../Get... -------------------- */
	function SetYes( $pa_Yes ) {
	  if(is_array( $pa_Yes ) ){
		$this->ma_Yes = $pa_Yes;
	  }	
	}

	function GetYes() {
		return $this->ma_Yes;
	}

	function SetNo( $pa_No ) {
	  if( is_array( $pa_No ) ){
		$this->ma_No = $pa_No;
	  }	
	}

	function GetNo() {
		return $this->ma_No;
	}

	function SetPresentation( $ps_Presentation ) {
		$this->ms_Presentation = $ps_Presentation;
	}

	function GetPresentation() {
		return $this->ms_Presentation;
	}

	function SetSeparator( $po_Separator ) {
		$this->mo_Separator = $po_Separator;
	}

	function GetSeparator() {
		return $this->mo_Separator;
	}

	function GetYesValue() {
	  list($lcRet) = array_keys( $this->GetYes() );
	  return $lcRet;
	}

	function GetYesText() {
	  list($lcRet) = array_values( $this->GetYes() );
		return $lcRet;
	}

	function GetNoValue() {
	  list($lcRet) = array_keys( $this->GetNo() );
	  return $lcRet;
	}

	function GetNoText() {
	  list($lcRet) = array_values( $this->GetNo() );
		return $lcRet;
	}
	/* -------------------- end Set.../Get... -------------------- */





	/* -------------------- dependable fields -------------------- */
	function SetDependableFields( $pa_On, $pa_Off ) {
	  if( is_array( $pa_On )){
		$this->ma_On = $pa_On;
	  }
	  if( is_array( $pa_Off )){
		$this->ma_Off = $pa_Off;
	  }
	}

	function &GetOn() {
		return $this->ma_On;
	}

	function &GetOff() {
		return $this->ma_Off;
	}

	function GetDependableHandler( $ps_On, $ps_Off ) {
		$la_On = $this->GetOn();
		array_unshift( $la_On, $ps_On );
		$la_Off = $this->GetOff();
		array_unshift( $la_Off, $ps_Off );
		return "ToggleElements( " . implode( ",", $la_On ) . "); ToggleElements( " . implode( ",", $la_Off ) . " );";
	}

	function NeedDependableHandler() {
		return count($this->GetOn()) || count($this->GetOff());
	}
	/* -------------------- end dependable fields -------------------- */





	/* -------------------- definitions of "abstract" methods -------------------- */
	function GetInputPresentation( $ps_ID=NULL ) {
		switch ( $this->GetPresentation() ) {
			case cc_CheckboxPresentation:
				$ls_YesValue = $this->GetYesValue();
				$la_Attributes = $this->GetAttributes( $ps_ID );
				$la_Attributes["value"] = $ls_YesValue;
				if ($this->GetValue()==$ls_YesValue) {
					$la_Attributes["checked"] = NULL;
				}
					$la_Attributes["id"]    = 'id_'.$la_Attributes['name'];

				$loLabel = new TagWithEndElement('label', array('for' => $la_Attributes["id"]));
				$loLabel->AppendToContent($this->GetYesText());
				
				return new CompoundElement( new InputCheckboxElement( $la_Attributes ), $loLabel);
			case cc_SelectPresentation:
				$lo_Result = new SelectElement( $this->GetAttributes( $ps_ID ) ); // dependable fields not implemented
				$ls_Selected = $this->GetValue();
				$ls_YesValue = $this->GetYesValue();
				$lo_Result->AppendToContent( new OptionElement( $ls_Selected==$ls_YesValue ?
							array( "value"=>$ls_YesValue, "selected"=>NULL ) : array( "value"=>$ls_YesValue ) ) );
				$ls_NoValue = $this->GetNoValue();
				$lo_Result->AppendToContent( new OptionElement( $ls_Selected==$ls_NoValue ?
							array( "value"=>$ls_NoValue, "selected"=>NULL ) : array( "value"=>$ls_NoValue ) ) );
				return $lo_Result;
			case cc_RadioGroupPresentation:
				$lo_Result = new CompoundElement();
				$ls_Selected = $this->GetValue();
				$ls_YesValue = $this->GetYesValue();
				$la_Attributes = $this->GetAttributes( $ps_ID ); // dependable fields not implemented
				$la_Attributes["value"] = $ls_YesValue;
				if( $ls_Selected==$ls_YesValue )
					$la_Attributes["checked"] = NULL;
				$lo_Result->AppendToContent( new InputRadioElement( $la_Attributes ), $this->GetYesText(),
						$this->GetSeparator() );
				$ls_NoValue = $this->GetNoValue();
				$la_Attributes = $this->GetAttributes( $ps_ID ); // dependable fields not implemented
				$la_Attributes["value"] = $ls_NoValue;
				if( $ls_Selected==$ls_NoValue )
					$la_Attributes["checked"] = NULL;
				$lo_Result->AppendToContent( new InputRadioElement( $la_Attributes ), $this->GetNoText(),
						$this->GetSeparator() );
				return $lo_Result;
			case cc_RadioPresentation:
				$lo_Result = new CompoundElement();
				$ls_Selected = $this->GetValue();
				$ls_YesValue = $this->GetYesValue();
				$la_Attributes = $this->GetAttributes( $ps_ID );
				$la_Attributes["value"] = $ls_YesValue;
				if( $ls_Selected==$ls_YesValue )
					$la_Attributes["checked"] = NULL;
				$lo_Result->AppendToContent( new InputRadioElement( $la_Attributes ), $this->GetYesText() );
				return $lo_Result;
		}
	}

	function GetOutputPresentation() {
		return new HTMLElement( $this->GetValue()==$this->GetYesValue() ? $this->GetYesText() : $this->GetNoText() );
	}

	function GetHiddenPresentation( $ps_ID=NULL ) {
		return new InputHiddenElement( array( "name"=>$this->GetNameWithID( $ps_ID ), "value"=>$this->GetValue() ) );
	}
	/* -------------------- end definitions "abstract" methods -------------------- */





	/* -------------------- GetAttributes -------------------- */
	function GetAttributes( $ps_ID, $ps_Handler="onclick", $ps_On="!this.checked", $ps_Off="this.checked" ) {
		$la_Attributes = OneValueDataField::GetAttributes( $ps_ID );
		if( $this->NeedDependableHandler() )
			$la_Attributes["onclick"] = $this->GetDependableHandler( $ps_On, $ps_Off );
		return $la_Attributes;
	}
	/* -------------------- end GetAttributes -------------------- */

}
?>
