<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/

include_once( dirname(__FILE__) . "/../data/class.SetOfRowsData.php" );
include_once( dirname(__FILE__) . "/../data/class.HTMLDataField.php" );
include_once( dirname(__FILE__) . "/../data/class.ServiceDataField.php" );
include_once( dirname(__FILE__) . "/../data/class.ShellServiceDataField.php" );
include_once( dirname(__FILE__) . "/../data/class.OptionsDataField.php" );


class ServicesData extends SetOfRowsData {
/* -------------------- Members -------------------- */
	var $msOwner; 
	/* -------------------- end Members -------------------- */

	/* -------------------- Constructor -------------------- */
	function ServicesData( $pa_Admin, $pa_Reseller=array(), $pa_User=array(), $pa_Services=array(),$psOwner="") {
		$this->SetOfRowsData();
		$this->msOwner = $psOwner;
		$this->AddService( "dbext", $pa_Admin["mysql"], !count($pa_Reseller), $pa_User, $pa_Services );

		foreach( array( "ftp", "php", "phpupload", "perl", "modpython", 
										"ssi", "wap", "coldfusion", "frontpage" ) as
						 $ls_Name ) {
			$this->AddService( $ls_Name, $pa_Admin, $pa_Reseller, 
												 $pa_User, $pa_Services );
		}

		if( !count($pa_Reseller) ) {
		
			// copied from old code: shell is available only if ftp is available
			$this->AddShellService( "shell" , $pa_Admin["shell"] && $pa_Admin["ftp"], TRUE,          TRUE,     $pa_Services );
			$this->AddShellService( "scponly", $pa_Admin,                             TRUE,          TRUE,     $pa_Services );
		}	else {
			// copied from old code: shell is available only if ftp is available
			$ls_CanShell = $this->CanDo( "shell", $pa_Admin["shell"] && $pa_Admin["ftp"], $pa_Reseller, $pa_User );
			$ls_CanScp = $this->CanDo( "scponly", $pa_Admin, $pa_Reseller, $pa_User );
			if ( $ls_CanShell && $ls_CanScp ) {
				$ls_Value = 0;
				if (array_key_exists("shell", $pa_Services)&&$pa_Services["shell"]) {
					$ls_Value = 1;
				}
				
				if (array_key_exists("scponly", $pa_Services)&&$pa_Services["scponly"]) {
					$ls_Value = 2;
				}
				$this->AppendRow( new HTMLDataField( ltext("uc_shell") ),
													new OptionsDataField( array( 0=>ltext("g_no"), 
																											 1=>ltext("uc_stdshell"), 
																											 2=>ltext("uc_scponly") ),
																								$ls_Value, 
																								"shell" ) );
			}	elseif ( $ls_CanShell ) {
				$this->AddShellService( "shell", $pa_Admin, $pa_Reseller, $pa_User, $pa_Services );
			} elseif( $ls_CanScp ) {
				$this->AddShellService( "scponly", $pa_Admin, $pa_Reseller, $pa_User, $pa_Services );
			}
		}

		foreach( array( 'cssl', "dirlist", "statistik", "awstats", "pwschutz", "fehlerseiten", "webftp",
										"webmail", "stdcgi" ) as $ls_Name ) {
			$this->AddService( $ls_Name, $pa_Admin, $pa_Reseller, $pa_User, $pa_Services );
		}

		$this->AddService( "dns", $pa_Admin, !count($pa_Reseller), !count($pa_User), $pa_Services );
		$this->AddService( "dnr", $pa_Admin, !count($pa_Reseller), !count($pa_User), $pa_Services );

		if( $this->CanDo( "maxpop", $pa_Admin["pop"], $pa_Reseller, $pa_User ) )
			$this->AddService( "spamfilter", $pa_Admin, $pa_Reseller, $pa_User, $pa_Services );

		$this->AddService( "drweb", $pa_Admin, $pa_Reseller, $pa_User, $pa_Services );
		if ( FALSE ){ ## yet time
			$this->AddService( "webshop", $pa_Admin, !count($pa_Reseller), $pa_User, $pa_Services );
		} ## /yet time

		if( $liAdminBackup = $this->CanDo( "backup", $pa_Admin["backup"], $pa_Reseller, $pa_User ) ) {
			if ( $liAdminBackup > 1 ) {
				$liBackup = array_key_exists( "backup", $pa_Services ) ? $pa_Services["backup"] : 0;
				if ($pa_Reseller["backup"]>1||$this->msOwner=="Administrator") {  
	
					$this->AppendRow( new HTMLDataField( ltext("uc_backup") ),
														new OptionsDataField( array( 0=>ltext("g_no"), 
																												 1=>ltext("g_yes"), 
																												 2=>ltext("uc_backup_upload") ),
																									$liBackup, 
																									"backup" ) );
				} else {
					$this->AppendRow( new HTMLDataField( ltext("uc_backup") ),
															new OptionsDataField( array( 0=>ltext("g_no"), 
																													 1=>ltext("g_yes") 
																													  ),
																										$liBackup, 
																										"backup" ) );
						
				}
			} else {
				$this->AddService( "backup", $pa_Admin, $pa_Reseller, $pa_User, $pa_Services );
			}
		}

		/*
		echo "ServicesData::ServicesData<br><pre>\n";
		print_r($this);
		echo "</pre><hr>\n"; 
		*/

	}
	/* -------------------- end Constructor -------------------- */





	/* -------------------- different methods (internal use only) -------------------- */
	function CanDo( $ps_What, $pm_Admin, $pm_Reseller, $pm_User ) {
		if( is_array($pm_Admin) ? !array_key_exists( $ps_What, $pm_Admin ) || !$pm_Admin[$ps_What] : !$pm_Admin )
			return FALSE;

		if( is_array($pm_Reseller) ? 
				count($pm_Reseller) && 
				( !array_key_exists( $ps_What, $pm_Reseller ) ||
					!$pm_Reseller[$ps_What] 
					) : !$pm_Reseller ) {
			return FALSE;
		}

		if( is_array($pm_User) ? 
				count($pm_User) && 
				( !array_key_exists( $ps_What, $pm_User ) || 
					!$pm_User[$ps_What] 
					) :	!$pm_User ) {
			return FALSE;
		}
		
		$liRet = is_array($pm_Admin)?$pm_Admin[$ps_What]:$pm_Admin; 

		return $liRet? $liRet: TRUE;
	}

	function AddService( $ps_What, $pm_Admin, $pm_Reseller, $pm_User, $pa_Values, $ps_Default=1 ) {
		if( $this->CanDo( $ps_What, $pm_Admin, $pm_Reseller, $pm_User ) )
			$this->AppendRow( new HTMLDataField( ltext("uc_$ps_What") ),
					new ServiceDataField( array_key_exists( $ps_What, $pa_Values ) ? $pa_Values[$ps_What] : $ps_Default,
						$ps_What ) );
	}

	function AddShellService( $ps_What, $pm_Admin, $pm_Reseller, $pm_User, $pa_Values = array(), $ps_Default = 0 ) {
		if( $this->CanDo( $ps_What, $pm_Admin, $pm_Reseller, $pm_User ) )
			$this->AppendRow( new HTMLDataField( ltext("uc_$ps_What") ), new ShellServiceDataField(
						array_key_exists( $ps_What, $pa_Values ) ? $pa_Values[$ps_What] : $ps_Default, $ps_What ) );
	}
	
 function &Owner( $psOwner = NULL ) {
		if( is_string( $psOwner ) ) {
			$this->msOwner = $psOwner;
		}
		return $this->msOwner;
	}

	
	/* -------------------- end different methods (internal use only) -------------------- */

	function &GetServices() {
		global $DEBUG;
		$laRet = array();
		foreach ($this->GetRows() as $loRow ){
			foreach ( $loRow->GetFields() as $loField ) {
				if (is_a( $loField,'ServiceDataField' ) ) {
					$laRet[] = $loField;
					break;
				}
			}
		}
		if($DEBUG){
			/*
			echo "ServicesData::GetServices<br><pre>\n";
			print_r($laRet);
			echo "</pre><hr>\n";
			*/
		}
		return $laRet;
	}

}
?>
