<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once ( dirname(__FILE__) . "/class.AbstractLimit.php" );





class Service extends AbstractLimit
{

    /* -------------------- Members -------------------- */
    /* -------------------- end Members -------------------- */





    /* -------------------- Constructor -------------------- */
    function Service ( $ps_Label, $ps_Name, $ps_Value, $pa_Names=array() )
    {
	$this->AbstractLimit ( $ps_Label, $ps_Name, $ps_Value, $pa_Names );
    }
    /* -------------------- end Constructor -------------------- */





    /* -------------------- SetValue -------------------- */
    function SetValue ( $ps_Value )
    {
	AbstractLimit::SetValue ( $ps_Value ? 1 : 0 );
    }
    /* -------------------- end SetValue -------------------- */





    /* -------------------- definitions of "abstract" methods -------------------- */
    function ResellerAllowed ( $pa_Data=NULL, $ps_Reseller=NULL )
    {
	$ls_Name = $this->GetNameForTable("anbieter");
	if ( is_null($ls_Name) || (!is_array($pa_Data) && !is_object($pa_Data)) )
	    return FALSE;
	if ( is_null($pa_Data) || !array_key_exists($ls_Name,$pa_Data) )
	    $pa_Data = $this->GetResellerData ( $ps_Reseller );
	return array_key_exists($ls_Name,$pa_Data) && $pa_Data[$ls_Name];
    }

    function UserAllowed ( $pa_Data=NULL, $ps_User=NULL )
    {
	$ls_Name = $this->GetNameForTable("kunden");
	if ( is_null($ls_Name) )
	    return FALSE;
	if ( is_null($pa_Data) || !array_key_exists($ls_Name,$pa_Data) )
	    $pa_Data = $this->GetUserData ( $ps_User );
	return array_key_exists($ls_Name,$pa_Data) && $pa_Data[$ls_Name];
    }

    function GetHTML ()
    {
	if ( $this->GetValue() )
	{
	    $ls_Yes = "checked";
	    $ls_No = "";
	}
	else
	{
	    $ls_Yes = "";
	    $ls_No = "checked";
	}
	return "<input type=radio name=\"" . htmlspecialchars($this->GetName()) . "\" value=1 $ls_Yes> " . ltext("g_yes") .
		" <input type=radio name=\"" . htmlspecialchars($this->GetName()) . "\" value=0 $ls_No> " . ltext("g_no");
    }

    function GetStatHTML ()
    {
	echo ( "method GetStatHTML should return HTML for statistics" );
    }
    /* -------------------- end definitions of "abstract" methods -------------------- */

}
?>
