<?
########## Confixx(R) 3.0 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####

/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once ( dirname(__FILE__) . "/../class.Pager.php" );
include_once ( dirname(__FILE__) . "/../class.InputTextColumn.php" );
include_once ( dirname(__FILE__) . "/../class.InputHiddenColumn.php" );
include_once ( dirname(__FILE__) . "/../class.InputCheckboxColumn.php" );





class MenuItemsPager extends Pager
{
    /* -------------------- Members -------------------- */
    /* -------------------- end Members -------------------- */





    /* -------------------- Constructor -------------------- */
    function MenuItemsPager ( &$po_Source )
    {
			$this->Pager ( $po_Source );
			$this->setText('noresults',ltext('cm_noitems'));
    }
    /* -------------------- end Constructor -------------------- */





    /* -------------------- "abstract" methods -------------------- */
    function ShouldShowSummary()
    {
			return TRUE;
    }

    function ShouldShowAddForm()
    {
			return TRUE;
    }

    function GetSummary()
    {
      global $ServerID;
			$lo_DB =& get_db_connection();
			$lo_Query =& $lo_DB->Select ( "SELECT label, usertype FROM menublock WHERE server_id='$ServerID' AND id=".
																		db_full_quote(ff_GetFromPostGet("menublock_id")) );
			$la_Row = $lo_Query->nextrow();
			return ltext( "cm_path",
										array( $la_Row["label"],
													 ltext ( $la_Row["usertype"]=="reseller" ?  
																	 "cm_path_reseller" : 
																	 "cm_path_user" ) 
													 ) 
										);
    }

    function GetAddColumns()
    {
			global $DEBUG;
			if ( $DEBUG ){
#				echo "MenuItemPager::GetAddColumns<br>\n";
			}
			return array(
									 new InputTextColumn( "label", ltext("cm_text"), "", array( "style" => "width:100%" ), "40%" ),
									 new InputTextColumn( "href", ltext("cm_link"), "", array( "style" => "width:100%" ), "40%" ),
									 new InputCheckboxColumn( "1", "in_frame",  ltext("cm_in_frame"), "", array(), "10%" ) 
  
									 );
			
    }

    function GetBrowseColumns()
    {
			$la_Result = array(
												 new InputTextColumn( "label", ltext("cm_text"), "", array( "style" => "width:100%" ), "40%" ),
												 new InputTextColumn( "href", ltext("cm_link"), "", array( "style" => "width:100%" ), "40%" ),
												 new InputCheckboxColumn( "1", "in_frame", ltext("cm_in_frame"), "1", array(), "10%" ) 
												 );
			$la_Result[0]->SetSortable (TRUE);
			$la_Result[1]->SetSortable (TRUE);
			$la_Result[2]->SetSortable (TRUE);

			return $la_Result;
    }

    function GetSearchColumns()
    {
			return array(
									 new InputTextColumn( "search_label", ltext("cm_text"), "", array( "style" => "width:100%" ), "40%" ),
									 new InputTextColumn( "search_href", ltext("cm_link"), "", array( "style" => "width:100%" ), "40%" ), 
									 new InputCheckboxColumn( "1", "search_in_frame", ltext("cm_in_frame"), "1", array(), "10%" ) 
									 );
    }

    function GetHiddenFields()
    {
			return array( new InputHiddenColumn( "menublock_id", "", ff_GetFromPostGet("menublock_id") ) );
    }
    /* -------------------- end "abstract" methods -------------------- */

}
?>
