<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once ( dirname(__FILE__) . "/../class.SQLValuesSource.php" );
include_once ( dirname(__FILE__) . "/../module.Webshop.php" );





class RegRequestsValuesSource extends SQLValuesSource
{
    /* -------------------- Members -------------------- */
    /* -------------------- end Members -------------------- */





    /* -------------------- Constructor -------------------- */
    function RegRequestsValuesSource (  $ps_IDName=0, $ps_PageNumber = NULL, $ps_ItemsPerPage = NULL )
    {
	$this->SQLValuesSource ( $ps_IDName, $ps_PageNumber, $ps_ItemsPerPage );
    }
    /* -------------------- end Constructor -------------------- */





    /* -------------------- definitions of "abstract" methods -------------------- */
    function GetBrowseSQL()
    {
	global $PHP_AUTH_USER;
	global $ServerID;
	return "SELECT *, UNIX_TIMESTAMP(requestdate) AS requesttimestamp FROM regrequest WHERE  server_id='$ServerID' AND anbieter = " .
		db_full_quote($PHP_AUTH_USER) . $this->GetOrder();
    }

    // to help GetBrowseSQL & GetSearchSQL
    function GetOrder()
    {
	$ls_Reverse = $this->GetSortReverse() ? " DESC " : "";
	switch ( $this->GetSortColumn() )
	{
	    case "requesttimestamp":
		return " ORDER BY requestdate $ls_Reverse ";
	    case "info":
		return " ORDER BY aname $ls_Reverse ";
	    case "status":
	    default:
		return " ORDER BY status+0 $ls_Reverse ";
	}
    }

    function GetDefaultSort()
    {
	return "status";
    }

    function GetCountBrowseSQL()
    {
	global $PHP_AUTH_USER;
	global $ServerID;
	return "SELECT COUNT(*) FROM regrequest WHERE  server_id='$ServerID' AND anbieter = " . db_full_quote($PHP_AUTH_USER);
    }

    function AddElement()
    {
	return NULL;
    }

    function EditElements()
    {
	return NULL;
    }

    function DeleteElements ( &$pa_IDs )
    {
	global $PHP_AUTH_USER, $Action;
	global $ServerID;
	switch ( $Action )
	{
	    case "delete":
		$lo_DB =& get_db_connection();
		$lo_Query =& $lo_DB->Select ( "SELECT id FROM regrequest WHERE server_id='$ServerID' AND id IN ( " .
				implode(",",db_full_quote_array($pa_IDs)) . " ) AND anbieter = " . db_full_quote($PHP_AUTH_USER) );
		for ( $la_IDs=array(); $la_Row =& $lo_Query->nextrow(); $la_IDs[] = $la_Row[0] );
		if ( count($la_IDs) )
		{
			$lo_DB->Execute ( "DELETE FROM regrequest WHERE server_id='$ServerID' AND id IN ( " . implode( ",", $la_IDs ) . " )" );
			$lo_DB->Execute ( "DELETE FROM requesteddomain WHERE server_id='$ServerID' AND regrequestid IN ( " . implode( ",", $la_IDs ) . " )" );
		}
		return NULL;
	    case "decline":
		$lo_DB =& get_db_connection();
		$lo_DB->Execute ( "UPDATE regrequest SET status='declined' WHERE server_id='$ServerID' AND id IN ( " .
			implode(",",db_full_quote_array($pa_IDs)) . " ) AND status='new' AND anbieter = " .
			db_full_quote($PHP_AUTH_USER) );
		return NULL;
	    case "accept":
		$lo_DB =& get_db_connection();
		$lo_Query =& $lo_DB->Select ( "SELECT * FROM anbieter WHERE server_id='$ServerID' AND anbieter = " . db_full_quote($PHP_AUTH_USER) );
		$la_Reseller =& $lo_Query->nextrow();
		$lo_Query =& $lo_DB->Select ( "SELECT * FROM admin WHERE server_id='$ServerID'" );
		$la_Admin =& $lo_Query->nextrow();
		$lo_User = NULL;
		foreach ( $pa_IDs as $ls_ID )
		{
		    $lo_Query =& $lo_DB->Select ( "SELECT * FROM regrequest WHERE server_id='$ServerID' AND id = " . db_full_quote($ls_ID) .
			    " AND anbieter = " . db_full_quote($PHP_AUTH_USER) );
		    if ( ! $la_Request =& $lo_Query->nextrow() )
		    {
			message ( ERROR, ltext( "webshop_requests_noid", $ls_ID ) );
			continue;
		    }
		    if ( ff_AcceptRequest( $ls_ID, $la_Request, $la_Reseller, $la_Admin, $lo_User ) == cc_RequestAbort )
			return NULL;
		}
		return NULL;
	}
	return NULL;
    }

    function ValidateAdd()
    {
	return NULL;
    }

    function ValidateEdit()
    {
	return NULL;
    }

    function ValidateDelete ( &$pa_IDs )
    {
	return NULL;
    }
    /* -------------------- end definitions of "abstract" methods -------------------- */





    /* -------------------- CountNew -------------------- */
    function CountNew()
    {
	global $PHP_AUTH_USER;
	global $ServerID;
	$lo_DB =& get_db_connection();
	$lo_Query =& $lo_DB->Select ( "SELECT COUNT(*) FROM regrequest WHERE server_id='$ServerID' AND anbieter = " . db_full_quote($PHP_AUTH_USER) .
		" AND status = 'new'" );
	$la_Data =& $lo_Query->nextrow();
	return $la_Data[0];
    }
    /* -------------------- end CountNew -------------------- */

}
?>
