<?
########## Confixx(R) 3.0 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####

$stylescript = "skinmng.pl";
$thisdir = dirname( __FILE__ );


function create_skin_from_skin ($res_login, $orig_skin_id, $new_skinname, &$alerts) { 
	$skinname = str_replace("'", "\\'", $new_skinname);
	$skin     = $orig_skin_id;

	global $stylescript;
	global $thisdir;
	global $bindir;
	global $sbindir;
	global $DEBUG;
  global $ServerID;

	$loSkin = new SQLString( $new_skinname );
	$loUser = new SQLString( $res_login );

	$id = safe_query2( "SELECT COUNT(*) AS c FROM custom_skins".
										 " WHERE  server_id='$ServerID' AND show_name = ? AND owner_type='reseller' and anbieter=?", 
										 $loSkin, $loUser );
	list($cnt) = db_fetch_array($id,'N');
	db_free_query( $id );

	if( $cnt ){
		$alerts[] = ltext("sk_skin_exists");
		include $thisdir . "/skins_inc/editskins.php";

	} else 	{
		$loID = new SQLinteger( $skin );

		$id = safe_query2( "SELECT name, owner_type, version FROM custom_skins".
											 " WHERE server_id='$ServerID' AND (id = ? AND ( owner_type = 'preinstalled' OR ( owner_type = 'reseller' AND anbieter=? ) ) )", $loID, $loUser );

		if( db_num_rows( $id ) ){
			list($name,$otype,$version) = db_fetch_array($id);
			db_free_query( $id );
		
			if( safe_query2( "INSERT INTO custom_skins (show_name, owner_type, anbieter, version, server_id) ".
											 " VALUES (?, 'reseller', ?, '$version', '$ServerID')",
											 $loSkin, $loUser ) ){

		    $skin_id = db_insert_id( 'custom_skins', 'id' );

				$prefix = ( $version == 'powp' )? 'mskin_': 'skin_';

				if( $otype == 'preinstalled' ){
					$useskin = $name;
				}else{
					$useskin = $prefix . $skin;
				}

				$cmd = "$sbindir/$stylescript --skin $prefix$skin_id --new_skin --use_dir $useskin";
				if( $DEBUG ){
					echo "create_skin_from_skin: run '$cmd'<br>\n";
				}

				exec( $cmd, $out, $ret );

				if( $ret != 0 ){
					echo '<pre>';
					echo implode ("\n", $out);
					echo '</pre>';
					$alerts[] = ltext('sk_system_error');
					safe_query2( "DELETE FROM custom_skins WHERE server_id='$ServerID' AND id=$skin_id");
					return false;

				}	else {
					safe_query2( "UPDATE custom_skins SET path = '/skins/$prefix$skin_id',".
											 " name='$prefix$skin_id' WHERE server_id='$ServerID' AND id=$skin_id");
					return true;
				}
			}	else {
				$alerts[] = ltext('sk_system_error');
				return false;
			}
		}	else {
			$alerts[] = ltext('sk_invalid_skin');
			return false;;
		}
		
	}
	return true;
}

function remove_skin($res_login, $skin_id, &$alerts) {
  $skin = $skin_id;

	global $stylescript;
	global $thisdir;
	global $bindir;
	global $sbindir;
	global $DEBUG;
	global $ServerID;

	$loID = new SQlInteger( $skin_id );
	$id = safe_query2( "SELECT version,name FROM custom_skins WHERE server_id='$ServerID' AND id = ? and anbieter=?".
										 " AND owner_type='reseller'", $loID, $loUser );
  list( $version ) = db_fetch_array($id);
	db_free_query( $id );

  if( ! $version ) {
		$alerts[] = ltext("sk_invalid_skin");	
		return false;
  }

	$prefix = ($version == 'powp')? 'mskin_': 'skin_';

	$cmd = "$sbindir/$stylescript --skin $prefix$skin --del_skin";
	if($DEBUG){
		echo "remove_skin: run '$cmd'<br>\n";
	}
  exec( $cmd, $out, $ret);

  if($ret != 0) {
	  echo '<pre>';
	  print_r($out);
	  echo '</pre>';
	  return false;
  }

  safe_query2( "DELETE FROM custom_skins WHERE  server_id='$ServerID' AND id = ? AND anbieter=? AND owner_type='reseller'",
							 $loID, $loUser );	
  return true;
  
}

function create_default_res_skin( $reseller_login ){
	// if no skins exists -> create default
	global $stylescript;
	global $thisdir;
	global $DEBUG;
  global $ServerID;
	$loUser = new SQLString( $reseller_login );

	$id = safe_query2("SELECT COUNT(*) FROM custom_skins WHERE  server_id='$ServerID' AND owner_type='reseller'".
										" AND anbieter = ?", 
										$loUser );
	list( $cnt ) = db_fetch_array( $id );
	if( $cnt == 0) {

		db_free_query( $id );

		$id = safe_query2( "SELECT skin_id FROM skins WHERE  server_id='$ServerID' AND cuser=?", $loUser);
		list( $skin_id ) = db_fetch_array( $id, 'N' );
		if( ! $skin_id ){

			db_free_query( $id );

			$id = db_query( "SELECT MIN(id) FROM custom_skins WHERE  server_id='$ServerID' AND version='powp'");
			$skin_id = db_fetch_array( $id, 'N' );

			db_free_query( $id );
		}

		$alerts = array();

		create_skin_from_skin( $reseller_login, $skin_id, ltext('sk_default_skin'), $alerts );
	}
}



?>
