<?
########## Confixx(R) 3.1 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####

include_once( 'auth.php' );
include_once( 'defines.php' );
include( "../languages/$shortlang/scripts.inc.php" );

include_once( '../include/elements/html/class.ButtonURLElement.php' );
include_once( '../include/elements/html/class.PPButtonElement.php' );
include_once( '../include/elements/html/class.SimpleSearchElement.php' );
include_once( '../include/elements/html/class.SelectElement.php' );
include_once( '../include/elements/html/class.HTMLElement.php' );
include_once( '../include/elements/html/class.MainPageElement.php' );
include_once( '../include/elements/html/module.Constants.php' );

include_once( '../include/elements/data/class.PagedTableView.php' );
include_once( '../include/elements/data/class.TextDataField.php' );
include_once( '../include/elements/data/class.HTMLDataField.php' );
include_once( '../include/elements/data/class.IconDataField.php' );

include_once( '../include/data_source/class.DataValue.php' );
include_once( '../include/data_source/class.SQLQuery.php' );
include_once( '../include/data_source/class.ValueDateFormated.php' );
include_once( '../include/data_source/class.ValueLocale.php' );
include_once( '../include/data_source/class.CompoundDBValue.php' );
include_once( '../include/data_source/class.ConversedDBValue.php' );

include_once( '../include/class.SQLFieldSet.php' );

global $DEBUG;
//$DEBUG=1;

if($DEBUG){
	echo "allgemein_servermeldungen2.php: POST<br><pre>\n";
	print_r($_POST);
	echo "</pre><br>\n";
}

db_master_connect();
if( !$code ) {
	$code = 0;
}
if($schritte){
	$page_size = $schritte;
}

initPagingSettings( $_POST, array( 'code' => $code ) );

$loWhere = new SQLFieldSet( array( 'anbieter' => array( '', 'C'),
																	 'kunde' => array( '', 'C' )
																	 )
														);

$lcSQL = "SELECT COUNT(e.code) FROM ereignisse e WHERE ".$loWhere->getSQLWhere();
$res = db_query( $lcSQL );
list( $total_number ) = db_fetch_array( $res );
db_free_query( $res );

if( $code >= 0 ){
	$loWhere->addField( 'e.code', $code );
 }
if( $server_id ){
	$loWhere->addField( 'e.server_id', $server_id, 'C' );
 }
$lcSQL = "SELECT COUNT(e.code) FROM ereignisse e WHERE ".$loWhere->getSQLWhere();


$loQuery = new SQLQuery( $lcSQL );
$loQuery->doQuery();
list($total_number) = $loQuery->fetchArray('N');
$loQuery->freeResult();

if( ! $total_number ){
	$fehlertext = ltext('messages__no_messages');
}

$lcSQL = "SELECT e.timestamp, e.nachricht, e.script, e.code, s.name, a.hostname ".
	" FROM (ereignisse e, admin a)".
	" LEFT JOIN server s ON s.server_id=e.server_id".
	" WHERE a.server_id = e.server_id AND " . $loWhere->getSQLWhere();;

$order = 'ident';
$lcSQL .= " ORDER BY ident";
if( $direction != 'asc' ) {
	$direction = 'desc';
	$lcSQL .= ' DESC';
}
$laContent = array();
$laContent['ident'] = new CompoundDataField( new HTMLDataField( ltext( 'alse2_cell_time' )),
																						 new IconDataField( ($direction == 'desc')?
																																cc_DescIcon :
																																cc_AscIcon )
																						);
$laContent['ident']->SetSeparator('');


$query = new SQLQuery( $lcSQL, $code );

$ds = new ConversedDBValue( $query, $page_size, $start_index - 1 );

function &prepareMsg( $msg ){ 
	$tmp = new HTMLDataField (mlf_text($msg));	
	return  $tmp;
}

function getNameOfCode ( $code ) {
	switch ($code) {
	case 0:
		$msgTop = ltext('alse_select_notice'); 
		break;
	case 1: 
		$msgTop = ltext('alse_select_error'); 
	 break;
	case 2:
		$msgTop = ltext('alse_select_warning'); ; 
	 break;
	default: 
		$msgTop = ltext('ll_any'); 
	}
	return $msgTop;
}


function &createIcon ( $poSrc ){
	global  $confixx_interface_version;
	switch( $poSrc ){
	case 2:
		$lcIcon = cc_TypeWarnigIcon;
		$lcTitle = substr(ltext('errtype_warning'),0,-1);
		break;
	case 1:
		$lcIcon = cc_TypeErrorIcon;
		$lcTitle = substr(ltext('errtype_error'),0,-1);
		break;
	case 0:
		$lcIcon = cc_TypeNoticeIcon;
		$lcTitle = substr(ltext('errtype_notice'),0,-1);
		break;
	default: 
		$lcIcon = cc_TypeNoticeIcon;
		$lcTitle = substr(ltext('errtype_notice'),0,-1);
	}
	if($confixx_interface_version == 'powp') {
		$loLink = new IconDataField($lcIcon, array(title=>$lcTitle)) ;
	} else {
		$loLink = new HTMLDataField($lcTitle);
	}
	return $loLink;
}

function &makeServerName( &$poSrc ){
	list($lcName,$lcHostname) = $poSrc->listValue();
	$loName = new HTMLDataField( $lcName? $lcName: $lcHostname );
	return $loName;
}

$lcNewDirection = ($direction=='asc')? 'desc': 'asc';
$loTemplate = new CompoundValue(new ValueFormated( 'code', NULL, 'getNameOfCode' ),
																new ValueFromArray( 'nachricht' ),																
																new ValueDateFormated( 'timestamp', NULL, $lang_format_datetime_long ),
																new CompoundValue( new ValueFromArray('name'),
																									 new ValueFromArray('hostname')
																									 ),
																new ValueFromArray( 'script' )
																);
																 
$loTitle = new CompoundValue( new ValueLocale( 'alse_cell_type' ) , 
															new ValueLocale( 'alse2_cell_error'),
															new DataValue( 'ident',	NULL,
																						 new LinkDataField( "javascript:setValue('order','ident');".
																																 "setValue('start_index',1);".
																																 "submitForm('direction','$lcNewDirection')",
																																 '',
																																 array(),
																																 $laContent['ident']
																																 )
																							),
															new ValueLocale( 'alse2_cell_server'), 
															new ValueLocale( 'alse2_cell_script' ));

$ds->Template(  $loTemplate );
$ds->Conversion(new CompoundValue(new ValueFormated( 'code',null, 'createIcon'),
																	new ValueFormated( 'Message', NULL, 'prepareMsg'),
																	NULL,
																	new ValueFormated( 'server', NULL, 'makeServerName' ),
																	NULL));


$ds->doQuery();

$ptv = new PagedTableView( $ds, $total_number );

$ptv->Title( $loTitle	);

$ptv->setParameter( 'order', $order );
$ptv->setParameter( 'direction', $direction );

//$ptv->Hiddens( array( 'code'=>$code	) ); ## in serach element



// output to html
//

$tbl = $ptv->GetOutputPresentation( array('action' => 'allgemein_servermeldungen2.php'), ltext("alse2_title") );


switch ($code) {
 case 0:
	 $msgTop = ltext('errtype_notices'); 
	 break;
 case 1: 
	 $msgTop = ltext('errtype_errors'); 
	 break;
 case -1:
	 $msgTop = ltext('errtype_any'); 
	 break;
 default: 
	 $msgTop = ltext('errtype_warnings'); 
}

$stop_index = $start_index + $page_size - 1;
if( $stop_index > $total_number){
	$stop_index = $total_number;
}


$dsSearch = new CompoundValue();

//
// select type of messages
//

$dsSearch->addValue( new ValueLocale( 'alse_cell_type' ));

$dsSearch->addValue( new CompoundValue( new KeyValue( 'code', '1' ), new ValueLocale('alse_select_error' ) ),
										 new CompoundValue( new KeyValue( 'code', '2' ), new ValueLocale('alse_select_warning' ) ),
										 new CompoundValue( new KeyValue( 'code', '0' ), new ValueLocale('alse_select_notice' ) ),
										 new CompoundValue( new KeyValue( 'code', '-1' ), new ValueLocale('ll_all' ) )
										 );

//
// select server
//
$dsSearch->addValue( new ValueLocale( 'alse_cell_server' ));

$dsServers = new CompoundDBValue( "SELECT a.server_id, s.name, a.confixx_domain ".
																	" FROM admin a LEFT JOIN server s ON s.server_id=a.server_id ".
																	" ORDER BY s.name, a.confixx_domain");
$dsServers->doQuery();
$loIter =& $dsServers->getFirstIterator();
$loServerSelect = new CompoundValue();
while( $loItem =& $loIter->getNext() ){

	list($lcServerID,$lcName,$lcHostname) = $loItem->listValue();

	$lcPrompt = "$lcName ($lcHostname)";
	$loServerSelect->addValue( new KeyValue( 'server_id', $lcServerID ),
														 new KeyValue( 'name', $lcPrompt )
														 );
 }

$loServerSelect->addValue( new KeyValue( 'server_id', '' ),
													 new ValueLocale('ll_all' ) );
														 
$dsSearch->addValue( $loServerSelect );

//
// label of button
//
$dsSearch->addValue( new ValueLocale( 'll_show' ) );


$loSearch = new SimpleSearchElement( array(),
																		 new HTMLElement( '' ), // promt
																		 new SelectElement(array( 'name' => 'code' )), 
																		 new HTMLElement( '' ), // prompt
																		 new SelectElement(array( 'name' => 'server_id' )), 
																		 new PPButtonElement( '',
																														 "javascript:submitForm('start_index',1)",
																														 'bid-search'
																														 )
																		 );

$loSearch->setDataSource( $dsSearch, array( 'code' => $code,
																						'server_id' => $server_id ) );


$tbl->SearchElement( $loSearch );
$tbl->updateBodyContent();
$page = new MainPageElement( $tbl);

$page->OutputHTML(array('../js/paged_form.js'));


?>
