<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

include_once( 'auth.php' );
include_once( '../include/elements/data/class.SetOfRowsData.php' );
include_once( '../include/elements/data/class.HTMLDataField.php' );
include_once( '../include/elements/data/class.TextDataField.php' );
include_once( '../include/elements/data/class.CompoundDataField.php' );
include_once( '../include/elements/data/class.YesNoDataField.php' );
include_once( '../include/elements/html/class.MainPageElement.php' );

global $DEBUG;
//$DEBUG = 1;

db_master_connect();

if( ! isset( $server_id ) ){
	$server_id = $masterServerID;
}

if( ! isset( $anbieter ) ){
	$anbieter = 'res0';
}

$loServerID = new SQLString( $server_id );
$loRes = new SQLString( $anbieter );

$id = safe_query2( "SELECT a.hostname,a.confixx_domain,s.name,a.ip_pns,a.ip_sns ".
									 " FROM admin a LEFT JOIN server s ON s.server_id=a.server_id ".
									 " WHERE a.server_id=?",
									 $loServerID );
$admin = db_fetch_array( $id, 'A' );
db_free_query( $id );

## liste freier ips holen

if( ! isset($pns) || ! isset( $sns ) ){
  $id = safe_query2( "SELECT pns, sns FROM anbieter WHERE anbieter = ? AND server_id=?",
										 $loRes, $loServerID);

  list($pns,$sns) = db_fetch_array($id,'N');
	db_free_query( $id );

  if( ! $pns  ){
		$pns = $admin['hostname'];
  }
  if ( ! $sns ){
		$sns = $admin['hostname'];
  }
}

$data = new SetOfRowsData();

$ip_pns = $admin['ip_pns'];
$ip_sns = $admin['ip_sns'];

if( $ip_pns ){
	$lo_label = new CompoundDataField( new HTMLDataField( ltext( 'eidntpdoae_title5' ) ),
		new HTMLDataField( "<strong>($ip_pns)</strong>" ) );
	$lo_label->SetSeparator('<br>')	;

}else{
	$lo_label = new HTMLDataField( ltext( 'eidntpdoae_title5' ) );
}

$data->AppendRow( $lo_label, new TextDataField( $pns, 'pns' ) );

if( $ip_sns ){
	$lo_label = new CompoundDataField( new HTMLDataField( ltext( 'eidntpdoae_title6' ) ),
		new HTMLDataField( "<strong>($ip_sns)</strong>" ) );
	$lo_label->SetSeparator( '<br>' )	;
}else{
	$lo_label = new HTMLDataField( ltext( 'eidntpdoae_title6' ) );
}

$data->AppendRow( $lo_label, new TextDataField( $sns,'sns' ) );

$data->AppendRow( new HTMLDataField( ltext( 'eidntpdoae_title13' ) ),
									new YesNoDataField(array( '1'=>null),array(),'','all'));

$data->AppendHidden( new TextDataField( $anbieter, 'anbieter' ) );
$data->AppendHidden( new TextDataField( $server_id, 'server_id' ) );
if( isset( $ret_path ) ){
	$data->AppendHidden( new TextDataField( $ret_path, 'ret_path' ) );
 }
if( isset( $server ) ){
	$data->AppendHidden( new TextDataField( $server, 'server' ) );
 }


$data->AppendButton( ltext( 'eidntpdoae_savedns' ),"javascript:doChange()",cc_IDOk);

$form = new MainPageElement();
$lcTitle = ltext( 'anae_cell_dns_master', array( $admin['name'], $admin['confixx_domain'] ) ).
           ' <strong>'.htmlspecialchars( $anbieter ).'</strong>';
$form->AppendToContent(
	$data->GetInputPresentation( array( 'action'=>'anbieter_aendern_dns2.php'),
															 $lcTitle ) );

$form->OutputHTML(js_f_call_help('dnshelp_title1', 'dnshelp_descr1'));

db_close();

?>
