<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

include_once( 'auth.php' );
include_once( '../include/limits/class.AllLimits.php' );
include_once( '../include/elements/data/class.SetOfRowsData.php'  );
include_once( '../include/elements/data/class.HTMLDataField.php'  );
include_once( '../include/elements/data/class.TextDataField.php'  );
include_once( '../include/elements/data/class.PasswordDataField.php'  );
include_once( '../include/elements/data/class.OptionsDataField.php'  );
include_once( '../include/elements/data/class.CompoundDataField.php'  );
include_once( '../include/elements/html/class.MainPageElement.php'  );
include_once( '../include/elements/html/module.Constants.php'  );
include_once( '../include/class.PathBar.php' );

global $DEBUG;
//$DEBUG=1;

if($DEBUG){
	echo "anbieter_anlegen2<br>\n";	
}

$limits = new AllLimits();
$limits->SetFromRow ( $_POST );

db_master_connect();


## Daten aus vorherigem Formular ueberpruefen

$laLimits = array( 'maxkundenlimit', 'maxkblimit', 'maxpoplimit', 'maxemaillimit', 'maxemail',
                   'maxautoresponderlimit', 'maxautoresponder', 'maxftplimit', 'maxftp',             
                   'maxdomainslimit', 'maxsubdomainslimit', 'maxwildcards', 'maxwildcardslimit',
                   'maxatdomainslimit', 'maxatdomains', 'maxsubdomains', 'maxmysqllimit', 
                   'maxmysql','maxcronjobslimit', 'maxcronjobs', 'maxmaillistlimit',  
                   'maxmaillist', 'maxpop', 'dnr', 'dns', 'maxtransfer', 'backup', 
                   'maxkb','popmaxkb', 'popmaxkblimit',
                   'maxshareddomains', 'maxshareddomainslimit'
                 );
                 
foreach( $laLimits as $lcLimit ){
  if( istleer( $$lcLimit ) ){ 
    $$lcLimit = 0; 
  }
}

function validateSettings($if,$msg){
	global $fehlertext;
	global $DEBUG;
	if($if){
		foreach (array_keys($GLOBALS) as $key ){ // expand all global variables 
		                                         // like 'global $variable;'
			$$key =& $GLOBALS[$key];
		}
		$fehlertext = $msg;
    db_close();
    include("anbieter_anlegen.php");
    exit();
	}
}
# checkboxen

validateSettings (($maxkundenlimit == 1) && ($maxkunden == -1),ltext("anan2_error1"));
validateSettings (($maxkblimit == 1) && ($maxkb == -1),ltext("anan2_error2"));
validateSettings (($maxpoplimit == 1) && ($maxpop == -1),ltext("anan2_error3"));
validateSettings (($maxemaillimit == 1) && ($maxemail == -1),ltext("anan2_error4"));
validateSettings (($maxautoresponderlimit == 1) && ($maxautoresponder == -1),ltext("anan2_error5"));
validateSettings (($maxftplimit == 1) && ($maxftp == -1),ltext("anan2_error6"));
validateSettings (($ftp == 0) && ($maxftp != 0),ltext("anan2_error7"));
validateSettings (($maxdomainslimit == 1) && ($maxdomains == -1),ltext("anan2_error8"));
validateSettings (($maxsubdomainslimit == 1) && ($maxsubdomains == -1),ltext("anan2_error9"));
validateSettings (($maxshareddomainslimit == 1) && ($maxshareddomains == -1), ltext("anan2_error45"));
validateSettings (($maxwildcardslimit == 1) && ($maxwildcards == -1),ltext("anan2_error41") );
validateSettings (($maxatdomainslimit == 1) && ($maxatdomains == -1),ltext("anan2_error42"));
validateSettings (($maxmysqllimit == 1) && ($maxmysql == -1),ltext("anan2_error10"));
validateSettings (($maxcronjobslimit == 1) && ($maxcronjobs == -1),ltext("anan2_error34"));
validateSettings (($maxmaillistlimit == 1) && ($maxmaillist == -1),ltext("anan2_error37"));
validateSettings (($popmaxkblimit == 1) && ($popmaxkb == -1),ltext("anan2_error_ms_2"));

# /checkboxen

validateSettings ( !is_numeric($maxkunden) || ($maxkunden > 32768) || ($maxkunden == 0) || ($maxkunden < -1) ,
	ltext("anan2_error11"));

## muss vor multiplikation mit 1024, fals man z.B. "0.5" angibt ist's nacher ne richtige zahl, bei eingabe nicht

validateSettings (!is_numeric($maxkb),ltext("anan2_error12"));
validateSettings (!is_numeric($popmaxkb),ltext("anan2_error_ms_12"));
## /muss...

## MB/GB in KB bei "max. Speicherplatz vom Anbieter" umwandeln

if ($maxkb <> -1) {
	$maxkb2 = $maxkb * 1024;
	if ($maxkb_mbgb == 'GB') { 
			$maxkb2 = $maxkb2 * 1024; 
	}
} else { 
	$maxkb2 = $maxkb; 
}
if ($popmaxkb <> -1) {
  $popmaxkb2 = $popmaxkb * 1024;
  if ($popmaxkb_mbgb == 'GB') { 
      $popmaxkb2 = $popmaxkb2 * 1024; 
  }
} else { 
  $popmaxkb2 = $popmaxkb; 
}

## /MB/GB in KB bei "max. Speicherplatz vom Anbieter" umwandeln


validateSettings ((($maxkb2 < 1024) && ($maxkb2 <> -1))|| ($maxkb2 > 2147283647) || ($maxkb2 < -1),
	ltext("anan2_error13"));
 
validateSettings (!is_numeric($maxpop) || ($maxpop > 8388607) || ($maxpop < -1),ltext("anan2_error14") );
validateSettings (!is_numeric($maxemail) || ($maxemail > 8388607) || ($maxemail < -1), ltext("anan2_error15") );
validateSettings (!is_numeric($maxautoresponder)||($maxautoresponder > 8388607) || ($maxautoresponder < -1),
	 ltext("anan2_error16") );

 
# wenn email < autoresponder dann fehler

validateSettings ((($maxemail < $maxautoresponder) && ($maxautoresponder > 0) && ($maxemail <> -1)) || (($maxautoresponder == -1) && ($maxemail <> -1)),
	ltext("anan2_error18"));

# /wenn email < pop dann fehler

validateSettings ( ! is_numeric( $maxshareddomains )
                   || ( $maxshareddomains > 8388607 ) 
                   || ( $maxshareddomains < -1 ),ltext("anan2_error46") );


validateSettings (!is_numeric($maxdomains)||($maxdomains > 8388607) || ($maxdomains < -1),ltext("anan2_error23") );

validateSettings( ( (  $maxdomains < $maxkunden ) && $maxdomains != -1 ) 
                  || ( $maxkunden == -1 && $maxdomains != -1 ), 	ltext( 'anan2_error19' ) );


validateSettings (!is_numeric($maxftp)||($maxftp > 8388607) || ($maxftp < -1),ltext("anan2_error20") );
validateSettings (!is_numeric($maxwildcards)||$maxwildcards > 0x7FFFFF || $maxwildcards < -1 ,ltext("anan2_error43") );
validateSettings (!is_numeric($maxatdomains)|| $maxatdomains > 0x7FFFFF || $maxatdomains < -1 ,ltext("anan2_error44") );
validateSettings (!is_numeric($maxtransfer)||($maxtransfer < -1),ltext("anan2_error21") );

## MB/GB in KB bei "max. transfer vom Anbieter" umwandeln

if( $maxtransfer >= 0 ) {
	$maxtransfer2 = $maxtransfer * 1024;
	if ( $maxtransfer_mbgb == 'GB' )
		$maxtransfer2 *= 1024;
}
else
	$maxtransfer2 = -1;

## /MB/GB in KB bei "max. transfer vom Anbieter" umwandeln

validateSettings ($maxtransfer2 > 2147283647,ltext("anan2_error22"));
validateSettings (!is_numeric($maxsubdomains)||($maxsubdomains > 8388607) || ($maxsubdomains < -1) ,ltext("anan2_error24"));
validateSettings (($maxwildcards > $maxsubdomains) && ($maxsubdomains != -1),ltext("anan2_error26"));
validateSettings (!is_numeric($maxmysql)||($maxmysql > 32767) || ($maxmysql < -1),ltext("anan2_error27") );
validateSettings (($shell == 1) && ($ftp == 0),ltext("anan2_error28"));
validateSettings (($stdcgi == 1) && ($perl != 1),ltext("anan2_error29"));
validateSettings (($dbext == 1) && ($maxmysql == 0),ltext("anan2_error30"));
validateSettings (($php == 0) && ($phpupload == 1),ltext("anan2_error31"));

## Wenn DNR dann muss auch DNS erlaubt sein
validateSettings (($dns == 0) && ($dnr == 1),ltext("anan2_error32"));
validateSettings (!is_numeric($maxcronjobs),ltext("anan2_error33"));

if($maxpop == 0) { $spamfilter = 0; }

validateSettings (!is_numeric($maxmaillist),ltext("anan2_error38"));

## /Wenn DNR dann muss auch DNS erlaubt sein



## /Eingabevariablen auf Typengueltigkeit ueberpruefen


## /Daten aus vorherigem Formular berprfen

###############################################

$loPathBar = new PathBar();
$loPathBar->cloneTop( array( 'cur_page' => 'anbieter_anlegen2.php',
														 'path_text'=>ltext('ma_personalinfo')
														 ) 
											);
$loPathBar->saveRequest( 'anbieter_anlegen.php' );
$loPathBar->restoreRequest( 'anbieter_anlegen2.php', TRUE );

// this is required because the file could be included to another 
// one inside some block
// in this case you will not have this varible global automatically
global $data;
$data = new SetOfRowsData();


$data->AppendHeaderRow(new HTMLDataField(ltext("anan2_cell_description")),
	new HTMLDataField(ltext("anan2_cell_input")));

function makeFF(&$poLabel,&$poField){	
	global $data;
	$data->AppendRow($poLabel,$poField);
}
	
function makeLF($psLabel,&$poField){
	$loLabel = new HTMLDataField($psLabel);
	makeFF($loLabel,$poField);
}	

makeLF(ltext("anan2_cell_gender"),
	new OptionsDataField(array("m" => ltext("anan2_cell_gender1"),"f" => ltext("anan2_cell_gender2")),
		$gender,"gender"));

if($dnr) makeLF(ltext("anan2_cell_firstname")." <sup class=required>*</sup>",	new TextDataField($firstname,"firstname"));	
else makeLF(ltext("anan2_cell_firstname"),	new TextDataField($firstname,"firstname"));
if($dnr) makeLF(ltext("anan2_cell_name")." <sup class=required>*</sup>",	new TextDataField($name,"name"));	
else makeLF(ltext("anan2_cell_name"),	new TextDataField($name,"name"));
makeLF(ltext("anan2_cell_firm"),	new TextDataField($firma,"firma"));
if($dnr) makeLF(ltext("anan2_cell_address")." <sup class=required>*</sup>",	new TextDataField($anschrift,"anschrift"));	
else makeLF(ltext("anan2_cell_address"),	new TextDataField($anschrift,"anschrift"));
if($dnr) makeLF(ltext("anan2_cell_city")." <sup class=required>*</sup>",	new TextDataField($ort,"ort"));	
else makeLF(ltext("anan2_cell_city"),	new TextDataField($ort,"ort"));
if($dnr) makeLF(ltext("anan2_cell_zip")." <sup class=required>*</sup>",	new TextDataField($plz,"plz"));	
else makeLF(ltext("anan2_cell_zip"),	new TextDataField($plz,"plz"));
if($dnr) makeLF(ltext("anan2_cell_country")." <sup class=required>*</sup>",	new TextDataField($land,"land"));	
else makeLF(ltext("anan2_cell_country"),	new TextDataField($land,"land"));
if($dnr) makeLF(ltext("anan2_cell_tel")." <sup class=required>*</sup>",	new TextDataField($telefon,"telefon"));	
else makeLF(ltext("anan2_cell_tel"),	new TextDataField($telefon,"telefon"));
makeLF(ltext("anan2_cell_fax"),	new TextDataField($fax,"fax"));		

$lsLabel = ltext("anan2_cell_email");

if( $emailclass && preg_match( '~^[a-zA-Z0-9=]+$~', $emailclass ) ){
	$lsLabel = "<sup ".htmlspecialchars( $emailclass ).">$lsLabel</sup>";
}
$lsLabel .= " <sup class=required>*</sup>";
makeLF($lsLabel,	new TextDataField($emailadresse,"emailadresse"));
		
makeLF(ltext("anan2_cell_cid"),	new TextDataField($kundennummer,"kundennummer"));		

$data->AppendHeaderRow(new HTMLDataField(ltext("anan2_cell_userdeffields")),
	new HTMLDataField(ltext("anan2_cell_input")));

makeFF(new TextDataField($freifeldname1,"freifeldname1"),	new TextDataField($freifeldwert1,"freifeldwert1"));		
makeFF(new TextDataField($freifeldname2,"freifeldname2"),	new TextDataField($freifeldwert2,"freifeldwert2"));		
makeFF(new TextDataField($freifeldname3,"freifeldname3"),	new TextDataField($freifeldwert3,"freifeldwert3"));		

$loRadio = new OptionsDataField(array("1"=>ltext("g_yes"),"0"=>ltext("g_no")),
	isset($kundendatenanzeigen)?$kundendatenanzeigen:1,"kundendatenanzeigen",cc_RadioGroupPresentation );
$loRadio->SetSeparator(' ');
makeFF(new HTMLDataField(ltext("anan2_cell_descr1")),$loRadio);


/*-----------------------------------------------------*/
	$data->AppendHeaderRow( new HTMLDataField( ltext('anan2_passwd_descr'),
																							 array(),
																							 array('colspan'=>2)
																							 )
														);

	$data->AppendRow( new HTMLDataField(ltext('anaepw_cell_pw1')),
											new PasswordDataField( $neupw1, 'neupw1'));
	$data->AppendRow( new HTMLDataField(ltext('anaepw_cell_pw2')),
											new PasswordDataField( $neupw2, 'neupw2'));


/*-----------------------------------------------------*/


/*
$loField = new CompoundDataField(new HTMLDataField(ltext("anan2_cell_descr1")), $loRadio);
$loField->SetSeparator('<br>');
$loField->SetColSpan(2);
$loField->SetParentAttributes(array("align"=>"center"));
$data->AppendRow($loField);
*/

$data->AppendButton( ltext("anan_back"), "javascript:goPrevPage('anbieter_anlegen.php')" ,cc_IDBack);
$data->AppendButton(ltext('anan2_button1'),"javascript:doChange()",cc_IDNext);

$data->AppendHidden( new TextDataField( $maxkundenlimit, 'maxkundenlimit' ) );
$data->AppendHidden( new TextDataField( $maxkblimit, 'maxkblimit' ) );
$data->AppendHidden( new TextDataField($popmaxkblimit,"popmaxkblimit"));
$data->AppendHidden( new TextDataField($popmaxkb,"popmaxkb"));
$data->AppendHidden( new TextDataField( $maxpoplimit, 'maxpoplimit' ) );
$data->AppendHidden( new TextDataField( $maxemaillimit, 'maxemaillimit' ) );
$data->AppendHidden( new TextDataField( $maxautoresponderlimit, 'maxautoresponderlimit' ) );
$data->AppendHidden( new TextDataField( $maxftplimit, 'maxftplimit' ) );
$data->AppendHidden( new TextDataField( $maxsubdomainslimit, 'maxsubdomainslimit' ) );
$data->AppendHidden( new TextDataField( $maxdomainslimit, 'maxdomainslimit' ) );
$data->AppendHidden( new TextDataField( $maxmysqllimit, 'maxmysqllimit' ) );
$data->AppendHidden( new TextDataField( $maxkunden, 'maxkunden' ) );
$data->AppendHidden( new TextDataField( $maxkb, 'maxkb' ) );
$data->AppendHidden( new TextDataField( $maxkb_mbgb, 'maxkb_mbgb' ) );
$data->AppendHidden( new TextDataField($popmaxkb_mbgb,"popmaxkb_mbgb"));
$data->AppendHidden( new TextDataField( $maxpop, 'maxpop' ) );
$data->AppendHidden( new TextDataField($maxshareddomainslimit,"maxshareddomainslimit"));
$data->AppendHidden( new TextDataField($maxshareddomains,"maxshareddomains"));
$data->AppendHidden( new TextDataField( $maxemail, 'maxemail' ) );
$data->AppendHidden( new TextDataField( $maxautoresponder, 'maxautoresponder' ) );
$data->AppendHidden( new TextDataField( $maxftp, 'maxftp' ) );
$data->AppendHidden( new TextDataField( $maxtransfer, 'maxtransfer' ) );
$data->AppendHidden( new TextDataField( $maxtransfer_mbgb, 'maxtransfer_mbgb' ) );
$data->AppendHidden( new TextDataField( $maxsubdomains, 'maxsubdomains' ) );
$data->AppendHidden( new TextDataField( $maxdomains, 'maxdomains' ) );
$data->AppendHidden( new TextDataField( $maxwildcards, 'maxwildcards' ) );
$data->AppendHidden( new TextDataField( $maxwildcardslimit, 'maxwildcardslimit' ) );
$data->AppendHidden( new TextDataField( $maxatdomains, 'maxatdomains' ) );
$data->AppendHidden( new TextDataField( $maxatdomainslimit, 'maxatdomainslimit' ) );
$data->AppendHidden( new TextDataField( $maxmysql, 'maxmysql' ) );
$data->AppendHidden( new TextDataField( $ftp, 'ftp' ) );
$data->AppendHidden( new TextDataField( $php, 'php' ) );
$data->AppendHidden( new TextDataField( $perl, 'perl' ) );
$data->AppendHidden( new TextDataField( $modpython, 'modpython' ) );
$data->AppendHidden( new TextDataField( $ssi, 'ssi' ) );
$data->AppendHidden( new TextDataField( $cssl, 'cssl' ) );
$data->AppendHidden( new TextDataField( $frontpage, 'frontpage' ) );
$data->AppendHidden( new TextDataField( $shell, 'shell' ) );
$data->AppendHidden( new TextDataField( $scponly, 'scponly' ) );
$data->AppendHidden( new TextDataField( $statistik, 'statistik' ) );
$data->AppendHidden( new TextDataField( $awstats, 'awstats' ) );
$data->AppendHidden( new TextDataField( $pwschutz, 'pwschutz' ) );
$data->AppendHidden( new TextDataField( $fehlerseiten, 'fehlerseiten' ) );
$data->AppendHidden( new TextDataField( $webftp, 'webftp' ) );
$data->AppendHidden( new TextDataField( $webmail, 'webmail' ) );
$data->AppendHidden( new TextDataField( $stdcgi, 'stdcgi' ) );
$data->AppendHidden( new TextDataField( $phpupload, 'phpupload' ) );
$data->AppendHidden( new TextDataField( $dirlist, 'dirlist' ) );
$data->AppendHidden( new TextDataField( $dbext, 'dbext' ) );
$data->AppendHidden( new TextDataField( $wap, 'wap' ) );
$data->AppendHidden( new TextDataField( $coldfusion, 'coldfusion' ) );
$data->AppendHidden( new TextDataField( $dns, 'dns' ) );
$data->AppendHidden( new TextDataField( $dnr, 'dnr' ) );
$data->AppendHidden( new TextDataField( $maxcronjobs, 'maxcronjobs' ) );
$data->AppendHidden( new TextDataField( $maxcronjobslimit, 'maxcronjobslimit' ) );
$data->AppendHidden( new TextDataField( $spamfilter, 'spamfilter' ) );
$data->AppendHidden( new TextDataField( $maxmaillist, 'maxmaillist' ) );
$data->AppendHidden( new TextDataField( $maxmaillistlimit, 'maxmaillistlimit' ) );

$data->AppendHidden( new TextDataField( $server_id, 'server_id'  ) );

$data->AppendHidden( new TextDataField( $backup, 'backup' ) );
/**
 * Httpd options
 */
if( empty( $httpd_ids ) ){
  $httpd_ids = array();
}
foreach( $httpd_ids as $id => $value ){
  $data->AppendHidden( new TextDataField( $value ,"httpd_ids[$id]" ) );
}



for( $limits->FirstService(); $service = $limits->NextService(); ){
	$data->AppendHidden( new TextDataField( $service->GetValue(),$service->GetName( ) ));
}
//
// output

$form = $data->GetInputPresentation( array( 'action'=>'anbieter_anlegen3.php', 'method'=>'post' ), 
	ltext('anan_title1') ); //InputForm

$form->AppendTop("<sup class=required>*</sup> - ".ltext("fp_required_fields" ) );
$form->SetWidths('50%', '50%');
	
$page = new MainPageElement( $form );

$page->OutputHTML(js_f_call_help('anan2_descr1', 'anan2_descr2' ) );

db_close();
?>
 
