<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

include_once( 'auth.php' );
include_once( 'defines.php' );
include_once( '../include/elements/data/class.HTMLDataField.php' );
include_once( '../include/elements/data/class.LinkDataField.php' );
include_once( '../include/elements/data/class.TextDataField.php' );
include_once( '../include/elements/data/class.CompoundDataField.php' );
include_once( '../include/elements/data/class.IconDataField.php' );
include_once( '../include/elements/data/class.PagedTableView.php' );
include_once( '../include/elements/data/class.GenericButtonData.php' );
include_once( '../include/elements/data/class.CheckDataField.php' );
include_once( '../include/elements/data/class.OptionsDataField.php' );
include_once( '../include/elements/data/class.CompoundDataField.php' );
include_once( '../include/elements/data/class.ToolsButtons.php' );
include_once( '../include/elements/data/class.ToolsButtonData.php' );
include_once( '../include/data_source/class.SQLQuery.php' );
include_once( '../include/data_source/class.CompoundValue.php' );
include_once( '../include/data_source/class.ValueLocale.php' );
include_once( '../include/data_source/class.ValueFromArray.php' );
include_once( '../include/data_source/class.ValueFormated.php' );
include_once( '../include/data_source/class.ConversedDBValue.php' );
include_once( '../include/data_source/class.DataValue.php' );
include_once( '../include/elements/html/class.MainPageElement.php' );
include_once( '../include/elements/html/class.CompoundElement.php' );
include_once( '../include/elements/html/class.PPButtonElement.php' );
include_once( '../include/elements/html/class.ButtonURLElement.php' );
include_once( '../include/elements/html/class.ButtonElement.php' );
include_once( '../include/elements/html/class.SimpleSearchElement.php' );
include_once( 'gui/module.GuiPP_HeadMenu.php' );
include_once( '../include/elements/html/module.Constants.php' );

global $DEBUG;
//$DEBUG=1;

if( $DEBUG ){
	echo "einstellungen_ip.php: _POST:<br><pre>\n";
	print_r($_POST);
	echo "</pre><hr>_GET:<br><pre>\n";
	print_r( $_GET );
	echo "</pre><hr>\n";
}


if( ! isset($server_id) ){
	$server_id = $masterServerID;
 }

$loServerID = new SQlString( $server_id );

db_master_connect();

$loPathBar = new PathBar();
$laFirstItem = array('main_menu_page' => 'einstellungen_ip.php',
										 'head_id'        => 'ip',
										 'head_text'      => ltext("me_ip"),
										 'menu_node_id'   => 'menu_node_setup_ip'
										 );
$loPathBar->pushPathBar( $laFirstItem );



if( isset($action) && $action ){
	switch( $action ){
	case 'reread':
		$lcSql = "UPDATE allgemein SET lokaleips = 1 WHERE server_id=?";
		safe_query2( $lcSql, $loServerID );
		$fehlertitel = ltext( 'eiipauup_errortitle' );
		$fehlertext  = ltext( 'eiipauup_error1' );
		break;
	case 'activate':
		safe_query2( "UPDATE ipadressen SET status=1, anbieter=? ".
								 " WHERE server_id=? AND ip=?",
								 new SQLString($anbieter), $loServerID, new SQLString($ip) );
		break;
	case 'deactivate':
		$loIP = new SQLString( $ip );
		$id = safe_query2( "SELECT kunde FROM kunden WHERE ip=? AND server_id=?",
											 $loIP, $loServerID);
		$cnt = db_num_rows( $id );
		if( $cnt ){
			$laUsers = array();
			while( list($user) = db_fetch_array($id, 'N' ) ){
				$laUsers[] = $user;
			}
			db_free_query( $id );
			$fehlertitel = ltext( 'eiipauup_errortitle' );
			$fehlertext  = ltext( 'eiipauup_error2', array( join(', ',$laUsers ) ) );
			
		}else{
			db_free_query( $id );
			$id = safe_query2("SELECT standardip FROM admin WHERE server_id=?",
												$loServerID );
			list($standardip) = db_fetch_array( $id );
			db_free_query( $id );
			if( $standardip == $ip ){

			}else{
				safe_query2( "UPDATE ipadressen SET status=0, anbieter='', kunde='' ".
										 " WHERE server_id=? AND ip=?",
										 $loServerID, $loIP );
				
				$fehlertitel = ltext("eiiplo_errortitle");
				$fehlertext = ltext("eiiplo_error1");
			}
		}
	}
}
//
// Update IP list form
//
$loToolsData = new ToolsButtons( new ToolsButtonData( 'menu_head_ip_update', ltext('eiipau_button2'),
                                                      'einstellungen_ip.php',
                                                     array( 'action'=>'reread', 'server_id' => $server_id ) 
                                                     )
                               );
$loToolsData->Legend( ltext( 'eiipau_button2' ) );
$loTools = $loToolsData->GetInputPresentation();
//
// IP list form
//
initPagingSettings( $_POST, array( 'ip_to_search' => $ip_to_search ) );

//Sort settings 
$listFormIndex = 0;

if( !isset( $order ) ){
    $order = 'ip';
}
$lcOrder = '';

$laOrders = array( 'ip'       => 'i.ip_num', 
                   'user'     => 'ku.number', 
                   'reseller' => 'an.number', 
                   'status'   => 'i.status', );

if( array_key_exists( $order, $laOrders ) ){ 
  $lcOrder .= " ORDER BY ".$laOrders[$order]; 
}else{ 
  $lcOrder .= " ORDER BY i.ip_num"; 
}
 
$lcOrder .= $direction == 'desc' ? " DESC" : ""; 

if( isset($ip_to_search) && $ip_to_search ){
	$loWhereOr = new SQLFieldSet ();
	$loWhereOr->addField( 'i.ip', '%'.$ip_to_search.'%', 'C' );
	$loWhereOr->addField( 'i.kunde', '%'.$ip_to_search.'%', 'C' );
	$lcWhereOr = $loWhereOr->getSQLWhere( ' OR ' );
}else{
	 $lcWhereOr = '';
}

$loWhereAnd = new SQLFieldSet ( new SQLField('i.server_id', 'a.server_id', 'U' ) );

$lcWhere = " WHERE ".$loWhereAnd->getSQLWhere( ' AND ' );

if( $lcWhereOr ){
	if( $lcWhere ){
		$lcWhere .= " AND ( $lcWhereOr )";
	}else{
		$lcWhere = " WHERE ".$lcWhereOr;
	}
 }
 
$lcWhere .= " AND i.server_id=".$loServerID->SQL();

$lcSQL = "SELECT count(*) FROM ipadressen i, admin a $lcWhere";

$loQuery = new SQLQuery( $lcSQL );
$loQuery->doQuery();

list($total_number) = $loQuery->fetchArray( 'N' );
$loQuery->freeResult();

$lcSQL = "SELECT i.status,i.ip,i.kunde,i.anbieter,a.confixx_domain, a.standardip ".
         " FROM ipadressen i, admin a ".
         " LEFT JOIN kunden ku ON i.server_id = ku.server_id AND i.kunde = ku.kunde ".
         " LEFT JOIN anbieter an ON i.server_id = an.server_id AND i.anbieter = an.anbieter ".
         $lcWhere.' '.$lcOrder;
         
$loQuery->Query( $lcSQL );

$laContent = array();

$lcDirIcon = $direction == 'desc' ? cc_DescIcon : cc_AscIcon; 
$lcNewDir  = $direction == 'desc' ? 'asc' : 'desc';

$laHeaders = array( 'status'   => array( 'name' => 'eiip_cell_status',   'sort' => 1 ), 
                    'ip'       => array( 'name' => 'eiip_cell_ip',       'sort' => 1 ), 
                    'user'     => array( 'name' => 'eiip_cell_user',     'sort' => 1 ), 
                    'reseller' => array( 'name' => 'eiip_cell_reseller', 'sort' => 1 ) 
                  );

foreach( $laHeaders as $lcKey => $laValue ){ 
  if( $laValue['sort'] ){ 
    if( $order == $lcKey ){ 
      $loContent = new CompoundDataField( new HTMLDataField( ltext( $laValue['name'] ) ), 
                                          new IconDataField( $lcDirIcon ) 
                                        ); 
      $loContent->SetSeparator( '' ); 
    }else{ 
      $loContent = new HTMlDataField( ltext( $laValue['name'] ) ); 
    } 
    $laContent[] = new DataValue( $lcKey, NULL, new LinkDataField( "javascript:setValue('order', '$lcKey',$listFormIndex);". 
                                                                   "setValue('start_index',1,$listFormIndex);". 
                                                                   "submitForm('direction','$lcNewDir',$listFormIndex)", 
                                                                   '', array(), $loContent 
                                                                  ) 
                                 ); 
  }else{ 
    $laContent[] = new ValueLocale( $laValue['name'] ); 
  } 
}

$loTitle = new CompoundValue( $laContent ); 


$loDS = new ConversedDBValue( $loQuery, $page_size, $start_index - 1 );
$loDS->TotalNumber( $total_number );

$loTemplate = new CompoundValue ( new CompoundValue( new ValueFromArray( 'status' ), 
																										 new ValueFromArray( 'ip' ),
																										 new ValueFromArray( 'anbieter'),
																										 new ValueFromArray( 'kunde'),
																										 new ValueFromArray( 'standardip')
																										 ),
																	new ValueFromArray( 'ip' ),
																	new ValueFromArray( 'kunde'),
																	new ValueFromArray( 'anbieter' )
																	);

$laWidths = array( '10%', '15%', '15%', '60%' );

$loDS->Template( $loTemplate );
//
// List functions
//
function &createStatusLink( &$poSrc ) {

	global $order;
	global $direction;
	global $server_id;

	list( $liStatus, $lcIP, $lcAnbieter, $lcUser, $lcStandardIP ) = $poSrc->listValue();
	switch( $liStatus ){
	case 0:
		$lcTitle = ltext('eiip_status_to_on');
		$lcIcon = cc_OffIcon;
		$loLink = new LinkDataField( 'einstellungen_ip.php',
																 '',
																 array( 'action' => 'activate',
																				'ip' => $lcIP,
																				'anbieter' => $lcAnbieter,
																				'server_id' => $server_id,
																				'order' => $order,
																				'direction' => $direction
																				),
																 new IconDataField( $lcIcon )
																 );
		break;
	case 1:
		$lcTitle = ltext('eiip_status_to_off');
		$lcIcon = cc_OnIcon;
		if( $lcUser || ( $lcIP == $lcStandardIP ) ){
			$loLink = new IconDataField( $lcIcon );
			$lcTitle = '';
		}else{
			$loLink = new LinkDataField( 'einstellungen_ip.php',
																	 '',
																	 array( 'action' => 'deactivate',
																					'ip' => $lcIP,
																					'anbieter' => $lcAnbieter,
																					'server_id' => $server_id,
																					'order' => $order,
																					'direction' => $direction
																					),
																	 new IconDataField( $lcIcon )
																 );
		}
		break;
	default:
		$lcTitle = ltext('eiip_status_unknown');
		$lcIcon = cc_UnknownIcon;
		$loLink = new IconDataField( $lcIcon );
		break;
	}
	if( $lcTitle ){
		$loLink->AppendAttributes( array( 'title' => $lcTitle ) );
	}
	$loLink->ParentAttribute( 'align', 'center' );
	return $loLink;

}

$loDS->Conversion( new CompoundValue( new ValueFormated( 'status', NULL, 'createStatusLink' ),
																			NULL,
																			NULL,
																			NULL
																			)
									 );

$loDS->doQuery();

$loPTV = new PagedTableView( $loDS, $total_number );

$loPTV->Title( $loTitle	);
$loPTV->Widths( $laWidths );
$loPTV->setParameter( 'menu_node_id', $menu_node_id );
$loPTV->setParameter( 'cur_page', $cur_page );
$loPTV->setParameter( 'head_text', $head_text );
$loPTV->setParameter( 'order', $order );
$loPTV->setParameter( 'direction', $direction );
$loPTV->setParameter( 'server_id', $server_id );
$loPTV->Anchor( 'list' );
$loPTV->FormIndex( $listFormIndex );

if( ( isset( $ip_to_search ) && $ip_to_search  ) ) {
	$loPTV->NoItemsMessage( ltext( 'll_empty_search' ) );
 }	else {
	$loPTV->NoItemsMessage( ltext( 'll_empty_list' ) );
 }

$tbl = $loPTV->GetOutputPresentation( array( 'action' => 'einstellungen_ip.php#list',
																						 'method' => 'post',
																						 'name' => 'list_ip' ), 
  																			     ltext( 'eiip_title2' ) );

$dsSearch = new CompoundValue();

$dsSearch->addValue( new KeyValue('ip_to_search',$ip_to_search) );
$dsSearch->addValue( new ValueLocale( 'll_search' ) );
$dsSearch->addValue( new ValueLocale( 'll_show_all' ) );

$loSearch = new SimpleSearchElement( array(),
																		 new InputTextElement( array( 'name' => 'ip_to_search', 
																																	'size' => '16',
																																	'value' => $ip_to_search,
																																	'MAXLENGTH'=> '64' )
																													 ) ,
																		 new PPButtonElement( '',
																													"javascript:submitForm('start_index',1,$listFormIndex)",
																													'bid-search'
																													),
																		 new PPButtonElement( '',
																													"javascript:setValue('ip_to_search','',$listFormIndex);".
																													"javascript:submitForm('start_index',1,$listFormIndex)",
																													'bid-show-all'
																													)
																		 );
$loSearch->setDataSource( $dsSearch, array( 'ip_to_search' => $ip_to_search ) );

$tbl->setSearchElement( $loSearch );

$tbl->updateBodyContent();


$page = new MainPageElement( $loTools, $tbl ); 

$page->OutputHTML(array( '../../js/paged_form.js' ));

?>