<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

include_once( 'auth.php' );
include_once( "../languages/$shortlang/scripts.inc.php" );
include_once( '../include/elements/data/class.HTMLDataField.php' );
include_once( '../include/elements/html/class.MainPageElement.php' );
include_once( '../include/elements/data/class.TableView.php' );
include_once( '../include/elements/data/class.TextDataField.php' );
include_once( '../include/elements/data/class.YesNoDataField.php' );

global $DEBUG;
//$DEBUG = 1;

db_master_connect();

if( ! isset( $server_id ) ){
	$server_id = $masterServerID;
 }

$loServerID = new SQLString( $server_id );

$id = safe_query2( "SELECT a.quota,a.ftpmaxkb, a.popmaxkb, a.popmaxkbhard, a.hostname, a.confixx_domain, s.name ".
									 " FROM admin a LEFT JOIN server s ON s.server_id=a.server_id ".
									 " WHERE a.server_id=?",
									 $loServerID );

$laAdmin = db_fetch_array( $id );
$popmaxkb = round( $laAdmin["popmaxkb"] / 1024 );
$popmaxkbhard = round( $laAdmin["popmaxkbhard"] / 1024 );

$data = new SetOfRowsData();

$data->AppendRow( new HTMLDataField( ltext( "eiqu_cell_soft" ) ), 
                  new TextDataField( $popmaxkb, "popmaxkb", true, array( "size"=>"10" ),
                                    array( ) 
                                   ),
                  new HTMLDataField( $lang_format_mb_expr ) 
                 );
                 
$data->AppendRow( new HTMLDataField( ltext( "eiqu_cell_hard" ) ), 
                  new TextDataField( $popmaxkbhard, "popmaxkbhard", true, array( "size"=>"10" ),
                                    array( ) 
                                    ),
                  new HTMLDataField( $lang_format_mb_expr ) );
                  
$data->AppendRow( new HTMLDataField( ltext( "eiqu_cell_text" ), false, array(), 
                                     array("colspan"=>"1")
                                   ),  
                  new YesNoDataField( array( "1"=>"" ), array( "0"=>"" ), 
                                      ( ( $quota4all == 1 ) ? "1" : "0" ), "quota4all"
                                    ),
                  new HTMLDataField( ltext( "g_yes" ) )
                );
                
$data->AppendRow( new HTMLDataField( ltext( "eiqu_cell_text2" ), false, array(), 
                                     array("colspan"=>"1")),  
                  new YesNoDataField( array( "1"=>"" ), array( "0"=>"" ), 
                                     ( ( $quota4all_with_set == 1 ) ? "1" : "0" ), "quota4all_with_set"
                                    ),
                  new HTMLDataField( ltext( "g_yes" ) ) );

$data->AppendButton( ltext( "eiqu_button1" ), "javascript:doChange()", cc_IDOk );

$data->AppendHidden( new TextDataField( $server_id, 'server_id' ) );
if( isset( $ret_path ) ){
	$data->AppendHidden( new TextDataField( $ret_path, 'ret_path' ) );
 }
if( isset( $server ) ){
	$data->AppendHidden( new TextDataField( $server, 'server' ) );
 }

/* -------------------- HTML: page -------------------- */

$page = new MainPageElement( $data->GetInputPresentation( 
                                    array( "action" => "einstellungen_quota2.php", 
                                    "method" => "post"), 
                                    ltext('eiqu_title1') 
                                    ) 
                           );
$page->OutputHTML();

/* -------------------- end HTML: page -------------------- */





?>
