<?
include_once( 'auth.php' );

include_once( '../include/elements/data/class.SetOfRowsData.php' );
include_once( '../include/elements/data/class.HTMLDataField.php' );
include_once( '../include/elements/data/class.TextDataField.php' );
include_once( '../include/elements/data/class.LongTextDataField.php' );

include_once( '../include/elements/html/class.MainPageElement.php' );

global $DEBUG;
//$DEBUG = 1;

db_master_connect();

if( ! isset($server_id)  ){
	$server_id = $masterServerID;
 }

if( isset( $action ) && $action ){
	switch($action){
	case 'save':
		safe_query2( "UPDATE server SET name=?, descr=? WHERE server_id=?",
								 new SQLString( $server_name ), 
								 new SQlString( $server_descr ),
								 new SQlString( $server_id )
								);
	case 'cancel':
		$action = '';
		if( $ret_path ){
			include($ret_path);
			exit;
		}
		break;
	}
 }

if( isset($server_id) && $server_id ){
	$loServerID = new SQLString( $server_id );
	$id = safe_query2( "SELECT a.server_id, s.name, s.descr, s.status, a.hostname FROM admin a ".
										 " LEFT JOIN server s ON a.server_id=s.server_id ".
										 " WHERE a.server_id=?", 
										 $loServerID );
	$liCount = db_num_rows( $id );
	$llInsert = 0;
	if( $liCount == 0 ){
		$fehlertext = ltext('server_id_not_found', array( $server_id ) );

	}else{
		list($lcServerID,$lcName, $lcDescr, $liStatus, $lcHostname ) = db_fetch_array( $id, 'N' );
		if( $liCount > 1 ){
			safe_query2( "DELETE FROM server WHERE server_id=?", $loServerID );
			$llInsert = 1;
		}
		if( is_null($lcName) ){
			$lcName = '';
			$lcDescr = '';
			$liStatus = 1;
			$llInsert = 1;
		}
		if( $llInsert){
			safe_query2( "INSERT INTO server (server_id,name,descr,status) VALUES (?,?,?,$llInsert)",
									 $loServerID, new SQLString($lcName), new SQLString($lcDescr) );
		}
	};
	db_free_query( $id );
 }else{
	$fehlertext = ltext( 'server_id_not_set' );
 }

$loData = new SetOfRowsData();
$loData->AppendRow( new HTMLDataField( ltext('sena_cell_name' ) ),
										new TextDataField( $lcName, 'server_name' )
										); 

$loData->AppendRow( new HTMLDataField( ltext('sena_cell_descr' ) ),
										new LongTextDataField( $lcDescr, 'server_descr' )
										); 

$loData->AppendButton( ltext('sl_save', "javascripts:doChange()", cc_IDOk) );
$loData->AppendHidden( new TextDataField( 'save', 'action' ) );
$loData->AppendHidden( new TextDataField( $server_id, 'server_id' ) );
$loData->AppendHidden( new TextDataField( $ret_path, 'ret_path' ) );
$loData->AppendHidden( new TextDataField( $server, 'server' ) );

$loForm = $loData->GetInputPresentation( array( 'action' => 'server_edit_descr.php',
																								'method' => 'post'
																								),
																				 ltext( 'sena_title1',array($lcName,$lcHostname) )
																				 );

	

$page = new MainPageElement( $loForm );

$page->OutputHTML();

db_close();

?>