<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

include_once( 'include/db/class.DBConnect.php' );
include_once( 'include/module.Database.php' );

$sMaxLifeLime = 1800;
$gcExpiredSessionID = '';

global $DEBUG;
//$DEBUG=1;

if( ! defined( 'SESSIONS_INC' ) ){

  define('USERTYPE_ADMIN', 1);
  define('USERTYPE_RESELLER', 2);
  define('USERTYPE_USER', 3);
  define('USERTYPE_POPUSER', 4);
  define('USERTYPE_FTPUSER', 5);
  define('USERTYPE_MASTER', 10);
	define('USERTYPE_REG', 11);

	define( 'SERVER_ID', "'$ServerID'");
	
  function sessao_start(){/*{{{*/

		global $gcExpiredSessionID;

		session_name('SID');
     
		if( isset( $_GET['SID'] ) && $_GET['SID'] ){
			session_id( $_GET['SID'] );
		}

		session_log( "sessao_start: ".session_id() );

		session_start();

		if( ! session_is_registered( '_error' ) ){
			session_register( '_error' );
			$_SESSION['_error'] = false;
			session_register( '_error_args' );
			$_SESSION['_error_args'] = false;
		}
		if( ! session_is_registered( '_expired' ) ){
			session_register( '_expired' );
			$_SESSION['_expired'] = false;
		}

		if( ! session_is_registered( '_login_url' ) ){
			session_register( '_login_url' );
			$_SESSION['_login_url'] = null;
		}

		//		session_log( "sessao_start: $gcExpiredSessionID" );

		if( $gcExpiredSessionID ){
			$_SESSION['_expired'] = $gcExpiredSessionID;
			setcookie( '_expired', $gcExpiredSessionID, time() + 60*60*24*7 );
		}else{
			if( array_key_exists( '_expired', $_COOKIE ) 
          && $_COOKIE['_expired'] == $gcExpiredSessionID )
      {
				$_SESSION['_expired'] = $gcExpiredSessionID;
			}
		}

  }/*}}}*/

  function sessao_open($aSavaPath, $aSessionName){/*{{{*/
	//global $aTime;
		session_log( "sessao_open: $aSavaPath, $aSessionName" );
		sessao_gc( $GLOBALS['sMaxLifeLime'] );
		return True;
  }/*}}}*/

  function sessao_close(){/*{{{*/
		session_log( "sessao_close" );
		return True;
  }/*}}}*/

  function sessao_read( $sKey ){/*{{{*/
		global $db_type;
		global $master_confixx,$ServerID,$masterServerID;
		global $gcExpiredSessionID;
  
    $sql = array();
    
		getConfixxDbConnect();

		sessao_lock( 'sessao_read' );

		$lcServerID = $master_confixx == 2 ? $masterServerID : $ServerID;
		$data = '';
    $sql['skey'] = db_full_quote( $sKey );

		$query = "SELECT sdata, server_id FROM sessions WHERE id=".$sql['skey'];

		session_log( "sessao_read: $query" );
		$id = db_query( $query );
		$liCnt = db_num_rows( $id );

		if( $liCnt == 1){
#
# one session is found
#
			list( $data, $lcServerID ) = db_fetch_array( $id, 'N' );

		}elseif( $liCnt >  1 ){
#
# n sessions are found
#
			$llNotFound = TRUE;
			while( list( $lcData, $lcSID ) = db_fetch_array( $id, 'N' ) ){
				if( $lcSID == $lcServerID ){
					$llNotFound = FALSE;
					$data = $lcData;
					break;
				}
			}
			if( $llNotFound ){
#
# can't define the session
#
				db_query( "DELETE FROM sessions WHERE id=".$sql['skey'] );
				$liCnt = 0;
			}
		}

		db_free_query( $id );

		if( $liCnt == 0 ){
#
# create new session
#
			$ip = $_SERVER['REMOTE_ADDR'];
			$t = time();
			$users = '';
			if( isset( $_SESSION ) &&
					array_key_exists( '_server_id', $_SESSION ) &&
					$_SESSION['_server_id'] ){
				$lcServerID = $_SESSION['_server_id'];
			}

			if( isset( $_SESSION ) ){

				if(	array_key_exists( '_users', $_SESSION ) && 
						is_array( $_SESSION['_users'] )&&
						array_key_exists( $lcServerID, $_SESSION['_users'] ) && 
						is_array( $_SESSION['_users'][$lcServerID] )
						) {
					$users = implode(',', array_keys($_SESSION['_users'][$lcServerID]));
				}
			}

			if( $db_type == 'mysql' ){    
				$query = "INSERT INTO sessions (id, startdate, lastupdate, sdata, user, ip,server_id) ";
			}else{
				$query = "INSERT INTO sessions (id, startdate, lastupdate, sdata, \"user\", ip,server_id) ";
			}
			$query .= "VALUES (".$sql['skey'].",'$t','$t','','$users ','$ip','$lcServerID')";

			session_log( "sessao_read: $query" );

			db_query($query);
			$data = '';
		}

		sessao_unlock('sessao_read');

		return $data;
  }/*}}}*/

  function sessao_write( $sKey, $sVal ){/*{{{*/
		global $db_type;
		global $master_confixx,$ServerID,$masterServerID;

		getConfixxDbConnect();

    $sql = array();
    $sql['skey'] = db_full_quote( $sKey );
    
  	/*Begin Fixed bug in PHP 4.3.3/Suse 9.0, 4.3.4/Suse 9.1 */
    if( ( version_compare( PHP_VERSION, "4.3.3" ) == 0 
          || version_compare( PHP_VERSION, "4.3.4" ) == 0 )
      && ! ini_get( 'suhosin.session.encrypt' ) )
    {
  	  $lcVal_tmp = '';
  		foreach ($_SESSION as $key => $value) { 
	  		$lcVal_tmp.= $key.'|'.serialize($value); 
		  }
	  	$sVal = $lcVal_tmp;
    }
		/*End  Fixed bug in PHP 4.3.3 / Suse 9.0 */
		$sVal = addslashes( $sVal );
		$users = '';
		if( array_key_exists( '_server_id', $_SESSION ) &&
				$_SESSION['_server_id'] ){
			$lcServerID = $_SESSION['_server_id'];
		}else{
			$lcServerID = $master_confixx == 2? $masterServerID: $ServerID;
		}
		if( array_key_exists('_users',$_SESSION) && 
				is_array( $_SESSION['_users'] )&&
				array_key_exists( $lcServerID, $_SESSION['_users']) && 
				is_array( $_SESSION['_users'][$lcServerID] )
				) {
			$users = implode(',', array_keys($_SESSION['_users'][$lcServerID]));
		}

		sessao_lock('sessao_write');

		$query = "UPDATE sessions SET sdata = '$sVal', lastupdate = " . time();
		$query .= ",server_id='$lcServerID'";
    
		if($db_type=='mysql'){    
			$query .= ",user = '$users' WHERE id = ".$sql['skey'];
		}else{
			$query .=  ",\"user\" = '$users' WHERE id = ".$sql['skey'];
		}

		session_log("sessao_write: $query");
		db_query($query);

		sessao_unlock('sessao_write');

		return TRUE;
  }/*}}}*/

  function sessao_destroy( $sKey ){/*{{{*/

		getConfixxDbConnect();
    
    $sql = array();
    $sql['skey'] = db_full_quote( $sKey );

		sessao_lock('sessao_destroy');

		$query = "DELETE FROM sessions WHERE id = ".$sql['skey'];
		session_log("sessao_destroy: $query");
		db_query($query);

		sessao_unlock('sessao_destroy');

		return True;
  }/*}}}*/

  function sessao_gc( $sMaxLifeTime ){/*{{{*/
		global $master_confixx,$ServerID;
		global $gcExpiredSessionID;
		
    getConfixxDbConnect();
    
 
		$liTime = time();
		$lcWhere = " $liTime - lastupdate > $sMaxLifeTime";
		if( $master_confixx != 2 ){
			$lcWhere .= " AND server_id='$ServerID'";
		}
		$lcSessionID = session_id();
    
    $sql = array();
    $sql['skey'] = db_full_quote( $lcSessionID );

		sessao_lock('sessao_gc');

		$query = " SELECT COUNT(id) FROM sessions WHERE $lcWhere ".
      			 " AND id=".$sql['skey'];
             
		session_log( "sessao_gc: $query" );
		$id = db_query( $query );
    
		list( $liCnt ) = db_fetch_array( $id, 'N' );
		db_free_query( $id );
    
		if( $liCnt ){
			$gcExpiredSessionID = $lcSessionID;
		}else{
			$gcExpiredSessionID = '';
		}
		session_log( "sessao_gc: $gcExpiredSessionID" );

		$query = "DELETE FROM sessions WHERE $lcWhere ";

		session_log("sessao_gc: $query");
		db_query($query);

		sessao_unlock('sessao_gc');

		return True;
  }/*}}}*/

	//  session handlers
	//
	//========================================================
	//
	//

  function session_log($data){/*{{{*/
		return; //no log
		$fname = ini_get('upload_tmp_dir')	. '/session_log';
		$data = $_SERVER['PHP_SELF'] . "# $data\n\n";
		if( $fp = fopen( $fname, 'a' ) ){
			fwrite( $fp, $data );
			fclose( $fp );
		}
  }/*}}}*/

	function sessao_lock($prefix=''){/*{{{*/
		global $db_type;

		if( $db_type == 'mysql' ){
			$query = "LOCK TABLES sessions WRITE";
		}else{
			$query = "LOCK TABLES sessions IN SHARE MODE";
		}
		session_log("sessao_lock: $prefix: $query");

		db_query( $query, FALSE );
	}/*}}}*/

	function sessao_unlock($prefix=''){/*{{{*/
		global $db_type;

		if( $db_type == 'mysql' ){
			$query = "UNLOCK TABLES";
		}else{
			$query = "COMMIT WORK";
		}
		session_log("sessao_unlock: $prefix: $query");
		db_query( $query, FALSE );
	}/*}}}*/

  function addSUser($user, $pass, $type, $pcComeFrom = '' ){/*{{{*/
		global $ServerID;

		if( ! session_is_registered( '_users' ) ){
			session_register( '_users' );
		}
		if( ! session_is_registered( '_server_id' ) ){
			session_register( '_server_id' );
		}

		$_SESSION['_server_id'] = $ServerID;

		if( ! is_array( $_SESSION['_users'] ) ){
			$_SESSION['_users'] = array();
		}
		if( ! array_key_exists( $ServerID, $_SESSION['_users'] ) ){
			$_SESSION['_users'][$ServerID] = array();
		}

		if( $pcComeFrom ){
			$_SESSION['_users'][$ServerID][$user] = array( 'password' => $pass,
																										 'type' => $type,
																										 'comefrom' => $pcComeFrom
																										 ); 
		} else {
			$_SESSION['_users'][$ServerID][$user] = array( 'password' => $pass,
																										 'type' => $type
																										 ); 
		}
  }/*}}}*/

  function isSUserLogged( $user, $server_id=NULL ){/*{{{*/
		global $ServerID;

		if( ! ( is_string( $user ) && $user ) ){
			return FALSE;
		}

		if( ! is_string( $server_id ) ){
			if( array_key_exists( '_server_id', $_SESSION ) ){
				$server_id = $_SESSION['_server_id'];
			}else{
				$server_id = $ServerID;
			}
		}

		if( is_array( $_SESSION['_users'] ) ){
			if( array_key_exists( $server_id, $_SESSION['_users'] ) ){
				if( array_key_exists( $user, $_SESSION['_users'][$server_id] ) ){
					return getUserParam( $user, 'type', $server_id );
				}
			}
		}
		return false;
  }/*}}}*/

  function deleteSUser( $user, $server_id=NULL ){/*{{{*/
		global $ServerID;
		if( ! is_string( $server_id ) ){
			if( array_key_exists( '_server_id', $_SESSION ) ){
				$server_id = $_SESSION['_server_id'];
			}else{
				$server_id = $ServerID;
			}
		}
		$llNotFound = 1;
		if( isset($_SESSION['_users'] ) && is_array($_SESSION['_users']) &&
				array_key_exists( $server_id, $_SESSION['_users'] ) ){
			if( array_key_exists( $user, $_SESSION['_users'][$server_id] ) ){
				unset($_SESSION['_users'][$server_id][$user]);
				$llNotFound = 0;
			}
		}

		if( isset($_SESSION['_del_settings'] ) ){
			unset( $_SESSION['_del_settings'][$server_id][$user] );
		}
  }/*}}}*/

  function setUserParam($user, $param, $value, $server_id=NULL){/*{{{*/
		global $ServerID;
		if( ! is_string( $server_id ) ){
			if( array_key_exists( '_server_id', $_SESSION ) ){
				$server_id = $_SESSION['_server_id'];
			}else{
				$server_id = $ServerID;
			}
		}

		if( array_key_exists('_users', $_SESSION) ){
			if( array_key_exists( $server_id, $_SESSION['_users'] ) ){
				if( array_key_exists( $user, $_SESSION['_users'][$server_id] ) ){
					$_SESSION['_users'][$server_id][$user][$param] = $value;
				}
			}
		}
  }/*}}}*/

  function getUserParam($user, $param, $server_id=NULL){/*{{{*/
		global $ServerID;
		if( ! is_string( $server_id ) ){
			if( array_key_exists( '_server_id', $_SESSION ) ){
				$server_id = $_SESSION['_server_id'];
			}else{
				$server_id = $ServerID;
			}
		}

		if(isUserParamExists( $user, $param, $server_id )){
			return $_SESSION['_users'][$server_id][$user][$param];
		}
		return false;
  }/*}}}*/

  function delUserParam($user, $param, $server_id=NULL){/*{{{*/
		global $ServerID;
		if( ! is_string( $server_id ) ){
			if( array_key_exists( '_server_id', $_SESSION ) ){
				$server_id = $_SESSION['_server_id'];
			}else{
				$server_id = $ServerID;
			}
		}

		if( isUserParamExists( $user, $param, $server_id ) ){
			unset($_SESSION['_users'][$server_id][$user][$param]);	
		}	
  }/*}}}*/

  function isUserParamExists($user, $param, $server_id=NULL){/*{{{*/
		global $ServerID;
		if( ! is_string( $server_id ) ){
			if( array_key_exists( '_server_id', $_SESSION ) ){
				$server_id = $_SESSION['_server_id'];
			}else{
				$server_id = $ServerID;
			}
		}

		return array_key_exists( '_users', $_SESSION) && 
			array_key_exists( $server_id, $_SESSION['_users']) &&
			array_key_exists( $user, $_SESSION['_users'][$server_id]) &&
			array_key_exists( $param, $_SESSION['_users'][$server_id][$user]);
  }/*}}}*/

	function fixGlobals( &$laAccountInfo, $piType = NULL ){/*{{{*/

		global $ServerID, $user_prefix, $hostname, $master_confixx;
		global $masterServerID;

		$llRet = FALSE;

		if( is_array($laAccountInfo) ){
			if( array_key_exists( 'server_id', $laAccountInfo ) &&
					$laAccountInfo['server_id'] ){

				$lcServerID = $laAccountInfo['server_id'];
				$piType = $laAccountInfo['type'];

			}else{
				return FALSE;
			}
		}else{
			$lcServerID = $laAccountInfo;
		}
	
		if( $lcServerID == $ServerID ||
				$lcServerID == $masterServerID ){
			return TRUE;
		}
	
#
# external server
#
		getMasterDbConnect();

		$loServerID = new SQlString( $lcServerID );

		$id = safe_query2( "SELECT userprefix,hostname FROM admin WHERE server_id=?",
											 $loServerID );
		if( db_num_rows( $id ) ){
			list($user_prefix, $hostname ) = db_fetch_array( $id, 'N' );
			//			if( $master_confixx==2 && $piType != USERTYPE_MASTER ){
			//				$master_confixx = 1;
			//			}
			$ServerID = $lcServerID;
			$llRet = TRUE;
		}
		db_free_query( $id );

		return $llRet;
	}/*}}}*/
 
/**
   * Checks ownership of object
   *
   * @param  string $pcObject
   * @return bool
   *
   */
 function checkOwnership($pcObject, $pcServerID = NULL ){/*{{{*/
    global $ServerID;
    global $user_prefix;
    
    if( empty( $pcServerID ) ){
    	$pcServerID = $ServerID;
    }
    
    $liUserType = 5; 
    $lcUserName = ''; 
    
    foreach ($_SESSION['_users'][$pcServerID] as $lcName => $laOptions) {
      if( $laOptions['type'] < $liUserType ){
        $liUserType = $laOptions['type']; 
        $lcUserName = $lcName; 
      }
    }
    
    if( empty( $lcUserName ) ){
    	return false;
    }
  
    if( $liUserType == USERTYPE_MASTER ){
      return true;
    }
    
    if( $lcUserName == $pcObject ){
      return true;
    }
    
    // If $pcObject is reseller
    if( preg_match( '~^res(\d+)$~i', $pcObject ) ){
      if( $liUserType == USERTYPE_ADMIN ){
        $lcSQL = "SELECT * FROM anbieter WHERE anbieter = '".addslashes($pcObject)
                 ."' AND server_id ='".addslashes($pcServerID)."'";
        $id = db_query($lcSQL);
    		if (db_num_rows($id) == 1) {
					db_free_query( $id );
          return true;
    		}
				db_free_query( $id );

      } 
    
    // If $pcObject is user
    } elseif (preg_match('~^'.$user_prefix.'(\d+)$~i', $pcObject)) {
      if ($liUserType == USERTYPE_ADMIN) {
        $lcSQL = "SELECT * FROM kunden WHERE kunde = '".addslashes($pcObject)
                 ."' AND server_id ='".addslashes($pcServerID)."'";
        $id    = db_query($lcSQL);
    		if (db_num_rows($id) == 1) {
					db_free_query( $id );
          return true;
    		}
				db_free_query( $id );

      } elseif ($liUserType == USERTYPE_RESELLER) {
        $lcSQL = "SELECT * FROM kunden WHERE anbieter = '".addslashes($lcUserName)
                 ."' AND kunde = '".addslashes($pcObject)."' AND server_id ='".addslashes($pcServerID)."'";
        $id = db_query($lcSQL);
    		if (db_num_rows($id) == 1) {
					db_free_query( $id );
          return true;
    		}
				db_free_query( $id );
      }
      
    // If $pcObject is mail user
    } elseif (preg_match('~^'.$user_prefix.'(\d+)p(\d+)$~i', $pcObject)) {
        if ($liUserType == USERTYPE_ADMIN) {
          $lcSQL = "SELECT * FROM pop3 WHERE account = '".addslashes($pcObject)
                    ."' AND server_id ='".addslashes($pcServerID)."'";
          $id    = db_query($lcSQL);
    		  if (db_num_rows($id) == 1) {
						db_free_query( $id );
            return true;
    		  }
					db_free_query( $id );
										
        } elseif ($liUserType == USERTYPE_RESELLER) {
          $lcSQL = "SELECT * FROM pop3 WHERE anbieter = '".addslashes($lcUserName)
                 ."' AND account = '".addslashes($pcObject)."' AND server_id ='".addslashes($pcServerID)."'";
                 
          $id    = db_query($lcSQL);
    		  if (db_num_rows($id) == 1) {
						db_free_query( $id );
            return true;
    		  }
					db_free_query( $id );

      } elseif ($liUserType == USERTYPE_USER) {
        $lcSQL = "SELECT * FROM pop3 WHERE kunde = '".addslashes($lcUserName)
                 ."' AND account = '".addslashes($pcObject)."' AND server_id ='".addslashes($pcServerID)."'";
                 
        $id = db_query($lcSQL);
    		if (db_num_rows($id) == 1) {
					db_free_query( $id );
          return true;
    		}
				db_free_query( $id );

      }
    
    // If $pcObject is ftp user
    } elseif (preg_match('~^'.$user_prefix.'(\d+)f(\d+)$~i', $pcObject)) {
        if ($liUserType == USERTYPE_ADMIN) {
          $lcSQL = "SELECT * FROM ftp WHERE account = '".addslashes($pcObject)
                   ."' AND server_id ='".addslashes($pcServerID)."'";
          $id  = db_query($lcSQL);
    		  if (db_num_rows($id) == 1) {
						db_free_query( $id );
            return true;
    		  }
					db_free_query( $id );

        } elseif ($liUserType == USERTYPE_RESELLER) {
          $lcSQL = "SELECT * FROM ftp WHERE anbieter = '".addslashes($lcUserName)
                 ."' AND account = '".addslashes($pcObject)."' AND server_id ='".addslashes($pcServerID)."'";
                 
          $id    = db_query($lcSQL);
    		  if (db_num_rows($id) == 1) {
            return true;
    		  }
        } elseif ($liUserType == USERTYPE_USER) {
            $lcSQL = "SELECT * FROM ftp WHERE kunde = '".addslashes($lcUserName)
                   ."' AND account = '".addslashes($pcObject)."' AND server_id ='".addslashes($pcServerID)."'";
                   
            $id = db_query($lcSQL);
      		  if (db_num_rows($id) == 1) {
							db_free_query( $id );
              return true;
      		  }
						db_free_query( $id );

        }
    }
    
    return false;
  }/*}}}*/
  
  session_set_save_handler( 'sessao_open', 
														'sessao_close',
														'sessao_read',
														'sessao_write',
														'sessao_destroy',
														'sessao_gc'
														);

  define('SESSIONS_INC', 1);
}


?>
