<?php
########## Confixx(R) 3.2 Professional ############
######## Copyright SWsoft, Inc. 2004-2006 #########
###### http://www.swsoft.com - info@swsoft.com ####
 
include_once( 'auth.php' );
include_once( 'defines.php' );
include_once( '../include/data_source/class.SQLQuery.php' );
include_once( '../include/class.SQLFieldSet.php' );
include_once( '../include/elements/data/class.SetOfRowsData.php' );
include_once( '../include/elements/data/class.HTMLDataField.php' );
include_once( '../include/elements/data/class.YesNoDataField.php' );
include_once( '../include/elements/data/class.CompoundDataField.php' );
include_once( '../include/elements/html/class.MainPageElement.php' );
include_once( '../include/elements/html/module.Constants.php' );
include_once( '../include/event_functions.php' );
include_once( '../include/module.webapp.php' );

global $DEBUG;
//$DEBUG=1;

if( $DEBUG ){
	echo "webapp_delete.php: _POST<br><pre>\n";
	var_dump( $_POST );
	echo "</pre><hr>\n";
}

db_connect();

$loUser = new SQLString( $PHP_AUTH_USER );

if( ! isset( $webapp_ids ) ){
  $webapp_ids = array(); 
}  

if( isset( $webapp_id ) && ! istleer( $webapp_id ) ){
  $webapp_ids[] = $webapp_id;
}

/**
 * Perform action
 */
if( isset( $action ) && $action == 'delete' ){

  if( ! isset( $delete_ids ) ){
    $delete_ids = array();
  } 

  foreach( $delete_ids as $webapp_id => $delete ){
    if( $delete == 'yes' && is_numeric( $webapp_id ) ){
      $lrId = safe_query2( " SELECT status FROM webapp_user WHERE server_id = '$ServerID'".
                           " AND kunde=? AND webapp_id=? ", $loUser, new SQLString( $webapp_id ) );
      list( $liCurrentStatus ) = db_fetch_array( $lrId, 'N');
      db_free_query( $lrId );

      if( ( $clean_files[$webapp_id] == 'yes' || $clean_db[$webapp_id] == 'yes' ) 
          && $liCurrentStatus !=1 ){
        $lcSql = "UPDATE webapp_user SET status=3";
        $lcSql .= ", clean_files=".(( $clean_files[$webapp_id] == 'yes')? 1: 0);
        $lcSql .= ", clean_db=".(( $clean_db[$webapp_id] == 'yes' )? 1: 0);
        $lcSql .= " WHERE server_id='$ServerID' ".
                  " AND webapp_id=? AND kunde=?";

        safe_query2( $lcSql, new SQLInteger( $webapp_id ), $loUser );

        eventAdd( $OBJECT_WEBAPP, $EVENT_DELETE );

        safe_query2( "UPDATE kunden SET httpd=1 WHERE kunde=? AND server_id='$ServerID'", 
                     $loUser );
        safe_query2( "UPDATE allgemein SET httpd=1 WHERE server_id='$ServerID'" );

      }else{
        safe_query2( " DELETE FROM webapp_user WHERE server_id='$ServerID' ".
                     " AND webapp_id=? AND kunde=?", 
                     new SQLInteger( $webapp_id), $loUser );
      }
    }
  }
	include( 'webapp.php' );
	exit();
 }

$id = db_query( "SELECT webapp FROM admin WHERE server_id='$ServerID'");
list( $skwebapp ) = db_fetch_array( $id );
db_free_query( $id );

$id = safe_query2( " SELECT maxwebapp, anbieter FROM kunden ".
									 " WHERE kunde=? AND server_id='$ServerID'",
									 $loUser );
list( $maxwebapp, $anbieter ) = db_fetch_array( $id, 'N' );
db_free_query( $id );

if( $skwebapp == 0 || $maxwebapp == 0 ){
	db_close();
	include( 'feature_unavailable.php' );
	exit;
}

/**
 * Output list of applications for deinstall
 */
$data = new SetOfRowsData();
 
foreach( $webapp_ids as $webapp_id ){
  $loWebappId = new SQLInteger( $webapp_id );

  $id = safe_query2( "SELECT name,descr,version FROM webapp ".
                     " WHERE server_id='$ServerID' AND id=?",
                     $loWebappId );
   
  if( ! db_num_rows( $id ) ){
    $fehlertext = ltext( 'wa_id_not_found' ); 
    db_close();
    include( 'webapp_conf.php' );
    exit;
  }

  list( $waName, $waDescr, $waVersion ) = db_fetch_array( $id, 'N' );
  db_free_query( $id );

  $id = safe_query2( "SELECT db, path FROM webapp_user WHERE webapp_id=? AND kunde=? AND server_id='$ServerID'",
    $loWebappId, $loUser );
   
  if( ! db_num_rows( $id ) ){
    $fehlertext = ltext( 'wa_id_not_found' ); 
    db_clode();
    include( 'webapp_conf.php' );
    exit;
   }
  list( $waDb, $waPath ) = db_fetch_array( $id, 'N' );
  db_free_query( $id );

  $data->AppendRow( new HTMLDataField( ltext( 'wa_del_descr', $waName ) ),
                    new YesNoDataField( array( 'yes' => ltext( 'g_yes' ) ), 
                                        array( 'no' => ltext( 'g_no' ) ),
                                        'yes', 
                                        "delete_ids[$webapp_id]",
                                        cc_RadioGroupPresentation )
                    );

  if( $waPath ){
    $data->AppendRow( new HTMLDataField( ltext( 'wa_del_path', $waPath ) ),
                      new YesNoDataField( array( 'yes' => ltext( 'g_yes' ) ), 
                                          array( 'no' => ltext( 'g_no' ) ),
                                          'yes', 
                                          "clean_files[$webapp_id]",
                                          cc_RadioGroupPresentation )
                      );
   }

  if( $waDb ){
    $data->AppendRow( new HTMLDataField( ltext( 'wa_del_db', $waDb ) ),
                      new YesNoDataField( array( 'yes' => ltext( 'g_yes' ) ), 
                                          array( 'no' => ltext( 'g_no' ) ),
                                          'yes', 
                                          "clean_db[$webapp_id]",
                                          cc_RadioGroupPresentation )
                      );

   }

  $data->AppendRow( new HTMLDataField( '&nbsp' ) );

}

$data->AppendButton( ltext( 'll_apply' ),
                       "javascript: doChange()",
                       cc_IDOk );

$data->AppendHidden( new TextDataField( 'delete', 'action' ) );

$page = new MainPageElement();
$page->AppendToContent( $data->GetInputPresentation( array( 'method'=>'post',
																														'action'=>'webapp_delete.php' ),
																										 ltext( 'wa_del_title' ) ) );

$page->OutputHTML();

?>
