package Modules::Apache::Config::Parser::Lines;

########## Confixx(R) 3.1 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.swsoft.com - info@swsoft.com ####





use strict;





# -------------------- Constructor -------------------- #
sub new{
    my ($proto) = @_;
    my ( $class, $self );
    $class = ref($proto) || $proto;
    $self = { 'LINES' => [],
							'isConfixx' => []
						};
    bless ($self, $class);
    return $self;
}
# -------------------- end Constructor -------------------- #





# -------------------- add -------------------- #
sub add{
    my ( $self, $line, $confixx ) = @_;
    push ( @{$self->{'LINES'}}, $line );
    push ( @{$self->{'isConfixx'}}, $confixx );
}
# -------------------- end add -------------------- #





# -------------------- output -------------------- #
sub output{
	my ( $self, $file ) = @_;
	my $i = -1;

	my $reInc = qr/^\s*Include\s+"?(?:\Q$::mhost_conf\E|\Q$::vhost_conf\E)"?\s*$/;

	foreach ( @{$self->{'LINES'}} ) {
		$i++;
		next if ( $self->{'isConfixx'}->[$i] ); ## skip the confixx part
		next if ( /$reInc/i );

		$file->print( $_ );

	}
}
# -------------------- end output -------------------- #





# -------------------- exclude -------------------- #
sub exclude{
    return undef;
}
# -------------------- end exclude -------------------- #





# -------------------- excludeInternal -------------------- #
sub excludeInternal{
	my ( $self ) = @_;

	foreach ( @{$self->{'LINES'}} ) {
		return 1 if ( /^\s*DocumentRoot\s+"?$::confixx_htmlDir"?\s*$/i );
		return 1 if ( /^\s*Include\s+"?$::mhost_conf"?\s*$/i );
		return 1 if ( /^\s*Include\s+"?$::vhost_conf"?\s*$/i );
	}
	return undef;
}
# -------------------- end excludeInternal -------------------- #





# -------------------- isConfixxDir -------------------- #
sub isConfixxDir{
	my ( $self ) = @_;
	foreach ( @{$self->{'LINES'}} ) {
		return 1 if ( /^\s*DocumentRoot\s+"?$::confixx_htmlDir"?\s*$/i );
	}
	return undef;
}
# -------------------- end isConfixxDir -------------------- #





# -------------------- getFirstParameter -------------------- #
sub getFirstParameter{
	my ( $self, $option ) = @_;
	foreach ( @{$self->{'LINES'}} ) {
		return $1 if ( /^\s*$option\s+(\S+)/i );
	}
	return undef;
}
# -------------------- end getFirstParameter -------------------- #




1;
