package Modules::Apache::Config::Parser::Section;

########## Confixx(R) 3.1 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.swsoft.com - info@swsoft.com ####

use Modules::Apache::Config::Parser::Lines;

use strict;


# -------------------- new -------------------- #
sub new{
    my ( $proto, $start, $isConfixx ) = @_;
    my ( $class, $self );
    $class = ref($proto) || $proto;
    $self = {};
		$self->{'isConfixx'} = $isConfixx;
    $self->{START} = $start;
    $self->{PARTS} = [];
    $self->{END} = "";
    bless ($self, $class);
    return $self;
}
# -------------------- end new -------------------- #





# -------------------- add -------------------- #
sub add{
    my ( $self, $object ) = @_;
    push ( @{$self->{PARTS}}, $object );
}
# -------------------- end add -------------------- #





# -------------------- output -------------------- #
sub output{
    my ( $self, $file ) = @_;

		return if  $self->{'isConfixx'};

    $file->print ( $self->{START} );
    map { $_->output($file); } @{$self->{PARTS}};
    $file->print ( $self->{END} );
}
# -------------------- end output -------------------- #





# -------------------- endMatch -------------------- #
sub endMatch{
    my ( $self, $end ) = @_;
    my ( $start );
    $self->{START} =~ /^\s*<(\S+).*>/;
    $start = $1;
    return $end =~ /^\s*<\/$start>\s*/i;
}
# -------------------- end endMatch -------------------- #





# -------------------- setEnd -------------------- #
sub setEnd{
    my ( $self, $end ) = @_;
    $self->{END} = $end;
}
# -------------------- end setEnd -------------------- #





# -------------------- startingTag -------------------- #
# "static" function
sub startingTag{
    my ( $tag ) = @_;
    return $tag =~ /^\s*<\S+.*>/;
}
# -------------------- end startingTag -------------------- #





# -------------------- exclude -------------------- #
sub exclude{
    my ( $self, $ip, $port ) = @_;

		return 1 if $self->{'isConfixx'};

    return 1 if ( $self->{START} =~ /\s*<Directory\s+"?\Q$::confixx_htmlDir\E"?>\s*/i );

		my ( $reVH,$portList,@ports );
		if ( $port ) {
			if ( ref($port)=~/ARRAY/ ) {
				@ports = grep { $_ } map { $_ eq '*'? '\*': $_ } @{$port};
				if ( @ports ) {
					$portList = join( '|', @ports );
					$portList = '(?:'.$portList.')';
					$reVH = qr/^\s*<VirtualHost\s+\Q$ip\E:$portList>\s*$/;
				} else {
					$reVH = qr/^\s*<VirtualHost\s+\Q$ip\E.*>\s*$/;
				}
			} else {
				$reVH = qr/^\s*<VirtualHost\s+\Q$ip\E:\Q$port\E>\s*$/;
			}
		} else {
			if ( $ip ) {
				$reVH = qr/^\s*<VirtualHost\s+\Q$ip\E.*>\s*$/;
			} else {
				$reVH = qr/^\s*<VirtualHost\s+.*>\s*$/;
			}
		}
    if ( $self->{START} =~ /$reVH/i ) {
			foreach my $object ( grep{ $_->isa('Modules::Apache::Config::Parser::Lines') }
													 @{$self->{PARTS}} ) {
				if ( $object->excludeInternal() ) {
					return 1;
				}
			}
    }
    return undef;
}
# -------------------- end exclude -------------------- #





# -------------------- isConfixxHost -------------------- #
sub isConfixxHost{
    my ( $self ) = @_;
    return undef if ( $self->{START} !~ /^\s*<VirtualHost\s+\S+:\d+>\s*$/i );
    foreach my $object ( grep { $_->isa('Modules::Apache::Config::Parser::Lines') }
												 @{$self->{PARTS}} 
											 ) {
			if ( $object->isConfixxDir() ) {
				 return 1;
			}
    }
    return undef;
}
# -------------------- end isConfixxHost -------------------- #





# -------------------- _getFirstParameter -------------------- #
sub _getFirstParameter{
    my ( $self, $option ) = @_;
		my ( $value );
    foreach my $object (
												grep { $_->isa('Modules::Apache::Config::Parser::Lines') }
												@{$self->{PARTS}}
											 ) {
			if ( $value = $object->getFirstParameter( $option ) ) {
				return $value;
			}
    }
    return undef;
}
# -------------------- end _getFirstParameter -------------------- #





# -------------------- getConfixxParameters -------------------- #
sub getConfixxParameters{
    my ( $self ) = @_;
    my ( $ip, $domain, $accessLog, $errorLog, $port );
    $self->{START} =~ /^\s*<VirtualHost\s+(\S+):(\d+)>\s*$/;
    $ip = $1;
    $port = $2;
    $domain = $self->_getFirstParameter ("ServerName");
    $accessLog = $self->_getFirstParameter ("CustomLog");
    $errorLog = $self->_getFirstParameter ("ErrorLog");
    return ( $ip, $domain, $accessLog, $errorLog, $port );
}
# -------------------- end getConfixxParameters -------------------- #





1;
