# The module contains miscelaneous application-wide functions 
# and provides correct script initiation

########## Confixx(R) 3.1 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.swsoft.com - info@swsoft.com ####


package Modules::Confixx;

BEGIN {
    use Exporter ();
    @ISA = qw(Exporter);
    @EXPORT_OK = qw(&ltext);
}

use Modules::Conf;
&Modules::Conf::loadConfFile;

use DBI;
$main::dbh = DBI->connect(
	$Modules::Conf::db_address, 
	$Modules::Conf::dbUser, 
	$Modules::Conf::dbPw)
	or die &ltext('db_connect', '#2127', $DBI::errstr);

sub loadConfFile{
  my ($file, $base);
  if(-T "/root/confixx/confixx_main.conf"){
    $file = "/root/confixx/confixx_main.conf";
  }
  else{
#  $base = dirname($0);
   $0 = $^X unless ($^X =~ m%(^|[/\\])(perl)|(perl.exe)$%i);
   ($base) = $0 =~ m%^(.*)[/\\]%;
   $base ||= ".";
   $file = "$base/confixx_main.conf";
   unless(-T $file){
     die("Couldn't find confixx_main.conf");
   }
 }
 do $file;
}

{	# fictive block for sub ltext()
my %lang_text = ();	# static variable

sub ltext {
  my $text_name = shift;
  if (!%lang_text) {
    my $langFile = "$Modules::Conf::confixx_htmlDir/languages/$Modules::Conf::language/scripts.local";
    do $langFile;
  }
  if (!defined($lang_text{$text_name})) {
    return "Sorry, text $text_name not found!";
  }
  else {
    my @VAR = @_;
    my $text = $lang_text{$text_name};
    $text =~ s/\$VAR\[(\d+)\]/$VAR[$1]/g;
    if ($text) {
      return $text;
    }
    else {
      return "Sorry, localizing text $text_name failed!";
    }
  }
}

} # fictive block for sub ltext()

return 1;

END {
	$main::dbh->disconnect if ($main::dbh);
}
