package Modules::Excp;

########## Confixx(R) 3.1 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.swsoft.com - info@swsoft.com ####

BEGIN {
	use Exporter ();
    @ISA = qw(Exporter);
    @EXPORT = qw(&exception &last_excp &drop_excp &get_excp);
}

use strict 'vars';

my @excp_stack_ = ();

sub new {
	my ($sevr, $code, $desc, $new) = @_;
	$new = 'NEW_EXCP' unless $new;
	my $this = {};
	
	$$this{'sevr'} = $sevr;
	$$this{'code'} = $code;
	$$this{'desc'} = $desc;
	
	&drop_excp if ($new eq 'NEW_EXCP');

	my $obj_ref = bless($this);
	push @excp_stack_, $obj_ref;
	return $obj_ref;
}

sub get_string {
	my $this = shift;
	return "($$this{'code'}) $$thisP{'desc'}";
}

use overload (
	'""'	=> \&as_string,
	'bool'	=> \&as_bool,
	'0+'	=> \&as_int,
);

sub as_bool { warn "as bool\n"; return 0; }

sub as_string { 
	warn "as str\n"; 
	return $$_{'descr'}; 
}

sub as_int { warn "as int\n"; return 0; }

#
#
#

sub exception(;@) {
	&new(@_);
}

sub last_excp() {
	return $excp_stack_[$#excp_stack_];
}

sub drop_excp() {
	@excp_stack_ = ();
}

sub get_excp() {
	my @errors;
	foreach $excp (@excp_stack_) {
		push @errors, "($$this{'sevr'} ; $$this{'code'}) $$this{'desc'}";
	}
	return @errors;
}

return 1;

END {}
