package Modules::File::Dir;

########## Confixx(R) 3.1 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.swsoft.com - info@swsoft.com ####

use Modules::File::Created;
use Modules::File::Proc;

@ISA = qw/Modules::File::Created/;

sub new {
	my $class = shift;
	my ($dir, $perm, $force) = @_;
	$this = { 'dir' => $dir, 'perm' => $perm, 'force' => $force};
	return bless($this);
}

sub create {
	my $this = shift;

	unless ( ( -d $$this{'dir'} ) ) {
		if ( $$this{'force'} && ( -e $$this{'dir'} ) ) {
			unlink $$this{'dir'};
		}
		unless ( mkdir ($$this{'dir'}, 0755)) {
			warn("Unable to create directory '$$this{'dir'}': $!\n");
			return $this->set_created(0);
		}
	}

	chmod ( $$this{'perm'}||0755, $$this{'dir'});
	return $this->set_created(1);
}

sub remove {
	my $this = shift;
	if ($this->is_created()) {
		unless (&removeDir($$this{'dir'})) {
			warn("Unable to remove directory '$$this{'dir'}': $!\n");
			return 0;
		}
	}
	return 1;
}

sub name {
	my $this = shift;
	return $$this{'dir'};
}

sub rollback_creation {
	my $this = shift;
	return $this->remove;
}

1;


