package Modules::Restore::Flag;

########## Confixx(R) 3.1 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.swsoft.com - info@swsoft.com ####

use Modules::Restore::Field;

sub new {
  my $classname = shift;
  my $fld = shift;
  $fld=undef unless (ref($fld)=~/Field/);
  my $this = { 'field'=> $fld,
	       'on'=>undef,
	       'off'=>undef,
	     'kids' => {}
  };
  bless ($this,$classname);
  return $this;
}

sub Field {
  my $this=shift;
  return $this->{'field'};
}

sub Name {
  my $this=shift;
  if (ref($this->{'field'})=~/Field/){
    return $this->{'field'}->Name;
  }else{
    return '';
  }
}

sub AddField {
  my $this=shift;
  my ($fld,@flds,@todo);
  while (@_){
    $fld=shift;
    push @flds,$fld if(ref($fld)=~/Field/);
  }
  my ($thisFld,$parent);
  my $loop=1;
  while ($loop && @flds){
    $loop=0;
    foreach $fld (@flds){
      unless($this->{'field'}){
	$this->{'field'}=$fld;
	next;
      }
      if($parent=$this->FindParent($fld->Link->Name)){
	$parent->AddChild($fld);
	$loop=1;
      }else{
	push @todo,$fld;
      }
    }
    @flds=@todo;
  }
}

sub AddChild {
  my $this=shift;
  my $add = shift;
  if (ref($add)=~/Flag/){
    $this->{'kids'}->{$add->Name}=$add;
    return 1;
  }elsif(ref($add)=~/Field/){
    $this->{'kids'}->{$add->Name}=Modules::Restore::Flag->new($add);
    return 1;
  }
  return 0;
}

sub On {
  my $this=shift;
  if (@_){
    $this->{'on'}=shift;
  }
  return $this->{'on'};
}

sub Off {
  my $this=shift;
  if (@_){
    $this->{'off'}=shift;
  }
  return $this->{'off'};
}

sub FindParent {
  my $this=shift;
  my $name=shift;
  return undef unless $name;
  if ($this->{'field'}->Name eq $name){
    return $this;
  }
  if (exists($this->{'kids'}->{$name})){
    return $this->{'kids'}->{$name};
  }
  my $ret;
  while (my($key,$flag)=each(%{$this->{'kids'}})){
    $ret = $flag->FindParent($name);
    last if $ret;
  }
  return $ret;
}

sub getFields {
  my $this=shift;
  my $ptrRet=shift;
  unless (ref($ptrRet)=~/ARRAY/){
    $ptrRet=[];
  }
  push @{$ptrRet},$this->{'field'};
  while (my($key,$flag)=each(%{$this->{'kids'}})){
    $ptrRet=$flag->getFields($ptrRet);
  }
  return $ptrRet;
}

return 1;
