package Modules::Restore::Tables::Table_personalinfo;

########## Confixx(R) 3.1 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.swsoft.com - info@swsoft.com ####

use XML::DOM;
use XML::DOM::NodeList;

use Exporter;

use Modules::Restore::Map;
use Modules::Restore::DumpDoc;
use Modules::Restore::Tables::Common;

use Modules::Restore::DumpDoc qw/&decode_row/;
use Modules::Restore::Map qw/$ASSIGN_CURRENT $RESTORE_DUMPED $APPEND_DUMPED/;
use Modules::Restore::Tables::Common qw/&insert_query &update_query/;

use strict;
use vars qw( @ISA @EXPORT_OK %oldPersonalInfo %newPersonalInfo );

@ISA = qw(Exporter);
@EXPORT_OK = qw( %oldPersonalInfo %newPersonalInfo );

%oldPersonalInfo = ();
%newPersonalInfo = ();

sub clean_tab($$){
  my ($table_name, $ptrConfXML) = @_;

  unless ($table_name && ref($ptrConfXML)=~/DumpConfXML/){
    print STDERR "Modules::Restore::Tables::Table_personalinfo::clean_tab : wrong arguments ($table_name,..)\n";
    return 1;
  }

	my($table);

  unless( $table = $ptrConfXML->getTable( $table_name ) ){
    return 1;
  }

  if ($table->AttrNoClean){
    return 0;
  }

  return 0 if $table->StateClean;

	my $where = '';

	if( $::map->get_rule('admin(*).default') != $RESTORE_DUMPED && 
			$newPersonalInfo{'admin'} =~ /^\d+$/
		){
		$where = " AND id != ".$newPersonalInfo{'admin'};

	} else {
		delete $newPersonalInfo{'admin'};
		delete $oldPersonalInfo{'admin'};
	}

	my $sql = "DELETE FROM personalinfo WHERE server_id='$::ServerID' ".$where;

	$main::dbh->do( $sql );

	my $maxID = 0;
	my $sth = $main::dbh->prepare( "SELECT MAX(id) FROM personalinfo" );
	if( $sth->execute ){
		( $maxID ) = $sth->fetchrow;

		$table->MaxID( $maxID || 0, 'nocheck' );
	}

	return 0;
}

sub pre_tab($$$$){
  my ( $tblName, $ptrConfXML, $clean, $xmlTable ) = @_;

  unless ($tblName && ref($ptrConfXML)=~/DumpConfXML/){
    print STDERR "Modules::Restore::Tables::Table_personalinfo::pre_tab : wrong arguments ($tblName,..)\n";
    return 1;
  }

	my($table);
  unless( $table = $ptrConfXML->getTable( $tblName ) ){
    return 1;
  }

	my $sql = "SELECT MAX(id), COUNT(id) FROM personalinfo WHERE server_id='$::ServerID'";
  my $sth = $main::dbh->prepare( $sql );
  $sth->execute or 
		die("Error #0201: Can not calc max ID from 'personalinfo' table: $DBI::errstr\n");
  my( $maxID, $cnt ) = $sth->fetchrow;
  $sth->finish;

  return 0 unless($cnt); ## empty

  $maxID = 0 unless( $maxID );

	my %newIDs = reverse %newPersonalInfo;
	my %oldIDs = reverse %oldPersonalInfo;

	my( $owner, $kid, $ptrRow, $oldID, $newID, $key );

  foreach $kid ( $xmlTable->getChildNodes() ){

    next unless( $kid->getNodeType == ELEMENT_NODE );
    next unless( $kid->getNodeName() eq 'row');

    $ptrRow = &Modules::Restore::DumpDoc::decode_row( $kid );
    next unless( ref( $ptrRow ) =~ /HASH/ );

		$oldID = $ptrRow->{'id'};

		$key = "personalinfo($oldID).id";
		next if $main::map->get_attr( $key );

		if( $owner = $oldIDs{$oldID} ){
			$newID = $newPersonalInfo{$owner};

		}else{
			$maxID++;
			while( $newIDs{$maxID} ){
				$maxID++;
			}
			$newID = $maxID;
		}

		$newIDs{$newID} = $oldID;
		$main::map->add_attr( $key, $newID );
		
	}

	$table->MaxID( $maxID, 'nocheck' );
	return 0;
}

sub restore_row($$$){
	my ($table_name, $ptrRow, $ptrTable) = @_;

	my $oldID = $ptrRow->{'id'};

	my %oldIDs = reverse %oldPersonalInfo;
	my ($owner,$newID,$key);

	if( $owner = $oldIDs{$oldID} ){

		if( $owner eq 'admin' && 
				$::map->get_rule( 'admin(*).default' ) == $RESTORE_DUMPED ){

			$newID = $newPersonalInfo{$owner};
		}

		delete $ptrRow->{'id'};

	}else{
		$key = "personalinfo($oldID).id";
		$newID = $main::map->get_attr( $key );
		$ptrRow->{'id'} = $newID;
	}

	if( $ptrRow->{'id'} ){
		&Modules::Restore::Tables::Common::insert_query( $table_name, $ptrRow );

	} else {
		if( $newID ){
			&Modules::Restore::Tables::Common::update_query( $table_name, $ptrRow, "WHERE id=".$newID );
		}
	}

	return 0;
}

1;
