#!/usr/bin/perl

BEGIN{
	use Cwd;
	use FindBin;
	use File::Basename;

  use lib $FindBin::Bin=~s%(?<=.)/$%%?$FindBin::Bin:$FindBin::Bin;
	use lib dirname($FindBin::Bin).'/subs';
	use lib dirname(dirname($FindBin::Bin));
}

use Getopt::Long;
use DBI;
use File::Find;
use File::Path;
use File::Temp qw/tempfile tempdir/;
use Digest::MD5 qw/md5 md5_hex md5_base64/;

use strict;

use lib_module_common;
use lib_module_db;

my @config_opts = (                  'src|s=s',
									 'webapp|w=s',
									 'user|u=s',
									 'domain|d=s',
									 'path|p=s',
									 'help|h',
									 'debug|dbg',
									 'config|c=s'
									);

my %args = ();

unless( &GetOptions( \%args, @config_opts ) ){
	&printHelp;
	die;
}

if(exists($args{'help'})){
	&printHelp;
	exit 0;
}

unless( exists( $args{'webapp'}) && $args{'webapp'} ){
    &printHelp();
    die "Error: webapplication is not set\n";
}

unless( exists( $args{'user'}) && $args{'user'} ){
    &printHelp();
    die "Error: user is not set\n";
}

if( exists( $args{'config'} ) ){
  &initConfig( $args{'config'} );
}else{
  &initConfig();
}  

if( exists( $args{'src'})){
  if( -d $args{'src'}){
	$siteappsDir = $args{'src'};
  }else{
	&printHelp();
	die "Error '".$args{'src'}."' is not a dir\n";
  }
}


my $dbh = DBI->connect( $db_address, $dbUser, $dbPw ) or
	die "Error connect to database: $DBI::errstr\n";


my( $dir, $webapp_id, $webapp_name ) = &getWebAppPath( $args{'webapp'} );
unless( $dir ){
	$dbh->disconnect;
	die;
}

my $webapp_srcroot = "$siteappsDir/$dir";

unless( -d $webapp_srcroot ){
	$dbh->disconnect;
	die "Error: application's source dir '$webapp_srcroot' is not found\n";
}

my( $html_dir, $user, $user_uid ) = &getUserHtml( $args{'user'} );
unless( $html_dir && -d $html_dir ){
	$dbh->disconnect;
	die;
}

my $sth = $dbh->prepare( "SELECT wu.clean_db, wu.domain_id, d.domain, d.pfad ".
												 " FROM webapp_user wu, domains d ".
												 " WHERE wu.server_id='$ServerID' AND wu.kunde='$user' AND".
												 " d.server_id=wu.server_id AND d.kunde=wu.kunde AND ".
												 " d.id=wu.domain_id AND wu.webapp_id = '$webapp_id'");
$sth->execute;
my( $clean_db, $domain_id, $domain, $domain_dir ) = $sth->fetchrow;
$sth->finish;

if( $args{'domain'} ){
	( $domain_dir, $domain ) = &getDomainPath( $args{'domain'}, $user );
}

unless( $domain ){
	$dbh->disconnect;
	die "Error: domain '".$args{'domain'}."' is not found\n";
}

my $docs_dir = 'html'.$domain_dir;
$docs_dir =~ s|/+$||;

my $root_dir = $html_dir.$domain_dir;
$root_dir =~ s|/+$||;

my $cgi_dir = $local_cgi? "$root_dir/cgi-bin": "$html_dir/cgi-bin";

unless( -d $root_dir ){
	$dbh->disconnect;
	die "Error: dir '$root_dir' is not exists\n";
}

unless( -d $cgi_dir ){
  my $tmp = $cgi_dir;
	$tmp =~ s/\\/\\\\\\/g;
	$tmp =~ s/([^\\])\'/$1\\\'/g;
	my $cmd = "mkdir -p \$'$tmp'";
	$cmd =~ s/\\/\\\\\\/g;
	$cmd =~ s/([^\\])\'/$1\\\'/g;
  if ( system "$bin_su - $user -s $stdShell -c \$'$cmd'" ){
		$dbh->disconnect;
		die "Error: create dir '$cgi_dir': $!\n";
	}
}

my $dst_dir = $root_dir;
my $dst_cgi_dir = $cgi_dir;

my( $bin_htpasswd )= &findBins( qw/htpasswd/ );

&checkPsaConf( '/etc/psa/psa.conf', 
							 'MYSQL_BIN_D' => dirname( $bin_mysql ),
							 'HTTPD_BIN_D' => dirname( $bin_htpasswd ));

my $postinstall = "$webapp_srcroot/scripts/postinstall";
unless( -f $postinstall ){
	$dbh->disconnect;
	die "Error: post install script '$postinstall' is not found\n";
}

unless( open( POST, '<', $postinstall ) ){
	$dbh->disconnect;
	die "Error open file '$postinstall': $!\n";
}

my $line = <POST>;
my $val = '';
my @imp_params = ();
my $script_type = 'perl';

if( $line =~ /^#!.*perl/ ){
	my $state = 0;
	while(<POST>){
		if( $state == 0 ){
			if( /\@imp_params\s*=\s*(.*)/ ){
				$val = $1;
				if( $val =~ s/;.*$// ){
					last;
				}else{
					$state = 1;
				}
			}
		}elsif( $state == 1 ){
			if( s/;.*$// ){
				$val .= ' '.$_;
				last;
			}
		}
	}
	close( POST );
}else{
	$script_type = 'shell';
}
my( $cmd );
if( $val ){
	$cmd = '@imp_params='.$val.';';
	
	eval $cmd;
}

my( $dbname ) = grep{/dbname$/} @imp_params;
$dbname ||= 'dbname';

my %params = map{ $_ => ' ' } @imp_params;

&fillParams( $webapp_id, $user, \%params );

if( $clean_db && $params{$dbname} ){
	$sth = $dbh->prepare( "SELECT COUNT(*) FROM mysql_datenbanken ".
												" WHERE kunde='$user' AND server_id='$ServerID' AND dbname=?");
	$sth->execute( $params{$dbname} );
	my($cnt) = $sth->fetchrow;
	$sth->finish;
	if( $cnt ){
		my $lcDSN = makeDSN('mysql',$mysqlUserServer,'mysql',$mysqlUserPort);	
		my $dbhUser = DBI->connect( $lcDSN, $mysqlUserUser, $mysqlUserPw );
		if( $dbhUser ){
			$dbhUser->do( "DROP DATABASE ".$params{$dbname} );
			$dbhUser->do( "CREATE DATABASE ".$params{$dbname} );
			$dbhUser->disconnect;
		}
	}
}


#
# standard parameters
#
$params{'vhost_path'} = "$user_homeDir/$user";

$params{'install_prefix'} ||= $args{'path'} || '.';
$params{'install_prefix'} =~ s/^\s+//;
$params{'install_prefix'} =~ s/\s+$//;

$params{'ssl_target_directory'} = 'false';
$params{'domain_name'} = $domain;

if( $mysqlUserServer eq 'localhost' ){
	$params{'dbsocket'} = $mysqlUserPort;
}else{
	$params{'dbhost'} = $mysqlUserServer;
	$params{'dbport'} = $mysqlUserPort;
}

#
# end standard parameters
#

my %srcTar = ( 'httpdocs-files.tar' => $dst_dir,
							 'cgi-bin-files.tar' => $dst_cgi_dir );
my( $tarName, $tar, $dstDir );
foreach $tarName (keys %srcTar ){

	$tar = "$webapp_srcroot/apps/$tarName";

	next unless( -f $tar );

	$dstDir = $srcTar{$tarName};

	if( $params{'install_prefix'} && $params{'install_prefix'} ne '.'  ){
		$dstDir .= '/'.$params{'install_prefix'};
	}

	if( &checkSymLink( $dstDir ) ){
		$dbh->disconnect;
		die "Error: dir '$dstDir' is a symbolik link\n";
	}
	my $tmp = $dstDir;
	unless( -d $dstDir ){
  	$tmp =~ s/\\/\\\\\\/g;
  	$tmp =~ s/([^\\])\'/$1\\\'/g;
  	my $cmd = "mkdir -p \$'$tmp'";
  	$cmd =~ s/\\/\\\\\\/g;
  	$cmd =~ s/([^\\])\'/$1\\\'/g;
  	if ( system "$bin_su - $user -s $stdShell -c \$'$cmd'" ){
			$dbh->disconnect;
			die "Error create dir '$dstDir': $!\n";
		}
	}
	$cmd = "$bin_tar -xf $tar -C \$'$tmp'";
  $cmd =~ s/\\/\\\\\\/g;
  $cmd =~ s/([^\\])\'/$1\\\'/g;
	if( system( "$bin_su - $user -s $stdShell -c \$'$cmd'" ) ){
		$dbh->disconnect;
		die "Error execute '$cmd': $!\n";

	}
}

#
# httpdocs
#
my $target = "$user_homeDir/$user/httpdocs";

if( -e $target || -l $target ){
	unlink $target;
}
symlink $root_dir, $target  or
	die "error create symlink '$root_dir' -> '$target': $!\n";
#
# end httpdocs
#


#
# cgi-bin
#
$target = "$user_homeDir/$user/cgi-bin";

if( -e $target || -l $target ){
	unlink $target;
}
symlink $cgi_dir, $target  or
	die "error create symlink '$cgi_dir' -> '$target': $!\n";
#
# end cgi-bin
#

my $cwd = getcwd();

my($fh, $filename) = tempfile('wa_XXXXXX', DIR => $cwd);
chmod 0644, $filename;
my %all_keys  = map{ $_ => 1 } @imp_params, keys %params;

foreach my $key ( keys %all_keys ){
	print $fh $key,'=',$params{$key},"\n";
}
close( $fh );

my $back_redir = 0;
my( $tempScript, $tempCreated ) = &replaceHttpdocs( $postinstall, $docs_dir );
system( "$bin_su - $user -s $stdShell -c '$tempScript <$filename'" );


my $ok = ($? == 0)? 1: 0;

if( $back_redir ){
	close( STDIN );
	open( STDIN, "<&OLDIN" );
	$back_redir = 0;
}

if( $tempCreated && -f $tempScript ){
	unlink $tempScript;
}

unlink $filename;
unlink "$user_homeDir/$user/httpdocs";
unlink "$user_homeDir/$user/cgi-bin";

if( $ok ){
	&registerOK( $user, $webapp_id, \%params );
}

$dbh->disconnect;

exit 0;

#
#
#=================================================
#
#
#

END{

	my $ok = ($? == 0)? 1: 0;

	no strict 'subs';

	if( $tempCreated && -f $tempScript ){
		unlink $tempScript;
	}

	if( $back_redir ){
		close( STDIN );
		open( STDIN, "<&OLDIN" );
		$back_redir = 0;

		unlink $filename;
		unlink "$user_homeDir/$user/httpdocs";
		unlink "$user_homeDir/$user/cgi-bin";

		if( $ok ){
			&registerOK( $user, $webapp_id, \%params );
		}
	
		$dbh->disconnect;
	}
}

#
#
#
#===================================================
#
#
#

sub checkSymLink{
	my $path = shift;

	unless( $path =~ m|^/| ){
		$path = Cwd::abs_path( $path );
	}

	my @chunks = split( /\//, $path );
	my @toCheck = ();
	my $toCheck;
	while( @chunks ){
		push @toCheck, shift @chunks;
		$toCheck = join( '/', @toCheck );
		next unless $toCheck;
		if( -l $toCheck ){
			return 1;
		}
		unless( -e $toCheck ){
			return 0;
		}
	}
	return 0;
}

sub replaceHttpdocs{

	my( $src_script, $new_httpdocs ) = @_;

	unless( open( SRC, '<', $src_script ) ){
		return $src_script;
	}

	my($name,$dir) = fileparse( $src_script );
	my($fh, $dst_script ) = tempfile( $name.'_XXXX', DIR => $dir);

	my $line = <SRC>;
	if( $line =~ /perl/ ){
	#strip -w for no warnings
	$line =~ s/-w//g;
	#strip windows endline
	$line =~ s/\r$//g;
	print $fh $line;
#
# perl script
#
		while( <SRC> ){
		  s/\r$//g;
			s/('|")httpdocs\1/$1$new_httpdocs$1/;
			print $fh $_;
		}

	}else{
#
# shell script
#
	$line =~ s/\r$//g;
  print $fh $line;
		while( <SRC> ){
		  s/\r$//g;
			s[('|"|/)httpdocs\1][$1$new_httpdocs$1];
			print $fh $_;
		}
	}

	close( $fh );
	close( SRC );

	chmod( 0755, $dst_script ); ## make executable

	return $dst_script, 1;
}

sub findBins{
	my @names = @_;
	my @res = ();
	my @dirs = qw|/bin /sbin /usr/bin /usr/sbin /usr/local/bin /usr/local/sbin|;
	my( $name, $dir, $path, $found );
	foreach $name ( @names ){
		$found = 0;
		foreach $dir ( @dirs ){
			$path = "$dir/$name";
			if( -x $path ){
				push @res, $path;
				$found = 1;
				last;
			}
		}
		unless( $found ){
			push @res, $name;
		}
	}
	return @res;
}

sub chownDir{
	my( $uid, $gid, $chownRoot, @target ) = @_;
	unless( $uid=~/^\d+$/ && $gid=~/^\d+$/ ){
		print STDERR "Error: chown: bad uid/gid ($uid:$gid)\n";
		return undef;
	}
	unless( $chownRoot =~ /^0|1$/ ){
		unshift @target, $chownRoot;
		$chownRoot = 0;
	}
	my( $rootDir );

	find sub{
		unless( $chownRoot && $File::Find::name eq $rootDir ){
			chown $uid, $gid, $File::Find::name;
		}
	}, grep{
		$rootDir = $_;
		-e $_
	} @target;

}

sub registerOK{
	my( $user, $webapp_id, $ptrParams ) = @_;
	
	my $where = "u.kunde=? AND u.webapp_id=$webapp_id AND u.server_id = '$ServerID'".
		" AND u.webapp_id=w.id AND w.server_id=u.server_id";
	my $sql = "SELECT u.id, k.start_page FROM webapp_user u, webapp w ".
		" LEFT JOIN webapp_knowledge k ON ( w.name=k.webapp AND w.server_id=k.server_id )".
			" WHERE $where";
	my $sth = $dbh->prepare( $sql );
	my( $id,$start_page,$url );
	if( $sth->execute( $user ) ){
		my $rows = $sth->rows;
		if( $rows ){
			( $id,$start_page ) = $sth->fetchrow;
			
			if( $rows > 1 ){
				$dbh->do( "DELETE FROM webapp_user WHERE $where",
									undef,
									$user );
				$rows = 0;
			}
		}
		$sth->finish;

		$url = 'http://'.$ptrParams->{'domain_name'}.'/';
		if( $ptrParams->{'install_prefix'} && 
				$ptrParams->{'install_prefix'} ne '.' ){
			$url .= $ptrParams->{'install_prefix'}.'/';
		}

		if( $start_page ){
			if( $ptrParams->{'install_prefix'} && 
					$ptrParams->{'install_prefix'} ne '.' ){
				$start_page =~ s/##path##/$ptrParams->{'install_prefix'}/g;
			}
			if( $start_page =~ m|^/| ){
				$url = 'http://'.$ptrParams->{'domain_name'}.$start_page;
			}else{
				$url .= $start_page;
			}
		}


		if( $rows ){
			$sql = "UPDATE webapp_user SET status=2, url=? WHERE id=$id";
		}else{
			$sql = "INSERT INTO webapp_user (status,url,kunde,webapp_id,server_id) ".
				" VALUES (2,?,'$user',$webapp_id,'$ServerID' )";
		}
		unless( $dbh->do( $sql, undef, $url ) ){
			print STDERR "Error sql query: $DBI::errstr\n";
		}
	}
}

sub fillParams{
	my( $webappId, $user, $ptrParam ) = @_;
	my $sth = $dbh->prepare( "SELECT name FROM webapp WHERE id=$webappId" );
	$sth->execute;
	my( $webappName ) = $sth->fetchrow;
	$sth->finish;

	
	$sth = $dbh->prepare( "SELECT name,value FROM webapp_user_param ".
													 " WHERE server_id='$ServerID' AND kunde='$user' AND webapp_id=$webappId" );
	unless( $sth->execute ){
		warn "Error sql-query: $DBI::errstr\n";
		return undef;
	}
	while( my( $name, $value ) = $sth->fetchrow ){
		if( $name =~ /admin_passwd$/ && $webappName ){
			my $sthPasswd = $dbh->prepare( "SELECT hash_type FROM webapp_knowledge WHERE webapp='$webappName' AND server_id='$ServerID'" );
			$sthPasswd->execute;
			if( $sthPasswd->rows ){
				my( $hash_type ) = $sthPasswd->fetchrow;

				if( $hash_type eq 'md5' ){
					$value = md5_hex( $value );

				}elsif( $hash_type eq 'crypt' ){
					my @alpha = ('a'..'Z', 'A'..'Z', 0..9);
					my $salt = join( '', map $alpha[rand( @alpha )], 1..2 );
					$value = crypt( $value, $salt );

				}elsif( $hash_type eq 'mysql' ){
					$sthPasswd->finish;
					$sthPasswd = $dbh->prepare( "SELECT password('$value')" );
					$sthPasswd->execute;
					if( $sthPasswd->rows ){
						($value) = $sthPasswd->fetchrow;
					}
				}
			}else{
				$value = "' '";
			}
			$sthPasswd->finish;
		}
		$ptrParam->{$name} = $value;
	}
	$sth->finish;
}

sub getWebAppPath{
	my $webapp_id = shift;

	my( $webapp_name, $sql, $path );
	if( $webapp_id =~ /^\d+$/ ){
		$sql = "SELECT id,name,path FROM webapp WHERE server_id='$ServerID' AND id=$webapp_id";
	}else{
		$sql = "SELECT id,name,path FROM webapp WHERE server_id='$ServerID' AND name='$webapp_id'";
	}
	my $sth = $dbh->prepare( $sql );
	unless( $sth->execute ){
		warn "error sql query: $sql\n$DBI::errstr\n";
		return undef;
	}
	if( $sth->rows == 1 ){
		( $webapp_id,$webapp_name, $path) = $sth->fetchrow;
	}else{
		warn "error: web application '$webapp_id' is not found\n";
	}
	$sth->finish;
	return ($path,$webapp_id,$webapp_name );
}

sub getUserHtml{
	my $user = shift;
	my $sth = $dbh->prepare( "SELECT uid FROM kunden WHERE server_id='$ServerID' AND kunde='$user'" );
	unless( $sth->execute ){
		warn "Error sql query: $DBI::errstr\n";
		return undef;
	}
	my( $uid ) = $sth->fetchrow;
	$sth->finish;
	unless( $uid ){
		warn "Error: user '$user' is not found\n";
		return undef;
	}
	
	return ( "$user_homeDir/$user/html", $user, $uid );
}

sub getDomainPath{
	my( $domain, $user ) = @_;
	my( $domain_id, $sql, $path );
	if( $domain =~ /^\d+$/ ){
		$sql = "SELECT domain, pfad FROM domains WHERE server_id='$ServerID' AND id=$domain AND kunde='$user'";
	}else{
		$sql = "SELECT domain, pfad FROM domains WHERE server_id='$ServerID' AND domain='$domain' AND kunde='$user'";
	}
	my $sth = $dbh->prepare( $sql );
	unless( $sth->execute ){
		warn "Error sql query: $DBI::errstr\n";
		return undef;
	}
	( $domain, $path) = $sth->fetchrow;
	$sth->finish;
	return ( $path, $domain );
}

sub checkPsaConf{
	my( $psa_conf, %requir ) = @_;
	$psa_conf ||= '/etc/psa/psa.conf';
	my $dir = dirname( $psa_conf );
	unless( -d $dir ){
		mkdir $dir or
			return undef;
	}
	my %psa_params = ();
	my @conf = ();
	my( $key, $val, $rewrite );
	if( -f $psa_conf ){
		if( open( PSA, '<', $psa_conf ) ){
			while(<PSA>){
				chomp;
				if(/^(\s*[_a-zA-Z]+)\s+(.+?)\s*$/){
					$key = $1;
					$val = $2;
					if( exists $requir{$key} && $requir{$key} ne $val ){
						$val = $requir{$key};
						$rewrite = 1;
						$_ = $key.' '.$val;
						delete $requir{$key};
					}
					$psa_params{$key} = $val;
				}
				push @conf, $_;
			}
			close( PSA );
		}
	}

	map{
		push @conf, $_.' '.$requir{$_};
		$rewrite = 1;
	} grep{ 
		! exists $psa_params{$_} 
	} keys %requir;

	if( $rewrite ){
		if( open( PSA, '>', $psa_conf ) ){
			map{
				print PSA $_,"\n";
			} @conf;
			close( PSA );
		}
	}
	return 1;
}

sub printHelp{
	print STDERR <<HELP;

Install the web application to the confixx user

Usage:
  install.pl [--user|-u] <user> [--webapp|-w] <web-application>

Options:
  --domain|-d <domain>
 	--path  |-p <path-to-install>
	--help  |-h                       help
	--debug |-dbg                     debug mode
	--config|-c <path-to-config>
  --src   |-s <dir-of-packages>
HELP

}
