#!/usr/bin/perl

########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####


BEGIN {
  use FindBin qw($Bin);
	use File::Basename;

  use lib $Bin=~s%(?<=.)/$%%?$Bin:$Bin ,
		$Bin.'/subs',
		$Bin.'/scripts',
		dirname($Bin).'/scripts',
		dirname($Bin).'/sub'	;
}

## Pre-Main
use DBI;

use lib_module_common;
use lib_module_db;
use lib_module_events;

use Modules::FileCopy;

use strict;

use vars qw/ $wDir /;

my ($baseDir);

unless( $wDir ){
	$wDir = &getCanonPath( dirname( $0 ) );
}

if (-d "$wDir/subs" ){ ## install
	$baseDir = "$wDir/subs";

}elsif( -d "$wDir/../subs") { ## update
	$baseDir = dirname($wDir).'/subs';

}elsif( -d "$wDir/admin/subs") { ## remake
	$baseDir = "$wDir/admin/subs";
}



my $subs_include_questions = "$baseDir/subs_include_questions.pl";

unless(-f $subs_include_questions){
  $wDir =~ s/\/[^\/]+$/\/subs/; 
  $subs_include_questions = "$baseDir/subs_include_questions.pl";
	unless ( -f $subs_include_questions ) {
		if ( -d $installDir ) {
			$baseDir = "$installDir/admin/subs";
			$subs_include_questions = "$baseDir/subs_include_questions.pl";
		}
	}
}

safe_do $subs_include_questions;
safe_do "$baseDir/subs_include_writeConfig.pl";

safe_do "$baseDir/MySQLLogin_install.pl";  # to run &installMySQLLogin;

&ReadMainConfigFile unless ($ENV{'ONLYFILES'});

safe_do "$baseDir/subs_include_files.pl";

my $subs_include_writeConfig = "$baseDir/subs_include_writeConfig.pl";
my $subs_include_qmail = "$baseDir/subs_include_qmail.pl";
my $subs_include_postfix = "$baseDir/subs_include_postfix.pl";
my $subs_include_sendmail = "$baseDir/subs_include_sendmail.pl";
my $subs_include_majo = "$baseDir/subs_include_majo.pl";
my $subs_include_IDN = "$baseDir/subs_include_IDN.pl";
my $subs_include_quota = "$baseDir/subs_include_quota.pl";

$baseDir = dirname($baseDir);
my $scriptDir = $baseDir.'/scripts';
my $subsDir = $baseDir.'/subs';
my $contribDir = $baseDir.'/contrib';
my $siteAppsDir = $baseDir.'/siteapps';

&header2( &ltext('install_header_scripts') );
## /Pre-Main

## Main
unless ($ENV{'NOFILES'}){
unless( $PIDDir  && -d "$ENV{'DESTDIR'}$PIDDir" ) {
  print &ltext('install_do_dir_create', $PIDDir);
  mkdir("$ENV{'DESTDIR'}$PIDDir", 0755) or 
		print( &ltext('install_dir_create', $PIDDir) );
}
}
$bin_cp ||= $bin{'cp'}||'cp';

unless( $confixxState =~ /remake/ ) {
	&invalidShell unless ($ENV{'ONLYFILES'});
	unless ($ENV{'NOFILES'}){
	&installUpdateScript;
	&installModules( $baseDir );
	&installFTPTraffik;
	&installHTTPDTraffik;
	&installWebalizer;
	&installAdmin;
	&installPipe;
	&installInstall( $baseDir );
}
unless ($ENV{'ONLYFILES'}){
	if(-e "$scriptDir/autoresponder.pl" && $mail_server>=1 && $mta) {
		&installAutoresponder('autoresponder.pl');
	}

	if(-e "$scriptDir/confixxevent.pl" && $mail_server>=1 && $mta ) {
		&installAutoresponder ('confixxevent.pl',($mta eq 'qmail')?'alias':undef);  
		## alias - system account for call confixxevent.pl by qmail
	}
}

unless ($ENV{'NOFILES'}){
	if(-e "$scriptDir/newsletter.pl"){
		&installNewsletter();
	}
	
	&installUserManager;
	&installSiteAppsScripts;
}
	&UpdateAllConfig unless($ENV{'ONLYFILES'});

	if ( $mysqlUserServer  && $mysqlUserUser && $mysqlUserPw ) {
		&installMySQLLogin unless($ENV{'ONLYFILES'});
	}
}

## /Main

#
#
#=================================================
#
#

## UNTERPROGRAMME
sub installSiteAppsScripts {
#check if we do copy of the folder to itself ( in case of update)
unless ( (stat "$installDir/admin/siteapps")[1] == (stat "$siteAppsDir")[1]){	
	system "$bin_cp -rf $siteAppsDir $ENV{'DESTDIR'}$installDir/admin/";
}
}
sub installUpdateScript{
  my (@Script,$file);

  print &ltext('install_install_group', 'UpdateScript');

  print &ltext('install_do_file_copy', "$scriptDir/confixx_updatescript.pl", "$installDir/confixx_updatescript.pl");

	foreach  $file ( qw/confixx_updatescript.pl
											backup.pl
											restore.pl
											restorefull.pl
											user_backup.pl
											reset_admin_pw.pl
											/ ) {
		print &ltext('install_do_file_copy', "$scriptDir/$file", "$installDir/$file");

		&safe_copy( $scriptDir, "$ENV{'DESTDIR'}$installDir", $file, 0755 );
		
	}
	&safe_copy( $scriptDir, "$ENV{'DESTDIR'}$installDir", 'confixx_dump.conf', 0400 );
	&safe_copy( $scriptDir, "$ENV{'DESTDIR'}$installDir", 'atdomain.php', 0644 );

	foreach  $file ( qw/ subs_include_sendmail.pl
											 subs_include_postfix.pl
											 subs_include_qmail.pl
											 subs_include_IDN.pl
											/ ) {
		print &ltext('install_do_file_copy', "$wDir/$file", "$installDir/$file");

		&safe_copy( $subsDir, "$ENV{'DESTDIR'}$installDir", $file, 0755 );
	}

	foreach  $file ( qw/ subs_include_majo.pl
											 subs_include_quota.pl
											 subs_include_writeConfig.pl
											 / ){
		print &ltext('install_do_file_copy', "$wDir/$file", "$installDir/$file");
		&safe_copy( $subsDir, "$ENV{'DESTDIR'}$installDir", $file, 0644 );
	}

unless($ENV{'ONLYFILES'}){
  (undef, $apache_root, undef) = fileparse($httpd_conf);
  ($apache_root =~ s/\/conf\/$//) || ($apache_root =~ s/\/$// );
  unless(-d "$apache_root/conf") {
    print &ltext('install_do_link', "$apache_root", "$apache_root/conf");
    symlink("$apache_root", "$apache_root/conf");
  }
}
  if((-e "$ENV{'DESTDIR'}$installDir/newserver.pl") && (-e "$contribDir/newserver.pl")){
    print &ltext('install_do_file_copy', "$contribDir/newserver.pl", "$installDir/newserver.pl");
    copy("$contribDir/newserver.pl", "$ENV{'DESTDIR'}$installDir/newserver.pl");
    chmod(0755, "$ENV{'DESTDIR'}$installDir/newserver.pl");
  }
  # create symlink for compatibility issues
  symlink("$installDir/confixx_updatescript.pl", "$ENV{'DESTDIR'}$installDir/confixx_counterscript.pl");
}


sub installModules
{
  my $wDir = $baseDir||shift;

	print &ltext('install_do_dir_copy', "$wDir/scripts/Modules", "$installDir/Modules");
	system( "$bin_cp -rf $wDir/scripts/Modules $ENV{'DESTDIR'}$installDir" );

}

sub installFTPTraffik{
  my (@Script);
  print &ltext('install_install_group', 'FTPTraffik-Script');
  print &ltext('install_do_file_copy', "$scriptDir/ftptraffik.pl", "$installDir/ftptraffik.pl");
  copy("$scriptDir/ftptraffik.pl", "$ENV{'DESTDIR'}$installDir/ftptraffik.pl");
  chmod(0755, "$ENV{'DESTDIR'}$installDir/ftptraffik.pl");
}


sub installHTTPDTraffik{
  my (@Script);
  my $time = localtime();
  print &ltext('install_install_group', 'HTTPDTraffik-Script');
  print &ltext('install_do_file_create', "$ENV{'DESTDIR'}$installDir/httpdtraffik.sh");
  open (FILE, ">$ENV{'DESTDIR'}$installDir/httpdtraffik.sh");

  print FILE << "SCRIPT";
#!/bin/sh
##
### Script zur Steuerung der HTTPD-Traffik-Ermittlung
########## created: $time ###
FIND="$bin{'find'}"
RM="$bin{'rm'}"
GREP="$bin{'grep'}"
PREFIX="$user_prefix";
HOMEDIR="$user_homeDir"
BACKUPDIR="$apacheBackupDir"
LOGEXPIRE="$apacheBackupExpire"
PIDFILE="$PIDDir/confixx_httpdtraffik.pid" # PID-File
SCRIPT="$installDir/httpdtraffik.pl" # Das Script, das den Traffik ermittelt anhand des ConfigFiles (und natuerlich Logfile;-)
ROTATESCRIPT="$installDir/rotate.pl" # Das Script, das die Logfiles packt...
CONF=".configs/webalizer.conf"
WEBALIZER="$bin_webalizer"
AWSTATS="$awstats"
AWSTATS_CONF_DIR="$awstats_conf_dir"
AWSTATS_SCRIPT="$awstats_script"
########################
if test "\$1" =  "DEBUG"  ; then
  DEBUG=1;
 else
  DEBUG=0;
fi

echo \$\$ > \$PIDFILE;
      for HOME in \$HOMEDIR/* ; do
        USER=\${HOME##\$HOMEDIR/}
        if ( echo -E "X\$USER" | \$GREP "^X\$PREFIX[0-9]\\+\$" >/dev/null )  ; then
          if test "\$DEBUG" = "1"; then
            echo "\$USER"
          fi
          if ((test "\$USER" != "*") && (test -e "\$HOME/log/access_log") && (test "1\$USER" != "1")); then
            if test "\$DEBUG" = "1"; then
              echo "\$SCRIPT \$USER"
            fi
            \$SCRIPT \$USER
            if ((test -e \$HOMEDIR/\$USER/\$CONF) && (test -x "\$WEBALIZER")) ; then
              if test "\$DEBUG" = "1"; then
                echo "\$WEBALIZER -c \$HOMEDIR/\$USER/\$CONF"
              fi
              \$WEBALIZER -c \$HOMEDIR/\$USER/\$CONF
            fi
            if ( (test \$AWSTATS = "1" ) && (test -e \$AWSTATS_CONF_DIR/awstats.\$USER.conf) && (test -x "\$AWSTATS_SCRIPT")) ; then
              if test "\$DEBUG" = "1"; then
                echo "\$AWSTATS_SCRIPT  -config=\$USER -update"
              fi
              \$AWSTATS_SCRIPT  -config=\$USER -update >/dev/null
            fi

            if test "\$DEBUG" = "1"; then
              echo "\$ROTATESCRIPT \$USER access"
            fi
           \$ROTATESCRIPT \$USER access
            if(test -d \$BACKUPDIR/\$USER) ; then
              if test "\$DEBUG" = "1"; then
              echo "\$FIND \$BACKUPDIR/\$USER/ -atime +\$LOGEXPIRE -type f -exec rm -f {} \\;"
              fi
              \$FIND \$BACKUPDIR/\$USER/ -atime +\$LOGEXPIRE -type f -exec rm -f {} \\;
            fi
            if(test -d \$HOMEDIR/\$USER/log/old) ; then
              if test "\$DEBUG" = "1"; then
                echo "\$FIND \$HOMEDIR/\$USER/log/old/ -atime +\$LOGEXPIRE -type f -exec rm -f {} \\;"
              fi
              \$FIND \$HOMEDIR/\$USER/log/old/ -atime +\$LOGEXPIRE -type f -exec rm -f {} \\;
            fi
          fi
        fi
      done
rm \$PIDFILE; # Bin fertig, also PID-File loeschen...
SCRIPT

  close(FILE);
  
unless ($ENV{'NOFILES'}){
  chmod(0755, "$ENV{'DESTDIR'}$installDir/httpdtraffik.sh");
  print &ltext('install_do_file_copy', "$scriptDir/httpdtraffik.pl" ,"$installDir/httpdtraffik.pl");
  copy("$scriptDir/httpdtraffik.pl", "$ENV{'DESTDIR'}$installDir/httpdtraffik.pl");
  chmod(0755, "$ENV{'DESTDIR'}$installDir/httpdtraffik.pl");

  print &ltext('install_do_file_copy', "$scriptDir/rotate.pl" ,"$installDir/rotate.pl");
  copy("$scriptDir/rotate.pl", "$ENV{'DESTDIR'}$installDir/rotate.pl");
  chmod(0755, "$ENV{'DESTDIR'}$installDir/rotate.pl");
}
}


sub installWebalizer{
  my $time = localtime();
  print &ltext('install_do_file_create', "$installDir/runwebalizer.sh");
  open(FILE, ">$ENV{'DESTDIR'}$installDir/runwebalizer.sh");

  print FILE << "SCRIPT";
###### Confixx-Webalizer-Script
## zum abarbeiten aller Domains mit Webalizer
########## erstellt am $time ###
PIDFILE="$PIDDir/confixx_webalizer.pid" # PID-File
HOMEDIR="$user_homeDir"
CONF=".configs/webalizer.conf"
WEBALIZER="$bin_webalizer"
########################
echo \$\$ > \$PIDFILE;
      for HOME in \$HOMEDIR/* ; do
        USER=\${HOME##\$HOMEDIR/}
        if test "\$USER" != "*"; then
          if test -e \$HOMEDIR/\$USER/\$CONF ; then
            \$WEBALIZER -c \$HOMEDIR/\$USER/\$CONF
          fi
        fi
      done
rm \$PIDFILE; # Bin fertig, also PID-File loeschen...
SCRIPT

  close(FILE);

  chmod(0755, "$ENV{'DESTDIR'}$installDir/runwebalizer.sh");
}


sub installAdmin{
  print &ltext('install_install_group', 'Admin-Script');
  unless(-d "$ENV{'DESTDIR'}$installDir/admin"){
    print &ltext('install_do_dir_create', "$installDir/admin");
    mkdir ("$ENV{'DESTDIR'}$installDir/admin", 0700);
  }
  my (@Script);

  print &ltext('install_do_file_copy', "$scriptDir/admin.pl", "$installDir/admin/admin.pl");
  copy("$scriptDir/admin.pl", "$ENV{'DESTDIR'}$installDir/admin/admin.pl");
  chmod(0755, "$ENV{'DESTDIR'}$installDir/admin/admin.pl");

  if ( -T "$baseDir/.config" ) { ## install mode
    print &ltext('install_do_dir_copy', "$baseDir/subs", "$installDir/admin/subs");
    system( "$bin_cp -rf $baseDir/subs $ENV{'DESTDIR'}$installDir/admin/" );
    print &ltext('install_do_dir_copy', "$baseDir/CPAN", "$installDir/admin/CPAN");
    system( "$bin_cp -rf $baseDir/CPAN $ENV{'DESTDIR'}$installDir/admin/" );
    print &ltext('install_do_dir_copy', "$baseDir/admin", "$installDir/admin/admin");
    system( "$bin_cp -rf $baseDir/scripts $ENV{'DESTDIR'}$installDir/admin/" );
    print &ltext('install_do_dir_copy', "$baseDir/cgis", "$installDir/admin/cgis");
    system( "$bin_cp -rf $baseDir/cgis $ENV{'DESTDIR'}$installDir/admin/" );
    print &ltext('install_do_dir_copy', "$baseDir/html", "$installDir/admin/html");
    system( "$bin_cp -rf $baseDir/html $ENV{'DESTDIR'}$installDir/admin/" );
    print &ltext('install_do_dir_copy', "$baseDir/languages", "$installDir/admin/languages");
    system( "$bin_cp -rf $baseDir/languages $ENV{'DESTDIR'}$installDir/admin/" );
  }
}

sub installInstall {
  my $wDir = $baseDir||shift;
    print &ltext('install_install_group', 'Install-Script');
#    if(-T "$baseDir/.config"){
	print &ltext('install_do_dir_copy', "$wDir/install", "$installDir/install");
	system( "$bin_cp -rf $wDir/install $ENV{'DESTDIR'}$installDir/" );
#    }
}

sub installPipe{
  print &ltext('install_install_group', 'PipeLog-Script');
  my $time = localtime();
  print &ltext('install_do_file_create', "$installDir/pipelog.pl");
  open(FILE, ">$ENV{'DESTDIR'}$installDir/pipelog.pl");

  print FILE << "SCRIPT";
#!/usr/bin/perl
###### Confixx-Apache-PipeLog
## zum Loggen der Webzugriffe pro User
########## erstellt am $time ###
\$logDir = "$apacheLogDir/domains/access";
\$stdLog = "$apacheLogDir/stdlog_access";
while(<STDIN>){
  (\$domain, \$log) = split(/:#?:/, \$_, 2);
  \$domain = lc(\$domain);
  \$logfile = "\$logDir/\$domain";
  \$worked = 0;
  if(-l \$logfile){
    \$target = readlink(\$logfile);
    unless(-l \$target){ 
      if(open(LOG, ">>\$logfile")){
        print LOG \$log;
        close(LOG);
        \$worked=1;
      }
    } 
  }
  unless(\$worked){
    open(LOG, ">>\$stdLog") or next;
    print LOG "\$domain :: \$log";
    close(LOG);
  }

}
SCRIPT

  close(FILE);

  chmod(0755, "$ENV{'DESTDIR'}$installDir/pipelog.pl");
}


sub installAutoresponder{

  my $scriptToInstall = shift || 'autoresponder.pl';
  my $scriptOwner = shift;

  $scriptToInstall =~ /^(\S+?)\./;
  my $scriptKey = $1;
  
  my($i, @Script, $default_uid, %trans );

  unless( $mta_uid =~ /^\d+$/ && $mta_gid =~ /^\d+$/ ) {
		&configureMtaUidGid();
  }

	%trans = ( 'db_address' => $db_address,
						 'dbUser' => $dbUser,
						 'dbPw' => $dbPw,
						 'SENDMAIL' => $bin{'sendmail'},
						 'ServerID' => $ServerID,
					 );

  if ($scriptKey =~ /autorespond/){
    $scriptKey ='autorespond';
    print &ltext('install_install_group', 'Autoresponder-Script');

		if( $master_confixx ){
#
# keep local connection
#
			&useModule( 'lib_module_master' );

			lib_module_master::readMasterConfig();

			$trans{'db_address'} = $db_local_dsn;
			$trans{'dbUser'} = $dbLocalUser;
			$trans{'dbPw'} = $dbLocalPw;
		}

  } else {
		print &ltext('install_install_group', "$scriptKey-Script");
	}	


	my $list = join('|',keys %trans);
	my $re = qr/^\s*\$($list)\s*=.*;(.*?)$/;

  umask 077;
  if( open(FILE, "$scriptDir/$scriptToInstall") ){
		while (<FILE>){
			if( /$re/ ){
				$_ = '$'."$1 = '".$trans{$1}."';$2\n";
			}

			push @Script, $_;
		}
	  close(FILE);
		umask 022;
	}else{
		warn "Open file error: $!\n";
	}

	no strict 'refs';

  my $ptrVar = "bin_$scriptKey";
  my $binCmd = $$ptrVar;

  if(($scriptToInstall =~ /autorespond/) && ($bin_autorespond ne "") && ($bin_autorespond =~ /^\/\S+\.pl$/)){
    $bin{$scriptKey} = $bin_autorespond;
  }else{
    if ($binCmd =~ /^\/\S+\.pl$/){
      $bin{$scriptKey} = $binCmd;
    }else{
      $bin{$scriptKey} = "/usr/bin/$scriptToInstall";
      $$ptrVar = $bin{$scriptKey};
    }
  }

	use strict 'refs';

  print &ltext('install_do_file_create', $bin{$scriptKey});
  if( open(FILE, '>', $bin{$scriptKey} ) ){
		print FILE @Script;
		close(FILE);
	}else{
		warn "Open file error: $!\n";
	}

  ## WICHTIG!!

  if( $mta eq 'postfix' ){
#
# fuer postfix soll autoresponder.pl zu nobody gehoeren
#
    my $default_privs = 'nobody';
    if( -f $MailConfigFile ){
      if( open( CONF, '<', $MailConfigFile ) ){
				while(<CONF>){
					chomp;
					unless (/^#/){
						if (/^\s*default_privs\s*=\s*(\S+)/){
							$default_privs=$1;
							last;
						}
					}
				}
      }
      close(CONF);
    }
    my ($privs_uid,$privs_gid)=(getpwnam($default_privs))[2,3];

    unless( $privs_uid ){
#
# der schlechste Fall
#
      $privs_uid = 99;
      $privs_gid = 99;
    }

    chown($privs_uid, $privs_gid, $bin{$scriptKey});

  } elsif( $scriptOwner ) {

    my ($privs_uid,$privs_gid) = (getpwnam($scriptOwner))[2,3];

    chown($privs_uid, $privs_gid, $bin{$scriptKey});

  } else{

    chown($mta_uid, $mta_gid, $bin{$scriptKey});

  }

  chmod(0550, $bin{$scriptKey});
  ##/ WICHTIG!!
	foreach my $smrshDir ('/etc/smrsh','/etc/mail/smrsh'){
		if(-d $smrshDir){
			if(!(-e "$smrshDir/$scriptToInstall")){
				symlink($bin{$scriptKey}, "$smrshDir/$scriptToInstall");
			}
		}
	}
}


sub installNewsletter{
  my($i, @Script);
  print &ltext('install_install_group', 'Newsletter-Script');
  print &ltext('install_do_file_copy', "$scriptDir/newsletter.pl", "$installDir/newsletter.pl");
  copy("$scriptDir/newsletter.pl", "$ENV{'DESTDIR'}$installDir/newsletter.pl");
  chmod(0750, "$ENV{'DESTDIR'}$installDir/newsletter.pl");
}


sub installUserManager{
  my($i, @Script);
  print &ltext('install_install_group', 'UserManager');

  if(-e "$ENV{'DESTDIR'}$installDir/confixx_useradd.pl"){
    unlink("$ENV{'DESTDIR'}$installDir/confixx_useradd.pl");
  }
  if(-e "$ENV{'DESTDIR'}$installDir/confixx_userdel.pl"){
    unlink("$ENV{'DESTDIR'}$installDir/confixx_userdel.pl");
  }
  if(-e "$ENV{'DESTDIR'}$installDir/confixx_passwd.pl"){
    unlink("$ENV{'DESTDIR'}$installDir/confixx_passwd.pl");
  }

  print &ltext('install_do_file_copy', "$scriptDir/confixx_passwd.pl", "$installDir/confixx_passwd.pl");
  copy("$scriptDir/confixx_passwd.pl", "$ENV{'DESTDIR'}$installDir/confixx_passwd.pl");
  chmod(0750, "$ENV{'DESTDIR'}$installDir/confixx_passwd.pl");

}


#
# add Shells used by Confixx to /etc/shells 
# to prevent "invalid shell" for ftp logins
#
sub invalidShell{
  my $file = '/etc/shells';
  my $bin_false = '/bin/false';
  my $bin_scp = $scponly_shell;
  
  if ( -T $file ) {
    if ( open(FILE, $file) ) {
			while(<FILE>){
				if($_ =~ /\/bin\/false/){
					$bin_false = '';
				}
				if($_ eq "$bin_scp\n"){
					$bin_scp = '';
				}
			}
			close(FILE);
		
			if ( $bin_false || $bin_scp ) {
				if ( open(FILE, '>>', $file) ) {
					print FILE $bin_false,"\n" if $bin_false;
					print FILE $bin_scp,"\n" if $bin_scp;
					close(FILE);
				} else {
					warn "Error: unable to open '$file': $!\n";
				}
			}
    } else {
			warn "Error: unable to open '$file': $!\n";
		}
  }
}
## /UNTERPROGRAMME



