#!/usr/bin/perl

########## Confixx(R) 3.0 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####

sub configureFtpd {

	my $defaultPath = '/etc/ftpaccess';
	my ($path);
	foreach my $dir ('/etc','/etc/wu-ftpd') {
		$path = $dir.'/ftpaccess';
		if (-f $path ) {
			$defaultPath = $path;
			last;
		}
	} 
	
	$ftpConfFile = &FileQuestion( &ltext('install_question_ftpconf', 'wu-ftpd'), $defaultPath );

	my $ptrHash = &parseFtpdCongif($ftpConfFile,'email');

	$ftpConfAdmin = &Question(&ltext('install_question_ftpemail', 'wu-ftpd'), 
												$ptrHash->{'email'} || "technik\@$hostname" );
	
  $ftp_bin_ls = &BinQuestion( &ltext('install_question_ftpls', 'wu-ftpd') , '/usr/local/ftp/bin/ls');


}

sub parseFtpdCongif {
  my $pathToConfig = shift; 

  my @keys = @_;
  my (%ret,%pats,$pat,$key,$i);
  
	return undef unless(@keys);

  if((-T $pathToConfig) && open(CONFIG,$pathToConfig)){

    foreach $key (@keys){
      $pats{$key} = qr/^\s*\Q$key\E\s+(\S+)/i;
    }

    while(<CONFIG>){
      next if /^#/;   ## commentary
      next if /^\s*$/; ## blank line
      while( ($key,$pat) = each(%pats) ) {  ## loop by patterns
				if ( /$pat/ ) {
					$ret{$key} = $1;        ## found
					delete( $pats{$key} );
					last;
				}
      }
      last unless (keys %pats);  ## no more patterns
    }
    close (CONFIG);
  }

  return \%ret;

}

1;

