#!/usr/bin/perl

########## Confixx(R) 3.0 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####

BEGIN {
  use FindBin;
  use lib $FindBin::Bin;
  use lib $FindBin::Bin.'/../scripts';
	use lib $FindBin::Bin.'/subs';
}

## Pre-Main
use File::Basename;
use File::Copy;

use lib_module_db;
use lib_module_common;

use vars qw/$wDir/;

use strict;

&initConfig();


if ($confixxState =~ /(install|update)/) {

	if ( -d "$wDir/subs" ){ ## configure & install

	    safe_do "$wDir/subs/subs_include_questions.pl";
	    safe_do "$wDir/subs/subs_include_wu-ftpd.pl";

	} elsif ( -d "$wDir/../subs" ) { ## update

	    safe_do "$wDir/../subs/subs_include_questions.pl";
	    safe_do "$wDir/../subs/subs_include_wu-ftpd.pl";
	}    
    
} else {
    $wDir = dirname($0);

    unless (-e "$wDir/vsftpd_install.pl"){
	$wDir = "$installDir/admin/subs";
    }

    safe_do "$wDir/subs_include_questions.pl";
    safe_do "$wDir/subs_include_writeConfig.pl";
    safe_do "$wDir/subs_include_files.pl";
    safe_do "$wDir/subs_include_wu-ftpd.pl";
}


&header2( &ltext('install_header_ftp', 'wu-ftpd') );

if ( $ftpDaemon ne 'wu-ftpd' ||  
		 ( -T "$wDir/../.config" && $ftpDaemon eq '' ) || 
		 !(-T $ftpConfFile) 
	 ){
  $ftpDaemon = 'wu-ftpd';

	&configureFtpd();

}
## Pre-Main

## Main
&ConfigureWuFtpd;
&UpdateMainConfig;
## /Main

## Unterprogramme

sub ConfigureWuFtpd{
  if ( $ftp_bin_ls && ( -x $ftp_bin_ls ) && ( ! -x "$installDir/ftp/bin/ls" ) ) {
    &RecCreateDir( "$installDir/ftp/bin", 0700 );
    copy ( $ftp_bin_ls, "$installDir/ftp/bin/ls" );
  }
  &BackUpFile( $ftpConfFile, "$installDir/backup/wuftpd/ftpaccess" );
  print "\n";
  &CreateWuFtpdConfigFile;
}


sub CreateWuFtpdConfigFile{
  copy($ftpConfFile, "$ftpConfFile.confixx-backup");
  my $time = localtime();
  my ($deny, $ftpuid);
  $ftpuid = getpwnam('ftp');
  if($ftpuid =~ /^\d+$/){
    $deny = "deny-uid \%$ftpuid"; 
  }

  my $questgroup = $userGroup? $userGroup: '*';

	$ftpConfAdmin ||= "technik\@$hostname";

  print &ltext('install_do_file_create', $ftpConfFile);
  open(FILE, ">$ftpConfFile");
  print FILE << "CONFIG";
#### CONFIXX WU-FTPD CONFIGFILE ####
    #### created at $time ###

class   all   real,guest,anonymous  *

email $ftpConfAdmin

defaultserver private

loginfails 5

readme  README*    login
readme  README*    cwd=*

message /etc/ftpwelcomemsg            login
message .message                cwd=*

compress        yes             all
tar             yes             all
chmod           yes             guest
delete          yes             guest
overwrite       yes             guest
rename          yes             guest

log transfers anonymous,real,guest inbound,outbound

shutdown /etc/shutdownmsg

passwd-check rfc822 warn
guestgroup $questgroup
guestgroup $apacheGroup
deny-gid \%$gidpop
$deny

     ### END ####

CONFIG

  close(FILE);
}


sub header2{
  my ($header) = @_;
  my ($length, $count, $fix, $space);
  $fix = 35;
  $length = length($header);
  if($length > $fix){
    $fix = $length + 2;
  }
  $space = int(( $fix - $length ) / 2);
  for($count=1; $count <= $fix; $count++){
    print "#";
  }
  print "\n";
  for($count=1; $count <= $space; $count++){
    print " ";
  }
  print "$header    \n";
  for($count=1; $count <= $fix; $count++){
    print "#";
  }
  print "\n\n";
}
## /Unterprogramme
