package Parser::Css;

use Parser::Css::Directive;
use Parser::Css::Style;
use Parser::Css::Comment;

use strict;

sub new {
	my $class = shift;
	my $path = shift;
	my $this = { 'path'=>$path,
							 'items' => []
						 };
	bless( $this, $class );

	$this->load();

	return $this;
}

sub Path{
	my $this = shift;
	if( @_ ){
		$this->{'path'} = shift;
	}
	return $this->{'path'};
}

sub addItem{
	my $this = shift;
	my $item = shift;
	if( ref( $item )){
		push @{$this->{'items'}}, $item;
	}
	return $item;
}

sub countItems{
	my $this = shift;
	return scalar @{$this->{'items'}};
}

sub getItems{
	my $this = shift;
	return $this->{'items'};
}

sub load{
	my $this = shift;
	my($path,$chr);
	if( @_ ){
		$path = $this->Path( shift );
	} else {
		$path = $this->Path();
	}
	unless(-T $path){
		return undef;
	}
	unless( open(FH,'<',$path) ){
		print STDERR "Error open file '$path': $!\n";
		return undef;
	}
	my $buf = '';
	my $sk = 0;
	my $comment = '';
	
	while( read( FH, $chr, 1 )){
		if( $comment ){
			if( $chr eq '*' ){
				read( FH, $chr, 1 );
				if( $chr eq '/' ){
					$comment .= '*/';
					$this->addItem( Parser::Css::Comment->new( $comment ) );
					$comment = '';
					$chr = undef;
				} else {
					$comment .= '*';
				}
			}
			$comment .= $chr if defined( $chr );
			next;
		}

		if( $sk ){
			if( $chr eq '}'){
				$sk--;
				if( $sk == 0 ){
					$buf .= $chr;
					$this->addItem( Parser::Css::Style->new( $buf ) );
					$buf = '';
					$chr = undef;
				}
			}elsif( $chr eq '{'){
				$sk++;
			}

		}else{
			if( $chr eq ';' ){
				$buf .= $chr;
				$this->addItem( Parser::Css::Directive->new( $buf ) );
				$buf = '';
				$chr = undef;
			}
		}

		if( $chr eq '/' ){
			read( FH, $chr, 1 );
			if( $chr eq '*' ){
				$comment = '/*';
				$chr = undef;
			} else {
				$buf .= '/';
			}
		}elsif( $chr eq '{' ){
			$sk++;
		}

		$buf .= $chr if defined( $chr );
	}
	close( FH );

	return $this->countItems();

}

sub findStyle {
	my $this = shift;
	my $keys = shift;
	my $ref = ref($keys);

	my( $ptrKeys );

	if( $ref =~ /Style/ ){
		$ptrKeys = $keys->getKeys();

	}elsif( $ref =~ /ARRAY/ ){
		$ptrKeys = $keys;
	} else {
		$ptrKeys = [ $keys, @_ ];
	}

	foreach my $item ( @{$this->{'items'}} ){
		unless( ref( $item ) =~ /Style/ ){
			next;
		}
		if( $item->isKeysEquiv( $ptrKeys ) ){
			return $item;
		}
	}
	
	return undef;
}

sub findDirective {
	my $this = shift;
	my $dir = shift;
	unless( ref( $dir )=~ /Directive/ ){
		return undef;
	}

	foreach my $item ( @{$this->{'items'}} ){
		unless( ref( $item ) =~ /Directive/ ){
			next;
		}
		if( $item->isEquiv( $dir ) ){
			return $item;
		}
	}
	return undef;
}

sub merge {
	my $this = shift;
	my $srcCss = shift;
	unless( ref( $srcCss ) =~ /Css/ ){
		return undef;
	}
	my( $srcItem, $ref, $item );
	my $ret =0;
	foreach $srcItem ( @{$srcCss->getItems()} ){

		$ref = ref( $srcItem );

		if( $ref =~ /Style/ ){
			$item = $this->findStyle( $srcItem->getKeys() );
			if( $item ){
				if( $item->mergeAttributes( $srcItem ) ){
					$ret++;
				}
			} else {
				$this->addItem( new Parser::Css::Style( $srcItem ) );
				$ret++;
			}

		}elsif( $ref =~ /Directive/ ){
			$item = $this->findDirective( $srcItem );
			unless( $item ){
				$this->addItem( new Parser::Css::Directive( $srcItem ) );
				$ret++;
			}
		}
	}
	return $ret;
}

sub save{
	my $this = shift;
	my( $path );
	if( @_ ){	
		$path = $this->Path( shift );
	}else{
		$path = $this->Path();
	}
	unless( open( OUT, '>', $path )){
		print STDERR "Error open file '$path': $!\n";
		return undef;
	}

	foreach my $item ( @{$this->{'items'}} ){
		print OUT $item->Text();
	}
	
	close( OUT );
}

sub getAttribute{
	my( $this, $key, $attr ) = @_;

	my( $ret, $val );

	foreach my $item ( @{$this->{'items'}} ){
		unless( ref( $item ) =~ /Style/ ){
			next;
		}
		if( $item->inKeys( $key ) ){
			if( $val = $item->getAttribute( $attr ) ){
				$ret = $val;
			}
		}
	}	

	return $ret;
}

sub delAttributes{
	my( $this, $key, $attr, @attrs ) = @_;
	my $ret = 0;
	foreach my $item ( @{$this->{'items'}} ){
		unless( ref( $item ) =~ /Style/ ){
			next;
		}
		if( $item->inKeys( $key ) ){
			if(  $item->delAttributes( $attr, @attrs ) ){
				$ret++;
			}
		}
	}	
	return $ret;
}

1;
