package Parser::Css::Directive;

use strict;

sub new {
	my $class = shift;
	my $this = { 'text' => undef,
							 'command' => undef,
							 'argument' => undef
						 };
	bless( $this, $class );
	if( @_ ){
		my $src = shift;
		if( ref( $src )){
			$this->copyFrom( $src );
		} else {
			$this->Text( $src );
		}
	}
	return $this;
}

sub Text {
	my $this = shift;
	if( @_ ){
		$this->{'text'} = shift;
		$this->parse();
	}
	return $this->{'text'};
}

sub parse {
	my $this = shift;
	( $this->{'command'}, $this->{'argument'} ) = split(' ',$this->{'text'},2);
	$this->{'argument'} =~ s/;.*$//;
}

sub Command{
	my $this = shift;
	if( @_ ){
		$this->{'command'}=  shift;
	}
	return $this->{'command'};	
}

sub Argumnet{
	my $this = shift;
	if( @_ ){
		$this->{'argument'}=  shift;
	}
	return $this->{'argument'};	
}

sub copyFrom{
	my $this = shift;
	my $src = shift;
	if( ref( $src ) =~ /Directory/ ){
		$this->{'text'} = $src->Text();
		$this->Command( $src->Command() );
		$this->Argument( $src->Argument() );

	} else {
		$this->Text( ${$src} );
	}
	return $this;
}

sub isEquiv{
	my $this = shift;
	my $src = shift;
	unless( ref($src)=~/Directive/){
		return undef;
	}

	return ( $this->Command() eq $src->Command() && 
					 $this->Argument() eq $src->Argument() )? 1: 0;
}

1;
