package sql::Field;

########## Confixx(R) 3.0 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####

use strict;

my	@updates = (['tinyint','smallint','int','bigint']);

sub new {
  my $classname = shift;
  
  my $args={};

  if ( @_ == 1 ) { ## only one parameter
    $args->{'sql'} = shift;

  }else{
    $args = {'name'=>'',
						 'sql'=>'',
						 @_
						};
  }

  my $this = {'name' => $args->{'name'},
							'sql' => $args->{'sql'},
						 };
  bless ($this,$classname);
  return $this;
}

sub Name {
  my $this = shift;
  if ( @_ ) {
    $this->{'name'} = shift;
  }
  return $this->{'name'};
}

sub Type {
  my $this = shift;
  if ( @_ ) {
    $this->{'type'} = shift;
  }
  return $this->{'type'};
}

sub Default {
  my $this = shift;
  if ( @_ ) {
    $this->{'default'} = shift;
  }
  return $this->{'default'};
}

sub NotNull {
  my $this = shift;
  if ( @_ ) {
    $this->{'notnull'} = shift;
  }
  return $this->{'notnull'};
}

sub AutoInc {
  my $this = shift;
  if(@_){
    $this->{'autoinc'} = shift;
  }
  return $this->{'autoinc'};
}

sub ID {
  my $this = shift;
  if( @_ ){
    $this->{'id'} = shift;
  }
  return $this->{'id'};
}

sub Unique {
  my $this = shift;
  if( @_ ){
    $this->{'unique'} = shift;
  }
  return $this->{'unique'};
}

sub SQL {
  my $this = shift;
  if( @_ ){
    $this->{'sql'}=shift;
  }
  return $this->{'sql'};
}

sub getSQL {
  my $this = shift;
  my $sql = $this->{'sql'};
  $sql =~ s/^\s+//;
  while (chomp $sql){
    $sql =~ s/--.*$//;
  }
  $sql =~ s/,$//;
  return $sql;
}


sub parseSQL {
  my $this = shift;
  my $sql = shift||$this->{'sql'};

  $sql =~ s/,$//;
  $sql =~ s/\);$//; ## last field

  return 1 unless $sql;

#
# get name of field
#
	if($::dbType eq 'Pg'){
		unless ( $sql =~ s/^\s*("[^"]+"|\S+)\s+// ) { ## `...` or XX...X
			print STDERR "Field: parse error: field's name is not found: $sql\n";
			return 0;
		}
		$this->{'name'} = $1;
		$this->{'name'} =~ s/^"(.*)"$/$1/;
	}else{
		unless ( $sql =~ s/^\s*(`[^`]+`|\S+)\s+// ) { ## `...` or XX...X
			print STDERR "Field: parse error: field's name is not found: $sql\n";
			return 0;
		}
		$this->{'name'} = $1;
		$this->{'name'} =~ s/^`(.*)`$/$1/;
	}

  unless ( $sql =~ s/^(\S+)(?=[ (]|$)// ) {
    print STDERR "Field (".$this->{'name'}."): parse error: type is not found: $sql\n";
    return 0;
  }
  $this->{'type'} = $1;
  if ( $sql =~ s/^\s*(?=\()// ) {
    unless ( $sql =~ s/\(((?:'(?>[^']*)(?>['\]'[^']*)*'|"(?>[^"]*)(?>["\]"[^"]*)*"|[^'"]*)*)\)//){
      print STDERR "Field (".$this->{'name'}."): parse error:  field's type is not completed: '$sql'\n";
      return 0;
    }
    $this->{'type'} .= "($1)";
  }
	if( $this->{'type'} =~ /serial/i ){ ## postgres type
    $this->{'id'} = 1;
	}

  if ( $sql =~ s/\s+auto_increment(?=\s|$)//i ) {
    $this->{'autoinc'} = 1;
  }
  if ( $sql =~ s/\s+primary\s+key(?=\s|$)//i ) {
    $this->{'id'} = 1;
  }
  if ( $sql =~ s/\s+not\s+null(?=\s|$)//i ) {
    $this->{'notnull'} = 1;
  }

  if ( $sql =~ s/\s+unique(?=\s|$)//i ) {
    $this->{'unique'} = 1;
  }

  if ( $sql=~s/^\s+default\s+//i ) {
    if ( $sql =~ /^(?=['"])/ ) {
      if ( $sql =~ s/((?:'(?>[^']*)(?>['\]'[^']*)*'|"(?>[^"]*)(?>["\]"[^"]*)*")*)// ) {
				$this->{'default'}=$1;
      } else {
				print STDERR "Field (".$this->{'name'}."): parse error: wrong argument for 'default': $sql\n";
      }

    }else {
      if ( $sql =~ s/(\S+)// ) {
				$this->{'default'} = $1;
      } else {
				print STDERR "Field (".$this->{'name'}."): parse error: wrong argument for 'default': $sql\n";
      }
    }
  } elsif ( $sql =~ s/^\s+references\s+//i ) {
    if ( $sql =~ s/(\S+\([^)(]+\))// ) {
      $this->{'ref'} = $1;
    } else {
      print STDERR "Field (".$this->{'name'}."): parse error: wrong argument for 'references': $sql\n";

    }
  }

  return 1;
}


sub toText {
  my $this = shift;
  my $prefix = shift||'';
  my ($key,$value);
  my $ret = '';
  while ( ($key,$value) = each %{$this} ) {
    $ret .= "$prefix$key\t=\t$value\n";
  }
  return $ret;
}

sub copyFrom {
  my $this = shift;
  my $from = shift;
  if ( ref($from) =~ /Table/ ) {
    $this->{'name'} = $from->Name;
    $this->{'type'} = $from->Type;
    $this->{'sql'} = $from->SQL;
    $this->{'default'} = $from->Defaul;
    $this->{'notnull'} = $from->NotNull;
    $this->{'autoinc'} = $from->AutoInc;
    $this->{'id'} = $from->ID;
    return 1;
  }else{
    return 0;
  }
}

sub clone {
  my $this = shift;
  my $clone = sql::Field->new;
  $clone->copyFrom($this);
  return $clone;
}


sub needUpdate {
  my $this = shift;
	my $dst = shift;
	return 0 unless ( ref($dst) =~ /Field/ );
		
	my $srcType = $this->{'type'};
	my $dstType = $dst->Type();

	return 0 if $srcType eq $dstType; ## optimization

	my( $srcLen, $dstLen );

	if( $srcType =~ /^(.+)\s*\(\s*(.+)\s*\)/ ){
		$srcType = $1;
		$srcLen = $2;
	}

	if( $dstType =~ /^(.+)\s*\(\s*(.+)\s*\)/ ){
		$dstType = $1;
		$dstLen = $2;
	}

	if( $dstType =~ /char/i ){
		return 1 unless $srcType =~ /char/i;
		if( $dstLen > $srcLen ){
			return 1; ## erlang the field
		}else{
			return 0;
		}

	}else{
		my ($ptrOrder, $type, $state);

		foreach $ptrOrder (@updates) {
			$state = 0;
			foreach $type (@{$ptrOrder}) {
				if ( $state ) {
					if ( $type eq $dstType ) {
						return 1; ## need update to destination type
					}
				} elsif ( $type eq $srcType ) {
					$state = 1;
				}
			}
		}
	}
	return 0;
}

1;
