<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

include_once( 'auth.php' );
include_once( '../include/class.SQLString.php' );
include_once( '../include/elements/data/class.SetOfRowsData.php' );
include_once( '../include/elements/data/class.HTMLDataField.php' );
include_once( '../include/elements/data/class.TextDataField.php' );
include_once( '../include/elements/data/class.OptionsDataField.php' );
include_once( '../include/elements/data/class.CompoundDataField.php' );
include_once( '../include/elements/html/class.MainPageElement.php' );
include_once( '../include/elements/html/module.Constants.php' );

global $DEBUG;
//$DEBUG=1;

## mysql verbindung aufbauen
db_connect($db_host, $db_user, $db_pass);
## /mysql verbindung aufbauen

# checken ob zielanbieter existiert
$id = safe_query( "select anbieter from anbieter where anbieter = ?  AND server_id='$ServerID'", 
                  TRUE, new SQLString( $zielanbieter ) );
if (db_num_rows($id) < 1)
	{
	 $fehlertext = ltext("anku2_error1");
	 db_close();
	 include("anbieter_kundenzuordnung.php");
	 exit();
	}
# /checken ob zielanbieter existiert und ob dieser kunden hat

# checken ziel- oder quellanbieter gesperrt sind
$id1 = safe_query( "select anbieter from anbieter where anbieter = ?  and gesperrt='1' AND server_id='$ServerID'", 
                    TRUE, new SQLString( $zielanbieter ) );
$id2 = safe_query( "select anbieter from anbieter where anbieter = ?  and gesperrt='1' AND server_id='$ServerID'", 
                    TRUE, new SQLString( $quellanbieter ) );
if ((db_num_rows($id1) > 0) || (db_num_rows($id2) > 0))
	{
	 $fehlertext = ltext("anku2_error2");
	 db_close();
	 include("anbieter_kundenzuordnung.php");
	 exit();
	}
#/

if (istleer($kunde)) {

# checken ob quellanbieter existiert
$id = safe_query( "select anbieter from anbieter where anbieter = ?  AND server_id='$ServerID'", 
                  TRUE, new SQLString( $quellanbieter ) );
if (db_num_rows($id) < 1)
	{
	 $fehlertext = ltext("anku2_error3",array($anbieter));
	 db_close();
	 include("anbieter_kundenzuordnung.php");
	 exit();
	}

$id = safe_query( "select kunde from kunden where anbieter = ?  AND server_id='$ServerID'", 
                    TRUE, new SQLString( $quellanbieter ) );
if (db_num_rows($id) < 1) 
	{
	 $fehlertext = ltext("anku2_error4",array($quellanbieter));
	 db_close();
	 include("anbieter_kundenzuordnung.php");
	 exit();
	}

if ($quellanbieter == $zielanbieter)
	{
	 $fehlertext = ltext("anku2_error5");
	 db_close();
	 include("anbieter_kundenzuordnung.php");
	 exit();
	}

# /checken ob quellanbieter existiert und ob dieser kunden hat

# anzahl ipadressen checken
$id = safe_query( "select count(ip) as ipanzahl from ipadressen where anbieter = ?  and kunde != '' AND server_id='$ServerID'", 
                  TRUE, new SQLString( $quellanbieter ) );
$werte = db_fetch_array($id);
$anzahlips = $werte["ipanzahl"];
# /anzahl ipadressen checken

$satz = ltext("anku2_confirmation1",array($quellanbieter,$zielanbieter));

if 	($anzahlips == 1)
	{
	 $satz .= ltext("anku2_confirmation2",array($quellanbieter,$zielanbieter));
	}
elseif ($anzahlips > 1)
	{
	 $satz .= ltext("anku2_confirmation2",array($anzahlips,$quellanbieter,$zielanbieter));
	}
$kundenliste = array();
## kundenliste erstellen
$id = safe_query( "select kunde from kunden where anbieter = ?  AND server_id='$ServerID'", 
                    TRUE, new SQLString( $quellanbieter ) );
while ($werte = db_fetch_array($id)) {
$kundenliste[] = $werte["kunde"];
}
## /kundenliste erstellen

} else {

if($kunde==$user_prefix.'0'	){
	 $fehlertext = ltext("anku2_forbidden",array($kunde));
	 db_close();
	 include("anbieter_kundenzuordnung.php");
	 exit();
}	

# checken ob kunde existiert
$id = safe_query( "select kunde from kunden where kunde = ?  AND server_id='$ServerID'", TRUE, new SQLString( $kunde ) );
if (db_num_rows($id) < 1)
	{
	 $fehlertext = ltext("anku2_error6");
	 db_close();
	 include("anbieter_kundenzuordnung.php");
	 exit();
	}
# /checken ob kunde existiert

# anzahl ipadressen checken
$id = safe_query( "select count(ip) as ipanzahl from ipadressen where kunde = ?  AND server_id='$ServerID'", 
                  TRUE, new SQLString( $kunde ) );
$werte = db_fetch_array($id);
$anzahlips = $werte["ipanzahl"];
# /anzahl ipadressen checken

# quellanbieter f�r satz ermitteln
$id = safe_query( "select anbieter from kunden where kunde = ?  AND server_id='$ServerID'", TRUE, new SQLString( $kunde ) );
$werte = db_fetch_array($id);
$quellanbieter = $werte["anbieter"];
# /quellanbieter f�r satz ermitteln

if ($quellanbieter == $zielanbieter)
	{
	 $fehlertext = ltext("anku2_error7",array($kunde,$quellanbieter));
	 db_close();
	 include("anbieter_kundenzuordnung.php");
	 exit();
	}

$satz = ltext("anku2_confirmation4",array($kunde,$quellanbieter,$zielanbieter));

if 	($anzahlips == 1)
	{
	 $satz .= ltext("anku2_confirmation5",array($quellanbieter,$zielanbieter));
	}
}

$data = new SetOfRowsData();
for ($i = 0; $i < count($kundenliste); $i++) {
	$data->AppendRow(new HTMLDataField("<b>".htmlspecialchars( $kundenliste[$i] )."</b>"));
}
$data->AppendRow(
	new OptionsDataField(array("ja"=>ltext("anku2_descr1"),"nein"=>ltext("anku2_descr2")),
		"nein","transferieren",cc_RadioGroupPresentation ));

$data->AppendHidden(new TextDataField($quellanbieter,"quellanbieter"));
$data->AppendHidden(new TextDataField($zielanbieter,"zielanbieter"));
$data->AppendHidden(new TextDataField($kunde,"kunde"));
$data->AppendButton(ltext("anku2_button1"), "javascript:doChange()", cc_IDOk );


$form=$data->GetInputPresentation(array( "action"=>"anbieter_kundenzuordnung3.php", "method"=>"post" ),
	$lang_text["anku_title1"]);
	
$form->AppendTop($satz);

$page = new MainPageElement( $form);
$page->OutputHTML();

db_close();

?>
