<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

include_once( 'auth.php' );
include_once( '../include/elements/data/class.SetOfRowsData.php' );
include_once( '../include/elements/data/class.PagedSetOfRowsData.php' );
include_once( '../include/elements/data/class.HTMLDataField.php' );
include_once( '../include/elements/data/class.TextDataField.php' );
include_once( '../include/elements/data/class.LinkDataField.php' );
include_once( '../include/elements/html/class.MainPageElement.php' );

global $DEBUG;

if( ! is_numeric( $step ) || ( $step < 1 ) ){
	$step = 25;
}

if( ! is_numeric( $start ) || ( $start < 0 ) ){
	$start = 0;
}

if( is_numeric( $next ) ){
	$start += $next;
	$step = $next;
}elseif( is_numeric( $prev ) ){
	$start -= $prev;
	$step = $prev;
}

if( $start < 0 ){
	$start = 0;
}

$db =& get_db_connection();

$data = new SetOfRowsData();
$page = new MainPageElement();

if( ! isset( $kunde ) ){
	$kunde = '';
}

$data->AppendRow( new HTMLDataField( ltext( 'eihtku_cell_user' ) ),
									new TextDataField( $kunde, 'kunde' ) );

$data->AppendHidden( new TextDataField( $step, 'step' ) );	
$data->AppendButton( ltext('eihtku_button1' ), 
										 "javascript:doChange()",
										 cc_IDOk );	

$page->AppendToContent( $data->GetInputPresentation( array( 'action' => 'einstellungen_httpd_kunde.php' ),
																									  ltext( 'eiht_cell_user' ) ) );

//---------------------------------------------------

$zeilen = 0;

if( $kunde ){
	$id = safe_query2( "SELECT kunde FROM kunden WHERE kunde = ? AND server_id='$ServerID'",
										 new SQLString( $kunde ) );
	$zeilen = db_num_rows( $id );
	db_free_query( $id );

	$kunde = strtolower($kunde);	
	$lcKundeQuotted = db_quote($kunde);
	$where = "WHERE LOWER(kunde) LIKE '%$lcKundeQuotted%' AND server_id='$ServerID'";

}else{
	$where=" WHERE server_id='$ServerID'";
}	

if( $zeilen == 1 ){ // found
	include( 'einstellungen_httpd_kunde_aendern.php' );
	exit();
}

$total = 0;
$la_list = array();

if( $where ){
	$lo_user = new SQLString( "%$kunde%" );
	$id = safe_query2( " SELECT k.kunde, k.name, k.anbieter, d.domain  FROM domains d, kunden k " .
										 " WHERE k.server_id='$ServerID' AND d.server_id='$ServerID' ".
                     " AND d.domain LIKE ? AND d.richtigedomain = 1 ".
										 " AND d.kunde=k.kunde", $lo_user );
              		
	$id3 = safe_query( "SELECT kunde,name,anbieter FROM kunden " .
		                 " WHERE server_id='$ServerID' AND LOWER(name) LIKE ? ".
                     " ORDER BY number", $lo_user );
		
	if( ( db_num_rows( $id ) + db_num_rows( $id3 ) ) < 1 ){
		 $fehlertext = ltext( 'eihtkusu_error1' );
		 $total = 0;
	}

	while( $row = db_fetch_array( $id3 ) ){
		$ls_key = sprintf( "%s%16s", $row["anbieter"],$row["kunde"]);
    
		$la_list[$ls_key] = array( 'anbieter' => $row['anbieter'],
															 'kunde' => $row['kunde'],
															 'name' => $row['name']);
	}
  
	db_free_query( $id3 );

	$ll_Insert = 0;
	while( $row = db_fetch_array( $id ) ){
		$ls_key = sprintf("%s%16s",$row["anbieter"],$row["kunde"]);
		if( ! array_key_exists( $ls_key, $la_list ) ){
			$la_list[$ls_key] = array( 'anbieter' => $row['anbieter'],
																 'kunde' => $row['kunde'],
																 'name' => $row['name']);
			$ll_Insert = 1;
		}
	}
	db_free_query( $id );

	if( $ll_Insert ){  // sort by reseller+user
		ksort( $la_list );	
	}
	$total = count($la_list);
  
//----------------- extract page -----------------------		
	if( $total>1 ){

		$i = 0;
		$la_temp = array();
		$stop = $start+$step;
		reset( $la_list );
		foreach( $la_list as $ls_key => $la_values ){
			if( $i >= $start && $i < $stop ){
				$la_temp[$ls_key] = $la_values;
			}
			$i++;
		}

		if( count( $la_temp ) < 1 ){  // go to first page
			$start = 0;
			$i = 0;
			reset( $la_list );
			foreach( $la_list as $ls_key => $la_values ){
				if( $i < $step ){
					$la_temp[$ls_key] = $la_values;
				} else {
					break;
				}	
				$i++;
			}	
		}
		$la_list = $la_temp;
	}
//----------------- end extract page -----------------------		

}

if( $total == 1 ){

  $tmp = current( $la_list );
  $kunde = $tmp['kunde'];
	include( 'einstellungen_httpd_kunde_aendern.php' );
	exit();
}elseif( $total < 1 ){
	$sql = "select count(*) from kunden $where";
	$res =& $db->Select ("select count(*) from kunden $where");
	$row = $res->nextrow();
	$total = $row[0];
	$res->Close();
	$pageNumber = (int)( $start / $step );
	$sql = "select kunde,name,anbieter from kunden $where order by anbieter,kunde";
	$res =& $db->Select ($sql,$step,$pageNumber);
	while($row = $res->nextrow()){
		$ls_key=sprintf("%s%16s",$row["anbieter"],$row["kunde"]);
		$la_list[$ls_key]=array("anbieter"=>$row["anbieter"],
				"kunde"=>$row["kunde"],"name"=>$row["name"]);
	}
	$res->Close();
}	



$data = new PagedSetOfRowsData(new LinkDataField("einstellungen_httpd_kunde.php","",
			array("kunde"=>$kunde)));

$data->SetStart($start);
$data->SetStep($step);
$data->SetTotal($total);


$data->AppendHeaderRow(
	new HTMLDataField(ltext("eihtkusu_cell_user")),
	new HTMLDataField(ltext("eihtkusu_cell_name")),
	new HTMLDataField(ltext("eihtkusu_cell_domains")),
	new HTMLDataField(ltext("eihtkusu_cell_reseller")),
	new HTMLDataField(ltext("eihtkusu_cell_select"))
);
$i = $start;
reset($la_list);
foreach($la_list as $ls_key=>$la_values){
	
	$ls_kunde = $la_values["kunde"];
	$ls_name = $la_values["name"];
	if(!$ls_name){
		$ls_name = "<font color=#666666>".ltext("eihtkusu_noname")."</font>";
	}
//------------ domains of user ----------------------------	
	
	$res =& $db->Select ("SELECT domain from domains where kunde='$ls_kunde' and richtigedomain=1 AND server_id='$ServerID'");
	
	$la_domains=array();
	if($res){
		while($row = $res->nextrow()){
			$la_domains[]=$row[0];
		}	
		$res->Close();
	}	
	if(count($la_domains)){
		$ls_domains=join('<br>',$la_domains);
	}else{
		$ls_domains="<font color=#666666>".ltext("eihtkusu_nodomain")."</font>";
	}
//------------ end domains of user ----------------------------		

	$data->AppendRow(new HTMLDataField($ls_kunde),
		new HTMLDataField($ls_name),
		new HTMLDataField($ls_domains),
		new HTMLDataField($la_values["anbieter"]),
		new LinkDataField("einstellungen_httpd_kunde_aendern.php","",
			array("kunde"=>$ls_kunde),ltext('eihtkusu_cell_select'))
	);
	$i++;
}

$table = $data->GetOutputPresentation(($start+1)." - $i ($total)");

$page->AppendToContent($table);

$page->OutputHTML();

?>
