<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

include_once( 'auth.php' );
include_once( '../include/elements/data/class.SetOfRowsData.php' );
include_once( '../include/elements/data/class.LongTextDataField.php' );
include_once( '../include/elements/data/class.HTMLDataField.php' );
include_once( '../include/elements/data/class.TextDataField.php' );
include_once( '../include/elements/data/class.CheckDataField.php' );
include_once( '../include/elements/html/class.MainPageElement.php' );

global $DEBUG;

if( $DEBUG ){
	echo "settings_ssl2<br>\n";
}

db_connect();

/**
 * Values of $type:
 *
 * 1 - private key & certificate
 * 0 - self-signed certificate ( Please complete the following form. 
 * Your private key and the certificate request (CSR) will automatically be generated.) 
 * 2 - self-signed certificate 
 */

if( $type ){

	if( $type == 2 ){
		$id = safe_query2( "SELECT privatekey, crt FROM cssl WHERE kunde = 'admin' AND server_id='$ServerID'");
		list( $privatekey, $crt) = db_fetch_array( $id, 'N' );
		db_free_query( $id );
	}else{
		$privatekey = '';
		$crt = '';
		$ca = '';
	}

	$loData = new SetOfRowsData();
	$loData->AppendRow( new HTMLDataField( ltext("stssl_cell_privatekey") ), 
	   							  	new LongTextDataField( $privatekey, "privatekey" ) 
									 );
	$loData->AppendRow( new HTMLDataField( ltext("stssl_cell_crt") ), 
		  								new LongTextDataField( $crt, "crt" ) 
								  );

  if( $type == 1 ){
    $loData->AppendRow( new HTMLDataField( ltext("stssl_cell_ca_crt") ), 
		    								new LongTextDataField( $ca, "ca" ) 
				      			  );
  }
	$loData->AppendButton( ltext("stssl_btn_save"), 
											 "javascript:doChange()", 
											 cc_IDOk  );

	$loData->AppendHidden( new TextDataField( $type, "type" ) );
	$lcHelp = ltext('stssl_help_crt');

 }else{
	$id = safe_query2( "SELECT * FROM cssl WHERE kunde = 'admin' AND server_id='$ServerID'");
	
	if( db_num_rows( $id ) ){
		$row = db_fetch_array( $id );
		$firm = $row['firm'];
		$unit = $row['unit'];
		$city = $row['city'];
		$state = $row['state'];
		$countrycode = $row['countrycode'];
		$email = $row['email'];
		$common = $row['common'];
		$domain = $row['domain'];
	}
	db_free_query( $id );

	$loData = new SetOfRowsData();
	$loData->AppendRow( new HTMLDataField( ltext("stssl_cell_firm") ), 
										new TextDataField( $firm, "firm" ) );
	$loData->AppendRow( new HTMLDataField( ltext("stssl_cell_unit") ), 
										new TextDataField( $unit, "unit" ) );
	$loData->AppendRow( new HTMLDataField( ltext("stssl_cell_city") ), 
										new TextDataField( $city, "city" ) );
	$loData->AppendRow( new HTMLDataField( ltext("stssl_cell_state") ), 
										new TextDataField( $state, "state" ) );
	$loData->AppendRow( new HTMLDataField( ltext("stssl_cell_countrycode") ), 
										new TextDataField( $countrycode,"countrycode" ) );
	$loData->AppendRow( new HTMLDataField( ltext("stssl_cell_email") ), 
										new TextDataField( $email, "email" ) );
	$loData->AppendRow( new HTMLDataField( ltext("stssl_cell_common") ), 
										new TextDataField( $common, "common" ) );

	$loSelfSigned = new CheckDataField( 1, "selfsigned" );
	$loSelfSigned->isChecked(1);
	$loData->AppendRow( new HTMLDataField( ltext("stssl_cell_selfsigned") ), 
										$loSelfSigned );

	$loData->AppendButton( ltext("stssl_btn_next"), 
											 "javascript:doChange()", 
											 cc_IDNext 
											 );

	$loData->AppendHidden( new TextDataField( $type, "type" ) );

	$lcHelp = ltext('stssl_help_crs');

 }

$loForm = $loData->GetInputPresentation( array( "action" => "settings_ssl_make.php",
																							"method" => "post" ), 
																			 $lcHelp );

$page = new MainPageElement( $loForm );

$page->OutputHTML();
?>
