<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
##### http://www.swsoft.com - info@swsoft.com #####

include_once( 'auth.php' );
include_once( 'defines.php' );
include_once( '../include/data_source/class.SQLQuery.php' );
include_once( '../include/data_source/class.CompoundValue.php' );
include_once( '../include/data_source/class.ValueLocale.php' );
include_once( '../include/data_source/class.ValueFromArray.php' );
include_once( '../include/data_source/class.ValueFormated.php' );
include_once( '../include/data_source/class.ConversedDBValue.php' );
include_once( '../include/data_source/class.DataValue.php' );
include_once( '../include/elements/data/class.ToolsButtons.php' );
include_once( '../include/elements/data/class.ToolsButtonData.php' );
include_once( '../include/elements/data/class.HTMLDataField.php' );
include_once( '../include/elements/data/class.CompoundDataField.php' );
include_once( '../include/elements/data/class.CheckDataField.php' );
include_once( '../include/elements/data/class.ButtonData.php' );
include_once( '../include/elements/data/class.TextDataField.php' );
include_once( '../include/elements/data/class.PagedTableView.php' );
include_once( '../include/elements/data/class.IconDataField.php' );
include_once( '../include/elements/html/class.MainPageElement.php' );
include_once( '../include/elements/html/class.CompoundElement.php' );
include_once( '../include/elements/html/class.PPButtonElement.php' );
include_once( '../include/elements/html/class.ButtonURLElement.php' );
include_once( '../include/elements/html/class.SimpleSearchElement.php' );
include_once( '../include/event_functions.php' );
include_once( '../include/elements/html/module.Constants.php' );

$lcLangFile = "../languages/$shortlang/webapp.inc.php";

if( is_readable( $lcLangFile ) ){
  include_once( $lcLangFile );
}

global $DEBUG;
//$DEBUG=1;

if( $DEBUG ){
  echo "webapp.php: _POST<br><pre>\n";
  print_r( $_POST );
  echo "</pre><hr>\n";
}

db_connect();
 
$id = db_query( "SELECT webapp FROM admin WHERE server_id='$ServerID'");
list( $skwebapp ) = db_fetch_array($id);
db_free_query( $id );

if( ! $skwebapp ){
  db_close();
  include( 'feature_unavailable.php' );
  exit;
 }

if( isset( $action ) ){
  switch( $action ){
  case 'on':
    safe_query2( "UPDATE webapp SET status=1 WHERE id=? AND server_id='$ServerID'",
                 new SQLInteger( $webapp_id ));
    break;
  case 'off':
    safe_query2( "UPDATE webapp SET status=0 WHERE id=? AND server_id='$ServerID'",
                 new SQLInteger( $webapp_id ));
    break;
  case 'group_on':
    if( isset( $webapp_ids ) && is_array( $webapp_ids ) ){
      foreach( $webapp_ids as $webapp_id ){
        safe_query2( "UPDATE webapp SET status=1 WHERE id=? AND server_id='$ServerID'",
                 new SQLInteger( $webapp_id ));
      }
    }
    break;
  case 'group_off':
    if( isset( $webapp_ids ) && is_array( $webapp_ids ) ){
      foreach( $webapp_ids as $webapp_id ){
        safe_query2( "UPDATE webapp SET status=0 WHERE id=? AND server_id='$ServerID'",
                 new SQLInteger( $webapp_id ));
      }
    }
    break;
  case 'update':
    eventAdd( $OBJECT_WEBAPP, $EVENT_UPDATE );
    
    $fehlertext = ltext( 'wa_update_ok' );
    break;
  }
 }


//=======================================================
//
//

$loToolsData = new ToolsButtons( new ToolsButtonData( 'menu_head_webapp_update', ltext( 'wa_update' ),
                                                      'webapp.php',
                                                      array( 'action'=>'update' ) 
                                                     )
                               );
$loToolsData->Legend( ltext( 'wa_tools' ) );
$loTools = $loToolsData->GetInputPresentation();


//
//
//===============================================================
//
//

if( is_array( $_POST ) && count( $_POST ) ){
  initPagingSettings( $_POST, array( 'webapp_to_search' => $webapp_to_search,
                                     'page_size' => $page_size,
                                     'start_index' => $start_index ) );
 }else{
  if( ! isset( $page_size ) ){
    $pages_size = 10;
  }
  if( ! isset( $start_index ) ){
    $start_index = 1;
  }
 }


//Sort settings 
if( ! isset( $direction ) ){
  $direction = 'asc';
 }
if( ! isset( $order ) ){
  $order = 'name';
 }
$lcDirIcon = ( $direction =='desc' ) ? cc_DescIcon : cc_AscIcon;
$lcNewDir =  ( $direction =='desc' ) ? 'asc' : 'desc';

switch( $order ){
 case 'name':
   $lcOrder = 'w.name';
   if ( $direction == 'desc' ) $lcOrder .= ' DESC';
   break;
 case 'status':
   $lcOrder = 'w.status';
   if ( $direction == 'desc' ) $lcOrder .= ' DESC';
   break;
 case 'type':
   $lcOrder = 'k.type';
   if ( $direction == 'desc' ) $lcOrder .= ' DESC';
   break;
 }

$lcFromJoin = " FROM webapp w LEFT JOIN webapp_knowledge k ON (w.name=k.webapp AND w.server_id=k.server_id)";
$lcSQL = "SELECT COUNT(w.id) FROM webapp w WHERE server_id='$ServerID'";
$id = db_query( $lcSQL );
list( $total_number ) = db_fetch_array( $id );
db_free_query( $id );

$lcWhere   = '';
$laArgs    = array();
$lcFields  = " w.id, w.name, w.version, w.descr, w.status, k.type  ";

if( isset( $webapp_to_search ) && $webapp_to_search ){
  $loName = new SQLValue( $webapp_to_search, 'S' );
  $laArgs = array( $loName, $loName, $loName );
  $lcWhere = " w.server_id='$ServerID' AND ( w.name LIKE '%?%' OR w.descr LIKE '%?%' OR k.type LIKE '%?%') ";
}

if( ! istleer( $webapp_type ) ){
  if( $lcWhere ){
    $lcWhere .= " AND k.type = ? ";
  }else{
    $lcWhere .= " k.type = ? ";
  }
  $laArgs[] = new SQLValue( $webapp_type, 'C' );
}

if( $lcWhere ){
  $lcSQL = " SELECT COUNT(w.id) FROM webapp w ".
           " LEFT JOIN webapp_knowledge k ".
           " ON ( w.name=k.webapp AND w.server_id=k.server_id ) WHERE $lcWhere ORDER BY $lcOrder";
  $loQuery = new SQLQuery( $lcSQL, $laArgs );
  $loQuery->doQuery();
  list( $total_number ) = $loQuery->fetchArray('N');
  $loQuery->finish();

  $lcSQL = "SELECT $lcFields ".$lcFromJoin." WHERE ".$lcWhere." ORDER BY ".$lcOrder;
  $loQuery->Query( $lcSQL );
  $loQuery->Parameters( $laArgs );
} else {
  $lcSQL = "SELECT $lcFields ".$lcFromJoin." WHERE w.server_id='$ServerID' ORDER BY $lcOrder";
  $loQuery = new SQLQuery( $lcSQL, array( new SQLValue($PHP_AUTH_USER,'C') ) );
}

$laContent = array();
if( $order == 'name' ) {
  $laContent['name'] = new CompoundDataField( new HTMLDataField( ltext( 'wa_name' )),
                                             new IconDataField( $lcDirIcon ));
  $laContent['name']->SetSeparator('');
 } else {
  $laContent['name'] = new HTMlDataField( ltext( 'wa_name' ) );
 }
if( $order == 'status' ) {
  $laContent['status'] = new CompoundDataField( new HTMLDataField( ltext( 'wa_status' )),
                                             new IconDataField( $lcDirIcon ));
  $laContent['status']->SetSeparator('');
 } else {
  $laContent['status'] = new HTMlDataField( ltext( 'wa_status' ) );
 }
if( $order == 'type' ) {
  $laContent['type'] = new CompoundDataField( new HTMLDataField( ltext( 'wa_type' )),
                                             new IconDataField( $lcDirIcon ));
  $laContent['type']->SetSeparator('');
 } else {
  $laContent['type'] = new HTMlDataField( ltext( 'wa_type' ) );
 }


$listFormIndex = 0;

$loDS = new ConversedDBValue( $loQuery, $page_size, $start_index - 1 );
$loDS->TotalNumber( $total_number );

$loTemplate = new CompoundValue( new CompoundValue( new ValueFromArray( 'status' ),
                                                    new ValueFromArray( 'id' )
                                                    ),
                                 new ValueFromArray( 'name' ),
                                 new ValueFromArray( 'version' ),
                                 new ValueFromArray( 'type' ),
                                 new CompoundValue( new ValueFromArray( 'name' ),
                                                    new ValueFromArray( 'descr' ) ),
                                 new CompoundValue( new ValueFromArray( 'status' ),
                                                    new ValueFromArray( 'id' )
                                                    ),
                                 new CompoundValue( new ValueFromArray( 'status' ),
                                                    new ValueFromArray( 'id' )
                                                    )

                                 );
$loCheckBox = new CheckDataField( 1, 'selectAll' );
$loCheckBox->Attribute('onclick', "javascript:checkedAll('webapp_ids', this.checked, $listFormIndex)");
$loCheckBox->SetParentAttributes(array('align'=>'center'));

$loSelValue = new DataValue( 'selectAll', 1, $loCheckBox );
$loSelValue->setTypeOfPresentation( 'Input' );

$loTitle = new CompoundValue( new DataValue( 'status', 
                                             NULL, 
                                             new LinkDataField( "javascript:setValue('order','status',$listFormIndex);".
                                                                "setValue('start_index',1,$listFormIndex);".
                                                                "submitForm('direction','$lcNewDir',$listFormIndex)",
                                                                '',
                                                                array(),
                                                                $laContent['status']
                                                                )
                                             ),
                              new DataValue( 'name', 
                                             NULL, 
                                             new LinkDataField( "javascript:setValue('order','name',$listFormIndex);".
                                                                "setValue('start_index',1,$listFormIndex);".
                                                                "submitForm('direction','$lcNewDir',$listFormIndex)",
                                                                '',
                                                                array(),
                                                                $laContent['name']
                                                                )
                                             ),
                              new ValueLocale( 'wa_version' ),
                              new DataValue( 'type', 
                                             NULL, 
                                             new LinkDataField( "javascript:setValue('order','type',$listFormIndex);".
                                                                "setValue('start_index',1,$listFormIndex);".
                                                                "submitForm('direction','$lcNewDir',$listFormIndex)",
                                                                '',
                                                                array(),
                                                                $laContent['type']
                                                                )
                                             ),
                              new ValueLocale( 'wa_descr' ),
                              new ValueLocale( 'wa_conf' ),
                              $loSelValue
                              );
$laWidths = array( '10%', '15%', '10%', '10%', '45%', '10%' ); 
$loDS->Template( $loTemplate );

$gcStatusOff = ltext( 'wa_status_to_off' );
$gcStatusOn = ltext( 'wa_status_to_on' );

function &makeStatus( &$poSrc ){/*{{{*/

  global $gcStatusOff,$gcStatusOn;
  global $confixx_interface_version;
  global $listFormIndex;

  list( $liStatus, $liId ) = $poSrc->listValue();
  $lcAction = '';
  switch( $liStatus ){
  case 1:
    $lcIcon = cc_OnIcon;
    $lcTitle = $gcStatusOff;
    $lcAction = 'off';
    break;
  default:
    $lcIcon = cc_OffIcon;
    $lcTitle = $gcStatusOn;
    $lcAction = 'on';
  }
  if( $confixx_interface_version == 'powp' ){
    $loIcon = new IconDataField( $lcIcon, 
                                 array( 'alt' => $lcTitle, 'title' => $lcTitle ), 
                                 array( 'align'=>'center') );
  } else {
    $loIcon = new HTMLDataField($lcTitle, FALSE, array(), array( 'align'=>'center'));
  }

  if( $lcAction ){
    $loLink = new LinkDataField( "javascript:setValue('webapp_id',$liId,$listFormIndex);".
                                 "submitForm('action','$lcAction',$listFormIndex)", 
                                 
                                 '',
                                 array(),
                                 $loIcon
                                 );
    $loLink->Attribute( 'title', $liStatus==1?$gcSwithToOff:$gcSwithToOn );
    $loLink->ParentAttribute( 'align', 'center' );
  }else{
    $loLink =& $loIcon; 
  }
    
  return $loLink;

}/*}}}*/

$gcConfig = ltext( 'wa_config' );
$gcHead = ltext( 'wa_config_head' );

function &makeConf( &$poSrc){/*{{{*/
  global $gcConfig, $gcHead;
  global $page_size,$start_index, $webapp_to_search;
  list( $liStatus, $liID ) = $poSrc->listValue();
      
  $loLink = new LinkDataField( 'webapp_conf.php',
                               '',
                               array( 'webapp_id' => $liID,
                                      'menu_node_id' => 'webapp_conf',
                                      'cur_page' => 'webapp_conf.php',
                                      'head_text' => $gcHead,
                                      'head_id' => 'webapp_conf',
                                      'page_size' => $page_size,
                                      'start_index' => $start_index,
                                      'webapp_to_search' => $webapp_to_search
                                      ),
                               new HTMLDataField( $gcConfig ) );

  return $loLink;
}/*}}}*/

function &makeSelect( &$poSrc ) {/*{{{*/
  list($liStatus,$liID) = $poSrc->listValue();
  $loCheckBox = new CheckDataField( $liID, 'webapp_ids[]');
  $loCheckBox->ParentAttribute('align','center');
  
  return array( $loCheckBox->GetInputPresentation(), array('align'=>'center'));
  
}/*}}}*/

function &makeDesc( $poDesc ){/*{{{*/
  global $lang_text;

  list( $lcName, $lcDesc ) = $poDesc->listValue();

  if( ! empty( $lang_text[$lcName] ) ){
    $loDesc = new HTMLDataField( ltext( $lcName ) ); 
  }else{
    $loDesc = new HTMLDataField( $lcDesc ); 
  }
  return $loDesc;
}/*}}}*/

// end formating funtions
//
//==========================================================

$loConv = new CompoundValue( new ValueFormated( 'status', NULL, 'makeStatus' ),
                             NULL,
                             NULL,
                             NULL,
                             new ValueFormated( 'desc', NULL, 'makeDesc' ),
                             new ValueFormated( 'conf', NULL, 'makeConf' ),
                             new ValueFormated( 'select', NULL, 'makeSelect' )
                             );
$loDS->Conversion( $loConv );


$loDS->doQuery();

$loPTV = new PagedTableView( $loDS, $total_number );
$loPTV->Title( $loTitle );
$loPTV->Widths( $laWidths );
$loPTV->setParameter( 'menu_node_id', $menu_node_id );
$loPTV->setParameter( 'cur_page', $cur_page?$cur_page:'' );
$loPTV->setParameter( 'head_text', $head_text );

$loPTV->setParameter( 'action', '' );
$loPTV->setParameter( 'webapp_id', '' );
$loPTV->setParameter( 'order', "$order" );
$loPTV->setParameter( 'direction', "$direction" );

if( isset( $name_to_search ) && $name_to_search ){
  $loPTV->NoItemsMessage(ltext('ll_empty_search'));
 } else {
  $loPTV->NoItemsMessage(ltext('ll_empty_list'));
 }

$loPTV->Anchor( 'list' );

$tbl = $loPTV->GetOutputPresentation( array( 'action' => 'webapp.php#list',
                                             'name' => 'list_apps' ), 
                                      ltext( 'wa_title' ) );
/**
 *  Added search elements
 */
$loType = new CompoundDBValue( new SQLQUery( " SELECT type AS webapp_type, type AS webapp_type FROM webapp_knowledge ".
                                             " WHERE type<>'' AND server_id='$ServerID' GROUP BY type" ) );
$loType->doQuery();
$loType->addValue( new KeyValue( 'webapp_type', '' ), new ValueLocale( 'wa_all_types' ) );

$dsSearch = new CompoundValue( new ValueFromArray( 'webapp_to_search', $webapp_to_search ),
                               $loType, 
                               new ValueLocale( 'll_search' ),
                               new ValueLocale( 'll_show_all' )
                               );

$loSearch = new SimpleSearchElement( array(), 
                                     new InputTextElement( array( 'name' => 'webapp_to_search', 
                                                                  'size' => '16',
                                                                  'value' => $mail_to_search,
                                                                  'MAXLENGTH'=> '32' ) ),
                                     new SelectElement( array( 'name' => 'webapp_type' ) ) );
  
$loGroup = new DivElement(array('class'=>'buttons'));
  

$loSearch->appendElement( new PPButtonElement( '', 
                                               "javascript:submitForm('start_index',1,$listFormIndex)", 
                                               'bid-search' 
                                               )
                          );
$loSearch->appendElement( new PPButtonElement( '', "javascript:setValue('webapp_to_search','',$listFormIndex);".
                                                   "setValue('webapp_type','',$listFormIndex );".
                                                   "submitForm('start_index',1,$listFormIndex)", 
                                                   'bid-show-all'
                                               ) 
                          );

$head_text = ltext('ll_delete');
$lcConfirm = ltext('ll_confirm_delete');
$lcNothing = ltext('ll_nothing');

  
$loSearch->setDataSource( $dsSearch, array( 'webapp_to_search' => $webapp_to_search,
                                            'webapp_type' => $webapp_type  ) );


$loGroup->AppendToContent( new PPButtonElement( $gcStatusOff,
																								"javascript:submitForm('action','group_off', $listFormIndex)",
																								'bid-deactivate' ) );
$loGroup->AppendToContent( new PPButtonElement( $gcStatusOn,
																								"javascript:submitForm('action','group_on',$listFormIndex)",
                                                'bid-activate') );

if( ( isset( $webapp_to_search ) && $webapp_to_search ) 
  || ! istleer( $webapp_type )
  || $total_number > 0 ){
  $tbl->setSearchElement( $loSearch );
 }
if ($total_number>0) {
  $tbl->setGroupActionElement( $loGroup );
 }

$tbl->updateBodyContent();

$page = new MainPageElement( $loTools, $tbl );

$page->OutputHTML( array( '../../js/paged_form.js' ) );

?>
