<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

include_once( 'auth.php' );
include_once( 'defines.php' );
include_once( '../include/data_source/class.SQLQuery.php' );
include_once( '../include/class.SQLFieldSet.php' );
include_once( '../include/elements/data/class.SetOfRowsData.php' );
include_once( '../include/elements/data/class.HTMLDataField.php' );
include_once( '../include/elements/data/class.TextDataField.php' );
include_once( '../include/elements/data/class.OptionsDataField.php' );
include_once( '../include/elements/data/class.YesNoDataField.php' );
include_once( '../include/elements/data/class.LongTextDataField.php' );
include_once( '../include/elements/html/class.MainPageElement.php' );
include_once( '../include/elements/html/module.Constants.php' );

$lcLangFile = "../languages/$shortlang/webapp.inc.php";

if( is_readable( $lcLangFile ) ){
  include_once( $lcLangFile );
}


global $DEBUG;
//$DEBUG = 1;

if( $DEBUG ){
	echo "webapp_conf.php: _POST<br><pre>\n";
	print_r( $_POST );
	echo "</pre><hr>\n";
 }

db_connect();

$loWebappId = new SQLInteger( $webapp_id );

if( isset( $action ) && $action == 'save' ){
	$id = safe_query2( " SELECT w.name, k.webapp, k.httpd_conf FROM webapp w ".
										 " LEFT JOIN webapp_knowledge k ON w.name=k.webapp AND w.server_id=k.server_id ".
										 " WHERE w.id=? AND w.server_id='$ServerID'",
										 $loWebappId );
	list($lcWebapp, $lcKnwldg, $lcOldHttpd_conf ) = db_fetch_array( $id, 'N' );
	db_free_query( $id );
	if( $lcWebapp ){
		$loFlds = new SQLFieldSet( array( 'httpd_conf' => array( $httpd_conf, 'C' ),
																			'hash_type' => array( $hash_type, 'C' ),
																			'type' => array( $type, 'C' ),
																			'start_page' => array( $start_page, 'C' )
																			) 
															 );
		if( $lcKnwldg ){
			$lcSql = "UPDATE webapp_knowledge SET ".$loFlds->getSQLUpdate()." WHERE webapp=? AND server_id='$ServerID'"; 
		}else{
			$loFlds->addField( 'server_id', $ServerID, 'C' );
			list( $lcFlds, $lcVals ) = $loFlds->getSQLInsert();
			$lcSql = "INSERT INTO webapp_knowledge ($lcFlds,webapp) VALUES ($lcVals,?)";
		}
		safe_query2( $lcSql, new SQLString( $lcWebapp ) );
		safe_query2( "UPDATE webapp SET status=".( $status == 'off'? 0: 1 ).
								 " WHERE id=? AND server_id='$ServerID'",
                 $loWebappId );
    /**
     * Update httpd special
     */
    if( $lcOldHttpd_conf != $httpd_conf ){
      $lrId = safe_query2( " SELECT kunde FROM webapp_user ".
                           " WHERE webapp_id=? AND server_id='$ServerID'", $loWebappId );
      $laUsers = array();

      while( $laRow = db_fetch_array( $lrId ) ){
        $laUsers[] = "'".$laRow['kunde']."'";
      }

      db_free_query( $lrId );
      safe_query2( " UPDATE kunden SET httpd = 1 WHERE kunde IN (".implode(', ', $laUsers ).
                   " ) AND server_id = '$ServerID'" );
      safe_query2( "UPDATE allgemein SET httpd =1 WHERE server_id = '$ServerID'");
    }
	}else{
		$fehlertext = ltext( 'wa_not_found' );
	}
	$action = '';
	include('webapp.php');
	exit;
 }

$id = db_query( "SELECT webapp FROM admin WHERE server_id='$ServerID'");
list( $skwebapp ) = db_fetch_array($id);
db_free_query( $id );

if( $skwebapp == 0 ){
	db_close();
	include( 'feature_unavailable.php' );
	exit;
 }

$id = safe_query2( "SELECT w.name,w.descr,w.version,w.status,".
									 " k.hash_type,k.httpd_conf,k.type,k.start_page ".
									 " FROM webapp w ".
									 " LEFT JOIN webapp_knowledge k ON w.name=k.webapp AND w.server_id=k.server_id ".
									 " WHERE w.server_id='$ServerID' AND w.id=?",
									 $loWebappId );
if( ! db_num_rows( $id ) ){
	$fehlertext = ltext( 'wa_id_not_found' ); 
	db_clode();
	include( 'webapp_conf.php' );
	exit;
 }

$waData = db_fetch_array( $id, 'A' );
db_free_query( $id );

if($DEBUG){
	echo "<br><pre>\n";
	print_r( $waData );
	echo "</pre><hr>\n";
 }

$data = new SetOfRowsData();

$data->AppendRow(new HTMLDataField( '##user##' ),
	new HTMLDataField( ltext( 'eihtdoae_cell_username' ) ) );
$data->AppendRow(new HTMLDataField( '##domain##' ),
	new HTMLDataField( ltext( 'eihtdoae_cell_domain' ) ) );
$data->AppendRow(new HTMLDataField( '##dir##' ),
	new HTMLDataField( ltext( 'eihtdoae_cell_dir' ) ) );

$boxLegend = $data->GetOutputPresentation( ltext( 'eihtdoae_title2' ) ); // Infotable
$boxLegend->SetWidths( '20%', '80%' );

$data->ClearRows();

$data->AppendRow( new HTMLDataField( ltext('wa_name')),
									new HTMLDataField( $waData['name'] )
									);

$data->AppendRow( new HTMLDataField( ltext('wa_version')),
									new HTMLDataField( $waData['version'] )
									);

$data->AppendRow( new HTMLDataField( ltext('wa_descr')),
									new HTMLDataField( empty( $lang_text[$waData['name']] ) 
                                     ? $waData['descr'] 
                                     : ltext($waData['name'] ) )
									);

$boxDescr = $data->GetOutputPresentation( ltext( 'wa_title1' ) );

$data->ClearRows();

$data->AppendRow( new HTMLDataField( ltext('wa_type' ) ), 
									new TextDataField( $waData['type'], 'type' )
									);

$data->AppendRow( new HTMLDataField( ltext('wa_hash_type' ) ), 

									new OptionsDataField( array( 'plain' => ltext( 'wa_hash_plain' ),
																							 'md5' => ltext( 'wa_hash_md5' ),
																							 'crypt' => ltext( 'wa_hash_crypt' ),
																							 'mysql' => ltext( 'wa_hash_mysql' ) ),
																				$waData['hash_type'],
																				'hash_type' ) );

$data->AppendRow( new HTMLDataField( ltext('wa_status' ) ), 
									new YesNoDataField( array( 'on' => ltext( 'wa_status_active' ) ),
																			array( 'off' => ltext( 'wa_status_deactive') ),
																			$waData['status']?'on':'off',
																			'status',
																			cc_RadioGroupPresentation
																			)
									);

$data->AppendRow( new HTMLDataField( ltext('wa_httpd_conf' ) ), 
									new LongTextDataField( $waData['httpd_conf'], 'httpd_conf' ) );

$data->AppendRow( new HTMLDataField( ltext('wa_start_page' ) ), 
									new TextDataField( $waData['start_page'], 'start_page' )
									);

$data->AppendButton( ltext( 'll_apply' ), 
										 "javascript:doChange()",
										 cc_IDOk );

$data->AppendHidden( new TextDataField( $webapp_id, 'webapp_id' ) );
$data->AppendHidden( new TextDataField( $waData['name'], 'webapp' ) );
$data->AppendHidden( new TextDataField( 'save', 'action' ) );

$data->AppendHidden( new TextDataField( $page_size, 'page_size' ) );
$data->AppendHidden( new TextDataField( $start_index, 'start_index' ) );
$data->AppendHidden( new TextDataField( $webapp_to_search, 'webapp_to_search' ) );


$form = $data->GetInputPresentation( array( 'action' => 'webapp_conf.php',
																						'method' => 'post',
																						'name' => 'form1' ),
																		 ltext( 'wa_config' )
																		 );

$page = new MainPageElement( $boxDescr, $form, $boxLegend )	;
$page->OutputHTML();

?>
