<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once ( dirname(__FILE__) . "/class.Validator.php" );
include_once ( dirname(__FILE__) . "/module.Database.php" );
define ( "cc_LimitErrorInvalidChar", 1 );
define ( "cc_LimitErrorMaximum", 2 );
define ( "cc_LimitErrorLimit", 3 );





class LimitValidator extends Validator
{

    /* -------------------- Members -------------------- */
    var $ms_Maximum; // maximum value allowed for this field
    var $ms_Limit; // limit
    var $ms_Hard; // hard limit
    var $ms_Current; // number of items that were assigned already
    var $ms_Query; // query to calculate ms_Current
    var $ms_Error; // error number
    /* -------------------- end Members -------------------- */





    /* -------------------- Constructor -------------------- */
    function LimitValidator ( $ps_Required, $ps_Empty="", $ps_Query=NULL )
    {
	$this->Validator ( $ps_Required, $ps_Empty );
	$this->SetQuery ($ps_Query);
    }
    /* -------------------- end Constructor -------------------- */





    /* -------------------- Set.../Get... -------------------- */
    function SetQuery ( $ps_Query )
    {
	$this->ms_Query = $ps_Query;
    }

    function GetQuery()
    {
	return $this->ms_Query;
    }

    function SetMaximum ( $ps_Maximum )
    {
	$this->ms_Maximum = $ps_Maximum;
    }

    function GetMaximum()
    {
	return $this->ms_Maximum;
    }

    function SetLimit ( $ps_Limit )
    {
	$this->ms_Limit = $ps_Limit;
    }

    function GetLimit()
    {
	return $this->ms_Limit;
    }

    function SetHardLimit ( $ps_Hard )
    {
	$this->ms_Hard = $ps_Hard;
    }

    function GetHardLimit()
    {
	return $this->ms_Hard;
    }

    function SetError ( $ps_Error )
    {
	$this->ms_Error = $ps_Error;
    }

    function GetError()
    {
	return $this->ms_Error;
    }

    function SetCurrent ( $ps_Current )
    {
	$this->ms_Current = $ps_Current;
    }

    function GetCurrent()
    {
	return $this->ms_Current;
    }
    /* -------------------- end Set.../Get... -------------------- */





    /* -------------------- SetCurrentFromSQL -------------------- */
    function SetCurrentFromSQL()
    {

	if ( is_null($ls_Query=$this->GetQuery()) )
	    $this->SetCurrent (0);
	else
	{
		  $lo_DB =& get_db_connection();
	    
	    $lo_Query =& $lo_DB->Select ( $ls_Query );
	    $la_Row =& $lo_Query->nextrow();
	    $this->SetCurrent ( $la_Row ? $la_Row[0] : 0 );
	}
    }
    /* -------------------- end SetCurrentFromSQL -------------------- */





    /* -------------------- definition of "abstract" methods -------------------- */
    function Validate ( $ps_Value )
    {
	if ( ! preg_match ( "/^(\-1|\d+)$/", $ps_Value ) )
	{
	    $this->SetError ( cc_LimitErrorInvalidChar );
	    return FALSE;
	}
	if ( $ps_Value > $this->GetMaximum() )
	{
	    $this->SetError ( cc_LimitErrorMaximum );
	    return FALSE;
	}
	$ls_Limit = $this->GetLimit();
	$ls_Hard = $this->GetHardLimit();
	$ls_Current = $this->GetCurrent();
	if ( $ls_Hard && ( $ls_Limit > 0 ) && ( $ps_Value < 0 || $ls_Current+$ps_Value > $ls_Limit ) )
	{
	    $this->SetError ( cc_LimitErrorLimit );
	    return FALSE;
	}
	return TRUE;
    }
    /* -------------------- end definition of "abstract" methods -------------------- */

}
?>
