<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####


class Traffic {
  var $dateBegin;
  var $dateEnd;
  var $user;
  var $reseller;
	var $server_id;
  var $sql;
  var $log;
  var $traffic;
  var $month;
  var $year;
  var $interval;
  var $fields;
  var $allFields;
  var $group;
  var $groups;
  var $blocked;
  var $maOrder;

  function Traffic( $pcServerID=NULL ){
		global $master_confixx, $ServerID, $masterServerID;

    $this->dateEnd = getdate();
    $this->dateBegin = $this->dateEnd;
    $this->dateBegin["mday"]=1;
    $this->month=$this->dateEnd["mon"];
    $this->year=$this->dateEnd["year"];
    $this->interval=false;
    $this->fields = array('web','ftp','email'); ### ,'pop','other');
		$this->allFields = array('web','ftp','email'); ###,'pop','other');
    $this->log=1;
    $this->maOrder = array();
			  			  
//		if( (( $master_confixx != 2 ) || is_string( $pcServerID ) )){
		if( (( !$masterServerID ) || is_string( $pcServerID ) )){
			if( is_string( $pcServerID ) ){
				$this->setServerID( $pcServerID );
			}else{
			  
				$this->setServerID( $ServerID );
			}
		}
  }
	
  function setGroup( $newValue ){
    if(is_string($newValue) || is_bool($newValue) ){
      $this->group = $newValue;

    }elseif(is_array($newValue)){
      $this->group=array();
      foreach( $newValue as $field ){
				if( is_string( $field )){
					$this->group[] = $field;
				}
      }

      if(!count($this->group)){
				$this->group=false;
      }	
    }
    return $this->group;
  }
	
  function getGroup (){
    return $this->group;
  }
	
  function setBegin ($newValue,$month=false,$mday=false){

    if (is_array($newValue)){
      $this->dateBegin=$newValue;
      return $this->dateBegin;

    }elseif(is_string($newValue)){
      list($year,$month,$mday)=split('[-/.]',$newValue);

    }elseif( is_numeric($newValue)){
      $year=$newValue;
    }

    if( is_numeric($year) && is_numeric($month) && is_numeric($mday) ){
      $this->dateBegin['year'] = $year;
      $this->dateBegin['mon'] = $month;
      $this->dateBegin['mday'] = $mday;
    }
    return $this->dateBegin;
  }
  
  function getBegin (){
    return $this->dateBegin;
  }
	
  function setEnd ($newValue,$month=false,$mday=false){

    if (is_array( $newValue ) ){
      $this->dateEnd = $newValue;
      return $this->dateEnd;

    }elseif( is_string( $newValue ) ) {
      list($year,$month,$mday) = split( '[-/.]', $newValue );

    }elseif( is_numeric( $newValue ) ){
      $year = $newValue;
    }

    if( is_numeric($year) && is_numeric($month) && is_numeric($mday)){
      $this->dateEnd['year'] = $year;
      $this->dateEnd['mon'] = $month;
      $this->dateEnd['mday'] = $mday;
    }
    return $this->dateEnd;
  }

  function getEnd (){
    return $this->dateEnd;
  }

  function setMonth ($newValue, $year=''){
    if(is_bool($newValue) || is_numeric($newValue)){
      $this->month=$newValue;
    }
    if(is_bool($year) || is_numeric($year)){
      $this->year=$year;
    }
    return $this->month;
  }

  function getMonth (){
    return $this->month;
  }

  function Order( $paOrder = NULL ) {
		if( is_array( $paOrder ) ) {
				$this->maOrder = $paOrder;
		}
		return $this->maOrder;
	}
	
  function setYear ($newValue){
    if(is_bool($newValue) || is_numeric($newValue)){
      $this->year=$newValue;
    }
    return $this->year;
  }

  function getYear (){
    return $this->year;
  }

  
  function setUser ($newValue, $blocked=0){
    if(is_bool($newValue) || is_string($newValue)){
      $this->user=$newValue;
    }
    if(is_bool($blocked) || is_numeric($blocked)){
      $this->blocked=$blocked;
    }
    return $this->user;
  }

  function getUser (){
    return $this->user;
  }

	function setServerID( $pcServerID ){
		$this->server_id = $pcServerID;
	}
	
	function &getServerID(){
		return $this->server_id;
	}
	
  function setBlocked ($newValue){
    if(is_bool($newValue) || is_numeric($newValue)){
      $this->blocked=$newValue;
    }
    return $this->blocked;
  }

  function getBlocked(){
    return $this->blocked;
  }

  function setReseller ($newValue){
    if(is_bool($newValue) || is_string($newValue)){
      $this->reseller = $newValue;
    }	
    return $this->reseller;
  }

  function getReseller (){
    return $this->reseller;
  }
	
  function setLog ($newValue){
    if(is_numeric($newValue) || is_bool($newValue)){
      $this->log=$newValue;
    }
    return $this->log;
  }
  function getLog (){
    return $this->log;
  }

  function setFields($newValue){
    if(is_array($newValue)){
      $this->fields=array();
      foreach($newValue as $key){
	if (in_array($key,$this->allFields)){
	  $this->fields[]=$key;
	}
      }	
    }
    return $this->fields;
  }		
	
  function getFields(){
    return $this->fields;
  }
  
  function getSql (){
    return $this->sql;
  }

  function makeSql(){
		
    if (!count($this->fields)){
      $this->fields=array($this->allFields);
    }
    foreach ( $this->fields as $field){
      if (in_array($field,$this->allFields)){
				if ($fields){
					$fields.=",";
				}
				$fields .= "sum($field) AS $field";
      }
    }
    if(!$fields){
      return false;
    }
    if($this->group){
      if(is_array($this->group)){
				foreach($this->group as $field){
					$fields.=",$field";
				}
      }else{
				$fields.=','.$this->group;
      }	
    }
    
    $sql = "SELECT $fields FROM transfer";
    $laWhere = array();
    
    if( $this->interval ){
      $begin=$this->dateBegin["year"]*10000+$this->dateBegin["mon"]*100+$this->dateBegin["mday"];
      $end=$this->dateEnd["year"]*10000+$this->dateEnd["mon"]*100+$this->dateEnd["mday"];
			$laWhere[] = "((jahr*10000+monat*100+tag) between $begin and $and)";
    }else{
      
      if(is_numeric($this->year)){
				$laWhere[] = "(jahr=".$this->year.")";
      }
      if(is_numeric($this->month)){
				$laWhere[] = "(monat=".$this->month.")";
      }
    }

    if( is_numeric( $this->log ) ){
      $laWhere[] = "(log=".$this->log.")";
    }
    if( is_string( $this->reseller ) ){
			$laWhere[] = "(anbieter='".db_quote($this->reseller)."')";
		}
		if( is_string( $this->user ) ){
			$laWhere[] = "(kunde='".db_quote($this->user)."')";
    }
    if( is_numeric( $this->blocked ) ){
      $laWhere[] = "(geloescht=".$this->blocked.")";
    }
		if( $this->server_id ){
			$laWhere[] = "(server_id='".db_quote($this->server_id)."')";
		}

    if( count($laWhere) ){
			$sql.=" WHERE ".join(' AND ', $laWhere );
    }

    if( $this->group ){
      if(is_array($this->group)){
				$group = join( ',', $this->group);

      }else{
				$group = $this->group;
      }
      if( $group ){
				$sql.=" GROUP BY $group";
      }
    }
    
		if( count( $this->maOrder ) ) {
			$lcOrderBy = " ORDER BY ";
			foreach ($this->maOrder as $key => $value) {
				$lcOrderBy .= $key." ".$value.", ";
			}
			$lcOrderBy = substr($lcOrderBy, 0 , -2);
			$sql .= $lcOrderBy;
		}
		    
    $this->sql = $sql;
    global $DEBUG;
    if( $DEBUG ){
      echo "Traffic::makeSQL: $sql<br>\n";
    }
    return $this->sql;
  }

  function Query(){

    global $DEBUG;

    if($this->makeSql()){
      $id = db_query( $this->sql );
      if( $id ){
				$this->traffic = array();
				$this->groups = array();
				if( $this->group ){
					if(is_array($this->group)){
						while( $row = db_fetch_array($id)){
							$node =& $this->traffic;
							$groupValue = array();
							foreach( $this->group as $field ){
								$key = $row[$field];
								if( ! is_array( $node[$key] ) ){
									$node[$key] = array();
								}
				
				#		if($DEBUG){
				#		  echo "field: $field, key: $key<br>\n";
				#		  print_r($node);
				#		  echo "<br>\n";
				#		}
				
								$node =& $node[$key];
								$groupValue[] = $key;
							}
							$node = $row;
							$this->groups[] = $groupValue;

#	      if($DEBUG){
#		echo "key: $key<br>\n";
#		print_r($node);
#		echo "<br>\n";
#	      }

						}	
						if( $DEBUG ){
							echo "Traffic::Query : groups:<br><pre>\n";
							print_r($this->groups);
							echo "</pre><hr><br>\n";
						}

					} else {
						while( $row = db_fetch_array( $id ) ){
							$key = $row[$this->group];
							$this->traffic[$key] = $row;
						}	
					}	
				}else{
					while( $row = db_fetch_array( $id ) ){
						$this->traffic[] = $row;
					}
				}
				db_free_query( $id );
      }	

      if( $DEBUG ){
				echo "Traffic::Query : traffic:<br><pre>\n";
				print_r($this->traffic);
				echo "</pre><br>\n";
      }

      $ret = $this->traffic;
    }else{
      $ret = false;
    }
    return $ret;
  }

  function monthlyQuery($month = false, $year = false){
		global $DEBUG;
    if( $DEBUG ){
      echo "Traffic::monthlyQuery: $month, year: $year<br>\n";
    }
    if(is_bool($month)){
      $this->month = $month;
    }else{
      if( is_numeric($month) && $month ){
				$this->month = $month;
      }
    }
    if(is_bool($year)){
      $this->year = $year;
    }else{
      if( is_numeric($year) && $year ){
				$this->year = $year;
      }
    }
    $this->interval = false;
    if( $DEBUG ){
      echo "Traffic::monthlyQuery: $this->month, year: $this->year<br>\n";
    }
    return $this->Query();
  }
	
  function getTraffic($key = false, $group=false){

    global $DEBUG;
#    if($DEBUG){
#      echo "getTraffic: key: $key, group: $group<br>\n";
#    }


    if (is_string($key)){
      $ret = 0;
      if(in_array($key,$this->fields)){
				if ($group){
					if(is_array($group)){
						$node = &$this->traffic;
						foreach($group as $field){
							$node = &$node[$field];
						}
						$ret += $node[$key];
					}else{
						$ret += $this->traffic[$group][$key];
					}
				}else{
					foreach($this->traffic as $row){	
						$ret += $row[$key];
					}
				}

      }elseif($key == 'all' || $key == 'sum'){
				if ($group){
					if(is_array($group)){
						$node =& $this->traffic;
						foreach( $group as $field ){
							$node =& $node[$field];
						}
						foreach($this->fields as $field){
							$ret += $node[$field];
						}
					}else{
						foreach( $this->fields as $field ){
							$ret += $this->traffic[$group][$field];
						}
					}
				 }else {
					foreach($this->traffic as $row){	
						foreach($this->fields as $field){
							$ret += $row[$field];
						}
					}	
				}
      }else{
				$ret = false;
      }
    }else{
      if($group){
				if(is_array($group)){
#	  if($DEBUG){
#	    echo "group:<br>\n";
#	    print_r($group);
#	    echo "<br>\n";
#	  }
					$node = &$this->traffic;
					foreach($group as $field){
#	    if($DEBUG){
#	      echo "field: $field<br>\n";
#	      print_r($node);
#	      echo "<br>\n";
#	    }
						$node =& $node[$field];
					}
#	  if($DEBUG){
#	    echo "node: <br>\n";
#	    print_r($node);
#	    echo "<br>\n";
#	  }

					$ret = $node;	
				}else{
					$ret = $this->traffic[$group];
				}
      }else{
				$ret = $this->traffic;
      }
    }
 
    if($DEBUG){
      echo "getTraffic: return<br>\n";
      print_r($ret);
      echo "<br>\n";
    }
    return $ret;
  }
	
  function getGroupTraffic($key = false){
    $ret = array();
    if( is_string( $key ) ){
      if(in_array( $key, $this->fields ) ){
				if($this->group){	
					if( is_array( $this->group ) ){
						copyArray( $ret, $this->traffic, count($this->group), $key );

					} else {
						foreach($this->traffic as $row){
							$gkey = $row[$this->group];
							$ret[$gkey] = $row[$key];
						}
					}	
				}else{
					foreach($this->traffic as $row){
						$ret[]=$row[$key];
					}	
				}		

      }elseif( $key == 'all' || $key == 'sum' ){
				
				if( $this->group ){	
					if(is_array( $this->group ) ){
						copyArray( $ret,
											 $this->traffic,
											 count($this->group)  ,
											 $this->fields,
											 $key );

					}else{
						foreach($this->traffic as $row){	
							$gret=0;
							foreach($this->fields as $field){
								$gret += $row[$field];
							}	
							$gkey = $row[$this->group];
							$ret[$gkey] = $gret;
						}	
					}	

				}else{
					foreach($this->traffic as $row){	
						$gret = 0;
						foreach( $this->fields as $field ){
							$gret += $row[$field];
						}	
						$ret[]=$gret;
					}
				}
      }else{
				$ret = false;
      }
    }else{
      $ret = $this->traffic;
    }
		if($DEBUG){
      echo "getGroupTraffic: ret: <br><pre>\n";
			print_r( $ret );
      echo "</pre><hr><br>\n";
			
		}
    return $ret;
  }
	
  function getGroups(){
    global $DEBUG;
    if(is_array($this->group)){
      $ret=$this->groups;
    }else{
      $ret = array_keys($this->traffic);
    }	
    if( $DEBUG ){
      echo "Traffic::getGroups: ret: <br><pre>\n";
      print_r($ret);
      echo "</pre><hr><br>\n";
    }
    return $ret;
  }
}



	
#
# end of class definition
#

#
# recurent copy multi-dimensional array
#

function copyArray( &$dst, &$src, $level, &$keyField, $sum ){

	global $DEBUG;
  if( $level > 0 ){
    while( list( $key, $val ) = each( $src ) ){
			/*
			if($DEBUG){
				echo "copyArray: $level: $key<br><pre>\n";
				print_r($val);
				echo "</pre><hr>\n";
			}
			*/
			if( $level == 1 && $sum ){
				if( is_array( $keyField ) ){
					$dst[$key] = 0;
					foreach( $keyField as $field ){
						$dst[$key] += $val[$field];
					}
				}else{
					$dst[$key] = $val[$keyField];
				}
			}else{
				$dst[$key] = array();
				copyArray( $dst[$key], $val, $level-1, $keyField, $sum );
			}
    }
		
  }else{
		if( is_array( $keyField ) ){
			foreach( $keyField as $field ){
				$dst[$field] = $src[$field];
			}

		}else{
			$dst[$keyField] = $src[$keyField];
    }	
  }	

}


?>
