<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once ( dirname(__FILE__) . "/class.Validator.php" );





class Validatable
{

    /* -------------------- Members -------------------- */
    var $mo_Validator; // object of type Validator
    /* -------------------- end Members -------------------- */





    /* -------------------- Constructor -------------------- */
    function Validatable ( $po_Validator=NULL )
    {
	$this->SetValidator ( $po_Validator );
    }
    /* -------------------- end Constructor -------------------- */





    /* -------------------- Get.../Set... -------------------- */
    function &GetValidator()
    {
	return $this->mo_Validator;
    }

    function GetRequired()
    {
	if ( ! is_object($this->mo_Validator) )
	    return FALSE;
	return $this->mo_Validator->GetRequired();
    }

    function SetValidator ( $po_Validator )
    {
	$this->mo_Validator = $po_Validator;
    }
    /* -------------------- end Get.../Set... -------------------- */





    /* -------------------- CallOnValidator -------------------- */
    function CallOnValidator ( $ps_Method )
    {
	$lo_Validator =& $this->GetValidator();
	if ( $lo_Validator )
	{
	    $la_Arguments = func_get_args();
	    array_shift ( $la_Arguments );
	    return call_user_func_array ( array( &$lo_Validator, $ps_Method ), $la_Arguments );
	}
	return NULL;
    }
    /* -------------------- end CallOnValidator -------------------- */





    /* -------------------- IsValid -------------------- */
    function IsValid()
    {
	if ( !is_object($this->mo_Validator) )
	    return TRUE;
	if ( $this->mo_Validator->GetRequired() && $this->mo_Validator->GetEmpty() == $this->GetValue() )
	    return FALSE;
	return $this->mo_Validator->Validate ( $this->GetValue() );
    }
    /* -------------------- end IsValid -------------------- */





    /* -------------------- "abstract" methods -------------------- */
    function GetValue()
    {
	echo ( "method GetValue should return value" );
    }
    /* -------------------- end "abstract" methods -------------------- */

}
?>
