<?
include_once('class.Iterators.php');

class CompoundValue {

	var $maValues;
	var $moJoin;

	function CompoundValue( $poValue = NULL ){
		$this->maValues = array();

		if( is_a( $poValue, 'CompoundValue') && func_num_args()==1){
			$this->copyFrom( $poValue );

		} elseif( is_array( $poValue ) ) {
			foreach ( $poValue as $loItem ) {
				$this->addValue( $loItem );
			}

		} else {
			foreach (func_get_args() as $loValue ){
				$this->addValue( $loValue );
			}
		}
	}


	function &Value( $piIndex, $poValue = NULL ){

		if(is_numeric($piIndex)){ ## get item by index
			$liCount = $this->getCount();

			if($piIndex<0){ ## get item at end of array
				$piIndex += $liCount;
			}

			if ( $piIndex >= 0 && $piIndex < $liCount ) {
				if( $this->isValidType( $poValue ) ) {
					unset( $this->maValues[$piIndex] );
					$this->maValues[$piIndex] =& $poValue;
				}
				return $this->maValues[$piIndex];
			}

		} else { ## find by key
			$loIter =& $this->getFirstIterator();
			while( $loItem =& $loIter->getNext() ){
				if( is_a( $loItem, 'KeyValue' ) ){
					if( $loItem->getKey() == $piIndex ){
						return $loItem;
					}
				}
			}
		}
		return NULL;

	}

	function Join( $poJoin = NULL ) {
		if ( is_string( $poJoin ) || is_a( $poJoin, 'KeyValue' ) ) {
			$this->moJoin = $poJoin;
		}
		return $this->moJoin;
	}


	function joinValue( $poJoin = NULL ) {
		if( !(is_string($poJoin) || is_a( $poJoin, 'KeyValue' ) ) ) {
			$poJoin = $this->Join();
		}
		if(is_string( $poJoin )){
			$lcJoin = $poJoin;
		} elseif( is_a( $poJoin, 'KeyValue' ) ) {
			$lcJoin = $poJoin->Value();
		}
		$loIter = $this->getFirstIterator();
		$laRet = array();
		while ( $loEntry =& $loIter->getNext() ){
			$laRet[] = $loEntry->Value();
		}
		return join( $lcJoin, $laRet );
	}

	function &listValue(){
		global $DEBUG;
		$loIter = $this->getFirstIterator();
		$laRet = array();
		while ( $loEntry =& $loIter->getNext() ){
			$laRet[] = $loEntry->Value();
		}
		/*
		if( $DEBUG ){
			echo "CompondValue::listValue:<br><pre>\n";
			print_r( $laRet );
			echo "</pre><hr>\n";
		}
		*/

		return $laRet;
	}

	function getCount(){
		return count($this->maValues);
	}

	function isValidType($poValue = NULL){
		return ( is_a( $poValue,'KeyValue' ) || is_a( $poValue, 'CompoundValue' ) );
	}

	function &addValue( $poValue = NULL ){

		if( func_num_args() > 1 ){
			$this->maValues[] = new CompoundValue( func_get_args() );

		} elseif( is_array( $poValue ) ) {
			$this->maValues[] = new CompoundValue( $poValue );

		} elseif ( $this->isValidType( $poValue ) ) {
			$liLast = count($this->maValues);
			$this->maValues[$liLast] =& $poValue;

		} elseif( is_null( $poValue ) ) {
			$this->maValues[] = new KeyValue( '' );
		}

		return $this->getLast();
	}

	function &getLast(){
		if( $liCount = count( $this->maValues ) ) {
			return $this->maValues[$liCount - 1];
		} else {
			return NULL;
		}
	}

	function clean() {
		global $DEBUG;
		foreach ( $this->maValues as $loItem ){
			if(method_exists($loItem,'clean')){
				$loItem->clean();
			} else {
				if($DEBUG){
					echo 'CompoundValue::clean: wrong type of item<br><pre>\n';
					print_r($loItem);
					echo "</pre><hr><pre>\n";
					print_r($this);
					echo "</pre><hr>\n";
				}
			}
		}
		$this->maValues = array();
	}

	function keepLeft( $piLeft ){
		if(is_numeric($piLeft)){
			$liCount = count($this->maValues);
			for ( $i = $piLeft; $i<$liCountl; $i++ ){ // call clean-method
				$this->maValues[$i]->clean();
			}
			array_splice($this->maValues,$piLeft );
		}
	}

	function copyFrom( $poSource ) {
		if( is_a( $poSource, 'CompoundValue' ) ) {
			$this->clean();
			$this->Join( $poSource->Join() );

			$loIter = $poSource->getFirstIterator();
			while( $loItem =& $loIter->getNext() ) {
				$this->maValues[] = $loItem->getClone();
			}
		}
	}

	function &getClone() {
		return new CompoundValue( $this );
	}

	function  setFromArray( &$paValues ) {
		global $DEBUG;

		$loIter =& $this->getFirstIterator();

		while( $loItem =& $loIter->getNext() ) {
			$loItem->setFromArray( $paValues );
		}

		if( is_a( $this->moJoin, 'ValueFromArray' ) ){
			$this->moJoin->setFromArray( $paValues );
		}
	}

	function fillArray( &$paValues ) {
		$loIter = $this->getFirstIterator();

		while( $loItem =& $loIter->getNext() ) {
			$loItem->fillArray( $paValues );
		}
	}

	function &findRowByCell( $piCellIndex, &$poPattern ){
		global $DEBUG;

		/*
		if($DEBUG){
			echo "CompoundValue::findRowByCell : $piCellIndex<br><pre>\n";
			print_r($poPattern);
			echo "</pre><hr>this:<br><pre>\n";
			print_r($this);
			echo "</pre><hr>\n";
		}
		*/

		if( is_a($poPattern, 'KeyValue' ) ) {
			$loIter = $this->getFirstIterator();
			while( $loItem =& $loIter->getNext() ) { ## loop by rows
				if( is_a( $loItem, 'CompoundValue' ) ){
					if ( $poPattern->isEquivByValue( $loItem->Value( $piCellIndex ) ) ) {

						/*
						if($DEBUG){
							echo "CompoundValue::findRowByCell : found !<br>\n";
						}
						*/
						return $loItem;
					}
				} else {
					if( $poPattern->isEquivByValue( $loItem ) ){
						return $loItem;
					}
				}
			}
		}		
		return NULL;
	}

	function &findRow( &$poPattern ){
		if( is_a($poPattern, 'KeyValue' ) ) {
			$loIter = $this->getFirstIterator();

			while( $loItem =& $loIter->getNext() ) { ## loop by rows
				if( is_a( $loItem, 'CompoundValue' ) ){
					$loRowIter = $loItem->getFirstIterator();
					while( $loCell =& $loRowIter->getNext() ) { ## loop by cells
						if ( $poPattern->isEquiv( $loCell ) ) {
							return $loItem;
						}
					}
				}else{
					if( $poPattern->isEquiv( $loItem ) ) {
						return $loItem;
					}
				}
			}
		}		
		return NULL;
	}


//
// Iterators
//

	function &getFirstIterator(){
		return  new FirstIterator( $this->maValues );
	}

	function &getRandomIterator(){
		return  new RandomIterator( $this->maValues );
	}

	function &getTreeIterator(){
		return new TreeIterator( $this->maValues );
	}

}


?>