<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once( dirname(__FILE__) . "/class.Data.php" );





class DataField extends Data {

	/* -------------------- Members -------------------- */
	var $ms_ColSpan; // how many columns to use for this field
	var $ms_Disabled; // if this field is disabled
	var $ma_Attributes; // attributes of field
	var $ma_ParentAttributes; // attributes of parent box
	/* -------------------- end Members -------------------- */





	/* -------------------- Constructor -------------------- */
	function DataField( $paAttributes = NULL, 
											$paParentAtributes = NULL,
											$piColSpan = 1,
											$plDisabled = FALSE) {
		$this->Data();
		$this->SetColSpan($piColSpan);
		$this->SetDisabled( $plDisabled );

		$this->ma_Attributes = array();
		$this->ma_ParentAttributes = array();

		$this->SetAttributes( $paAttributes );
		$this->SetParentAttributes( $paParentAtributes );
	}
	/* -------------------- end Constructor -------------------- */





	/* -------------------- Set.../Get... -------------------- */
	function SetColSpan( $ps_ColSpan ) {
		$this->ms_ColSpan = $ps_ColSpan;
	}

	function GetColSpan() {
		return $this->ms_ColSpan;
	}

	function SetDisabled( $ps_Disabled ) {
		$this->ms_Disabled = $ps_Disabled;
	}

	function GetDisabled() {
		return $this->ms_Disabled;
	}
	/* -------------------- end Set.../Get... -------------------- */





	/* -------------------- GetAttributes/SetAttributes -------------------- */
	function GetAttributes() {
		$la_Attributes = $this->ma_Attributes;
		if( $this->GetDisabled() )
			$la_Attributes["disabled"] = NULL;
		return $la_Attributes;
	}

	function SetAttributes( $pa_Attributes ) {
		if( is_array($pa_Attributes)){
			$this->ma_Attributes = $pa_Attributes;
		}
	}

	function AppendAttributes( $pa_Attributes ) {
		$this->ma_Attributes = array_merge( $this->ma_Attributes, $pa_Attributes );
	}

	function &Attribute( $pcKey, $pcValue = NULL ) {

		/*
		echo "DataField::Attribute<br><pre>\n";
		print_r(func_get_args());
		echo "</pre><hr>\n";
		*/

		if(!is_null($pcValue)){
			$this->ma_Attributes[$pcKey] = $pcValue;
		}
		if(array_key_exists( $pcKey, $this->ma_Attributes ) ) {
			return $this->ma_Attributes[$pcKey];
		} else {
			return NULL;
		}
	}

	function &setAttribute( $pcKey, $pcValue = NULL ){
		$this->ma_Attributes[$pcKey] = $pcValue;
		return $this->ma_Attributes[$pcKey];
	}

	function &removeAttribute( $pcKey ){
		if( array_key_exists( $pcKey, $this->ma_Attributes ) ){
			$lcRet = $this->ma_Attributes[$pcKey];

			unset( $this->ma_Attributes[$pcKey] );

		} else {
			$lcRet = NULL;
		}
		return $lcRet;
	}

	function &ParentAttribute( $pcKey, $pcValue = NULL ) {

		if(!is_null($pcValue)){
			$this->ma_ParentAttributes[$pcKey] = $pcValue;
		}
		if(array_key_exists( $pcKey, $this->ma_ParentAttributes ) ) {
			return $this->ma_ParentAttributes[$pcKey];
		} else {
			return NULL;
		}
	}


	function GetParentAttributes() {
		return $this->ma_ParentAttributes;
	}

	function SetParentAttributes( $pa_Attributes ) {
		if (is_array($pa_Attributes)){
			$this->ma_ParentAttributes = $pa_Attributes;
		}	
	}

	function AppendParentAttributes( $pa_Attributes ) {
		if (is_array($pa_Attributes)){
			$this->ma_ParentAttributes = array_merge( $this->ma_ParentAttributes, $pa_Attributes );
		}	
	}
	
	/* -------------------- end GetAttributes/SetAttributes -------------------- */





	/* -------------------- "abstract" methods -------------------- */
	function SetFromArray( $pa_Data ) {
		echo( "Method SetFromArray should set value(s)!" );
	}
	/* -------------------- end "abstract" methods -------------------- */

}
?>
