<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once( dirname(__FILE__) . "/../html/module.Constants.php" );





class DataRow {

	/* -------------------- Members -------------------- */
	var $ma_Fields; // cells of row (objects)
	var $ms_Header; // if this is a header row
	var $ms_Special; // if this is a special row
	var $ms_ID; // id of element
	var $maAttributes;
	/* -------------------- end Members -------------------- */





	/* -------------------- Constructor -------------------- */
	function DataRow( $ps_Header = FALSE, $ps_Special=FALSE ) {
		$this->ClearFields();
		$this->SetHeader( $ps_Header );
		$this->SetSpecial( $ps_Special );
		$this->SetID( NULL );
		$this->maAttributes = array();
	}
	/* -------------------- end Constructor -------------------- */





	/* -------------------- methods to access fields -------------------- */
	function ClearFields() {
		$this->ma_Fields = array();
	}

	function &AppendFields( $po_Field ) {
		global $DEBUG;
		if( !is_array( $po_Field ) ){
			$po_Field = func_get_args();
		}

		foreach( $po_Field as $lo_Field ){
			$this->ma_Fields[] = $lo_Field;
		}

		return $this->ma_Fields[count($this->ma_Fields)-1];
	}

	function &GetFields( $ps_Index = NULL ) {
		if( is_null( $ps_Index ) )
			return $this->ma_Fields;
		elseif( $ps_Index == cc_LastElement )
			return $this->ma_Fields[count($this->ma_Fields)-1];
		return $this->ma_Fields[$ps_Index];
	}

	function CountFields() {
		return count( $this->ma_Fields );
	}
	/* -------------------- end methods to access fields -------------------- */





	/* -------------------- SetDisabled -------------------- */
	function SetDisabled( $ps_Disabled ) {
		$la_Fields =& $this->GetFields();
		foreach( array_keys($la_Fields) as $ls_Key )
			$la_Fields[$ls_Key]->SetDisabled($ps_Disabled);
	}
	/* -------------------- end SetDisabled -------------------- */





	/* -------------------- Set.../Get... -------------------- */
	function SetHeader( $ps_Header ) {
		$this->ms_Header = $ps_Header;
	}

	function GetHeader() {
		return $this->ms_Header;
	}

	function SetSpecial( $ps_Special ) {
		$this->ms_Special = $ps_Special;
	}

	function GetSpecial() {
		return $this->ms_Special;
	}

	function SetID( $ps_ID ) {
		$this->ms_ID = $ps_ID;
	}

	function GetID() {
		return $this->ms_ID;
	}

	function &getClone() {
		global $DEBUG;
		$loClone =& new DataRow( $this->GetHeader(), $this->GetSpecial() );

		$laFields = $this->GetFields();

		$laVer = explode('.',phpversion());
		if( $laVer[0] >= 5 ) {
			for( $i=0; $i<count($laFields); $i++ ){
				$laFields[$i] =& getClone( $laFields[$i] );
			}
		}

		$loClone->AppendFields( $laFields );
		
		return $loClone;
	}

	function SetAttribute( $pcKey, $pcValue ){
		$this->maAttributes[$pcKey] = $pcValue;
		return $this->maAttributes[$pcKey];
	}
	
	function &GetAttribute( $pcKey=NULL ){
		if(is_null($pcKey)){
			return $this->maAttributes;
		} else {
			if( array_key_exists( $pcKey, $this->maAttributes ) ){
				return  $this->maAttributes[$pcKey];
			}
		}
		return NULL;
	}

	function AppendAttributes( $paAttrs ){
		if( is_array( $paAttrs ) ){
			$this->maAttributes = array_merge( $paAttrs, $this->maAttributes );
		}
	}

	function OverwriteAttributes( $paAttrs ){
		if( is_array( $paAttrs ) ){
			$this->maAttributes = array_merge( $this->maAttributes, $paAttrs );
		}
	}

	/* -------------------- end Set.../Get... -------------------- */





	/* -------------------- SetFromArray -------------------- */
	function SetFromArray( $pa_Data ) {
		$la_Fields =& $this->GetFields();
		foreach( array_keys( $la_Fields ) as $ls_Key )
			$la_Fields[$ls_Key]->SetFromArray( $pa_Data );
	}
	/* -------------------- end SetFromArray -------------------- */


	function &GetOutputPresentation( $paRowAttributes = array(), $paCellAttributes = array() ) {
		
		$loRow = new TRElement( $this->AppendAttributes( $paRowAttributes ) );
		$llHeader = $this->GetHeader();
		$loRow->isHeader( $llHeader );

		
		foreach( $this->GetFields() as $loField ){
			$loRow->AppendCell( $paCellAttributes, $llHeader, $loField->GetOutputPresentation() );
		}

		return $loRow;
	}

	function &GetInputPresentation( $paRowAttributes = array(), $paCellAttributes = array() ) {
		$loRow = new TRElement( $this->AppendAttributes( $paRowAttributes ) );
		$llHeader = $this->GetHeader();
		$loRow->isHeader( $llHeader );

		
		foreach( $this->GetFields() as $loField ){
			$loRow->AppendCell( $paCellAttributes, $llHeader, $loField->GetInputPresentation() );
		}

		return $loRow;
	}


}
?>
