<?
########## Confixx(R) 3.1 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####

/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once( dirname(__FILE__) . "/class.Limit.php" );
include_once( dirname(__FILE__) . "/class.KBLimitDataField.php" );





class KBLimit extends Limit {

	/* -------------------- Members -------------------- */
	var $ms_KBName; // name of options field
	var $ms_KBValue; // value of options field
	var $ma_KBOptions; // options
	/* -------------------- end Members -------------------- */





	/* -------------------- Constructor -------------------- */
	function KBLimit( $ps_Name, $ps_HardName, $ps_KBName, $ps_Value="", $ps_KBValue="KB" ) {
		global $lang_format_gb_expr, $lang_format_mb_expr, $lang_format_kb_expr;
		$this->Limit( $ps_Name, $ps_HardName, $ps_Value );
		$this->SetKBName( $ps_KBName );
		$this->ClearOptions();
		$this->AppendToOptions( array( "KB"=>$lang_format_kb_expr, "MB"=>$lang_format_mb_expr,
					"GB"=>$lang_format_gb_expr ) );
		$this->SetKBValue( $ps_KBValue );
		
	}
	/* -------------------- end Constructor -------------------- */


	/* -------------------- Set.../Get... -------------------- */
	function SetKBName( $ps_KBName ) {
		$this->ms_KBName = $ps_KBName;
	}

	function GetKBName() {
		return $this->ms_KBName;
	}

	function SetKBValue( $ps_KBValue ) {
		$this->ms_KBValue = $ps_KBValue;
	}

	function GetKBValue() {
		return $this->ms_KBValue;
	}

	function GetNormalizedValue() {
		if ( $this->ms_KBValue == 'MB' ) {
			return $this->GetValue() * 1024;
		} elseif ( $this->ms_KBValue == 'GB' ) {
			return $this->GetValue() * 1024 * 1024;
		} else {
			return $this->GetValue();
		}
	}
	/* -------------------- end Set.../Get... -------------------- */





	/* -------------------- SetFromArray -------------------- */
	function SetFromArray( $pa_Data ) {
		global $DEBUG;
		Limit::SetFromArray( $pa_Data );
		$ls_Name = $this->GetKBName();
		if($DEBUG){
			/*
			echo "KBLimit::SetFromArray<br><pre>\n";
			print_r($this);
			echo "</pre><hr>\n";
			*/
		}
		if( is_null($ls_Name) )
			return;
		$this->SetKBValue( array_key_exists( $ls_Name, $pa_Data ) ? $pa_Data[$ls_Name] : "MB" );
		if($DEBUG){
			/*
			echo "KBLimit::SetFromArray (after SetKBValue)<br><pre>\n";
			print_r($this);
			echo "</pre><hr>\n";
			*/
		}

	}
	/* -------------------- end SetFromArray -------------------- */





	/* -------------------- options -------------------- */
	function ClearOptions() {
		$this->ma_KBOptions = array();
	}

	function AppendToOptions( $pa_New ) {
		foreach( $pa_New as $ls_Key => $ls_Value )
			$this->ma_KBOptions[$ls_Key] = $ls_Value;
	}

	function GetOptions() {
		return $this->ma_KBOptions;
	}
	/* -------------------- end options -------------------- */





	/* -------------------- definitions of "abstract" methods -------------------- */
	function GetField() {
		$lo_Result = new KBLimitDataField( $this->GetName(), $this->GetKBName(), $this->GetValue(), $this->GetKBValue() );
		$lo_Result->AppendToOptions( $this->GetOptions() );
		if( $this->GetValue() < 0 )
			$lo_Result->SetDisabled( TRUE );
		return $lo_Result;
	}

	function GetOff( $pi_FromIndex=NULL, $pi_FieldIndex=NULL) {
		if (!is_numeric($pi_FromIndex)){
			$pi_FromIndex = $this->FormIndex();
		}
		if ( !is_numeric($pi_FieldIndex) ) {
			$pi_FieldIndex = 0;
		}
		$la_Result = array( "document.forms[$pi_FromIndex].".$this->GetName()."[0]" );
		$ls_Name = $this->GetKBName();
		if( !is_null($ls_Name) )
			$la_Result[] = "document.forms[$pi_FromIndex].$ls_Name";
		$ls_Name = $this->GetHardName();
		if( !is_null($ls_Name) )
			$la_Result[] = "document.forms[$pi_FromIndex].$ls_Name";
		return $la_Result;
	}
	/* -------------------- end definitions of "abstract" methods -------------------- */

}
?>
