<?
########## Confixx(R) 3.1 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once( dirname(__FILE__) . "/class.OneValueDataField.php" );
include_once( dirname(__FILE__) . "/../html/class.InputTextElement.php" );
include_once( dirname(__FILE__) . "/../html/class.SelectElement.php" );
include_once( dirname(__FILE__) . "/../html/class.TextElement.php" );
include_once( dirname(__FILE__) . "/../html/class.CompoundElement.php" );
include_once( dirname(__FILE__) . "/../html/class.InputHiddenElement.php" );

class KBLimitDataField extends OneValueDataField {

	/* -------------------- Members -------------------- */
	var $ms_KBName;
	var $ms_KBValue;
	var $ma_KBOptions;
	/* -------------------- end Members -------------------- */


	/* -------------------- Constructor -------------------- */
	function KBLimitDataField( $ps_Name, $ps_KBName, $ps_Value, $ps_KBValue ) {

		global $DEBUG;
		if($DEBUG){
#			echo "KBLimitDataField::KBLimitDataField $ps_Name, $ps_KBName, $ps_Value, $ps_KBValue<br>\n";
		}

		/*
		if( is_numeric($ps_Value) && $ps_Value>0 ){
			if($ps_KBValue=='MB'){
				$ps_Value=$ps_Value/1024;
			}elseif($ps_KBValue=='GB'){
				$ps_Value=$ps_Value/1048576;
			}
		}
		*/
		if($DEBUG){
#			echo "KBLimitDataField::KBLimitDataField $ps_Name, $ps_KBName, $ps_Value, $ps_KBValue<br>\n";
		}

		$this->OneValueDataField( $ps_Value, $ps_Name );
		$this->ClearOptions();
		$this->SetKBName( $ps_KBName );
		$this->SetKBValue( $ps_KBValue );
		
		$this->Normalize();
		
	}
	/* -------------------- end Constructor -------------------- */



	/* -------------------- KB options -------------------- */
	function ClearOptions() {
		$this->ma_KBOptions = array();
	}

	function AppendToOptions( $pa_New ) {
		foreach( $pa_New as $ls_Key => $ls_Value )
			$this->ma_KBOptions[$ls_Key] = $ls_Value;
	}

	function GetOptions() {
		return $this->ma_KBOptions;
	}
	/* -------------------- end KB options -------------------- */

	/* -------------------- Set.../Get... -------------------- */
	function SetKBName( $ps_KBName ) {
		$this->ms_KBName = $ps_KBName;
	}

	function GetKBName() {
		return $this->ms_KBName;
	}

	function SetKBValue( $ps_KBValue ) {
		$this->ms_KBValue = $ps_KBValue;
	}

	function GetKBValue() {
		return $this->ms_KBValue;
	}

	function GetNormalizedValue() {
		if ( $this->ms_KBValue == 'MB' ) {
			return $this->GetValue() * 1024;
		} elseif ( $this->ms_KBValue == 'GB' ) {
			return $this->GetValue() * 1024 * 1024;
		} else {
			return $this->GetValue();
		}
	}
	/* -------------------- end Set.../Get... -------------------- */

	/* -------------------- definitions of "abstract" methods -------------------- */
	function SetFromArray( $pa_Data ) {
		$ll_recalc=1;
		$ls_nameKB = $this->GetKBName();
		if(array_key_exists($ls_nameKB,$pa_Data)){
			$this->SetKBValue($pa_Data[$ls_nameKB]);	
			$ll_recalc=0;
		}
		$ls_nameValue = $this->GetName();
		if(array_key_exists($ls_nameValue,$pa_Data)){
			$li_newValue = $pa_Data[$ls_nameValue];
			if ($ll_recalc && is_numeric($li_newValue)){
				$ls_valueKB = $this->GetKBValue();
				if($ls_valueKB=='MB'){		
					$li_newValue = $li_newValue/1024;
				}elseif($ls_valueKB=='GB'){
					$li_newValue = $li_newValue/1048576;
				}	
			}	
			$this->SetValue($pa_Data[$li_newValue]);
		}
		$this->Normalize();
	}
	
	function Normalize(){

		global $DEBUG;
		if($DEBUG){

			/*
			 echo "KBLimitDataField::Normalize<br><pre>\n";
			 print_r($this);
			 echo "</pre><hr>\n";
			*/
		}

		$li_Value = $this->GetValue();
		if (!is_numeric($li_Value)){
			return;
		}
		
		if ($li_Value > 0) {
      $lc_valueKB = 'KB';
		} else {
      $lc_valueKB = $this->GetKBValue();
		}
		
 		// KB -> MB
 		if ( $li_Value % 1024 == 0 ) {
 			$li_Value = $li_Value/1024;
 			$lc_valueKB = 'MB';
 		}	
 		
 		if (!is_null($this->GetKBName())) {
   		// MB -> GB
   		if ( $li_Value % 1024 == 0 ) { 
   			$li_Value = $li_Value/1024;
   			$lc_valueKB = 'GB';
  		}
 		}
		$this->SetValue($li_Value);
		$this->SetKBValue($lc_valueKB);
		
	}
	
	function GetInputPresentation( $ps_ID=NULL ) {
	  
		$la_Attributes = $this->GetAttributes( $ps_ID );
		$la_Attributes["size"] = cc_LimitSize;
		$la_Attributes["value"] = $this->GetValue();
		$lo_Result = new CompoundElement( new InputTextElement( $la_Attributes ) );
		$lo_Result->SetSeparator( " " );
		$la_Options = $this->GetOptions();
		$ls_Name = $this->GetKBName();

		if( is_null($ls_Name) )
			$lo_Result->AppendToContent( new HTMLElement($la_Options[$this->GetKBValue()]) );
		else {
			$lo_Select = new SelectElement( $this->GetDisabled() ? array( "disabled"=>NULL, "name"=>$ls_Name ) :
					array( "name"=>$ls_Name ) );
			$ls_Selected = $this->GetKBValue();
			foreach( $this->GetOptions() as $ls_Key => $ls_Value )
				$lo_Select->AppendToContent( new OptionElement( $ls_Key == $ls_Selected ? array( "value"=>$ls_Key,
								"selected"=>NULL ) : array( "value"=>$ls_Key ), $ls_Value ) );
			$lo_Result->AppendToContent( $lo_Select );
		}
		return $lo_Result;
	}

	function GetOutputPresentation() {
		$li_Value = $this->GetValue();
		$lc_valueKB = $this->GetKBValue();
		if( $li_Value < 0 )
			return new HTMLElement( ltext("ldf_unlimited") );
		$la_Options = $this->GetOptions();
   
	 // KB -> MB
   if( $li_Value > 1000 && $lc_valueKB == 'KB'){
   	if( $li_Value % 1024 !=0 )
     	$li_Value = sprintf( "%.2f", ( $li_Value/1024 ) );
     else 
     	$li_Value = $li_Value/1024;
   	  $lc_valueKB = 'MB';
   }
   // MB -> GB
   if( $li_Value > 1000 && $lc_valueKB == 'MB'){
   	if( $li_Value % 1024 !=0 )
     	$li_Value = sprintf( "%.2f", ( $li_Value/1024 ) );
     else 
     	$li_Value = $li_Value/1024;
   	  $lc_valueKB = 'GB';
   } 
		$lo_Result = new CompoundElement( new TextElement( $li_Value ),
				new HTMLElement( $la_Options[$lc_valueKB] ) );
		$lo_Result->SetSeparator( " " );
		return $lo_Result;
	}

	function GetHiddenPresentation( $ps_ID=NULL ) {
		$liValue = $this->GetValue();
		$lcKBValue = $this->GetKBValue();
		if ( $lcKBValue == 'MB') {
			$liValue *= 1024;
			$lcKBValue = 'KB';
		} elseif( $lcKBValue == 'GB' ) {
			$liValue *= 1048576;
			$lcKBValue = 'KB';
		}

		$lo_Result = new CompoundElement(
																		 new InputHiddenElement( array( "name"=>$this->GetNameWithID( $ps_ID ),
																																		"value"=>$liValue ) 
																														 ), 
																		 new InputHiddenElement( array( "name"=>$this->GetKBName(),
																																		"value"=>$lcKBValue ) 
																														 ) 
																		 );
		$lo_Result->SetSeparator( "" );
		return $lo_Result;
	}
	/* -------------------- end definitions of "abstract" methods -------------------- */

}
?>
