<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once( dirname(__FILE__) . "/class.Data.php" );
include_once( dirname(__FILE__) . "/class.DataRow.php" );
include_once( dirname(__FILE__) . "/../html/module.Constants.php" );
include_once( dirname(__FILE__) . "/../html/class.InfoTable.php" );
include_once( dirname(__FILE__) . "/../html/class.InputForm.php" );
include_once( dirname(__FILE__) . "/../html/class.CompoundElement.php" );
include_once( dirname(__FILE__) . "/../html/class.FileTree.php" );
include_once( dirname(__FILE__) . "/class.FormButtonData.php" );
include_once( dirname(__FILE__) . "/../../module.Database.php" );





class SetOfRowsData extends Data {

	/* -------------------- Members -------------------- */
	var $ma_Rows; // rows
	var $ma_Buttons; // buttons
	var $ma_Template; // template for rows
	var $ma_Hidden; // hidden fields
	var $mm_SpecialFunction; // function to test special rows
	var $ms_HasData; // if set of rows has data
	var $mi_LabelIndex; // index of label's cell
	/* -------------------- end Members -------------------- */





	/* -------------------- Constructor -------------------- */
	function SetOfRowsData() {
		$this->ClearRows();
		$this->ClearButtons();
		$this->ClearTemplate();
		$this->ClearHidden();
		$this->SetSpecialFunction( NULL );
		$this->SetHasData( FALSE );
		$this->LabelIndex(0);
	}
	/* -------------------- end Constructor -------------------- */


	function &LabelIndex( $piIndex=NULL){
		if(is_numeric($piIndex)){
			$this->mi_LabelIndex = $piIndex;
		}
		return $this->mi_LabelIndex;
	}


	/* -------------------- methods to access rows -------------------- */
	function ClearRows() {
		$this->ma_Rows = array();
	}

	function &AppendHeaderRow() {
		$lo_Row = new DataRow( TRUE );
		$la_Arguments = func_get_args();
		if( count($la_Arguments) )
			call_user_func_array( array( &$lo_Row, "AppendFields" ), $la_Arguments );
		$this->ma_Rows[] =& $lo_Row;
		return $lo_Row;
	}
	
	function &InsertHeaderRowBefor(){
		$lo_Row = new DataRow( TRUE );
		$la_Arguments = func_get_args();
		if(is_numeric($la_Arguments[0])){
			$li_Index = $la_Arguments[0];
			if($li_Index>=count($this->ma_Rows)){
				$li_Index = cc_LastElement;
			}
			array_shift($la_Arguments);
		}else{
			$li_Index	= 0;
		}
		
		call_user_func_array( array( &$lo_Row, "AppendFields" ), $la_Arguments );
//		
// insert element into array befor $li_Index
// if $li_Index	== -1 appen at end
//	
		if ($li_Index == cc_LastElement){
			$this->ma_Rows[] = $lo_Row;
		}elseif($li_Index == 0 ){
			array_unshift($this->ma_Rows,$lo_Row);
		}else{
			array_unshift($this->ma_Rows,0); // append blank element to begin of array
			for ($li_I=0; $li_I<$li_Index; $li_I++){ // shift $li_Index elements to left
				$this->ma_Rows[$li_I]=$this->ma_Rows[$li_I+1];
			}
			$this->ma_Rows[$li_Index] = $lo_Row; // insert new element
		}	
// end insert		
		return $lo_Row;
	}

	function &AppendRow( $poRow = NULL ) {
		if( is_a( $poRow, 'DataRow' ) ){
			$this->ma_Rows[] =& $poRow;
			$loRow =& $poRow;
		} else {
			$lo_Row = new DataRow( FALSE );
			if( is_array( $poRow )){
				$la_Arguments =& $poRow; 
			} else {
				$la_Arguments = func_get_args();
			}
			if( count($la_Arguments) ) {
				call_user_func_array( array( &$lo_Row, "AppendFields" ), $la_Arguments );
			}
			$this->ma_Rows[] =& $lo_Row;
		}
		$this->SetHasData( TRUE );
		return $lo_Row;
	}

	function AppendRowsFrom( $po_Data ) {
		foreach( $po_Data->GetRows() as $lo_Row )
			$this->ma_Rows[] = $lo_Row;
	}

	function &InsertRow( $ps_Index ) {
		$la_Arguments = func_get_args();
		array_shift( $la_Arguments );
		$lo_Row = new DataRow( FALSE );
		call_user_func_array( array( &$lo_Row, "AppendFields" ), $la_Arguments );
		array_splice( $this->ma_Rows, $ps_Index, 0, array( $lo_Row ) );
		$this->SetHasData( TRUE );
		return $lo_Row;
	}

	function &GetRows( $ps_Index = NULL ) {
		if( is_null( $ps_Index ) )
			return $this->ma_Rows;
		elseif( $ps_Index == cc_LastElement )
			return $this->ma_Rows[ count($this->ma_Rows) - 1 ];
		return $this->ma_Rows[$ps_Index];
	}

	function SetRowID( $ps_ID ) {
		$lo_Row =& $this->GetRows( cc_LastElement );
		$lo_Row->SetID( $ps_ID );
	}

	function AppendFields( $po_First ) {
		$lo_Row =& $this->GetRows( cc_LastElement );
		$la_Arguments = func_get_args();
		call_user_func_array( array( &$lo_Row, "AppendFields" ), $la_Arguments );
	}

	function CountColumns() {
		$ls_Result = 0;
		foreach( $this->GetRows() as $lo_Row )
			if( $ls_Result < $lo_Row->CountFields() )
				$ls_Result = $lo_Row->CountFields();
		return $ls_Result;
	}

	function CountRows() {
		return count( $this->ma_Rows );
	}
	/* -------------------- end methods to access rows -------------------- */





	/* -------------------- SetFromArray -------------------- */
	function SetFromArray( $pa_Data ) {
		$la_Rows =& $this->GetRows();
		foreach( array_keys($la_Rows) as $ls_Key ) {
			$la_Fields =& $la_Rows[$ls_Key]->GetFields();
			foreach( array_keys($la_Fields) as $ls_FieldKey )
				$la_Fields[$ls_FieldKey]->SetFromArray( $pa_Data );
		}
	}
	/* -------------------- end SetFromArray -------------------- */





	/* -------------------- methods to access hidden fields -------------------- */
	function ClearHidden() {
		$this->ma_Hidden = array();
	}

	function AppendHidden( $po_First ) {
		$la_Arguments = func_get_args();
		array_splice( $this->ma_Hidden, count($this->ma_Hidden), 0, array_values( $la_Arguments ) );
	}

	function &GetHidden( $ps_Index = NULL ) {
		if( is_null( $ps_Index ) )
			return $this->ma_Hidden;
		elseif( $ps_Index == cc_LastElement )
			return $this->ma_Hidden[ count($this->ma_Hidden) - 1 ];
		return $this->ma_Hidden[$ps_Index];
	}

	function CountHidden() {
		return count( $this->ma_Hidden );
	}
	/* -------------------- end methods to access hidden fields -------------------- */





	/* -------------------- methods to support templates -------------------- */
	function ClearTemplate() {
		$this->ma_Template = array();
	}

	function AppendToTemplate( $po_First ) {
		foreach( func_get_args() as $lo_Field )
			$this->ma_Template[] = $lo_Field;
	}

	function &GetTemplate( $ps_Index = NULL ) {
		if( is_null( $ps_Index ) )
			return $this->ma_Template;
		elseif( $ps_Index == cc_LastElement )
			return $this->ma_Template[ count($this->ma_Template) - 1 ];
		return $this->ma_Template[$ps_Index];
	}


	function &cloneTemplate(){
		global $DEBUG;
		/*
		if( $DEBUG ){
			echo "SetOfRowsData::cloneTemplate : template<br><pre>\n";
			print_r($this->ma_Template);
			echo "</pre><hr>\n";
		}
		*/
		$laRet = array();
		if( is_array( $this->ma_Template ) ) {
			foreach( $this->ma_Template as $loField ) {
				$laRet[] =& getClone( $loField );
			}
		}
		return $laRet;
	}
	/* -------------------- end methods to support templates -------------------- */





	/* -------------------- method to support "no data" situation -------------------- */
	function SetHasData( $ps_Flag ) {
		$this->ms_HasData = $ps_Flag;
	}

	function GetHasData() {
		return $this->ms_HasData;
	}
	/* -------------------- end method to support "no data" situation -------------------- */





	/* -------------------- SetDisabled -------------------- */
	function SetDisabled( $ps_Disabled ) {
		$la_Rows =& $this->GetRows();
		foreach( array_keys($la_Rows) as $ls_Key )
			$la_Rows[$ls_Key]->SetDisabled($ps_Disabled);
	}
	/* -------------------- end SetDisabled -------------------- */





	/* -------------------- GenerateFromSQL -------------------- */
	function GenerateFromSQL( $ps_Query ) {

		global $DEBUG;

		$lo_DB =& get_db_connection();
		$lo_Query =& $lo_DB->Select( $ps_Query );

		while( $la_Row =& $lo_Query->nextrow() ) {

			$la_Template =& $this->cloneTemplate();

			foreach( array_keys( $la_Template ) as  $ls_Key )
				$la_Template[$ls_Key]->SetFromArray( $la_Row );

			/*
			if($DEBUG){
				echo "SetOfRowsData::GenerateFromSQL : template<br><pre>\n";
				print_r($la_Template);
				echo "</pre><hr>\n";
			}
			*/
			call_user_func_array( array( &$this, "AppendRow" ), $la_Template );

			$lo_Row =& $this->GetRows( cc_LastElement );

			$lo_Row->SetSpecial( $this->IsSpecialRow($la_Row) );
		}
	}
	/* -------------------- end GenerateFromSQL -------------------- */





	/* -------------------- GenerateFromArray -------------------- */
	function GenerateFromArray( $pa_Array ) {
		foreach( array_keys($pa_Array) as $ls_Key ) {
			$la_Template = $this->GetTemplate();
			foreach( array_keys( $la_Template ) as  $ls_TemplateKey )
				$la_Template[$ls_TemplateKey]->SetFromArray( $pa_Array[$ls_Key] );
			call_user_func_array( array( &$this, "AppendRow" ), $la_Template );
			$lo_Row =& $this->GetRows( cc_LastElement );
			$lo_Row->SetSpecial( $this->IsSpecialRow($pa_Array[$ls_Key]) );
		}
	}
	/* -------------------- end GenerateFromArray -------------------- */





	/* -------------------- methods to support special rows -------------------- */
	function SetSpecialFunction( $pm_SpecialFunction ) {
		$this->mm_SpecialFunction = $pm_SpecialFunction;
	}

	function GetSpecialFunction() {
		return $this->mm_SpecialFunction;
	}

	function IsSpecialRow( $pa_Row ) {
		$lm_Function = $this->GetSpecialFunction();
		return !is_null( $lm_Function ) && call_user_func( $lm_Function, $pa_Row );
	}
	/* -------------------- end methods to support special rows -------------------- */





	/* -------------------- methods to access buttons -------------------- */
	function ClearButtons() {
		$this->ma_Buttons = array();
	}

	function AppendButton( $ps_Label, $ps_JS="javascript:doChange()", 
												 $ps_ID=NULL, $plIsSubmit=NULL ) {

		$this->ma_Buttons[] = new FormButtonData( $ps_Label, 
																							$ps_JS, 
																							$ps_ID,
																							$plIsSubmit
																							);

	}

	function &GetButtons( $ps_Index = NULL ) {
		if( is_null( $ps_Index ) )
			return $this->ma_Buttons;
		elseif( $ps_Index == cc_LastElement )
			return $this->ma_Buttons[ count($this->ma_Buttons) - 1 ];
		return $this->ma_Buttons[$ps_Index];
	}
	/* -------------------- end methods to access buttons -------------------- */





	/* -------------------- definitions of "abstract" methods -------------------- */
	function GetInputPresentation( $pa_FormAttributes, $pm_Title = NULL, $pm_NoData = NULL, 
	                               $ps_FormFlags = cc_IncludeForm, $ps_TableClass = null ) {
		if( !is_null($pm_NoData) && !$this->GetHasData() )
			return is_object( $pm_NoData ) ? $pm_NoData : new HTMLElement( $pm_NoData );

		$lo_Result = new InputForm( $pa_FormAttributes, $pm_Title, $ps_FormFlags, $ps_TableClass );

		$lo_Result->LabelIndex( $this->LabelIndex() );

		foreach( $this->GetRows() as $lo_Row ) {

			if( method_exists( $lo_Row, 'GetHeader' ) ) {
				$lo_Result->AppendRow( array(), $lo_Row->GetHeader() );

			} else {
				echo "SetOfRowsData::GetInputPresentation: bad type<br><pre>\n";
				print_r($lo_Row);
				echo "</pre><hr>\n";
			}

			foreach( $lo_Row->GetFields() as $lo_Field ) {
				$la_Attributes = $lo_Field->GetColSpan()==1 ? array() : array( "colspan"=>$lo_Field->GetColSpan() );
				$la_Attributes = array_merge( $la_Attributes, $lo_Field->GetParentAttributes() );
				if( $lo_Row->GetSpecial() )
					$la_Attributes["class"] = "spaciallistitem";
				$lo_Result->AppendCell( $la_Attributes, $lo_Field->GetInputPresentation($lo_Row->GetID()) );
			}
		}

		foreach( $this->GetButtons() as $lo_Button )
			$lo_Result->AppendButton( $lo_Button->GetInputPresentation() );

		foreach( $this->GetHidden() as $lo_Hidden )
			$lo_Result->AppendHidden( $lo_Hidden->GetHiddenPresentation() );

		return $lo_Result;
	}

	function GetTreePresentation( $pa_FormAttributes, $pm_Title, $ps_URL, $ps_Parameter, $ps_Path ) {
		$lo_Result = new FileTree( $pa_FormAttributes, $pm_Title, $ps_URL, $ps_Parameter, $ps_Path );
		foreach( $this->GetRows() as $lo_Row ) {
			$lo_Result->AppendRow( array(), $lo_Row->GetHeader() );
			foreach( $lo_Row->GetFields() as $lo_Field ) {
				$la_Attributes = $lo_Field->GetColSpan()==1 ? array() : array( "colspan"=>$lo_Field->GetColSpan() );
				$la_Attributes = array_merge( $la_Attributes, $lo_Field->GetParentAttributes() );
				if( $lo_Row->GetSpecial() )
					$la_Attributes["class"] = "spaciallistitem";
				$lo_Result->AppendCell( $la_Attributes, $lo_Field->GetTreePresentation() );
			}
		}
		foreach( $this->GetButtons() as $lo_Button )
			$lo_Result->AppendButton( $lo_Button->GetInputPresentation() );

		foreach( $this->GetHidden() as $lo_Hidden )
			$lo_Result->AppendHidden( $lo_Hidden->GetHiddenPresentation() );

		return $lo_Result;
	}

	function GetListPresentation( $pa_FormAttributes, $pm_Title, $pm_NoData=NULL, $ps_FormFlags=cc_IncludeForm ) {
		// don't use this method, use PagedSetOfRowsData class to implement lists
		$lo_Result = $this->GetInputPresentation( $pa_FormAttributes, $pm_Title, $pm_NoData, $ps_FormFlags );
		$lo_Table =& $lo_Result->GetTable();
		$lo_Table->AppendAttributes( array( "width"=>"100%" ));
		return $lo_Result;
	}

	function GetOutputPresentation( $pm_Title=NULL, $pm_NoData=NULL ) {
		if( !is_null($pm_NoData) && !$this->GetHasData() )
			return is_object( $pm_NoData ) ? $pm_NoData : new HTMLElement( $pm_NoData );
		$lo_Result = new InfoTable( $pm_Title );
		foreach( $this->GetRows() as $lo_Row ) {
			$lo_Result->AppendRow( array(), $lo_Row->GetHeader() );
			foreach( $lo_Row->GetFields() as $lo_Field ) {
				$la_Attributes = $lo_Field->GetColSpan()==1 ? array() : array( "colspan"=>$lo_Field->GetColSpan() );
				$la_Attributes = array_merge($la_Attributes,$lo_Field->GetParentAttributes());
				if( $lo_Row->GetSpecial() )
					$la_Attributes["class"] = "spaciallistitem";
				$lo_Result->AppendCell( $la_Attributes, $lo_Field->GetOutputPresentation() );
			}
		}
		return $lo_Result;
	}

	function GetHiddenPresentation() {
		$lo_Result = new CompoundElement();

		foreach( $this->GetRows() as $lo_Row )
			foreach( $lo_Row->GetFields() as $lo_Field )
				$lo_Result->AppendToContent( $lo_Field->GetHiddenPresentation() );

		foreach( $this->GetHidden() as $lo_Hidden )
			$lo_Result->AppendHidden( $lo_Hidden->GetHiddenPresentation() );

		return $lo_Result;
	}



	/* -------------------- end definitions of "abstract" methods -------------------- */

	function &GetTableOutputPresentation( $paTableAttributes = array(), 
																				$paRowAttributes = array(),
																				$paCellAttributes = array() ) {
		$loTable = new TableElement( $paTableAttributes );
		foreach( $this->GetRows() as $loRow ) {
			$loTable->AppendToContent( $loRow->GetOutputPresentation( $paRowAttributes, 
																																$paCellAttributes) );
		}
		return $loTable;
	}

	function &GetTableInputPresentation( $paTableAttributes = array(), 
																			 $paRowAttributes = array(),
																			 $paCellAttributes = array() ) {
		$loTable = new TableElement( $paTableAttributes );
		foreach( $this->GetRows() as $loRow ) {
			$loTable->AppendToContent( $loRow->GetInputPresentation( $paRowAttributes, 
																															 $paCellAttributes ) );
		}
		return $loTable;
	}

}
?>
