<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once( dirname(__FILE__) . "/class.OneValueDataField.php" );
include_once( dirname(__FILE__) . "/../html/class.InputTextElement.php" );
include_once( dirname(__FILE__) . "/../html/class.TextElement.php" );
include_once( dirname(__FILE__) . "/../html/class.HTMLElement.php" );
include_once( dirname(__FILE__) . "/../html/class.CompoundElement.php" );





class TextLimitDataField extends OneValueDataField {

	/* -------------------- Constructor -------------------- */
	function TextLimitDataField( $ps_Value, $ps_Name="" ) {
		$this->OneValueDataField( $ps_Value, $ps_Name );
	}
	/* -------------------- end Constructor -------------------- */





	/* -------------------- definitions of "abstract" methods -------------------- */
	function GetInputPresentation( $ps_ID=NULL ) {
		$la_Attributes = $this->GetAttributes( $ps_ID );
		$la_Attributes["value"] = $this->GetValue();
		$la_Attributes["size"] = cc_LimitSize;
		$lo_Result = new CompoundElement( new InputTextElement( $la_Attributes ), ltext("ldf_maximum") );
		$lo_Result->SetSeparator( " " );
		return $lo_Result;
	}

	function GetOutputPresentation() {
		$ls_Value = $this->GetValue();
		return $ls_Value < 0 ? new HTMLElement( ltext("ldf_unlimited") ) : new TextElement( $ls_Value );
	}

	function GetHiddenPresentation( $ps_ID=NULL ) {
		return new InputHiddenElement( array( "name"=>$this->GetNameWithID( $ps_ID ), "value"=>$this->GetValue() ) );
	}
	/* -------------------- end definitions of "abstract" methods -------------------- */

}
?>
