<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once( dirname(__FILE__) . "/module.Constants.php" );
include_once( dirname(__FILE__) . "/class.HTMLElement.php" );
include_once( dirname(__FILE__) . "/../../page_functions.php" );





class MainPageElement {

	/* -------------------- Members -------------------- */
	var $ma_Elements; // elements in page
	var $ma_Help; // help elements
	/* -------------------- end Members -------------------- */





	/* -------------------- Constructor -------------------- */
	function MainPageElement( ) {
		$this->ClearContent();
		$la_Arguments = func_get_args();
		if( count($la_Arguments) )
			call_user_func_array( array( &$this, "AppendToContent" ), $la_Arguments );
		$this->SetHelp( array() );
	}
	/* -------------------- end Constructor -------------------- */





	/* -------------------- methods to access elements -------------------- */
	function AppendToContent( $pm_First ) {
		foreach( func_get_args() as $lm_Element )
			$this->ma_Elements[] = is_object($lm_Element) ? $lm_Element : new HTMLElement( $lm_Element );
	}

	function ClearContent() {
		$this->ma_Elements = array();
	}

	function &GetContent( $ps_Index = NULL ) {
		if( is_null( $ps_Index ) )
			return $this->ma_Elements;
		if( $ps_Index == cc_LastElement )
			return $this->ma_Elements[ count($this->ma_Elements)-1 ];
		return $this->ma_Elements[$ps_Index];
	}

	function InsertToContent( $ps_Index, $pm_First ) {
		$la_Arguments = func_get_args();
		array_shift( $la_Arguments );
		foreach( array_reverse($la_Arguments) as $lm_Element ) {
			array_splice( $this->ma_Elements, $ps_Index, 0, array( is_object($lm_Element) ? $lm_Element :
					new HTMLElement( $lm_Element ) ) );
		}
	}
	/* -------------------- end methods to access elements -------------------- */





	/* -------------------- methods to access help elements -------------------- */
	function SetHelp( $pa_Help ) {
		$this->ma_Help = $pa_Help;
	}

	function GetHelp() {
		return $this->ma_Help;
	}

	function AppendToHelp( $pa_First ) {
		foreach( func_get_args() as $la_ToAdd )
			$this->ma_Help[] = $la_ToAdd;
	}
	/* -------------------- end methods to access help elements -------------------- */





	/* -------------------- OutputHTML -------------------- */
	function OutputHTML( $ps_IncludeJS = FALSE, $ps_PartJS = FALSE ) {

		global $DEBUG;

		$lo_PartJS=FALSE;
		if(is_array($ps_IncludeJS)){
			$lo_IncludeJS=$ps_IncludeJS;
		}else{
			if(is_string($ps_IncludeJS)){
				$lo_PartJS = $ps_IncludeJS;
			}
			$lo_IncludeJS=FALSE;
		}	
		if(is_string($ps_PartJS)){
			$lo_PartJS=is_string($lo_PartJS)?$lo_PartJS."\n".$ps_PartJS:$ps_PartJS;
		}
		
		print_header( $lo_IncludeJS, $lo_PartJS );
		
		$la_AllHelp = $this->GetHelp();
		if( count($la_AllHelp) ) {
			echo( "<script>\n" );
			foreach( $la_AllHelp as $la_Help )
				echo js_f_call_help( $la_Help[0], $la_Help[1] );
			echo( "</script>\n" );
		}

		foreach( $this->GetContent() as $lo_Element ) {
			$lo_Element->OutputHTML();
			echo( "<p>" );
		}
		print_footer();
	}
	/* -------------------- end OutputHTML -------------------- */

}
?>
